/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.AppManagementBaseFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassloaderFactory;
import com.ibm.websphere.models.config.classloader.ClassloaderPackage;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.registrar.registrar;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.Fence;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.MapModulesToServersHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;

public class AppUtils {
    private static TraceComponent tc = Tr.register(AppUtils.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String SYSTEM_APPS_FILE_NAME = "systemapps.xml";
    private static ClassloaderFactory classloaderFactory;
    private static Boolean _entitled;
    private static PublicKey _entitledKey;
    private static String productName;

    public static synchronized boolean isEntitled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEntitled");
        }
        boolean bl = true;
        if (_entitled == null) {
            try {
                String string = new String("GjSl6k4j76jW6j3FsGNhNsrjY3p762eM");
                boolean bl2 = false;
                try {
                    string = Fence.getKey();
                    bl2 = true;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Server entitlement class not found", new Boolean(bl2));
                    }
                }
                catch (Throwable throwable) {
                    Tr.event(tc, "Server entitlement class not found", throwable);
                }
                InputStream inputStream = AppUtils.class.getClassLoader().getResourceAsStream("jarsign/zruntime_keystore");
                if (inputStream == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Server entitlement keystore not found");
                    }
                } else {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(inputStream, string.toCharArray());
                    Certificate certificate = keyStore.getCertificate("zruntime");
                    if (certificate == null) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Server entitlement keystore is incomplete");
                        }
                    } else {
                        _entitledKey = certificate.getPublicKey();
                    }
                }
                if (_entitledKey != null && bl2) {
                    bl = false;
                }
                _entitled = new Boolean(bl);
            }
            catch (Throwable throwable) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Server entitlement check failed", throwable);
                }
                _entitled = new Boolean(true);
            }
        } else {
            bl = _entitled;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEntitled", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isAppEntitled(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAppEntitled", string);
        }
        boolean bl = true;
        if (_entitledKey != null) {
            try {
                JarFile jarFile = new JarFile(string, true);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements() && bl) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string2 = jarEntry.getName();
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    while (inputStream.read() != -1) {
                    }
                    Certificate[] certificateArray = jarEntry.getCertificates();
                    boolean bl2 = false;
                    if (certificateArray != null && certificateArray.length > 0) {
                        for (int i = 0; i < certificateArray.length; ++i) {
                            try {
                                certificateArray[i].verify(_entitledKey);
                                bl2 = true;
                                continue;
                            }
                            catch (Throwable throwable) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Exception verifying certificate signature for file " + string2 + " in application " + string + ", this may not be fatal", throwable);
                            }
                        }
                    }
                    if (bl2 || !string2.endsWith(".class") && !string2.endsWith(".jar") && !string2.endsWith(".ear") && !string2.endsWith(".war")) continue;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Application " + string + " failed certificate " + "verification on file " + string2);
                    }
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error during app entitlement verification", throwable);
                }
                bl = false;
            }
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAppEntitled", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signEntitledApplication(String string) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signEntitledApplication", string);
        }
        if (bl = AppUtils.isEntitled()) {
            String string2 = new String("GjSl6k4j76jW6j3FsGNhNsrjY3p762eM");
            InputStream inputStream = AppUtils.class.getClassLoader().getResourceAsStream("jarsign/zruntime_keystore");
            if (inputStream == null) {
                throw new Exception("Server entitlement keystore not found");
            }
            java.io.File file = null;
            try {
                java.io.File file2 = new java.io.File(AppUtils.getTempDir());
                file2.mkdirs();
                file2.deleteOnExit();
                file = java.io.File.createTempFile("zrun_keystore", null, file2);
                file.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[16];
                int n = inputStream.read(byArray);
                while (n > 0) {
                    fileOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                fileOutputStream.close();
                String string3 = System.getProperty("java.home");
                if (string3 == null) {
                    throw new Exception("Could not find java.home property");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using Java home", string3);
                }
                String string4 = new String(string3 + java.io.File.separator + "bin" + java.io.File.separator + "jarsigner -keystore " + file.getPath() + " -storepass " + string2 + " " + string + " " + "zruntime");
                Runtime runtime2 = Runtime.getRuntime();
                Process process = runtime2.exec(string4);
                int n2 = process.waitFor();
                InputStream inputStream2 = process.getInputStream();
                InputStream inputStream3 = process.getErrorStream();
                int n3 = inputStream2.available();
                if (n3 > 0) {
                    byte[] byArray2 = new byte[n3];
                    inputStream2.read(byArray2);
                    throw new Exception("Error signing application: " + string + ". " + new String(byArray2));
                }
                int n4 = inputStream3.available();
                if (n4 > 0) {
                    byte[] byArray3 = new byte[n4];
                    inputStream2.read(byArray3);
                    throw new Exception("Error signing application: " + string + ". " + new String(byArray3));
                }
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signEntitledApplication");
        }
    }

    public static void printEntitleServerMessage() {
        Tr.info(tc, "ADMA9007I", AppUtils.getProductName());
    }

    public static String getProductName() {
        if (productName.equals("")) {
            registrar registrar2 = null;
            WASProduct wASProduct = new WASProduct();
            Iterator iterator = wASProduct.getRegistrars();
            while (iterator.hasNext()) {
                registrar2 = (registrar)iterator.next();
                if (!registrar2.getId().equals("BASE")) continue;
                productName = registrar2.getProductName();
                break;
            }
        }
        return productName;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static void printEx(Throwable throwable) {
        AppUtils.printEx(throwable, true);
    }

    private static ClassloaderFactory getClassloaderFactory() {
        if (classloaderFactory == null) {
            ClassloaderPackage classloaderPackage = (ClassloaderPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/classloader.xmi");
            classloaderFactory = classloaderPackage.getClassloaderFactory();
        }
        return classloaderFactory;
    }

    public static void printEx(Throwable throwable, boolean bl) {
        if (throwable instanceof AdminException && ((AdminException)throwable).getCause() != null) {
            AppUtils.printEx(((AdminException)throwable).getCause(), bl);
        } else if (throwable instanceof MBeanException && ((MBeanException)throwable).getTargetException() != null) {
            AppUtils.printEx(((MBeanException)throwable).getTargetException(), bl);
        } else if (throwable instanceof AppDeploymentException && ((AppDeploymentException)throwable).getEmbeddedEx() != null) {
            AppUtils.printEx(((AppDeploymentException)throwable).getEmbeddedEx(), bl);
        } else {
            AppUtils.dbg(tc, "Exception: " + throwable);
            if (bl) {
                throwable.printStackTrace();
            }
        }
    }

    public static ResourceBundle getBundle(String string, Locale locale) {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(string, locale2);
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException(missingResourceException, "com.ibm.ws.management.application.AppUtils.getBundle", "90");
            AppUtils.dbg(tc, "Error loading class: " + string + ", locale " + locale2 + ", " + missingResourceException);
            return null;
        }
    }

    public static ResourceBundle getBundle(Hashtable hashtable) {
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        ResourceBundle resourceBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        return resourceBundle;
    }

    public static String getMessage(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            return string;
        }
        try {
            String string2 = resourceBundle.getString(string);
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Translation key not found: " + string);
                }
                return string;
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException(missingResourceException, "com.ibm.ws.management.application.AppUtils.getMessage", "114");
            return string;
        }
    }

    public static String getMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = AppUtils.getMessage(resourceBundle, string);
        if (objectArray == null) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }

    public static void dbg(TraceComponent traceComponent, String string, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug(traceComponent, string, object);
        }
    }

    public static void dbg(TraceComponent traceComponent, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(traceComponent, string);
        }
    }

    public static String validateInstall(Scheduler scheduler) {
        return (String)scheduler.getProperties().get("validateinstall");
    }

    public static boolean isPreCompileJSPs(Scheduler scheduler) {
        return scheduler.getProperties().get("preCompileJSPs") != null && scheduler.getProperties().get("preCompileJSPs").equals(Boolean.TRUE);
    }

    public static boolean isDeployEJBs(Scheduler scheduler) {
        return scheduler.getProperties().get("deployejb") != null && scheduler.getProperties().get("deployejb").equals(Boolean.TRUE);
    }

    public static RepositoryContextType getContextType(String string) throws Exception {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType(string);
    }

    public static RepositoryContext getContextFromArray(Object[] objectArray, String string, String string2, boolean bl) throws Exception {
        RepositoryContext repositoryContext = null;
        for (int i = 0; i < objectArray.length; ++i) {
            RepositoryContext repositoryContext2 = (RepositoryContext)objectArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "aaa: " + repositoryContext2.getName());
            }
            if (!repositoryContext2.getName().equals(string)) continue;
            if (string2 != null) {
                if (!repositoryContext2.getParent().getName().equals(string2)) continue;
                return repositoryContext2;
            }
            if (bl) {
                return repositoryContext2;
            }
            if (repositoryContext == null) {
                repositoryContext = repositoryContext2;
                continue;
            }
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5023E", new Object[]{repositoryContext.getName(), repositoryContext.getParent().getName(), repositoryContext2.getParent().getName(), repositoryContext2.getParent().getType().getName()}));
        }
        return repositoryContext;
    }

    public static Object[] getContextArray(String string, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (string.equals("cells")) {
            return workSpace.findContext(AppUtils.getContextType("cells")).toArray();
        }
        return repositoryContext.findContext(AppUtils.getContextType(string)).toArray();
    }

    public static RepositoryContext findContext(String string, String string2, String string3, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        Object[] objectArray = AppUtils.getContextArray(string, repositoryContext, workSpace);
        if (objectArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ar is null: type: " + string);
            }
            return null;
        }
        return AppUtils.getContextFromArray(objectArray, string2, string3, bl);
    }

    public static Vector listSystemApps(Hashtable hashtable, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSystemApps", new String[]{"properties=" + hashtable, "wsID=" + string});
        }
        Vector vector = new Vector();
        HashSet hashSet = new HashSet();
        WorkSpace workSpace = ConfigRepoHelper.getWorkSpace(string);
        URI uRI = URI.createURI((String)SYSTEM_APPS_FILE_NAME);
        Object[] objectArray = AppUtils.getContextArray("cells", null, workSpace);
        for (int i = 0; i < objectArray.length; ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)objectArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellContext: " + repositoryContext);
            }
            Object[] objectArray2 = AppUtils.getContextArray("nodes", repositoryContext, workSpace);
            for (int j = 0; j < objectArray2.length; ++j) {
                WorkSpaceFile workSpaceFile;
                RepositoryContext repositoryContext2 = (RepositoryContext)objectArray2[j];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeContext: " + repositoryContext2);
                }
                if ((workSpaceFile = repositoryContext2.getFile(SYSTEM_APPS_FILE_NAME)) == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "wsf is null - systemapps.xml does not exists on node " + repositoryContext2);
                    continue;
                }
                repositoryContext2.extract(SYSTEM_APPS_FILE_NAME, false);
                ResourceSet resourceSet = repositoryContext2.getResourceSet();
                Resource resource = resourceSet.createResource(uRI);
                resource.load(new HashMap());
                hashSet.addAll(AppUtils.listSystemApps(resource));
            }
        }
        vector.addAll(hashSet);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSystemApps", vector);
        }
        return vector;
    }

    public static Vector listSystemApps(Resource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSystemApps", new String[]{"resource=" + resource});
        }
        Vector<String> vector = new Vector<String>();
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            EList eList2 = serverEntry.getDeployedApplications();
            for (int j = 0; j < eList2.size(); ++j) {
                String string = (String)eList2.get(j);
                if (!string.endsWith(".ear")) continue;
                String string2 = string.substring(string.lastIndexOf("/") + 1);
                string2 = string2.substring(0, string2.lastIndexOf(".ear"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deployedAppName: " + string2);
                }
                vector.add(string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSystemApps: " + vector);
        }
        return vector;
    }

    public static boolean isAnInstalledSystemApp(String string, WorkSpace workSpace, Hashtable hashtable, boolean bl) throws Exception {
        String string2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnInstalledSystemApp" + string);
        }
        String string3 = hashtable == null ? null : (String)hashtable.get("cell.name");
        String string4 = (String)hashtable.get("node.name");
        String string5 = (String)hashtable.get("server.name");
        if (!bl) {
            object2 = (String)hashtable.get("original.ear.location");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " ear file " + (String)object2);
            }
            if (object2 != null) {
                object = ((String)object2).replace('\\', '/');
                string2 = ((String)object).substring(((String)object).lastIndexOf("/") + 1);
                if (string2.endsWith(".ear")) {
                    string2 = string2.substring(0, string2.lastIndexOf(".ear"));
                }
                string = string2;
            }
        }
        object2 = workSpace.findContext("cells/" + string3 + "/nodes/" + string4);
        object = null;
        if (string4 != null) {
            try {
                object = object2.getFile(SYSTEM_APPS_FILE_NAME);
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMA0164W", new Object[]{string3, string4});
                return false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wsf = " + object);
        }
        if (object == null) {
            return false;
        }
        object2.extract(SYSTEM_APPS_FILE_NAME, false);
        string2 = object2.getResourceSet().createResource(URI.createURI((String)SYSTEM_APPS_FILE_NAME));
        string2.load(new HashMap());
        ServerIndex serverIndex = (ServerIndex)string2.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            EList eList2 = serverEntry.getDeployedApplications();
            for (int j = 0; j < eList2.size(); ++j) {
                String string6 = (String)eList2.get(j);
                if (!string6.endsWith(".ear")) continue;
                String string7 = string6.substring(string6.lastIndexOf("/") + 1);
                if (!(string7 = string7.substring(0, string7.lastIndexOf(".ear"))).equals(string)) continue;
                if (bl) {
                    serverEntry.getDeployedApplications().remove(j);
                    serverEntry.eResource().save(new HashMap());
                }
                if (!serverEntry.getServerName().equals(string5)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isAnInstalledSystemApp" + string + ", " + string3 + ", " + string5 + ": true");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAnInstalledSystemApp" + string + ", " + string3);
        }
        return false;
    }

    public static boolean isAnInstalledSystemAppOnCluster(String string, WorkSpace workSpace, Hashtable hashtable) throws Exception {
        Hashtable hashtable2;
        Hashtable hashtable3;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnInstalledSystemAppOnCluster");
        }
        String string2 = hashtable == null ? null : (String)hashtable.get("cell.name");
        String string3 = (String)hashtable.get("original.ear.location");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " ear file " + string3);
        }
        if (string3 != null) {
            object2 = string3.replace('\\', '/');
            object = ((String)object2).substring(((String)object2).lastIndexOf("/") + 1);
            if (((String)object).endsWith(".ear")) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf(".ear"));
            }
            string = object;
        }
        object2 = workSpace.findContext("cells/" + string2);
        object = ConfigRepoHelper.getServerNames(AppUtils.getTargetStr(hashtable), AppUtils.getTargetStr(hashtable), false, (RepositoryContext)object2, workSpace);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnInstalledSystemAppOnCluster: " + object);
        }
        if ((hashtable3 = AppUtils.getSystemAppsXMLDocs(workSpace, (hashtable2 = ConfigRepoHelper.getNodeServerRelation(workSpace, (Vector)object)).keys())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server index docs not found!!");
            }
            return false;
        }
        Enumeration enumeration = hashtable2.keys();
        Hashtable hashtable4 = new Hashtable();
        String string4 = "";
        try {
            while (enumeration.hasMoreElements()) {
                RepositoryContext repositoryContext = (RepositoryContext)enumeration.nextElement();
                Vector vector = (Vector)hashtable2.get(repositoryContext);
                Vector<String> vector2 = new Vector<String>();
                for (int i = 0; i < vector.size(); ++i) {
                    vector2.addElement(((RepositoryContext)vector.elementAt(i)).getName());
                }
                Resource resource = (Resource)hashtable3.get(repositoryContext);
                if (resource == null || resource.getContents().size() == 0) continue;
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                ArrayList arrayList = new ArrayList();
                hashtable4.put(repositoryContext.getName(), arrayList);
                string4 = repositoryContext.getName();
                EList eList = serverIndex.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "servers for " + repositoryContext.getName() + " are " + vector2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + repositoryContext.getName() + " are " + eList);
                }
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    if (!vector2.contains(serverEntry.getServerName())) continue;
                    EList eList2 = serverEntry.getDeployedApplications();
                    for (int j = 0; j < eList2.size(); ++j) {
                        String string5 = (String)eList2.get(j);
                        String string6 = string5.substring(string5.lastIndexOf("/") + 1);
                        if (!string.equals(string6 = string6.substring(0, string6.lastIndexOf(".ear")))) continue;
                        AppUtils.dbg(tc, "System Application found " + string6 + ", with binUrl = " + string5);
                        return true;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isAnInstalledSystemAppOnCluster");
            }
            return false;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.ConfigRepoHelper.updateServerIndexDocs", "124");
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "Server Index update failed at  the last node of " + string4);
        }
    }

    private static Hashtable getSystemAppsXMLDocs(WorkSpace workSpace, Enumeration enumeration) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAppsXMLDocs");
        }
        Hashtable<RepositoryContext, Resource> hashtable = new Hashtable<RepositoryContext, Resource>();
        while (enumeration.hasMoreElements()) {
            RepositoryContext repositoryContext = (RepositoryContext)enumeration.nextElement();
            URI uRI = URI.createURI((String)SYSTEM_APPS_FILE_NAME);
            WorkSpaceFile workSpaceFile = repositoryContext.getFile(SYSTEM_APPS_FILE_NAME);
            if (workSpaceFile == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "No systemapps.xml on node " + repositoryContext.getName());
                continue;
            }
            repositoryContext.extract(SYSTEM_APPS_FILE_NAME, false);
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            resource.load(new HashMap());
            if (resource != null) {
                hashtable.put(repositoryContext, resource);
                continue;
            }
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{SYSTEM_APPS_FILE_NAME, repositoryContext}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "retVal: " + hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAppsXMLDocs");
        }
        return hashtable;
    }

    public static String getTargetStr(Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetStr", new Object[]{hashtable});
        }
        String string = null;
        if (hashtable.get("cluster.name") != null) {
            String string2 = (String)hashtable.get("cluster.name");
            String string3 = (String)hashtable.get("cell.name");
            string = "WebSphere:cell=" + string3 + ",cluster=" + string2;
        } else if (hashtable.get("cell.name") != null && hashtable.get("node.name") != null && hashtable.get("server.name") != null) {
            String string4 = (String)hashtable.get("cell.name");
            String string5 = (String)hashtable.get("node.name");
            String string6 = (String)hashtable.get("server.name");
            string = "WebSphere:cell=" + string4 + ",node=" + string5 + ",server=" + string6;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetStr - " + string);
        }
        return string;
    }

    public static RepositoryContext findAppContextFromConfig(String string, WorkSpace workSpace, Hashtable hashtable) throws Exception {
        String string2;
        String string3 = AppUtils.getAppBinDirName(hashtable, string);
        String string4 = EditionHelper.getCompositeName(string, hashtable);
        String string5 = string2 = hashtable == null ? null : (String)hashtable.get("cell.name");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findAppContextFromConfig:" + string + ", " + string2 + ", " + string3);
        }
        Object[] objectArray = AppUtils.getContextArray("cells", null, workSpace);
        RepositoryContext repositoryContext = null;
        if (string2 != null) {
            repositoryContext = AppUtils.getContextFromArray(objectArray, string2, null, true);
        }
        if (repositoryContext == null && objectArray.length == 1) {
            repositoryContext = (RepositoryContext)objectArray[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell context: " + repositoryContext);
        }
        if (string3 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting bin name to appname.ear");
            }
            string3 = string + ".ear";
        }
        if (repositoryContext != null) {
            RepositoryContext repositoryContext2 = repositoryContext.getChild(AppUtils.getContextType("applications"), string3);
            if (repositoryContext2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No binC : " + string3);
                }
                return null;
            }
            RepositoryContext repositoryContext3 = repositoryContext2.getChild(AppUtils.getContextType("deployments"), string4);
            return repositoryContext3;
        }
        Object[] objectArray2 = workSpace.findContext(AppUtils.getContextType("applications")).toArray();
        RepositoryContext repositoryContext4 = AppUtils.getContextFromArray(objectArray2, string3, null, false);
        if (repositoryContext4 == null) {
            return null;
        }
        return repositoryContext4.getChild(AppUtils.getContextType("deployments"), string4);
    }

    public static boolean isCluster(RepositoryContext repositoryContext) {
        if (repositoryContext == null) {
            return false;
        }
        return repositoryContext.getType().getName().equals("clusters");
    }

    public static RepositoryContext getClusterFromMember(RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        ResourceBundle resourceBundle = AppUtils.getBundle(null);
        final RepositoryContext repositoryContext2 = repositoryContext;
        final WorkSpace workSpace2 = workSpace;
        Object object = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            object = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppUtils.getClusterFromMemberAsSystem(repositoryContext2, workSpace2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getClusterFromMember", "756");
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getClusterFromMember", "760");
        }
        return (RepositoryContext)object;
    }

    public static RepositoryContext getClusterFromMemberAsSystem(RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterFromMember: " + repositoryContext.getName());
        }
        if ((objectArray = AppUtils.getContextArray("clusters", repositoryContext.getParent().getParent(), workSpace)) == null || objectArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterFromMember:none");
            }
            return null;
        }
        URI uRI = URI.createURI((String)"server.xml");
        Resource resource = repositoryContext.getResourceSet().createResource(uRI);
        HashMap hashMap = new HashMap();
        resource.load(hashMap);
        Server server2 = (Server)resource.getContents().get(0);
        String string = server2.getClusterName();
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterFromMember:null");
            }
            return null;
        }
        RepositoryContext repositoryContext2 = AppUtils.getContextFromArray(objectArray, string, null, false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "For server: " + repositoryContext.getName() + ", clusterName: " + string + ", clContext: " + repositoryContext2);
        }
        if (repositoryContext2 == null) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{repositoryContext.getName(), string}));
        }
        return repositoryContext2;
    }

    public static boolean isServer(RepositoryContext repositoryContext) {
        if (repositoryContext == null) {
            return false;
        }
        return repositoryContext.getType().getName().equals("servers");
    }

    public static String getAppDir(String string) {
        String string2 = string;
        string2 = string2.replace(' ', '_');
        string2 = string2.replace('.', '_');
        return string2;
    }

    public static String getAppDir(Scheduler scheduler) {
        return AppUtils.getAppDir(scheduler.getAppName());
    }

    public static String getAppTempDir(Scheduler scheduler) {
        String string = AppUtils.getTempDir(scheduler);
        string = string + AppUtils.getAppDir("app." + scheduler.getID());
        return string;
    }

    public static String getTempDir() {
        return AppUtils.getTempDir(null);
    }

    public static String getTempDir(Scheduler scheduler) {
        String string = "";
        string = scheduler == null ? AppManagementBaseFactory.getTempExtractDir() : (String)scheduler.getAppManagement().getGlobalSettings().get("Temp extraction dir for multiserver");
        if (!string.endsWith(java.io.File.separator)) {
            string = string + java.io.File.separator;
        }
        return string;
    }

    public static String getAppTempExtractDir(Scheduler scheduler) throws AdminException {
        return AppUtils.getAppTempDir(scheduler) + java.io.File.separator + "ext";
    }

    public static String getAppTempMergeDir(Scheduler scheduler) throws AdminException {
        return AppUtils.getAppTempDir(scheduler) + java.io.File.separator + "mrg";
    }

    public static String getAppTempDeployDir(Scheduler scheduler) throws AdminException {
        return AppUtils.getAppTempDir(scheduler) + java.io.File.separator + "dpl";
    }

    public static String getAppDeployFileName(String string) {
        return "dpl_" + AppUtils.getAppDir(string);
    }

    public static String getPreAppDeployFileName(String string) {
        return "predpl_" + AppUtils.getAppDir(string) + ".ear";
    }

    public static String getAppTempExportDir(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("Temp extraction dir for multiserver");
        if (!string2.endsWith(java.io.File.separator)) {
            string2 = string2 + java.io.File.separator;
        }
        string2 = string2 + "tmp." + System.currentTimeMillis();
        return string2;
    }

    public static boolean isSystemApp(Scheduler scheduler) {
        if (Boolean.TRUE.equals(scheduler.getProperties().get("META-INF/ibm-application-sa.props")) || AppUtils.isSystemAppOption(scheduler.getProperties())) {
            return true;
        }
        Tr.debug(tc, "ttt isSystemApp return false");
        return false;
    }

    public static boolean isSystemAppOption(Hashtable hashtable) {
        Tr.entry(tc, "isSystemAppOption", new Object[]{hashtable});
        if (hashtable.containsKey("systemApp")) {
            return true;
        }
        Tr.exit(tc, "isSystemAppOption");
        return false;
    }

    public static String getAppInstallDir(Scheduler scheduler, RepositoryContext repositoryContext) throws Exception {
        return AppUtils.getAppInstallDir(scheduler, repositoryContext, true);
    }

    public static String getAppInstallDir(Scheduler scheduler, RepositoryContext repositoryContext, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppInstallDir", new Object[]{scheduler, repositoryContext, new Boolean(bl)});
        }
        Object v = scheduler.getProperties().get("installed.ear.destination.final");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "INSTALL_DIR_FINAL= " + v);
        }
        if (v != null) {
            return v.toString();
        }
        String string = (String)scheduler.getProperties().get("installed.ear.destination");
        if (AppUtils.isEmpty(string)) {
            string = "$(APP_INSTALL_ROOT)/" + repositoryContext.getParent().getParent().getName() + "/";
        } else if (!(string = string.trim().replace(java.io.File.separatorChar, '/')).endsWith("/") && bl) {
            string = string + "/";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dir before checking for addearsuffix or not: " + string);
        }
        if (bl) {
            string = string + EditionHelper.getAppEarName(scheduler.getAppName(), scheduler.getProperties());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppInstalldir", new Object[]{string});
        }
        return string;
    }

    public static String getAppBinDirName(Scheduler scheduler) {
        return AppUtils.getAppBinDirName(scheduler.getProperties(), scheduler.getAppName());
    }

    public static String getAppBinDirName(Hashtable hashtable, String string) {
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get("appbinary.name");
        }
        if (string2 != null) {
            return string2;
        }
        String string3 = EditionHelper.getAppAndEdition(string, hashtable)[0];
        return string3 + ".ear";
    }

    public static String convert2AbsPath(String string, VariableMap variableMap) throws Exception {
        if (string.indexOf("$(") == -1 && string.indexOf("${") == -1) {
            return string;
        }
        if (variableMap == null) {
            return string;
        }
        String string2 = variableMap.expand(string);
        string2 = string2.replace('/', java.io.File.separatorChar);
        string2 = string2.replace('\\', java.io.File.separatorChar);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "convert2AbsPath: " + string + " = " + string2);
        }
        return string2;
    }

    public static VariableMap createVarMap(RepositoryContext repositoryContext, String string) throws Exception {
        if (AppManagementImpl.isLocalMode()) {
            String string2 = repositoryContext.getParent().getParent().getName();
            String string3 = repositoryContext.getParent().getName();
            return AppUtils.createVarMap(string, string2, string3, null);
        }
        String string4 = repositoryContext.getParent().getParent().getName();
        String string5 = repositoryContext.getParent().getName();
        String string6 = repositoryContext.getName();
        Tr.debug(tc, " cellName => " + string4);
        Tr.debug(tc, " nodeName => " + string5);
        Tr.debug(tc, " server   => " + string6);
        return AppUtils.createVarMap(string, string4, string5, string6);
    }

    public static VariableMap createVarMap(String string, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVarMap");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConfigRoot: " + string + ", " + "CellName: " + string2 + ", " + "NodeName: " + string3 + ", " + "ProcName: " + string4);
        }
        Repository repository2 = RepositoryFactory.createRepository("ws-server", string, string2, string3, string4);
        VariableMap variableMap = VariableMapFactory.createVariableMap(repository2);
        variableMap.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + variableMap);
        }
        return variableMap;
    }

    public static synchronized void deleteDirTree(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        AppUtils._deleteDirTree(new java.io.File(string).getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(String string, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        AppUtils._deleteDirTree(new java.io.File(string).getCanonicalFile(), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(java.io.File file) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        AppUtils._deleteDirTree(file.getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(java.io.File file, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDirTree");
        }
        AppUtils._deleteDirTree(file.getCanonicalFile(), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDirTree");
        }
    }

    private static synchronized void _deleteDirTree(java.io.File file, boolean bl) throws IOException {
        if (!file.exists()) {
            Tr.event(tc, "directory does not exist");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteDirTree");
            }
            return;
        }
        String string = System.getProperty("os.name");
        boolean bl2 = true;
        if (!bl && !string.startsWith("Windows")) {
            bl2 = string.equals("OS/400") ? file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath()) : file.getAbsolutePath().equals(file.getCanonicalPath());
        }
        if (!bl2) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "file/dir a symlink: " + file);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteDirTree");
            }
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                java.io.File file2 = new java.io.File(file.getPath(), stringArray[i]);
                AppUtils._deleteDirTree(file2, bl);
            }
        }
        if (!file.delete()) {
            Tr.warning(tc, "ADMA0078W", file);
        }
    }

    public static void xcopy(RepositoryContext repositoryContext, String string, Vector vector) throws Exception {
        Object object;
        int n;
        java.io.File file = new java.io.File(string);
        String string2 = file.getAbsolutePath();
        file.mkdirs();
        repositoryContext.extract(false);
        String string3 = repositoryContext.getPath();
        List list = new ArrayList(repositoryContext.getFiles());
        for (n = 0; n < list.size(); ++n) {
            object = (String)list.get(n);
            if (vector.contains(object)) continue;
            if (java.io.File.separatorChar != '/') {
                object = ((String)object).replace('/', java.io.File.separatorChar);
            }
            String string4 = string3 + java.io.File.separator + (String)object;
            AppUtils.copyFile(new java.io.File(string4), string2 + java.io.File.separator + (String)object);
        }
        list = repositoryContext.getChildren();
        for (n = 0; n < list.size(); ++n) {
            object = (RepositoryContext)list.get(n);
            AppUtils.xcopy((RepositoryContext)object, string + java.io.File.separator + object.getName(), vector);
        }
    }

    public static void copyFile(java.io.File file, String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Copying..: " + file.getAbsolutePath() + " to " + string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        AppUtils.copyFile(fileInputStream, string);
        fileInputStream.close();
    }

    public static void copyFile(InputStream inputStream, String string) throws Exception {
        java.io.File file = new java.io.File(string);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            fileOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static byte[] getFileContents(InputStream inputStream) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileContents");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        byteArrayOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileContents: " + byArray2.length);
        }
        return byArray2;
    }

    public static String getInstallDirFromBinariesURL(ApplicationDeployment applicationDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstallDirFromBinariesURL " + applicationDeployment);
        }
        String string = applicationDeployment.getBinariesURL();
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        if (n == -1) {
            return string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstallDirFromBinariesURL " + string);
        }
        return string.substring(0, n);
    }

    public static String getBinaryContextFromBinariesURL(ApplicationDeployment applicationDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBinaryContextFromBinariesURL " + applicationDeployment);
        }
        String string = applicationDeployment.getBinariesURL();
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        if (n == -1) {
            return string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBinaryContextFromBinariesURL " + string);
        }
        return string.substring(n + 1);
    }

    public static List getURIs(String string) {
        return AppUtils.getFiles(string, "");
    }

    public static List getFiles(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        AppUtils.getFiles(arrayList, new java.io.File(string), string2);
        return arrayList;
    }

    public static void getFiles(List list, java.io.File file, String string) {
        if (!file.isDirectory()) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getName();
            if (string2.equals(".") || string2.equals("..")) continue;
            if (fileArray[i].isDirectory()) {
                AppUtils.getFiles(list, fileArray[i], string + string2 + "/");
                continue;
            }
            list.add((string + string2).replace('\\', '/'));
        }
    }

    public static Object[] getContainerAndOffset(Container container2, String string) throws Exception {
        string.replace('\\', '/');
        EList eList = container2.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (file.getURI().equals(string)) {
                return new Object[]{container2, string};
            }
            if (!string.startsWith(file.getURI() + "/") || !(file instanceof Container)) continue;
            return AppUtils.getContainerAndOffset((Container)file, string.substring(string.indexOf(file.getURI()) + file.getURI().length() + 1));
        }
        return new Object[]{container2, string};
    }

    public static String getNodeMajorVersion(String string, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeMajorVersion");
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("local.cell", string);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
            String string3 = managedObjectMetadataHelper.getNodeMajorVersion(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMajorVersion: " + string3 + ", node: " + string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeMajorVersion");
            }
            return string3;
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, "");
        }
    }

    public static String getNodeMajorVersion(Session session, String string, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeMajorVersion");
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("local.cell", string);
            properties.setProperty("CONFIG_SESSION", session.toString());
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
            String string3 = managedObjectMetadataHelper.getNodeMajorVersion(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMajorVersion: " + string3 + ", node: " + string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeMajorVersion");
            }
            return string3;
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, "");
        }
    }

    public static String getNodeMinorVersion(Session session, String string, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeMinorVersion");
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("local.cell", string);
            properties.setProperty("CONFIG_SESSION", session.toString());
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
            String string3 = managedObjectMetadataHelper.getNodeMinorVersion(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMinorVersion: " + string3 + ", node: " + string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeMinorVersion");
            }
            return string3;
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, "");
        }
    }

    public static String[][] getResourceTable() {
        String[] stringArray = new String[]{"server", "MapModulesToServers", "Server", "name"};
        String[] stringArray2 = new String[]{"virtualHost", "MapWebModToVH", "VirtualHost", "name"};
        String[] stringArray3 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2EEResourceFactory", "jndiName"};
        String[] stringArray4 = new String[]{"JNDI", "DataSourceFor10CMPBeans", "J2EEResourceFactory", "jndiName"};
        String[] stringArray5 = new String[]{"JNDI", "DataSourceFor10EJBModules", "J2EEResourceFactory", "jndiName"};
        String[] stringArray6 = new String[]{"JNDI", "DataSourceFor20CMPBeans", "J2EEResourceFactory", "jndiName"};
        String[] stringArray7 = new String[]{"JNDI", "DataSourceFor20EJBModules", "J2EEResourceFactory", "jndiName"};
        String[] stringArray8 = new String[]{"JNDI", "BindJndiForEJBNonMessageBinding", "J2EEResourceFactory", "jndiName"};
        String[] stringArray9 = new String[]{"JNDI", "MapResRefToEJB", "J2EEResourceFactory", "jndiName"};
        String[] stringArray10 = new String[]{"JNDI", "MapResEnvRefToRes", "J2EEResourceFactory", "jndiName"};
        String[] stringArray11 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2CActivationSpec", "destinationJndiName"};
        String[] stringArray12 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2CActivationSpec", "jndiName"};
        String[] stringArray13 = new String[]{"jndi.dest", "BindJndiForEJBMessageBinding", "J2CAdminObject", "jndiName"};
        String[] stringArray14 = new String[]{"jndi.dest", "MapRunAsRolesToUsers", "JAASAuthData", "authData"};
        String[][] stringArray15 = new String[][]{stringArray, stringArray2, stringArray3, stringArray4, stringArray4, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14};
        return stringArray15;
    }

    public static String getClientVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientVersion ");
        }
        if (AppManagementImpl.isLocalMode()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClientVersion: 999999");
            }
            return "999999";
        }
        JMXVersionValidation jMXVersionValidation = new JMXVersionValidation();
        String string = jMXVersionValidation.getClientVersion();
        if (string == null) {
            string = "999999";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientVersion: " + string);
        }
        return string;
    }

    public static String getClientVersion(Hashtable hashtable, boolean bl) {
        if (bl) {
            return "999999";
        }
        return AppUtils.getClientVersion();
    }

    public static Properties getEditionProps(RepositoryContext repositoryContext) throws AdminException {
        if (!repositoryContext.getParent().isAvailable("ibm-edition-metadata.props")) {
            return new Properties();
        }
        try {
            repositoryContext.getParent().extract("ibm-edition-metadata.props", false);
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(repositoryContext.getParent().getPath() + "/" + "ibm-edition-metadata.props");
            properties.load(fileInputStream);
            fileInputStream.close();
            return properties;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppUtils.getEditionProps", "756");
            AppUtils.dbg(tc, "Error loading edition props: " + repositoryContext);
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, null);
        }
    }

    public static void setEditionProps(RepositoryContext repositoryContext, Properties properties) throws AdminException {
        try {
            if (properties == null) {
                return;
            }
            boolean bl = repositoryContext.getParent().isAvailable("ibm-edition-metadata.props");
            OutputStream outputStream = repositoryContext.getParent().getOutputStream("ibm-edition-metadata.props");
            properties.store(outputStream, "File contains metadata for all editions of the application");
            outputStream.flush();
            outputStream.close();
            repositoryContext.getParent().notifyChanged(bl ? 0 : 1, "ibm-edition-metadata.props");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppUtils.setEditionProps", "779");
            AppUtils.dbg(tc, "Error saving edition props: " + repositoryContext);
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, null);
        }
    }

    public static String getAttrValueFromManifest(String string, ArchiveManifest archiveManifest) {
        String string2 = "";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttrValueFromManifest: key=" + string);
        }
        Attributes attributes2 = archiveManifest.getMainAttributes();
        string2 = attributes2.getValue(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttrValueFromManifest: value=" + string2);
        }
        return string2;
    }

    public static boolean checkAdminAccessApp(Hashtable hashtable, String string, String string2) {
        String string3 = AppUtils.getAppUri(hashtable, string2);
        boolean bl = AppUtils.checkAdminAccess(string, string3);
        return bl;
    }

    public static boolean checkAdminAccess(String string, String string2) {
        AdminAuthorizer adminAuthorizer = null;
        adminAuthorizer = SecurityHelper.getHelper().getAdminAuthorizer();
        return adminAuthorizer == null || adminAuthorizer.checkAccess(string2, string);
    }

    public static String getAppUri(Hashtable hashtable, String string) {
        String string2 = AppManagementImpl.getCellName();
        String string3 = AppUtils.getAppBinDirName(hashtable, string);
        String string4 = EditionHelper.getCompositeName(string, hashtable);
        String string5 = "config/cells/" + string2 + "/applications/" + string3;
        return string5;
    }

    public static boolean checkAdminAccessNewTarget(Hashtable hashtable, String string, String string2, String string3, Vector vector, Vector vector2) {
        boolean bl = false;
        String string4 = null;
        for (int i = 0; i < vector2.size(); ++i) {
            AppDeploymentTask appDeploymentTask = (AppDeploymentTask)vector2.get(i);
            if (!appDeploymentTask.getName().equals("MapModulesToServers")) continue;
            String[][] stringArray = appDeploymentTask.getTaskData();
            for (int j = 1; j < stringArray.length; ++j) {
                String string5 = stringArray[j][2];
                Object[] objectArray = AppUtils.convertToURL(string5);
                for (int k = 0; k < objectArray.length; ++k) {
                    string4 = (String)objectArray[k];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new target = " + string5);
                    }
                    bl = AppUtils.checkAdminAccess(string, string4);
                    vector.add(string4);
                    if (bl) continue;
                    return bl;
                }
            }
            break;
        }
        return true;
    }

    public static boolean checkAdminAccessTarget(Hashtable hashtable, String string, String string2, String string3, Vector vector) {
        boolean bl = false;
        String string4 = null;
        Object v = hashtable.get("moduleToServer");
        if (v == null) {
            return true;
        }
        Enumeration enumeration = ((Hashtable)v).keys();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            String string6 = (String)((Hashtable)v).get(string5);
            Object[] objectArray = AppUtils.convertToURL(string6);
            for (int i = 0; i < objectArray.length; ++i) {
                string4 = (String)objectArray[i];
                bl = AppUtils.checkAdminAccess(string, string4);
                vector.add(string4);
                if (bl) continue;
                return bl;
            }
        }
        return true;
    }

    private static Object[] convertToURL(String string) {
        if (string == null) {
            return new Object[0];
        }
        String string2 = "cells/";
        Vector<String> vector = new Vector<String>(3);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String[] stringArray = string.split("\\+");
        ObjectName objectName = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                objectName = new ObjectName(stringArray[i]);
            }
            catch (Exception exception) {
                continue;
            }
            string4 = objectName.getKeyProperty("node");
            if (string4 != null) {
                string3 = objectName.getKeyProperty("cell");
                string5 = objectName.getKeyProperty("server");
                if (string5 == null || string3 == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bad target format :" + stringArray[i]);
                    continue;
                }
                string2 = "cells/" + string3 + "/nodes/" + string4 + "/servers/" + string5;
            } else {
                string3 = objectName.getKeyProperty("cell");
                string6 = objectName.getKeyProperty("cluster");
                if (string6 == null || string3 == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bad target format :" + stringArray[i]);
                    continue;
                }
                string2 = "cells/" + string3 + "/clusters/" + string6;
            }
            vector.add(string2);
        }
        return vector.toArray();
    }

    private static Vector processTargets(String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace) {
        Vector vector;
        Vector vector2 = null;
        RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
        try {
            vector = ConfigRepoHelper.getAddRemoveServerNames(string, string2, true, repositoryContext2, workSpace);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1744");
            return vector2;
        }
        Vector vector3 = (Vector)vector.elementAt(0);
        Vector vector4 = (Vector)vector.elementAt(1);
        vector2 = vector3;
        vector2.addAll(vector4);
        return vector2;
    }

    public static boolean checkAdminAccessChangedTarget(String string, Hashtable hashtable, String string2, String string3, String string4, Vector vector) {
        Object object;
        Object object2;
        Object object3;
        String[][] stringArray;
        WorkSpace workSpace;
        boolean bl = false;
        Object v = hashtable.get("moduleToServer");
        if (v == null) {
            return true;
        }
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string4);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1568");
            vector.add("");
            return false;
        }
        AppDeploymentTask appDeploymentTask = null;
        RepositoryContext repositoryContext = null;
        try {
            repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + repositoryContext);
                }
                vector.add("");
                return false;
            }
            stringArray = AppUtils.getBundle(hashtable);
            object3 = ConfigRepoHelper.getEarFileForApp(workSpace, repositoryContext, (ResourceBundle)stringArray, true);
            object2 = AppInstallHelper.getAppDeploymentInfo((EARFile)object3);
            object = new MapModulesToServersHelper();
            appDeploymentTask = ((MapModulesToServersHelper)object).createTask(null, "MapModulesToServers");
            ((MapModulesToServersHelper)object).prepareTask((AppDeploymentInfo)object2, appDeploymentTask);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1593");
            vector.add("");
            return false;
        }
        stringArray = appDeploymentTask.getTaskData();
        if (stringArray == null) {
            object3 = ((Hashtable)v).keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = (String)((Hashtable)v).get(object2);
                Object[] objectArray = AppUtils.convertToURL((String)object);
                for (int i = 0; i < objectArray.length; ++i) {
                    bl = AppUtils.checkAdminAccess(string2, (String)objectArray[i]);
                    if (bl) continue;
                    return bl;
                }
            }
        } else if (v == null) {
            bl = AppUtils.checkAccessForTask(stringArray, string2, vector);
            if (!bl) {
                return bl;
            }
        } else {
            boolean bl2 = false;
            for (int i = 1; i < stringArray.length; ++i) {
                String string5;
                int n;
                int n2;
                String string6;
                Object object4;
                object = stringArray[i][1];
                String string7 = ((String)object).replace(',', '+');
                String string8 = stringArray[i][2];
                String string9 = (String)((Hashtable)v).get(string7);
                if (string9 != null && (string9.startsWith("+") || string9.startsWith("-")) && (object4 = AppUtils.processTargets(string9, string7, repositoryContext, workSpace)) != null) {
                    for (int j = 0; j < ((Vector)object4).size(); j += 2) {
                        RepositoryContext repositoryContext2 = (RepositoryContext)((Vector)object4).elementAt(j);
                        string6 = repositoryContext2.getURI();
                        bl = AppUtils.checkAdminAccess(string2, string6);
                        vector.add(string6);
                        if (bl) continue;
                        return bl;
                    }
                    break;
                }
                object4 = AppUtils.convertToURL(string9);
                Object[] objectArray = AppUtils.convertToURL(string8);
                for (n2 = 0; n2 < ((Object[])object4).length; ++n2) {
                    bl2 = false;
                    string6 = (String)object4[n2];
                    for (n = 0; n < objectArray.length; ++n) {
                        string5 = (String)objectArray[n];
                        if (!string6.equals(string5)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    bl = AppUtils.checkAdminAccess(string2, string6);
                    vector.add(string6);
                    if (bl) continue;
                    return bl;
                }
                if (objectArray.length == ((Object[])object4).length) continue;
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    bl2 = false;
                    string6 = (String)objectArray[n2];
                    for (n = 0; n < ((Object)object4).length; ++n) {
                        string5 = (String)object4[n];
                        if (!string5.equals(string5)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    bl = AppUtils.checkAdminAccess(string2, string6);
                    vector.add(string6);
                    if (bl) continue;
                    return bl;
                }
            }
        }
        return true;
    }

    private static boolean checkAccessForTask(String[][] stringArray, String string, Vector vector) {
        for (int i = 1; i < stringArray.length; ++i) {
            boolean bl = false;
            String string2 = stringArray[i][2];
            Object[] objectArray = AppUtils.convertToURL(string2);
            for (int j = 0; j < objectArray.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "url=" + objectArray[j]);
                }
                bl = AppUtils.checkAdminAccess(string, (String)objectArray[j]);
                vector.add(objectArray[j]);
                if (bl) continue;
                return bl;
            }
        }
        return true;
    }

    public static boolean checkAdminAccessChangedTarget(String string, Hashtable hashtable, String string2, String string3, String string4, Vector vector, Vector vector2) throws AdminException {
        int n;
        Object object;
        String[][] stringArray;
        String[][] stringArray2;
        WorkSpace workSpace;
        boolean bl = false;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string4);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1627");
            return false;
        }
        AppDeploymentTask appDeploymentTask = null;
        RepositoryContext repositoryContext = null;
        try {
            repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + repositoryContext);
                }
                return false;
            }
            stringArray2 = AppUtils.getBundle(hashtable);
            stringArray = ConfigRepoHelper.getEarFileForApp(workSpace, repositoryContext, (ResourceBundle)stringArray2, true);
            AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo((EARFile)stringArray);
            object = new MapModulesToServersHelper();
            appDeploymentTask = ((MapModulesToServersHelper)object).createTask(null, "MapModulesToServers");
            ((MapModulesToServersHelper)object).prepareTask(appDeploymentInfo, appDeploymentTask);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1645");
            throw new AdminException(exception);
        }
        stringArray2 = appDeploymentTask.getTaskData();
        stringArray = null;
        for (n = 0; n < vector2.size(); ++n) {
            object = (AppDeploymentTask)vector2.get(n);
            if (!((AppDeploymentTask)object).getName().equals("MapModulesToServers")) continue;
            stringArray = ((AppDeploymentTask)object).getTaskData();
            break;
        }
        if (stringArray2 == null) {
            if (stringArray == null) {
                return true;
            }
            bl = AppUtils.checkAccessForTask(stringArray, string2, vector);
            if (!bl) {
                return bl;
            }
        } else if (stringArray == null) {
            bl = AppUtils.checkAccessForTask(stringArray2, string2, vector);
        } else {
            block5: for (n = 1; n < stringArray2.length; ++n) {
                object = stringArray2[n][1];
                for (int i = 1; i < stringArray.length; ++i) {
                    int n2;
                    int n3;
                    Object object2;
                    String string5 = stringArray[n][1];
                    if (!string5.equals(object)) continue;
                    String string6 = stringArray2[n][2];
                    String string7 = stringArray[i][2];
                    if (string6 != null && string6.equals(string7)) continue;
                    String string8 = string5.replace(',', '+');
                    if (string7 != null && (string7.startsWith("+") || string7.startsWith("-")) && (object2 = AppUtils.processTargets(string7, string8, repositoryContext, workSpace)) != null) {
                        for (int j = 0; j < ((Vector)object2).size(); j += 2) {
                            RepositoryContext repositoryContext2 = (RepositoryContext)((Vector)object2).elementAt(j);
                            String string9 = repositoryContext2.getURI();
                            bl = AppUtils.checkAdminAccess(string2, string9);
                            vector.add(string9);
                            if (bl) continue;
                            return bl;
                        }
                        continue block5;
                    }
                    object2 = AppUtils.convertToURL(string6);
                    Object[] objectArray = AppUtils.convertToURL(string7);
                    boolean bl2 = false;
                    for (n3 = 0; n3 < ((Object[])object2).length; ++n3) {
                        bl2 = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ourl=" + object2[n3]);
                        }
                        for (n2 = 0; n2 < objectArray.length; ++n2) {
                            if (!object2[n3].equals(objectArray[n2])) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        bl = AppUtils.checkAdminAccess(string2, (String)object2[n3]);
                        vector.add(object2[n3]);
                        if (bl) continue;
                        return bl;
                    }
                    if (((Object[])object2).length == objectArray.length) continue;
                    bl2 = false;
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ourl=" + objectArray[n3]);
                        }
                        for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                            if (!objectArray[n3].equals(object2[n2])) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        bl = AppUtils.checkAdminAccess(string2, (String)objectArray[n3]);
                        vector.add(objectArray[n3]);
                        if (bl) continue;
                        return bl;
                    }
                }
            }
        }
        return true;
    }

    public static void loadDeploymentsToWorkSpacorkSpace(String string, Hashtable hashtable, String string2) {
        WorkSpace workSpace;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1792");
            return;
        }
        Vector vector = null;
        try {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + repositoryContext);
                }
                return;
            }
            RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            vector = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, repositoryContext2, workSpace, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All targets: " + vector);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "2048");
        }
    }

    public static boolean checkAdminAccessRemovedTarget(String string, Hashtable hashtable, String string2, String string3, String string4, Vector vector) {
        RepositoryContext repositoryContext;
        WorkSpace workSpace;
        boolean bl = false;
        String string5 = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string4);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1697");
            return false;
        }
        Vector vector2 = null;
        try {
            RepositoryContext repositoryContext2 = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + repositoryContext2);
                }
                return false;
            }
            repositoryContext = repositoryContext2.getParent().getParent();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext2);
            vector2 = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, repositoryContext, workSpace, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All targets: " + vector2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1705");
            return false;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            repositoryContext = (RepositoryContext)vector2.elementAt(i);
            string5 = repositoryContext.getURI();
            bl = AppUtils.checkAdminAccess(string2, string5);
            if (bl) continue;
            return bl;
        }
        return bl;
    }

    public static boolean checkAdminAccessRemovedTargetForModule(String string, Hashtable hashtable, String string2, String string3, String string4, Vector vector, String string5) {
        RepositoryContext repositoryContext;
        WorkSpace workSpace;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appName=" + string + "cellName = " + string3 + " module=" + string5);
        }
        boolean bl = false;
        String string6 = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string4);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1697");
            return false;
        }
        Vector vector2 = null;
        try {
            RepositoryContext repositoryContext2 = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to get application repository context =" + repositoryContext2);
                }
                return false;
            }
            repositoryContext = repositoryContext2.getParent().getParent();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext2);
            vector2 = ConfigRepoHelper.getServersForAppDeploymentModule(applicationDeployment, null, repositoryContext, workSpace, false, string5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All targets: " + vector2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.application.AppUtils.getBundle", "1705");
            return false;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            repositoryContext = (RepositoryContext)vector2.elementAt(i);
            string6 = repositoryContext.getURI();
            bl = AppUtils.checkAdminAccess(string2, string6);
            vector.add(string6);
            if (bl) continue;
            return bl;
        }
        return bl;
    }

    public static boolean checkCellLevelAdminAccess(String string) {
        String string2 = "cells/" + string;
        boolean bl = AppUtils.checkAdminAccess("configurator", string2);
        if (!bl) {
            bl = AppUtils.checkAdminAccess("deployer", string2);
            return bl;
        }
        return true;
    }

    public static Hashtable getSharedLibData(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedLibData", new Object[]{string});
        }
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl;
                String string2;
                int n;
                boolean bl2 = AppConstants.APPDEPL_ISSHARED_DEFAULT;
                String string3 = stringTokenizer.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing lib string: " + string3);
                }
                if ((n = string3.indexOf("WebSphere:")) == -1) {
                    string2 = string3;
                    bl = bl2;
                } else {
                    ObjectName objectName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Construting lib string into an object name");
                    }
                    try {
                        objectName = new ObjectName(string3);
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bad token: " + string3);
                        }
                        throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{string3}), malformedObjectNameException);
                    }
                    string2 = objectName.getKeyProperty("name");
                    if (string2 == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "name is null");
                        }
                        throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5073E", new Object[]{string3}), null);
                    }
                    String string4 = objectName.getKeyProperty("isSharedClassloader");
                    bl = string4 == null ? bl2 : Boolean.TRUE.toString().equalsIgnoreCase(string4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding (" + string2 + ", " + bl + ") to table");
                }
                hashtable.put(string2, new Boolean(bl));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedLibData", new Object[]{hashtable});
        }
        return hashtable;
    }

    public static boolean isSkipPrepOption(Hashtable hashtable) {
        Tr.entry(tc, "isSkipPrepOption", new Object[]{hashtable});
        if (hashtable.containsKey("skipPreparation")) {
            Tr.exit(tc, "isSkipPrepOption: true");
            return true;
        }
        Tr.exit(tc, "isSkipPrepOption: false");
        return false;
    }

    public static void validateFilePermissionStringThrowsException(String string) throws AdminException {
        if (!AppUtils.validateFilePermissionString(string)) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0174E", new Object[]{string}));
        }
    }

    public static boolean validateFilePermissionString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFilePermissionString: input string = " + string);
        }
        boolean bl = true;
        String string2 = ".+=[0-7]{3}#?";
        AppUtils.dbg(tc, "pattern = " + string2);
        Pattern pattern = Pattern.compile(string2);
        String[] stringArray = string.split("#");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            Matcher matcher = pattern.matcher(string);
            boolean bl2 = matcher.matches();
            if (!bl2) {
                bl = false;
            }
            String[] stringArray2 = string.split("=");
            String string3 = stringArray2[0];
            AppUtils.dbg(tc, "filePattern = " + string3);
            try {
                Pattern pattern2 = Pattern.compile(string3);
                continue;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                bl = false;
                AppUtils.dbg(tc, patternSyntaxException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFilePermissionString: " + bl);
        }
        return bl;
    }

    public static String getNewFilePermissions(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNewFilePermissions:  orig = " + string + ", newInput = " + string2);
        }
        if (string == null) {
            return string2;
        }
        String string3 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string2.split("#");
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) != -1) continue;
            arrayList.add(stringArray[i]);
        }
        if (!arrayList.isEmpty()) {
            string3 = AppUtils.join("#", arrayList.toArray(new String[0]));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNewFilePermissions - " + string3);
        }
        return string3;
    }

    public static String join(String string, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "join - token: " + string + ", strings = " + stringArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string);
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    public static boolean isProductInstalled(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isProductInstalled", new Object[]{string, string2});
        }
        boolean bl = false;
        if (!AppUtils.isEmpty(string)) {
            WASDirectory wASDirectory = new WASDirectory(string);
            bl = wASDirectory.isThisProductInstalled("embeddedEXPRESS");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProductInstalled", new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    public static boolean isAppEditable(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAppEditable()", new Object[]{string, string2});
        }
        boolean bl = false;
        try {
            WorkSpace workSpace = ConfigRepoHelper.getWorkSpace(string);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string2, workSpace, new Hashtable());
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            bl = ConfigRepoHelper.isEditAllowed(applicationDeployment);
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Exception Received: ", throwable);
            }
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAppEditable()");
        }
        return bl;
    }

    public static boolean getGlobalEmbededConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalEmbededConfig ");
        }
        String string = System.getProperty("com.ibm.websphere.management.processEmbeddedConfigGlobal");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "globally processEmbeddedConfigGlobal is set as--" + string);
        }
        Boolean bl = AppConstants.APPDEPL_PROCESS_EMBEDDEDCFG_INSTALL_DEFAULT;
        if ("false".equals(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGlobalEmbededConfig - false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalEmbededConfig - true");
        }
        return true;
    }

    public static void merge(WorkSpace workSpace, WorkSpace workSpace2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge");
        }
        Collection collection = workSpace.getRootContext().findContext(AppUtils.getContextType("applications"));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            String string = repositoryContext.getName();
            Collection collection2 = workSpace2.getRootContext().findContext(AppUtils.getContextType("applications"));
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)iterator2.next();
                if (!string.equals(repositoryContext2.getName())) continue;
                AppUtils.dbg(tc, "archiveAppName and targetApp name: " + string);
                if (!repositoryContext.isAvailable("ibm-edition-metadata.props") || !repositoryContext2.isAvailable("ibm-edition-metadata.props")) continue;
                try {
                    Properties properties = AppUtils._loadProperties(repositoryContext);
                    Properties properties2 = AppUtils._loadProperties(repositoryContext2);
                    Properties properties3 = AppUtils.mergeProps(properties, properties2);
                    AppUtils._writeProperties(repositoryContext, properties3);
                }
                catch (Exception exception) {
                    AppUtils.dbg(tc, "Error during merge of edition properties");
                    throw exception;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
    }

    private static void _writeProperties(RepositoryContext repositoryContext, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_writeProperties");
        }
        OutputStream outputStream = null;
        try {
            if (properties == null) {
                return;
            }
            outputStream = repositoryContext.getOutputStream("ibm-edition-metadata.props");
            properties.store(outputStream, "File contains metadata for all editions of the application");
            outputStream.flush();
        }
        catch (Exception exception) {
            AppUtils.dbg(tc, "Error writing edition props of " + repositoryContext.getName() + " at " + repositoryContext.getPath());
            throw exception;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_writeProperties");
            }
        }
    }

    private static Properties mergeProps(Properties properties, Properties properties2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergProps");
        }
        Properties properties3 = new Properties();
        properties3.putAll((Map<?, ?>)properties);
        properties3.putAll((Map<?, ?>)properties2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeProps", "mergedProps: " + properties3);
        }
        return properties3;
    }

    private static Properties _loadProperties(RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_loadProperties");
        }
        FileInputStream fileInputStream = null;
        Properties properties = null;
        try {
            repositoryContext.extract("ibm-edition-metadata.props", false);
            properties = new Properties();
            fileInputStream = new FileInputStream(repositoryContext.getPath() + "/" + "ibm-edition-metadata.props");
            properties.load(fileInputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception exception) {
            AppUtils.dbg(tc, "Exception during loading edition properties of : " + repositoryContext.getName() + " at " + repositoryContext.getPath());
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_loadProperties", "props: " + properties);
            }
        }
    }

    static {
        _entitled = null;
        _entitledKey = null;
        productName = "";
    }
}

