/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;

public abstract class ArchiveSchedulerImpl
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register(ArchiveSchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    protected String _origPathToContent;
    protected String _pathToContent;
    private Archive archive;
    protected String _contentType;
    private boolean _isAppEntitled;

    public ArchiveSchedulerImpl(String string, String string2, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string2, hashtable, appManagement, listener);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ArchiveSchedulerImpl");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive: " + string + ", appName: " + string2 + ", options: " + hashtable);
        }
        this._origPathToContent = string;
        this._pathToContent = string;
        this._contentType = "app";
        this._isAppEntitled = false;
        Object v = this.properties.get("was.loose.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LOOSE_CONFI_PROPERTY: " + v);
        }
        if (v != null) {
            LooseConfigRegister.singleton().addLooseMapping(this._origPathToContent, (String)v);
        }
        if ((v = this.properties.get("zeroBinaryCopy")) != null && v instanceof String && "true".equalsIgnoreCase((String)v)) {
            this.properties.put("zeroBinaryCopy", Boolean.TRUE);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Uniquie id: " + this.id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ArchiveSchedulerImpl");
        }
    }

    protected String getArchivePath() {
        return this._pathToContent;
    }

    protected void setArchivePath(String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContentPath");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new path: " + string);
        }
        this._pathToContent = string;
        if (this.archive != null) {
            try {
                Tr.debug(tc, "********** closing: " + this.archive.getURI());
                this.archive.close();
                this.archive = null;
            }
            catch (Throwable throwable) {
                if (this.resBundle != null) {
                    throw new AdminException(throwable, AppUtils.getMessage(this.resBundle, "ADMA0053E", new Object[]{this._pathToContent}));
                }
                throw new AdminException(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContentPath");
        }
    }

    protected Archive getArchive() throws AdminException {
        return this.getArchive(false, false);
    }

    protected Archive getArchive(boolean bl, boolean bl2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getArchive: " + bl2 + ", " + bl);
        }
        if (this.archive == null) {
            try {
                if (AppUtils.isEntitled() && !this._isAppEntitled && !new File(this._pathToContent).isDirectory()) {
                    if (!AppUtils.isAppEntitled(this._pathToContent)) {
                        Tr.error(tc, "ADMA9006E", new Object[]{this._pathToContent, AppUtils.getProductName()});
                        throw new AppDeploymentException("This application is not licensed to be installed in this server", null);
                    }
                    this._isAppEntitled = true;
                }
                this.archive = AppInstallHelper.getArchive(this._pathToContent, bl, bl2, this.resBundle, this._contentType.equals("app"));
                Tr.debug(tc, "********** opening: " + this.archive.getURI());
            }
            catch (AppDeploymentException appDeploymentException) {
                throw new AdminException(appDeploymentException.getEmbeddedEx(), appDeploymentException.getMessage());
            }
        }
        ArchiveOptions archiveOptions = this.archive.getOptions();
        boolean bl3 = !bl2 && archiveOptions.isReadOnly();
        boolean bl4 = bl3 = bl3 || bl && !archiveOptions.useJavaReflection();
        if (bl3) {
            this.archive.close();
            this.archive = null;
            try {
                AppUtils.dbg(tc, "Reopening since: read=" + archiveOptions.isReadOnly() + ", refl=" + archiveOptions.useJavaReflection());
                this.archive = AppInstallHelper.getArchive(this._pathToContent, bl, bl2, this.resBundle, this._contentType.equals("app"));
            }
            catch (AppDeploymentException appDeploymentException) {
                throw new AdminException(appDeploymentException.getEmbeddedEx(), appDeploymentException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getArchive");
        }
        return this.archive;
    }

    protected void performCleanup(boolean bl) throws Exception {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performCleanup");
        }
        if (this.archive != null) {
            Tr.debug(tc, "Closing ear: " + this.archive.getURI());
            this.archive.close();
        }
        if ((v = this.getProperties().get("DeleteSourceEar")) != null && v.equals(Boolean.TRUE)) {
            File file = new File(this._origPathToContent);
            boolean bl2 = file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Delete original ear: " + this._origPathToContent + " -- success: " + bl2);
            }
        }
        this.archive = null;
        if (this.setupDone) {
            AppUtils.dbg(tc, AppUtils.getMessage(this.resBundle, "ADMA6011I", new Object[]{AppUtils.getAppTempDir(this)}));
            AppUtils.deleteDirTree(AppUtils.getAppTempDir(this));
        }
        if (this.properties.get("was.loose.config") != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing loose mapping for: " + this._origPathToContent);
            }
            LooseConfigRegister.singleton().removeLooseMapping(this._origPathToContent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performCleanup");
        }
    }
}

