/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;

public class DeltaFile
extends XMLDocument {
    public static final String ROOTELEMENT = "app-delta";
    public static final String FILES = "files";
    public static final String FILE = "file";
    public static final String URI = "uri";
    public static final String UPDATE_INPUT = "change_input";
    private String _rootPath;
    private static TraceComponent tc = Tr.register(DeltaFile.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private String fileName = null;

    public DeltaFile() throws Exception {
        this.xmlDoc = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.xmlDoc = documentBuilder.newDocument();
            DOMImplementation dOMImplementation = this.xmlDoc.getImplementation();
            this.xmlDoc = dOMImplementation.createDocument(null, ROOTELEMENT, null);
            this.fileName = "delta-" + System.currentTimeMillis();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.DeltaFile", "34", this);
            this.xmlDoc = null;
            throw exception;
        }
        AppUtils.dbg(tc, "xmlDoc: " + this.xmlDoc);
        AppUtils.dbg(tc, "root element: " + this.xmlDoc.getDocumentElement());
    }

    public DeltaFile(String string) throws Exception {
        this();
        this._rootPath = string;
    }

    public DeltaFile(InputStream inputStream) throws Exception {
        super(inputStream);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void writeToDisk() throws Exception {
        String string = this._rootPath + "/" + this.fileName;
        AppUtils.dbg(tc, "****** delta file name: " + string);
        File file = new File(string);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.sendToStream(fileOutputStream);
        if (fileOutputStream != null) {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    public void sendToStream(OutputStream outputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendToStream");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        this.sendToWriter(bufferedWriter);
        ((Writer)bufferedWriter).flush();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendToStream");
        }
    }
}

