/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class PartialDeploymentInfo
extends ArchiveDeploymentInfo {
    private static TraceComponent tc = Tr.register(PartialDeploymentInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    boolean isApp;
    com.ibm.etools.commonarchive.ModuleRef moduleRef;
    ResourceBundle resBundle;

    public PartialDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws Exception {
        super(eARFile, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PartialDeploymentInfo");
        }
        this.resBundle = AppUtils.getBundle(hashtable);
        if (hashtable.get("EditAppOnly") != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Edit the app");
            }
            this.isApp = true;
            this.setApplication(eARFile.getDeploymentDescriptor());
            this.setApplicationBindings(eARFile.getBindings());
            this.setApplicationExtensions(eARFile.getExtensions());
        } else {
            this.isApp = false;
            String string = (String)hashtable.get("EditModuleOnly");
            this.moduleRef = this.findModuleRef(string);
            if (this.moduleRef == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0048E", new Object[]{string}));
            }
            if (this.moduleRef.isEJB()) {
                this.fluffConfig(this.moduleRef, "JAR_DD", "JAR_BND", "JAR_EXT");
            } else if (this.moduleRef.isWeb()) {
                this.fluffConfig(this.moduleRef, "WAR_DD", "WAR_BND", "WAR_EXT");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PartialDeploymentInfo");
        }
    }

    public boolean isApp() {
        return this.isApp;
    }

    private com.ibm.etools.commonarchive.ModuleRef findModuleRef(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findModuleRef: " + string);
        }
        EList eList = this.archive.getModuleRefs();
        String string2 = util.getModuleURIFromUniqueName(string);
        String string3 = util.getDDURIFromUniqueName(string);
        for (int i = 0; i < eList.size(); ++i) {
            com.ibm.etools.commonarchive.ModuleRef moduleRef = (com.ibm.etools.commonarchive.ModuleRef)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modRef: " + moduleRef);
            }
            if (!this.matchModuleRef(string3, string2, moduleRef)) continue;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "findModuleRef: " + moduleRef);
            }
            return moduleRef;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findModuleRef: null");
        }
        return null;
    }

    private boolean matchModuleRef(String string, String string2, com.ibm.etools.commonarchive.ModuleRef moduleRef) throws Exception {
        if (!string2.equals(moduleRef.getUri())) {
            return false;
        }
        EObject eObject = moduleRef.getAltDeploymentDescriptor();
        if (eObject != null) {
            if (eObject.eResource().getURI().toString().equals(string)) {
                return true;
            }
        } else {
            if (AppUtils.isEmpty(string)) {
                return true;
            }
            if (ConfigRepoHelper.getDDUri((ModuleRef)moduleRef).equals(string)) {
                return true;
            }
        }
        return false;
    }

    private void fluffConfig(com.ibm.etools.commonarchive.ModuleRef moduleRef, String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fluffConfig: " + moduleRef + ", " + string);
        }
        Vector<EObject> vector = null;
        EObject eObject = moduleRef.getDeploymentDescriptor();
        vector = new Vector<EObject>();
        vector.addElement(eObject);
        this.setModuleConfig(string, vector);
        EObject eObject2 = moduleRef.getBindings();
        vector = new Vector();
        vector.addElement(eObject2);
        this.setModuleConfig(string2, vector);
        EObject eObject3 = moduleRef.getExtensions();
        vector = new Vector();
        vector.addElement(eObject3);
        this.setModuleConfig(string3, vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fluffConfig: " + string2 + ", " + string3);
        }
    }

    protected Vector createModuleConfig(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModuleConfig");
        }
        if (this.isApp) {
            return super.createModuleConfig(string);
        }
        Vector vector = new Vector();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModuleConfig");
        }
        return vector;
    }

    public Module getModuleForDD(EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleForDD");
        }
        if (this.isApp) {
            return super.getModuleForDD(eObject);
        }
        try {
            if (this.moduleRef.getDeploymentDescriptor() == eObject) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getModuleForDD");
                }
                return this.moduleRef.getModule();
            }
        }
        catch (ArchiveWrappedException archiveWrappedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getModuleForDD: " + this.moduleRef + ", dd: " + eObject + " " + (Object)((Object)archiveWrappedException));
            }
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0049E", new Object[]{eObject}), archiveWrappedException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleForDD: BADDD: return null");
        }
        return null;
    }

    public void saveAndClose() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAndClose");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveAndClose");
        }
    }

    public Hashtable getSavedResults() {
        return super.getSavedResults();
    }

    public String getSecurityPolicyData() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityPolicyData");
        }
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityPolicyData");
        }
        return string;
    }

    public String getJ2EEAppVersion() {
        Application application;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEAppVersion");
        }
        if ((application = this.app) == null) {
            application = this.archive.getDeploymentDescriptor();
        }
        String string = "";
        if (application == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null Application DD");
            }
        } else {
            XMLResource xMLResource = (XMLResource)application.eResource();
            if (xMLResource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AppDD has no XML Resource: " + application);
                }
            } else {
                String string2 = xMLResource.getPublicId();
                if (string2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppDD has no XML Resource Id: " + application);
                    }
                } else if (string2.equalsIgnoreCase("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN")) {
                    string = AppConstants.APPDEPL_APP_VERSION_1_2;
                } else if (string2.equalsIgnoreCase("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN")) {
                    string = AppConstants.APPDEPL_APP_VERSION_1_3;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Return J2EE version: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEAppVersion");
        }
        return string;
    }

    public String getURI() {
        return null;
    }
}

