/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.security.auth.Subject;

public abstract class SchedulerImpl
implements Scheduler {
    private static TraceComponent tc = Tr.register(SchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    protected Vector tasks;
    protected int nextTaskNum = 0;
    protected String appName;
    protected String appTaskName = "xxx";
    protected AppManagement appManagement;
    protected Hashtable properties;
    protected String id;
    protected AppNotification.Listener notifier;
    protected WorkSpace workSpace;
    protected boolean amIWorkSpaceOwner = false;
    protected Locale locale;
    protected ResourceBundle resBundle;
    protected RepositoryContext cellContext = null;
    protected boolean setupDone = false;
    protected Subject subject = null;
    protected Throwable lastEx = null;

    public SchedulerImpl(String string, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SchedulerImpl");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appName: " + string + ", options: " + hashtable);
        }
        this.properties = hashtable;
        this.notifier = listener;
        if (!AppUtils.isEmpty(string)) {
            this.appName = string;
            this.appName = this.appName.trim();
        }
        this.appManagement = appManagement;
        if (this.properties != null) {
            this.locale = (Locale)this.properties.get("app.client.locale");
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.id = Long.toHexString(System.currentTimeMillis());
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", this.locale);
        if (!AdminHelper.getPlatformHelper().isZOS() && !AppManagementImpl.isLocalMode()) {
            this.subject = SecurityHelper.retrieveSubject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "subject: " + this.subject);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Uniquie id: " + this.id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SchedulerImpl");
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
    }

    public void setWorkSpaceID(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWorkSpaceID: " + string);
        }
        if (string == null) {
            this.amIWorkSpaceOwner = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create workspace");
        }
        this.workSpace = ConfigRepoHelper.getWorkSpace(string == null ? "" + this.id : string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WorkSpace root path: " + this.workSpace.getRootContext().getPath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWorkSpaceID: " + string);
        }
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    public String getID() {
        return this.id;
    }

    public AppManagement getAppManagement() {
        return this.appManagement;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public String getAppName() {
        return this.appName;
    }

    public void propagateTaskEvent(AppNotification appNotification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateTaskEvent");
        }
        if (appNotification == null) {
            return;
        }
        Properties properties = null;
        if (appNotification.props != null) {
            properties = appNotification.props;
        } else {
            properties = new Properties();
            appNotification.setProperties(properties);
        }
        properties.put("appname", this.appName);
        properties.putAll((Map<?, ?>)appNotification.props);
        Object v = this.getProperties().get("HandBackForClient");
        if (v != null) {
            properties.put("HandBackForClient", v);
        }
        if (this.notifier != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sending notification: " + appNotification);
            }
            this.notifier.appEventReceived(appNotification);
        }
        this.appManagement.sendJMXEvent(this.getJMXEventType(), appNotification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateTaskEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        boolean bl = true;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object = ExtClassLoader.getInstance();
            if (object == null) {
                object = this.getClass().getClassLoader();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "switching CCL to = " + object);
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)object);
            if (AdminHelper.getPlatformHelper().isZOS()) {
                if (!AppManagementImpl.isLocalMode()) {
                    this.subject = SecurityHelper.getOwnedSubject();
                    if (null != this.subject) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Pushing Server Subject: " + this.subject.toString());
                        }
                        this.subject = SecurityHelper.pushInvocationSubject(this.subject);
                    }
                }
            } else if (!AppManagementImpl.isLocalMode() && this.subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Push creds: " + this.subject);
                }
                this.subject = SecurityHelper.pushInvocationSubject(this.subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "After push: " + this.subject);
                }
            }
            this.setupTasks();
            this.setupDone = true;
            AbstractTask abstractTask = this.getNextTask();
            this.propagateTaskEvent(this.createStartEvent());
            while (abstractTask != null && bl) {
                abstractTask.setScheduler(this);
                abstractTask.setLocale(this.locale);
                abstractTask.setAppTaskName(this.appTaskName);
                Tr.debug(tc, "Executing: " + abstractTask);
                bl = abstractTask.performTask();
                if (bl) {
                    abstractTask = this.getNextTask();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            bl = false;
            this.lastEx = throwable;
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.SchedulerImpl.run", "223", this);
            AppUtils.dbg(tc, AppUtils.getMessage(this.resBundle, "ADMA6012I", new Object[]{throwable}));
            AppUtils.printEx(throwable, true);
        }
        finally {
            this.cleanup(bl);
            this.propagateTaskEvent(this.createCompletionEvent(bl));
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    protected AbstractTask getNextTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextTask");
        }
        if (this.nextTaskNum >= this.tasks.size()) {
            return null;
        }
        int n = this.nextTaskNum++;
        Object e2 = this.tasks.elementAt(n);
        Object var3_3 = null;
        if (e2 instanceof AbstractTask) {
            Tr.exit(tc, "getNextTask: " + e2);
            return (AbstractTask)e2;
        }
        if (e2 instanceof String) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "XXXX Task list should contain a task instance and not a string, needs to be changed: " + this + ", " + e2);
            }
            try {
                Class clazz = ExtensionHelper.loadExtension(null, (String)e2);
                return (AbstractTask)clazz.newInstance();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.SchedulerImpl.getNextTask", "258", this);
                if (this.resBundle != null) {
                    throw new AdminException(throwable, AppUtils.getMessage(this.resBundle, "ADMA0055E", new Object[]{var3_3}));
                }
                throw new AdminException(throwable);
            }
        }
        throw new AdminException("Unexpected task in the list: " + e2);
    }

    private void cleanup(boolean bl) {
        block15: {
            block14: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "cleanup: " + bl);
                }
                boolean bl2 = true;
                try {
                    this.performCleanup(bl);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.SchedulerImpl.cleanup", "276", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "performCleanup failed: " + throwable);
                    }
                    bl2 = false;
                }
                String string = "";
                if (this.resBundle != null) {
                    string = AppUtils.getMessage(this.resBundle, bl2 ? "ADMA5011I" : "ADMA5012I", new String[]{this.appName});
                }
                AppNotification appNotification = new AppNotification(this.appTaskName, "Cleanup", "InProgress", bl2 ? "Completed" : "Failed", string);
                this.propagateTaskEvent(appNotification);
                if ((this.amIWorkSpaceOwner || Boolean.TRUE.equals(this.properties.get("com.ibm.ws.management.application.manageWorkSpace"))) && this.workSpace != null) {
                    try {
                        ConfigRepoHelper.removeWorkSpace(bl, this.workSpace);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.application.SchedulerImpl.cleanup", "326", this);
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Error in removing workspace: " + throwable);
                    }
                }
            }
            if (!AppManagementImpl.isLocalMode() && this.subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pop creds: " + this.subject);
                }
                try {
                    SecurityHelper.popInvocationSubject(this.subject);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "After pop");
                    }
                    this.subject = null;
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "Error popping  subject after scheduler is done: " + throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup: " + bl);
        }
    }

    public RepositoryContext getCellContext() throws Exception {
        RepositoryContext repositoryContext;
        if (this.cellContext != null) {
            return this.cellContext;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellContext");
        }
        if ((repositoryContext = AppUtils.findAppContextFromConfig(this.appName, this.getWorkSpace(), this.getProperties())) == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5045E", new Object[]{this.appName}));
        }
        this.cellContext = AdminHelper.getPlatformHelper().isZOS() ? repositoryContext.getParentContext().getParentContext() : repositoryContext.getParent().getParent();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellContext:" + this.cellContext);
        }
        return this.cellContext;
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt";
    }

    protected abstract void setupTasks() throws Exception;

    protected abstract void performCleanup(boolean var1) throws Exception;

    protected abstract AppNotification createCompletionEvent(boolean var1);

    protected abstract AppNotification createStartEvent();

    public String getClientVersion() {
        return AppUtils.getClientVersion();
    }

    public String getTempDir() {
        return AppUtils.getAppTempDir(this);
    }
}

