/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.sync.AppBinaryProcessor;
import com.ibm.ws.management.application.task.UpdateClusterTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Hashtable;
import java.util.Vector;

public class UpdateClusterScheduler
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register(UpdateClusterScheduler.class);
    private String[] appNames;
    public static final String LAUNCH_TIMEOUT = "LAUNCH_TIMEOUT";
    public static final Integer DEFAULT_LAUNCH_TIMEOUT = new Integer(1200);
    public static final String APPLICATION_ROLLOUT_PAUSERESUME = "com.ibm.websphere.zos.rollout.pauseresume";

    public UpdateClusterScheduler(String[] stringArray, String string, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string, hashtable, appManagement, listener);
        this.appNames = stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UpdateClusterScheduler");
        }
        this.appTaskName = "UpdateCluster";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UpdateClusterScheduler");
        }
    }

    protected void setupTasks() throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupTasks");
        }
        if (!(bl = this.ensureAppsAreSaved())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App is not saved to config ");
            }
            AppNotification appNotification = new AppNotification(this.appTaskName, "", "Failed", "", AppUtils.getMessage(this.resBundle, "ADMA8001E", new Object[]{this.appName}) + " Applications are not yet saved to the config repository.");
            this.propagateTaskEvent(appNotification);
            throw new AdminException(null, "Applications are not yet saved to config repository");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Applications are saved to config repository");
        }
        this.tasks = new Vector();
        this.tasks.addElement(new UpdateClusterTask());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The tasks are: " + this.tasks);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTasks");
        }
    }

    private boolean ensureAppsAreSaved() throws AdminException {
        boolean bl;
        block14: {
            Object object;
            long l;
            long l2;
            block13: {
                bl = true;
                l2 = 180000L;
                l = 500L;
                if (System.getProperty("com.ibm.websphere.application.updateapponcluster.waitforappsave") != null) {
                    object = System.getProperty("com.ibm.websphere.application.updateapponcluster.waitforappsave");
                    try {
                        l2 = Long.parseLong((String)object) * 1000L;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Invalid App Save time out value - " + (String)object);
                        Tr.debug(tc, "Using default App Save time out: " + l2);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Applications Save max_wait_time: " + l2 / 1000L + "secs");
            }
            try {
                while (true) {
                    block15: {
                        object = AppBinaryProcessor.getAppsInProgress();
                        bl = true;
                        for (int i = 0; i < this.appNames.length && bl; bl &= !object.contains(this.appNames[i]), ++i) {
                        }
                        if (bl || l2 <= 0L) break block14;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Waiting for applications to be saved in the config repository");
                        }
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!tc.isDebugEnabled()) break block15;
                            Tr.debug(tc, "Wait interrupted");
                        }
                    }
                    l2 -= l;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.UpdateClusterScheduler.ensureAppsAreSaved", "126", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception: ", throwable.getMessage());
                }
                if (throwable instanceof AdminException) {
                    throw (AdminException)throwable;
                }
                throw new AdminException(throwable, "");
            }
        }
        return bl;
    }

    public String[] getAppNames() {
        return this.appNames;
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.updatecluster";
    }

    protected AppNotification createCompletionEvent(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCompletionEvent");
        }
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, bl ? "ADMA8000I" : "ADMA8001E", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("UpdateCluster", "", bl ? "Completed" : "Failed", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCompletionEvent");
        }
        return appNotification;
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStartEvent");
        }
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, "ADMA8002I", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("UpdateCluster", "", "InProgress", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStartEvent");
        }
        return appNotification;
    }

    protected void performCleanup(boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performCleanup");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performCleanup");
        }
    }

    public RepositoryContext getCellContext() throws Exception {
        RepositoryContext repositoryContext;
        if (this.cellContext != null) {
            return this.cellContext;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellContext");
        }
        if ((repositoryContext = AppUtils.findAppContextFromConfig(this.appNames[0], this.getWorkSpace(), this.getProperties())) == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5045E", new Object[]{this.appName}));
        }
        this.cellContext = repositoryContext.getParentContext().getParentContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellContext:" + this.cellContext);
        }
        return this.cellContext;
    }
}

