/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ArchiveSchedulerImpl;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.cdfj2eebridge.CDFBridgeExtensionHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.DeltaDataTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;

public class UpdateSchedulerImpl
extends ArchiveSchedulerImpl
implements UpdateScheduler {
    private static TraceComponent tc = Tr.register(UpdateSchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private boolean inPreUpdate = true;
    private String _contentURI;
    private String _operation;
    private String _origContentType;
    private List _deltaContents;
    private boolean isZeroBinCopy = false;

    public UpdateSchedulerImpl(String string, String string2, String string3, String string4, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string3, string, hashtable, appManagement, listener);
        this.appTaskName = "UpdateApplication";
        this._contentType = (String)hashtable.get("contenttype");
        this._contentURI = string2;
        if (this._contentURI != null) {
            this._contentURI = this._contentURI.replace('\\', '/');
        }
        this._operation = string4;
        this._origContentType = this._contentType;
        this._deltaContents = new ArrayList();
    }

    public String getOperation() {
        return this._operation;
    }

    public String getContentPath() {
        return super.getArchivePath();
    }

    public void setContentPath(String string) throws AdminException {
        super.setArchivePath(string);
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getOrigContentType() {
        return this._origContentType;
    }

    public void setContentType(String string) throws AdminException {
        if (string == null || string.equals(this.getContentType())) {
            return;
        }
        if (!this.inPreUpdate) {
            throw new AdminException("ContentType can only be set in pre update phase.");
        }
        this._contentType = string;
        this.setContentPath(this.getContentPath());
    }

    public Archive getContentAsArchive() throws AdminException {
        if (!(this.isZeroBinCopy || this._contentType.equals("app") || this._contentType.equals("modulefile"))) {
            return null;
        }
        return super.getArchive();
    }

    public Archive getContentAsArchive(boolean bl, boolean bl2) throws AdminException {
        if (!(this.isZeroBinCopy || this._contentType.equals("app") || this._contentType.equals("modulefile"))) {
            return null;
        }
        return super.getArchive(bl, bl2);
    }

    public String getContentURI() {
        return this._contentURI;
    }

    protected AppNotification createCompletionEvent(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCompletionEvent");
        }
        String string = "Update of " + this.appName + " has ended.";
        AppNotification appNotification = new AppNotification("UpdateApplication", "", bl ? "Completed" : "Failed", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCompletionEvent");
        }
        return appNotification;
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStartEvent");
        }
        String string = "Update of " + this.appName + " has started.";
        AppNotification appNotification = new AppNotification("UpdateApplication", "", "InProgress", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStartEvent");
        }
        return appNotification;
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.update";
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupTasks");
        }
        try {
            this.validateParams(this.getProperties(), this._contentURI, this._pathToContent, this._operation);
        }
        catch (AdminException adminException) {
            String string = "";
            if (this.resBundle != null) {
                string = AppUtils.getMessage(this.resBundle, "ADMA0169E", new String[]{this.appName});
            }
            this.propagateTaskEvent(new AppNotification("UpdateApplication", "", "InProgress", "", string + adminException.getMessage()));
            throw adminException;
        }
        this.tasks = new Vector();
        DefaultTaskProvider defaultTaskProvider = new DefaultTaskProvider();
        defaultTaskProvider.providePreUpdateTasks(this.tasks, this);
        this.tasks = ExtensionHelper.processServerPreUpdateExtensions(this.properties, this.tasks, this);
        this.inPreUpdate = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTasks");
        }
    }

    protected void performCleanup(boolean bl) throws Exception {
        super.performCleanup(bl);
        if (!bl && !this.amIWorkSpaceOwner) {
            String string = "An update application operation failed and the configuration session could not be restored to its state before the operation was initiated.  The configuration session is in an inconsistent state, and changes made in the session should be discarded.";
            if (this.resBundle != null) {
                string = AppUtils.getMessage(this.resBundle, "ADMA0185W");
            }
            AppNotification appNotification = new AppNotification("UpdateApplication", "", "Warning", "", string);
            this.propagateTaskEvent(appNotification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateParams(Hashtable hashtable, String string, String string2, String string3) throws Exception {
        RepositoryContext repositoryContext;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "op " + string3);
        }
        if ((repositoryContext = AppUtils.findAppContextFromConfig(this.appName, this.getWorkSpace(), this.getProperties())) == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
        }
        boolean bl = AppUtils.isEmpty(string);
        boolean bl2 = AppUtils.isEmpty(string2);
        String string4 = (String)hashtable.get("contenttype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cType " + string4);
        }
        if (ConfigRepoHelper.getAppDeploymentForApp(repositoryContext).isZeroBinaryCopy()) {
            this._pathToContent = ConfigRepoHelper.getAbsoluteBinariesURL(repositoryContext, this.getWorkSpace());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_pathToContent " + this._pathToContent);
            }
            if (!new File(this._pathToContent).exists()) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0174E", new Object[0]));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No other validation for zero binary copy");
            }
            this.isZeroBinCopy = true;
            if (AppUtils.isEmpty(string4)) {
                string4 = "partialapp";
            }
            return;
        }
        if (!bl) {
            this._contentURI = string.replace('\\', '/');
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_contentURI " + this._contentURI);
        }
        if (AppUtils.isEmpty(string4) || !string4.equals("app") && !string4.equals("file") && !string4.equals("partialapp") && !string4.equals("modulefile")) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0130E", new String[]{string4, this.appName}));
        }
        if (!(string4.equals("partialapp") || !AppUtils.isEmpty(string3) && (string3.equalsIgnoreCase("add") || string3.equalsIgnoreCase("addupdate") || string3.equalsIgnoreCase("delete") || string3.equalsIgnoreCase("update")))) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0132E", new String[]{string3, this.appName}));
        }
        if ("delete".equals(this._operation) && (string4.equals("file") || string4.equals("modulefile"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove jsp precompile or ejbdeploy flags for delete");
            }
            this.getProperties().remove("preCompileJSPs");
            this.getProperties().remove("deployejb");
        }
        if (string4.equals("partialapp")) {
            if (bl2) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0131E", new String[0]));
            }
            File file = new File(string2);
            if (!file.exists()) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0165E", new String[]{string2}));
            }
        } else {
            File file;
            if (string3.equals("add") || string3.equals("addupdate") || string3.equals("update")) {
                if (bl || bl2) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0133E"));
                }
                if (string4.equals("modulefile")) {
                    int n = string.indexOf(File.separator);
                    String string5 = null;
                    if (n > 0) {
                        string5 = string.substring(0, n);
                    } else {
                        n = string.indexOf("/");
                        if (n > 0) {
                            string5 = string.substring(0, n);
                        }
                    }
                    if (string5 != null && (string5.endsWith(".ear") || string5.endsWith(".jar") || string5.endsWith(".war") || string5.endsWith(".rar"))) {
                        throw new AdminException("Parameter validation failure for " + this.appName + ". The contentURI '" + string + "'  for modulefile update has syntax error. Please make sure it contains the module uri only. ");
                    }
                }
                if (!(file = new File(string2)).exists()) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0134E", new String[]{string2, this.appName}));
                }
            } else if (string3.equalsIgnoreCase("delete") && bl) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0135E"));
            }
            file = null;
            try {
                boolean bl3 = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext).isZeroEarCopy();
                file = !bl3 ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, this.getWorkSpace(), this.resBundle, true) : ConfigRepoHelper.getEarFileFromDeployment(this.getWorkSpace(), repositoryContext);
                if ("modulefile".equals(string4) && "addupdate".equals(string3)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "For ModuleFile::ADDUPDATE case lets decide if ADD or UPDATE");
                    }
                    this._operation = this.containsModuleFile((EARFile)file, string) ? "update" : "add";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "For ModuleFile::ADDUPDATE case changed operation to " + this._operation);
                    }
                }
                if ("modulefile".equals(string4) && "delete".equals(string3)) {
                    this.checkRemoveLastModule((EARFile)file, string);
                }
                if (!bl3 || string.matches("META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*")) {
                    this.checkDuplicate((EARFile)file, string, string3);
                }
                if (("add".equals(string3) || "update".equals(string3) || "delete".equals(string3)) && bl3 && string4.equals("modulefile")) {
                    this.checkDuplicateForZeroEarCopy((EARFile)file, string, string3);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof AdminException) {
                    throw (AdminException)throwable;
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.UpdateScheduler.validateParams", "360", this);
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
    }

    private boolean containsModuleFile(EARFile eARFile, String string) throws Exception {
        EList eList = eARFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            if (!((ModuleRef)eList.get(i)).getUri().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void checkDuplicate(EARFile eARFile, String string, String string2) throws AdminException {
        Object[] objectArray = null;
        try {
            objectArray = AppUtils.getContainerAndOffset((Container)eARFile, string);
        }
        catch (Exception exception) {
            throw new AdminException("ERROR: " + exception.getMessage());
        }
        Container container2 = (Container)objectArray[0];
        String string3 = (String)objectArray[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "container = " + container2 + " , offset = " + string3);
        }
        if (container2.containsFile(string3)) {
            if ("add".equals(string2)) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0166E", new Object[]{string, string2}));
            }
        } else {
            EList eList = container2.getFiles();
            boolean bl = false;
            String string4 = string3 + "/";
            if (!string4.endsWith("/")) {
                string4 = string3 + "/";
            }
            if (eList != null) {
                for (int i = 0; i < eList.size(); ++i) {
                    org.eclipse.jst.j2ee.commonarchivecore.internal.File file = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)eList.get(i);
                    if (file.getURI().indexOf(string4) == -1) continue;
                    if ("update".equals(string2) || "addupdate".equals(string2)) {
                        throw new AdminException("Parameter validation failure for " + this.appName + ". The contentURI '" + string3 + "'  for file update points to the directory. Directory can not be replaced by a single file.");
                    }
                    if ("add".equals(string2)) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0166E", new Object[]{string, string2}));
                    }
                    bl = true;
                    break;
                }
            }
            if (!bl && ("update".equals(string2) || "delete".equals(string2))) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0167E", new Object[]{string, string2}));
            }
        }
    }

    private void checkDuplicateForZeroEarCopy(EARFile eARFile, String string, String string2) throws AdminException {
        int n;
        EList eList = eARFile.getModuleRefs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "search uri: " + string);
        }
        for (n = 0; n < eList.size(); ++n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri: " + ((ModuleRef)eList.get(n)).getUri());
            }
            if (eList.size() != 1 || !((ModuleRef)eList.get(0)).getUri().equals(string)) continue;
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0168E", new Object[]{string}));
        }
        try {
            n = this.containsModuleFile(eARFile, string) ? 1 : 0;
            if (n != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "contains " + string);
                }
                if ("add".equals(string2)) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0166E", new Object[]{string, string2}));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not contains " + string);
                }
                if ("update".equals(string2) || "delete".equals(string2)) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0167E", new Object[]{string, string2}));
                }
            }
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable);
        }
    }

    private void checkRemoveLastModule(EARFile eARFile, String string) throws AdminException {
        EList eList = eARFile.getModuleRefs();
        if (eList.size() == 1 && ((ModuleRef)eList.get(0)).getUri().equals(string)) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0168E", new Object[]{string}));
        }
    }

    protected AbstractTask getNextTask() throws AdminException {
        if (this.inPreUpdate && this.nextTaskNum >= this.tasks.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Preupdate phase is over . gather update tasks");
            }
            this.inPreUpdate = false;
            Vector vector = new Vector();
            DefaultTaskProvider defaultTaskProvider = new DefaultTaskProvider();
            defaultTaskProvider.provideUpdateTasks(vector, this);
            try {
                vector = ExtensionHelper.processServerUpdateExtensions(this.properties, vector, this);
                CDFBridgeExtensionHelper.processServerUpdateExtensions(this.properties, vector, this);
            }
            catch (AppDeploymentException appDeploymentException) {
                throw new AdminException(appDeploymentException, "");
            }
            vector.addElement(new DeltaDataTask());
            this.tasks.addAll(vector);
            vector = null;
        }
        return super.getNextTask();
    }

    public void notifyDeltaUpdate(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notifyDeltaUpdate: " + string + ", " + string2);
        }
        this._deltaContents.add(string);
        this._deltaContents.add(string2);
    }

    public List getDeltaContents() {
        return this._deltaContents;
    }
}

