/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.cdfj2eebridge;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.EarWrapperTask;
import com.ibm.websphere.management.deployment.core.DeployableObject;
import com.ibm.websphere.management.deployment.core.DeploymentContext;
import com.ibm.websphere.management.deployment.core.DeploymentStep;
import com.ibm.websphere.management.deployment.exception.DeploymentException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.cdfj2eebridge.CDFStepWrapper;
import com.ibm.ws.management.deployment.j2ee.J2EEToCDFBridge;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class CDFBridgeExtensionHelper {
    private static TraceComponent tc = Tr.register(CDFBridgeExtensionHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public static void processServerInstallExtensions(Hashtable hashtable, Vector vector, InstallScheduler installScheduler) throws AppDeploymentException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processServerInstallExtensions", new Object[]{hashtable, vector, installScheduler});
            }
            try {
                CDFBridgeExtensionHelper.provideServerExtensions(1L, vector, installScheduler, hashtable);
            }
            catch (Throwable throwable) {
                AppUtils.dbg(tc, "xxxException in getting CDF server extensions for install" + throwable);
                if (!(throwable instanceof AppDeploymentException)) break block4;
                throw (AppDeploymentException)throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerInstallExtensions", new Object[]{hashtable, vector, installScheduler});
        }
    }

    public static void processServerExtensionsForEdit(Hashtable hashtable, Vector vector, Scheduler scheduler) throws AppDeploymentException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processServerExtensionsForEdit", new Object[]{hashtable, vector, scheduler});
            }
            try {
                CDFBridgeExtensionHelper.provideServerExtensions(2L, vector, scheduler, hashtable);
            }
            catch (Throwable throwable) {
                AppUtils.dbg(tc, "xxxException in getting CDF server extensions for edit: " + throwable);
                if (!(throwable instanceof AppDeploymentException)) break block4;
                throw (AppDeploymentException)throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerExtensionsForEdit", new Object[]{hashtable, vector, scheduler});
        }
    }

    public static void processServerUpdateExtensions(Hashtable hashtable, Vector vector, UpdateSchedulerImpl updateSchedulerImpl) throws AppDeploymentException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processServerUpdateExtensions", new Object[]{hashtable, vector, updateSchedulerImpl});
            }
            try {
                CDFBridgeExtensionHelper.provideServerExtensions(4L, vector, updateSchedulerImpl, hashtable);
            }
            catch (Throwable throwable) {
                AppUtils.dbg(tc, "xxxException in getting CDF server extensions for update: " + throwable);
                if (!(throwable instanceof AppDeploymentException)) break block4;
                throw (AppDeploymentException)throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerUpdateExtensions", new Object[]{hashtable, vector, updateSchedulerImpl});
        }
    }

    public static void processServerUninstallExtensions(Hashtable hashtable, Vector vector, Scheduler scheduler) throws AppDeploymentException {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processServerUninstallExtensions", new Object[]{hashtable, vector, scheduler});
            }
            try {
                CDFBridgeExtensionHelper.provideServerExtensions(8L, vector, scheduler, hashtable);
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    AppUtils.dbg(tc, "Exception in getting CDF server extensions for uninstall: " + throwable);
                }
                if (!(throwable instanceof AppDeploymentException)) break block5;
                throw (AppDeploymentException)throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerUninstallExtensions", new Object[]{hashtable, vector, scheduler});
        }
    }

    public static void processEarWrapperExtension(Vector vector, Archive archive, String string, String string2, Hashtable hashtable) throws AppDeploymentException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processEarWrapperExtension", new Object[]{archive, string, string2, hashtable});
            }
            Object var5_5 = null;
            Object var6_6 = null;
            boolean bl = false;
            try {
                J2EEToCDFBridge.addCDFServerPluginToJ2EE(16L, vector, null, hashtable);
            }
            catch (Throwable throwable) {
                AppUtils.dbg(tc, "Exception in getting CDF create ear wrapper extensions: " + throwable);
                if (!(throwable instanceof AppDeploymentException)) break block4;
                throw (AppDeploymentException)throwable;
            }
        }
        AppUtils.dbg(tc, "tasks.size() == " + vector.size());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processEarWrapperExtension", new Object[]{hashtable, vector});
        }
    }

    public static String executeEarWrapperExtension(Vector vector, Archive archive, String string, String string2, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeEarWrapperTasks", new Object[]{vector});
        }
        String string3 = null;
        int n = vector.size();
        AppUtils.dbg(tc, "earWrapperTasks.size() = " + n);
        if (n == 0) {
            return null;
        }
        Object object = null;
        for (int i = 0; i < n; ++i) {
            string3 = null;
            object = vector.get(i);
            if (object instanceof DeploymentStep) {
                string3 = CDFBridgeExtensionHelper.executeCDFEarWrapperStep((DeploymentStep)object, archive, string, string2, hashtable);
            } else if (object instanceof EarWrapperTask) {
                string3 = ((EarWrapperTask)object).executeTask(archive, string, string2, hashtable);
            }
            if (string3 != null) break;
        }
        if (string3 != null) {
            AppUtils.dbg(tc, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0156I", new String[]{object.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeEarWrapperTasks", new Object[]{string3});
        }
        return string3;
    }

    private static String executeCDFEarWrapperStep(DeploymentStep deploymentStep, Archive archive, String string, String string2, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCDFEarWrapperStep", new Object[]{deploymentStep, archive, string, string2, hashtable});
        }
        String string3 = null;
        boolean bl = false;
        try {
            DeployableObject deployableObject = J2EEToCDFBridge.createDO(archive);
            deploymentStep.getContext().getContextData().put(DeploymentContext.EARWRAPPER_NewFileName_key, string);
            deploymentStep.getContext().getContextData().put(DeploymentContext.EARWRAPPER_NewModuleUri_key, string2);
            deploymentStep.getContext().getContextData().put(DeploymentContext.PREFS_Hashtable_key, hashtable);
            AppUtils.dbg(tc, "executing step " + deploymentStep.getClass().toString());
            bl = deploymentStep.execute(deployableObject);
            string3 = (String)deploymentStep.getContext().getContextData().get(DeploymentContext.RETURN_Object_key);
            AppUtils.dbg(tc, "newEarPath = " + string3);
        }
        catch (DeploymentException deploymentException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCDFEarWrapperStep", new Object[]{string3});
        }
        return string3;
    }

    private static void provideServerExtensions(long l, Vector vector, Scheduler scheduler, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "provideServerExtensions", new Object[]{vector, scheduler});
        }
        int n = vector.size();
        AppUtils.dbg(tc, "..... orig j2eeTasks size:  " + n);
        try {
            J2EEToCDFBridge.addCDFServerPluginToJ2EE(l, vector, scheduler, hashtable);
        }
        catch (Throwable throwable) {
            throw new AppDeploymentException(throwable.getMessage(), throwable);
        }
        int n2 = vector.size();
        AppUtils.dbg(tc, "..... new j2eeTasks size " + n2);
        if (n2 > n) {
            for (int i = 0; i < n2; ++i) {
                Object e2 = vector.get(i);
                if (!(e2 instanceof DeploymentStep)) continue;
                AppUtils.dbg(tc, "converting " + e2.getClass().getName() + " to CDFStepWrapper tht");
                vector.set(i, new CDFStepWrapper((DeploymentStep)e2));
            }
        } else {
            AppUtils.dbg(tc, "No new CDF steps were found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "provideServerExtensions", new Object[]{vector, scheduler});
        }
    }
}

