/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.CommonbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPResAuthType;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndPackage;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.impl.EjbbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.BindingStrategy;
import com.ibm.ws.management.application.dfltbndngs.ConnectionFactoryBinding;
import com.ibm.ws.management.application.dfltbndngs.CustomizeableStrategy;
import com.ibm.ws.management.application.dfltbndngs.DataSourceBinding;
import com.ibm.ws.management.application.dfltbndngs.DefaultStrategy;
import com.ibm.ws.management.application.dfltbndngs.EjbId;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.dfltbndngs.StrategyExporter;
import com.ibm.ws.management.application.dfltbndngs.utils.EJBRefPkg;
import com.ibm.ws.management.application.dfltbndngs.utils.GetAllResourceEnvRefs;
import com.ibm.ws.management.application.dfltbndngs.utils.GetAllResourceRefs;
import com.ibm.ws.management.application.dfltbndngs.utils.GetAllVirtualHosts;
import com.ibm.ws.management.application.dfltbndngs.utils.GetEjbRefs;
import com.ibm.ws.management.application.dfltbndngs.utils.GetMessageDestinationRefs;
import com.ibm.ws.management.application.dfltbndngs.utils.MessageDestinationRefPkg;
import com.ibm.ws.management.application.dfltbndngs.utils.ResEnvRef;
import com.ibm.ws.management.application.dfltbndngs.utils.ResRef;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class BindEarCmd
implements BindingStrategy.WarningCollaborator {
    static TraceComponent tc = Tr.register(BindEarCmd.class, null, "com.ibm.ws.management.resources.BindEarCmd");
    private EARFile ear = null;
    private BindingStrategy strategy = null;
    private Vector warnings = null;
    private ResourceBundle nlsBundle = null;
    private Preferences preferences = null;
    private boolean isCreateMode = false;

    public String toString() {
        return "BindEarCmd{ ear=" + this.ear + ", strategy=" + this.strategy + "}";
    }

    public BindEarCmd() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>()");
        }
        this.preferences = new Preferences();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>()", this.toString());
        }
    }

    public BindEarCmd(EARFile eARFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>(EARFile)", eARFile);
        }
        this.ear = eARFile;
        this.strategy = new DefaultStrategy();
        this.preferences = new Preferences();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>(EARFile)", this.toString());
        }
    }

    public BindEarCmd(EARFile eARFile, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>(EARFile)", eARFile);
        }
        this.ear = eARFile;
        this.isCreateMode = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>(EARFile)", this.toString());
        }
    }

    public BindEarCmd(EARFile eARFile, Preferences preferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>(EARFile,Preferences)", new Object[]{eARFile, preferences});
        }
        this.ear = eARFile;
        this.preferences = preferences;
        if (preferences.getStrategyFile() == null || preferences.getStrategyFile().length() == 0 || preferences.getStrategyFile().equalsIgnoreCase("default")) {
            this.strategy = new DefaultStrategy(preferences);
        } else {
            this.strategy = new CustomizeableStrategy(preferences);
            if (!preferences.getStrategyFile().equals("_NULL_")) {
                try {
                    ((CustomizeableStrategy)this.strategy).parse(preferences.getStrategyFile());
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.BindEarCmd.BindEarCmd", "134", this);
                    throwable.printStackTrace();
                    throw new IllegalStateException("error enabling custom strategy");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>(EARFile,Preferences)", this.toString());
        }
    }

    public EARFile getEar() {
        return this.ear;
    }

    public void setEar(EARFile eARFile) {
        this.ear = eARFile;
    }

    public BindingStrategy getStrategy() {
        return this.strategy;
    }

    public boolean bind() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind", this.toString());
        }
        this.warnings = new Vector();
        this.bindEjbs();
        this.bindResourceRefs();
        this.bindResourceEnvRefs();
        this.bindEjbRefs();
        if (!this.isCreateMode) {
            this.bindVirtualHosts();
        }
        this.bindMessageDestinationRefs();
        if (!this.isCreateMode && this.preferences.getExportFile() != null) {
            StrategyExporter strategyExporter = new StrategyExporter(this.preferences, this.ear);
            strategyExporter.export();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bind", this.warnings.toString());
        }
        return this.warnings.size() == 0;
    }

    public Collection getWarnings() {
        return this.warnings;
    }

    public void logWarning(String string, Object[] objectArray) {
        Tr.warning(tc, string, objectArray);
        if (this.nlsBundle == null) {
            this.nlsBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.BindEarCmd");
        }
        this.warnings.add(MessageFormat.format(this.nlsBundle.getString(string), objectArray));
    }

    protected void bindEjbs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbs");
        }
        try {
            List list = this.getEar().getEJBModuleRefs();
            for (int i = 0; i < list.size(); ++i) {
                EJBModuleRef eJBModuleRef = (EJBModuleRef)list.get(i);
                EJBJarFile eJBJarFile = (EJBJarFile)eJBModuleRef.getModuleFile();
                EJBJar eJBJar = eJBModuleRef.getEJBJar();
                EJBJarBinding eJBJarBinding = eJBModuleRef.getEJBJarBinding();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bindEjbs - found EJB jar", new Object[]{"ejbJar=" + eJBJarFile.getName()});
                }
                if (eJBJarBinding == null) {
                    eJBJarBinding = EjbbndFactoryImpl.getActiveFactory().createEJBJarBinding();
                    eJBJarBinding.setEjbJar(eJBJar);
                }
                if (((XMLResource)eJBJar.eResource()).getVersionID() == 12) {
                    this.bindEjbJarDefaultDatasource(eJBJarFile, eJBJarBinding);
                } else {
                    this.bindEjbJarDefaultDatasource(eJBJarFile, eJBJarBinding);
                    this.bindEjbJarDefaultConnectionFactory(eJBJarFile, eJBJarBinding);
                }
                EList eList = eJBJar.getEnterpriseBeans();
                for (int j = 0; j < eList.size(); ++j) {
                    EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(j);
                    if (enterpriseBean.isMessageDriven()) {
                        this.bindMdb((MessageDriven)enterpriseBean, eJBJarBinding);
                        continue;
                    }
                    this.bindNonMdb(enterpriseBean, eJBJarBinding, eJBJar);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindEjbs");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.dfltbndngs.BindEarCmd.bindEjbs", "262", this);
            Tr.error(tc, "BNDEAR0000", exception.getMessage());
            throw new BindingError("couldnt bind EJBs", exception);
        }
    }

    protected void bindMdb(MessageDriven messageDriven, EJBJarBinding eJBJarBinding) throws BindingError {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMdb", new Object[]{"mdb=" + messageDriven, "ejbBinding=" + eJBJarBinding});
        }
        MessageDrivenBeanBinding messageDrivenBeanBinding = (MessageDrivenBeanBinding)eJBJarBinding.getEJBBinding((EnterpriseBean)messageDriven);
        EList eList = eJBJarBinding.getEjbBindings();
        if (messageDrivenBeanBinding == null) {
            object = ((EjbbndPackage)EPackage.Registry.INSTANCE.getEPackage("ejbbnd.xmi")).getEjbbndFactory();
            messageDrivenBeanBinding = object.createMessageDrivenBeanBinding();
            messageDrivenBeanBinding.setEnterpriseBean((EnterpriseBean)messageDriven);
            messageDrivenBeanBinding.setModuleBinding(eJBJarBinding);
            eList.add(messageDrivenBeanBinding);
        }
        if (this.isCreateMode) {
            return;
        }
        Tr.debug(tc, "The Value of strPreferExisting" + System.getProperty("com.ibm.websphere.management.application.dfltbndng.mdb.preferexisting"));
        object = "true".equals(System.getProperty("com.ibm.websphere.management.application.dfltbndng.mdb.preferexisting")) ? "true" : "false";
        Tr.debug(tc, "The Value of strPreferExisting" + (String)object);
        String string = messageDrivenBeanBinding.getActivationSpecJndiName();
        String string2 = messageDrivenBeanBinding.getListenerInputPortName();
        Tr.debug(tc, "The Value of jndiName" + string);
        Tr.debug(tc, "The Value of listenerPort" + string2);
        if (!((String)object).equals("true") || (string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
            String string3 = "com.ibm.websphere.management.application.dfltbndng.mdb.preferMDBCustomBindingsExclusive";
            boolean bl = "true".equalsIgnoreCase(System.getProperty(string3));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prefer custom bnd flag for MDB = " + bl);
            }
            if ((string = this.getStrategy().getMDBActivationSpec(messageDriven.getName(), string, ((XMLResource)eJBJarBinding.getEjbJar().eResource()).getVersionID() > 13, this)) != null) {
                messageDrivenBeanBinding.setActivationSpecJndiName(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "bindMdb", new Object[]{"mdb=" + messageDriven, "ejbBinding=" + eJBJarBinding, "jndiName=" + string});
            }
            if (string != null && bl) {
                messageDrivenBeanBinding.setListenerInputPortName(null);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "preferMDBCustomBindingsExclusive is set and act spec jndi is non null so setting lport to null");
                }
            }
            if (string == null) {
                string2 = this.getStrategy().getMDBListenerPort(messageDriven.getName(), string2, this);
                messageDrivenBeanBinding.setListenerInputPortName(string2);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindMdb", new Object[]{"mdb=" + messageDriven, "ejbBinding=" + eJBJarBinding, "listenerPort=" + string2});
                }
                if (bl) {
                    if (((XMLResource)eJBJarBinding.getEjbJar().eResource()).getVersionID() > 13) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EJb2.1 so set act spec jndi to null");
                        }
                        messageDrivenBeanBinding.setActivationSpecJndiName(null);
                        messageDrivenBeanBinding.setDestinationJndiName(null);
                    } else if (this.getStrategy() instanceof CustomizeableStrategy && ((CustomizeableStrategy)this.getStrategy()).hasMDBListenerPortCustom(messageDriven.getName())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EJb2.0 and has listener port in custom so setting act spec to null");
                        }
                        messageDrivenBeanBinding.setActivationSpecJndiName(null);
                        messageDrivenBeanBinding.setDestinationJndiName(null);
                    }
                }
            }
        }
    }

    protected void bindNonMdb(EnterpriseBean enterpriseBean, EJBJarBinding eJBJarBinding, EJBJar eJBJar) throws BindingError {
        String string;
        Object object;
        boolean bl;
        EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding(enterpriseBean);
        EList eList = eJBJarBinding.getEjbBindings();
        if (enterpriseBeanBinding == null) {
            enterpriseBeanBinding = EjbbndFactoryImpl.getActiveFactory().createEnterpriseBeanBinding();
            enterpriseBeanBinding.setEnterpriseBean(enterpriseBean);
            enterpriseBeanBinding.setModuleBinding(eJBJarBinding);
            eList.add(enterpriseBeanBinding);
        }
        boolean bl2 = enterpriseBean.isEntity() && ((Entity)enterpriseBean).isContainerManagedEntity();
        boolean bl3 = bl = bl2 && enterpriseBean.getVersionID() == 11;
        if (bl2) {
            if (bl) {
                object = enterpriseBeanBinding.getDatasource();
                if (object == null) {
                    object = CommonbndFactoryImpl.getActiveFactory().createResourceRefBinding();
                    enterpriseBeanBinding.setDatasource(object);
                }
                if ((string = (BasicAuthData)object.getDefaultAuth()) == null) {
                    string = CommonbndFactoryImpl.getActiveFactory().createBasicAuthData();
                    object.setDefaultAuth((AbstractAuthData)string);
                }
            } else {
                object = enterpriseBeanBinding.getCmpConnectionFactory();
                if (object == null) {
                    object = EjbbndFactoryImpl.getActiveFactory().createCMPConnectionFactoryBinding();
                    enterpriseBeanBinding.setCmpConnectionFactory((CMPConnectionFactoryBinding)object);
                }
            }
        }
        if (this.isCreateMode) {
            return;
        }
        object = enterpriseBeanBinding.getJndiName();
        string = enterpriseBean.getName();
        String string2 = enterpriseBean.getHomeInterfaceName();
        String string3 = enterpriseBean.getRemoteInterfaceName();
        String string4 = enterpriseBean.getLocalHomeInterfaceName();
        String string5 = enterpriseBean.getLocalInterfaceName();
        EjbId ejbId = new EjbId(string, string2, string3, string4, string5, null);
        object = this.getStrategy().getEJBBinding(ejbId, (String)object, this);
        enterpriseBeanBinding.setJndiName((String)object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindEjb - bound EJB", new Object[]{"ejbInfo=" + ejbId, "jndiName=" + (String)object});
        }
        if (bl2) {
            if (bl) {
                if (!(this.bindCmpToDataSource((Entity)enterpriseBean, enterpriseBeanBinding) || eJBJarBinding.getDefaultDatasource() != null && eJBJarBinding.getDefaultDatasource().getJndiName() != null && eJBJarBinding.getDefaultDatasource().getJndiName().trim().length() != 0)) {
                    this.logWarning("BNDEAR0010", new Object[]{string});
                }
            } else if (!(this.bindCmpToConnectionFactory((Entity)enterpriseBean, enterpriseBeanBinding) || eJBJarBinding.getDefaultCMPConnectionFactory() != null && eJBJarBinding.getDefaultCMPConnectionFactory().getJndiName() != null && eJBJarBinding.getDefaultCMPConnectionFactory().getJndiName().trim().length() != 0)) {
                this.logWarning("BNDEAR0009", new Object[]{string});
            }
        }
    }

    protected boolean bindCmpToDataSource(Entity entity, EnterpriseBeanBinding enterpriseBeanBinding) throws BindingError {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindCmpToDataSource", new Object[]{"ejb=" + entity, "ejbBinding=" + enterpriseBeanBinding});
        }
        ResourceRefBinding resourceRefBinding = enterpriseBeanBinding.getDatasource();
        BasicAuthData basicAuthData = (BasicAuthData)resourceRefBinding.getDefaultAuth();
        String string = entity.getName();
        String string2 = entity.getHomeInterfaceName();
        String string3 = entity.getRemoteInterfaceName();
        String string4 = entity.getLocalHomeInterfaceName();
        String string5 = entity.getLocalInterfaceName();
        EjbId ejbId = new EjbId(string, string2, string3, string4, string5, null);
        DataSourceBinding dataSourceBinding = new DataSourceBinding(resourceRefBinding.getJndiName(), basicAuthData.getUserId(), basicAuthData.getPassword());
        dataSourceBinding = this.getStrategy().getEJBDatasourceBinding(ejbId, dataSourceBinding, this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindCmpToDataSource - binding info:", new Object[]{"ejbInfo=" + ejbId, "binding=" + dataSourceBinding});
        }
        if (dataSourceBinding.getJndiName() == null || dataSourceBinding.getJndiName().trim().length() == 0) {
            bl = false;
        } else {
            resourceRefBinding.setJndiName(dataSourceBinding.getJndiName());
            enterpriseBeanBinding.setDatasource(resourceRefBinding);
            if (dataSourceBinding.getUser() != null) {
                basicAuthData.setUserId(dataSourceBinding.getUser());
                basicAuthData.setPassword(dataSourceBinding.getPassword());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindCmpToDataSource", new Object[]{"ejb=" + entity, "ejbBinding=" + enterpriseBeanBinding});
        }
        return bl;
    }

    protected boolean bindCmpToConnectionFactory(Entity entity, EnterpriseBeanBinding enterpriseBeanBinding) throws BindingError {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindCmpToConnectionFactory", new Object[]{"ejb=" + entity, "ejbBinding=" + enterpriseBeanBinding});
        }
        CMPConnectionFactoryBinding cMPConnectionFactoryBinding = enterpriseBeanBinding.getCmpConnectionFactory();
        String string = entity.getName();
        String string2 = entity.getHomeInterfaceName();
        String string3 = entity.getRemoteInterfaceName();
        String string4 = entity.getLocalHomeInterfaceName();
        String string5 = entity.getLocalInterfaceName();
        int n = 0;
        if (cMPConnectionFactoryBinding.getResAuth() != null) {
            n = cMPConnectionFactoryBinding.getResAuth().getValue();
        }
        EjbId ejbId = new EjbId(string, string2, string3, string4, string5, null);
        ConnectionFactoryBinding connectionFactoryBinding = new ConnectionFactoryBinding(cMPConnectionFactoryBinding.getJndiName(), n);
        connectionFactoryBinding = this.getStrategy().getEJBConnectionFactoryBinding(ejbId, connectionFactoryBinding, this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindCmpToConnectionFactory - binding info:", new Object[]{"ejbInfo=" + ejbId, "binding=" + connectionFactoryBinding});
        }
        if (connectionFactoryBinding.getJndiName() == null || connectionFactoryBinding.getJndiName().trim().length() == 0) {
            bl = false;
        } else {
            cMPConnectionFactoryBinding.setJndiName(connectionFactoryBinding.getJndiName());
            cMPConnectionFactoryBinding.setResAuth(CMPResAuthType.get((int)connectionFactoryBinding.getResAuth()));
            enterpriseBeanBinding.setCmpConnectionFactory(cMPConnectionFactoryBinding);
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindCmpToConnectionFactory", new Object[]{"ejb=" + entity, "ejbBinding=" + enterpriseBeanBinding});
        }
        return bl;
    }

    protected void bindEjbJarDefaultConnectionFactory(EJBJarFile eJBJarFile, EJBJarBinding eJBJarBinding) throws BindingError {
        CMPConnectionFactoryBinding cMPConnectionFactoryBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbJarDefaultConnectionFactory", new Object[]{"ejbJar=" + eJBJarFile, "bnd=" + eJBJarBinding});
        }
        if ((cMPConnectionFactoryBinding = eJBJarBinding.getDefaultCMPConnectionFactory()) == null) {
            cMPConnectionFactoryBinding = EjbbndFactoryImpl.getActiveFactory().createCMPConnectionFactoryBinding();
            eJBJarBinding.setDefaultCMPConnectionFactory(cMPConnectionFactoryBinding);
        }
        if (this.isCreateMode) {
            return;
        }
        int n = 0;
        if (cMPConnectionFactoryBinding.getResAuth() != null) {
            n = cMPConnectionFactoryBinding.getResAuth().getValue();
        }
        ConnectionFactoryBinding connectionFactoryBinding = new ConnectionFactoryBinding(cMPConnectionFactoryBinding.getJndiName(), n);
        connectionFactoryBinding = this.getStrategy().getDefaultConnectionFactoryBindings(eJBJarFile.getName(), connectionFactoryBinding, this);
        if (connectionFactoryBinding.getJndiName() != null) {
            cMPConnectionFactoryBinding.setJndiName(connectionFactoryBinding.getJndiName());
            cMPConnectionFactoryBinding.setResAuth(CMPResAuthType.get((int)connectionFactoryBinding.getResAuth()));
            eJBJarBinding.setDefaultCMPConnectionFactory(cMPConnectionFactoryBinding);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbJarDefaultConnectionFactory", new Object[]{"ejbJar=" + eJBJarFile, "bnd=" + eJBJarBinding, "values=" + connectionFactoryBinding});
        }
    }

    protected void bindEjbJarDefaultDatasource(EJBJarFile eJBJarFile, EJBJarBinding eJBJarBinding) throws BindingError {
        BasicAuthData basicAuthData;
        ResourceRefBinding resourceRefBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbJarDefaultDatasource", new Object[]{"ejbJar=" + eJBJarFile, "bnd=" + eJBJarBinding});
        }
        if ((resourceRefBinding = eJBJarBinding.getDefaultDatasource()) == null) {
            resourceRefBinding = CommonbndFactoryImpl.getActiveFactory().createResourceRefBinding();
            eJBJarBinding.setDefaultDatasource(resourceRefBinding);
        }
        if ((basicAuthData = (BasicAuthData)resourceRefBinding.getDefaultAuth()) == null) {
            basicAuthData = CommonbndFactoryImpl.getActiveFactory().createBasicAuthData();
            resourceRefBinding.setDefaultAuth((AbstractAuthData)basicAuthData);
        }
        if (this.isCreateMode) {
            return;
        }
        DataSourceBinding dataSourceBinding = new DataSourceBinding(resourceRefBinding.getJndiName(), basicAuthData.getUserId(), basicAuthData.getPassword());
        dataSourceBinding = this.getStrategy().getDefaultDatasourceBindings(eJBJarFile.getName(), dataSourceBinding, this);
        if (dataSourceBinding.getJndiName() != null) {
            resourceRefBinding.setJndiName(dataSourceBinding.getJndiName());
        }
        if (dataSourceBinding.getUser() != null) {
            basicAuthData.setUserId(dataSourceBinding.getUser());
            basicAuthData.setPassword(dataSourceBinding.getPassword());
            resourceRefBinding.setDefaultAuth((AbstractAuthData)basicAuthData);
        }
        eJBJarBinding.setDefaultDatasource(resourceRefBinding);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbJarDefaultDatasource", new Object[]{"ejbJar=" + eJBJarFile, "bnd=" + eJBJarBinding});
        }
    }

    protected void bindEjbRefs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbRefs");
        }
        GetEjbRefs getEjbRefs = new GetEjbRefs(this.getEar(), this.isCreateMode);
        try {
            Iterator iterator = getEjbRefs.execute().iterator();
            if (this.isCreateMode) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindEjbRefs");
                }
                return;
            }
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    EJBRefPkg eJBRefPkg = (EJBRefPkg)iterator.next();
                    String string = eJBRefPkg.getRefBinding().getJndiName();
                    String string2 = eJBRefPkg.getRefBinding().getBindingEjbRef().getName();
                    String string3 = eJBRefPkg.getRefBinding().getBindingEjbRef().getHome();
                    String string4 = eJBRefPkg.getRefBinding().getBindingEjbRef().getRemote();
                    String string5 = eJBRefPkg.getRefBinding().getBindingEjbRef().getLink();
                    EjbId ejbId = new EjbId(string2, string3, string4, null, null, string5);
                    string = this.getStrategy().getEJBRefBinding(ejbId, string, this);
                    eJBRefPkg.getRefBinding().setJndiName(string);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "<ejb-ref> binding", new Object[]{"package=" + eJBRefPkg.getQualifier(), "ref=java:comp/env/" + string2, "jndiName=" + string});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no ejbs refs found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindEjbRefs");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.BindEarCmd.bindEjbRefs", "656", this);
            Tr.error(tc, "BNDEAR0001", throwable.getMessage());
            throw new BindingError("couldnt bind EJB refs", throwable);
        }
    }

    protected void bindResourceRefs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindResourceRefs");
        }
        try {
            GetAllResourceRefs getAllResourceRefs = new GetAllResourceRefs(this.getEar(), this.isCreateMode);
            Iterator iterator = getAllResourceRefs.execute().iterator();
            if (this.isCreateMode) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindResourceRefs");
                }
                return;
            }
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    ResRef resRef = (ResRef)iterator.next();
                    String string = resRef.getBinding().getJndiName();
                    String string2 = resRef.getBinding().getBindingResourceRef().getName();
                    String string3 = resRef.getBinding().getBindingResourceRef().getType();
                    String string4 = resRef.getModule();
                    String string5 = resRef.getComponent();
                    string = this.getStrategy().getResourceRefBinding(string2, string3, string4, string5, string, this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "<res-ref> binding", new Object[]{"module=" + string4, "ref=java:comp/env/" + string2, "type=" + string3, "jndi=" + string});
                    }
                    resRef.getBinding().setJndiName(string);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no resource refs found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindResourceRefs");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.BindEarCmd.bindResourceRefs", "714", this);
            Tr.error(tc, "BNDEAR0002", throwable.getMessage());
            throw new BindingError("couldnt bind resource refs", throwable);
        }
    }

    protected void bindResourceEnvRefs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindResourceEnvRefs");
        }
        try {
            GetAllResourceEnvRefs getAllResourceEnvRefs = new GetAllResourceEnvRefs(this.getEar(), this.isCreateMode);
            Iterator iterator = getAllResourceEnvRefs.execute().iterator();
            if (this.isCreateMode) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindResourceEnvRefs");
                }
                return;
            }
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    ResEnvRef resEnvRef = (ResEnvRef)iterator.next();
                    String string = resEnvRef.getBinding().getJndiName();
                    String string2 = resEnvRef.getBinding().getBindingResourceEnvRef().getName();
                    String string3 = resEnvRef.getBinding().getBindingResourceEnvRef().getTypeName();
                    String string4 = resEnvRef.getModule();
                    String string5 = resEnvRef.getComponent();
                    string = this.getStrategy().getResourceEnvRefBinding(string2, string3, string4, string5, string, this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "<res-env-ref> binding", new Object[]{"module=" + string4, "ref=java:comp/env/" + string2, "type=" + string3, "jndi=" + string});
                    }
                    resEnvRef.getBinding().setJndiName(string);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no resource env refs found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindResourceEnvRefs");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.BindEarCmd.bindResourceEnvRefs", "849", this);
            Tr.error(tc, "BNDEAR0003", throwable.getMessage());
            throw new BindingError("couldnt bind resource env refs", throwable);
        }
    }

    protected void bindMessageDestinationRefs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMessageDestinationRefs");
        }
        try {
            GetMessageDestinationRefs getMessageDestinationRefs = new GetMessageDestinationRefs(this.getEar(), this.isCreateMode);
            Iterator iterator = getMessageDestinationRefs.execute().iterator();
            if (this.isCreateMode) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindMessageDestinationRefs");
                }
                return;
            }
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    MessageDestinationRefPkg messageDestinationRefPkg = (MessageDestinationRefPkg)iterator.next();
                    String string = messageDestinationRefPkg.getRefBinding().getBindingMessageDestinationRef().getName();
                    String string2 = messageDestinationRefPkg.getRefBinding().getBindingMessageDestinationRef().getLink();
                    String string3 = messageDestinationRefPkg.getModule();
                    String string4 = messageDestinationRefPkg.getComponent();
                    String string5 = messageDestinationRefPkg.getRefBinding().getJndiName();
                    string5 = this.getStrategy().getMessageDestinationRefBinding(string, string2, string3, string4, string5, this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "<message-destination-ref> binding", new Object[]{"module=" + string3, "ref=java:comp/env/" + string, "jndi=" + string5});
                    }
                    messageDestinationRefPkg.getRefBinding().setJndiName(string5);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no message destination refs found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindMessageDestinationRefs");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.BindEarCmd.bindMessageDestinationRefs", "818", this);
            Tr.error(tc, "BNDEAR0003", throwable.getMessage());
            throw new BindingError("couldnt bind message destination refs", throwable);
        }
    }

    protected void bindVirtualHosts() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindVirtualHosts");
        }
        GetAllVirtualHosts getAllVirtualHosts = new GetAllVirtualHosts(this.getEar());
        try {
            Iterator iterator = getAllVirtualHosts.execute().iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    GetAllVirtualHosts.VirtualHostInfo virtualHostInfo = (GetAllVirtualHosts.VirtualHostInfo)iterator.next();
                    WebAppBinding webAppBinding = virtualHostInfo.webAppBinding;
                    String string = webAppBinding.getVirtualHostName();
                    string = this.getStrategy().getVirtualHost(string, virtualHostInfo.moduleName, this);
                    webAppBinding.setVirtualHostName(string);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindVirtualHosts");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.BindEarCmd.bindVirtualHosts", "812", this);
            Tr.error(tc, "BNDEAR0004", throwable.getMessage());
            throwable.printStackTrace();
        }
    }
}

