/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.configservice.tasks.InstallRARTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.J2EEAppDeploymentImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.j2ee.deploy.spi.DeploymentConfigurationImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentController;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.exceptions.J2EEDeployIllegalStateException;
import com.ibm.ws.management.application.j2ee.deploy.spi.status.DeploymentStatusImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.status.ProgressObjectImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;

public class DeploymentManagerImpl
implements DeploymentManager,
NotificationListener {
    private boolean connected = false;
    private AdminClient client = null;
    private ObjectName j2eeAppDeploymentON = null;
    private ObjectName appManagementON = null;
    private Locale userLocale = null;
    private static Hashtable localePrefs = new Hashtable();
    private DConfigBeanVersionType configBeanVersion = DConfigBeanVersionType.V1_4;
    private AppManagement appM = null;
    private Hashtable commandpoAssociation = new Hashtable();
    private Boolean distributed = null;
    private String processType = "unknown";
    public static String EAR_MODULE = "Application";
    public static String WAR_MODULE = "WebModule";
    public static String EJB_MODULE = "EJBModule";
    public static String RAR_MODULE = "RARModule";
    public static String CAR_MODULE = "CARModule";
    private static TraceComponent tc = Tr.register(DeploymentManagerImpl.class, "Admin", "com.ibm.ws.management.resources.J2eeDeploymentMessages");

    public DeploymentManagerImpl() {
        localePrefs.put("app.client.locale", this.getCurrentLocale());
    }

    public void connect(String string, String string2, String string3, String string4, String string5) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connect");
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("host", string);
            properties.setProperty("port", string2);
            properties.setProperty("type", string3 == null ? "SOAP" : string3);
            if (string4 != null && string5 != null && !string4.equals("") && !string5.equals("")) {
                properties.setProperty("securityEnabled", Boolean.toString(true));
                properties.setProperty("username", string4);
                properties.setProperty("password", string5);
            }
            this.client = AdminClientFactory.createAdminClient(properties);
            ObjectName objectName = this.client.getServerMBean();
            this.processType = (String)this.client.invoke(objectName, "getProcessType", null, null);
        }
        catch (Exception exception) {
            throw new ConnectorException(exception);
        }
        this.connected = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connect");
        }
    }

    public Target[] getTargets() throws IllegalStateException {
        Target[] targetArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTargets");
            }
            this.validateConnection();
            Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
            hashtable.put("app.client.locale", this.getCurrentLocale());
            targetArray = null;
            try {
                targetArray = (Target[])this.invokeJ2EEAppDeploymentMBean("getTargets", new Object[]{hashtable, null}, new String[]{Hashtable.class.getName(), String.class.getName()});
            }
            catch (TargetException targetException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getTargets - Unexpected exception:", (Object)targetException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargets");
        }
        return targetArray;
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningModules");
        }
        this.validateConnection();
        String string = DeploymentManagerImpl.convertModuleType(moduleType);
        Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
        hashtable.put("app.client.locale", this.getCurrentLocale());
        TargetModuleID[] targetModuleIDArray = (TargetModuleID[])this.invokeJ2EEAppDeploymentMBean("getRunningModules", new Object[]{string, targetArray, hashtable, null}, new String[]{"java.lang.String", "[Ljavax.enterprise.deploy.spi.Target;", "java.util.Hashtable", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningModules");
        }
        return targetModuleIDArray;
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonRunningModules");
        }
        this.validateConnection();
        String string = DeploymentManagerImpl.convertModuleType(moduleType);
        Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
        hashtable.put("app.client.locale", this.getCurrentLocale());
        TargetModuleID[] targetModuleIDArray = (TargetModuleID[])this.invokeJ2EEAppDeploymentMBean("getNonRunningModules", new Object[]{string, targetArray, hashtable, null}, new String[]{"java.lang.String", "[Ljavax.enterprise.deploy.spi.Target;", "java.util.Hashtable", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonRunningModules");
        }
        return targetModuleIDArray;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableModules");
        }
        this.validateConnection();
        String string = DeploymentManagerImpl.convertModuleType(moduleType);
        TargetModuleID[] targetModuleIDArray = null;
        if (moduleType.equals(ModuleType.RAR)) {
            return this.getAvailableRarModules(targetArray);
        }
        Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
        hashtable.put("app.client.locale", this.getCurrentLocale());
        targetModuleIDArray = (TargetModuleID[])this.invokeJ2EEAppDeploymentMBean("getAvailableModules", new Object[]{string, targetArray, hashtable, null}, new String[]{"java.lang.String", "[Ljavax.enterprise.deploy.spi.Target;", "java.util.Hashtable", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailableModules");
        }
        return targetModuleIDArray;
    }

    public TargetModuleID[] getAvailableRarModules(Target[] targetArray) throws TargetException, IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableRarModules");
        }
        TargetModuleID[] targetModuleIDArray = null;
        Session session = null;
        ConfigServiceProxy configServiceProxy = null;
        try {
            int n;
            session = new Session();
            configServiceProxy = new ConfigServiceProxy(this.client);
            TargetImpl targetImpl = null;
            ObjectName objectName = null;
            Vector<TargetModuleIDImpl> vector = new Vector<TargetModuleIDImpl>();
            for (n = 0; n < targetArray.length; ++n) {
                targetImpl = (TargetImpl)targetArray[n];
                objectName = ConfigServiceHelper.createObjectName(null, "Node", targetImpl.getNode());
                ObjectName[] objectNameArray = configServiceProxy.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "J2CResourceAdapter"), null);
                for (int i = 0; i < objectNameArray.length; ++i) {
                    if (objectNameArray[i].getKeyPropertyListString().indexOf("builtin_rra") >= 0) continue;
                    vector.add(this.createRARTargetModule(targetImpl, objectNameArray[i]));
                }
            }
            configServiceProxy.discard(session);
            targetModuleIDArray = new TargetModuleID[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                targetModuleIDArray[n] = (TargetModuleID)vector.elementAt(n);
            }
        }
        catch (Exception exception) {
            this.cleanUpSession(configServiceProxy, session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailableRarModules");
        }
        return targetModuleIDArray;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        return new DeploymentConfigurationImpl(deployableObject, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "distribute");
        }
        this.validateConnection();
        try {
            if (file == null) {
                throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1010E"));
            }
            if (targetArray == null) {
                ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.DISTRIBUTE);
                DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus();
                deploymentStatusImpl.setState(StateType.COMPLETED.getValue());
                deploymentStatusImpl.setMessage("ADMJ1031I", null);
                ProgressObjectImpl progressObjectImpl2 = progressObjectImpl;
                return progressObjectImpl2;
            }
            File file3 = null;
            ModuleType moduleType = this.getModuleType(file);
            file3 = moduleType.equals(ModuleType.EAR) ? this.createTempFile(new FileInputStream(file), "app", ".ear") : file;
            ProgressObject progressObject = this.distributeInternal(targetArray, file3, file2, moduleType);
            return progressObject;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.DISTRIBUTE);
            DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus();
            deploymentStatusImpl.setState(StateType.FAILED.getValue());
            deploymentStatusImpl.setMessage("ADMJ1022E", new Object[]{fileNotFoundException.getMessage()});
            ProgressObjectImpl progressObjectImpl3 = progressObjectImpl;
            return progressObjectImpl3;
        }
        catch (Exception exception) {
            ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.DISTRIBUTE);
            DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus();
            deploymentStatusImpl.setState(StateType.FAILED.getValue());
            deploymentStatusImpl.setMessage(exception.getMessage());
            ProgressObjectImpl progressObjectImpl4 = progressObjectImpl;
            return progressObjectImpl4;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "distribute");
            }
        }
    }

    public ProgressObject distributeInternal(Target[] targetArray, File file, File file2, ModuleType moduleType) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "distributeInternal: " + file + " plan: " + file2);
        }
        ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.DISTRIBUTE);
        String string = file.getAbsolutePath();
        try {
            if (moduleType == null) {
                moduleType = this.getModuleType(file);
            }
            if (moduleType.equals(ModuleType.RAR)) {
                this.distributeRARFile(targetArray, file, file2, progressObjectImpl);
            } else {
                if (!moduleType.equals(ModuleType.EAR)) {
                    string = AppInstallHelper.createEarWrapper(string, null, "/");
                }
                Hashtable hashtable = new Hashtable();
                hashtable.put("app.client.locale", this.getCurrentLocale());
                hashtable.put("jsr88", Boolean.toString(true));
                J2EEDeploymentController j2EEDeploymentController = (J2EEDeploymentController)AppManagementFactory.readArchive(string, hashtable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "1. Created controller: " + j2EEDeploymentController);
                }
                if (file2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reading plan..");
                    }
                    j2EEDeploymentController.readDeploymentPlan(file2);
                }
                j2EEDeploymentController.saveAndClose();
                hashtable = j2EEDeploymentController.getAppDeploymentSavedResults();
                String string2 = (String)hashtable.get("appname");
                AppManagement appManagement = this.getAppManagementProxy(this.client);
                hashtable.put("app.client.locale", this.getCurrentLocale());
                hashtable.put("DeleteSourceEar", Boolean.TRUE);
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                String string3 = this.createModule2ServerValue(targetArray);
                if (string3 != null && !string3.equals("")) {
                    hashtable2.put("*", string3);
                    hashtable.put("moduleToServer", hashtable2);
                }
                String string4 = Long.toHexString(System.currentTimeMillis());
                hashtable.put("HandBackForClient", string4);
                boolean bl = this.isClientOnlyEarFile(string);
                TargetModuleIDImpl[] targetModuleIDImplArray = this.createTargetModules(targetArray, string2, !bl, moduleType);
                this.commandpoAssociation.put(string4, new DataHolder(progressObjectImpl, null, targetModuleIDImplArray));
                string = this.prepareOnServer(string, hashtable);
                appManagement.installApplication(string, null, hashtable, null);
            }
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMJ1016E", new Object[]{exception});
            throw new J2EEDeployIllegalStateException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "distributeInternal");
        }
        return progressObjectImpl;
    }

    private ProgressObject distributeRARFile(Target[] targetArray, File file, File file2, ProgressObject progressObject) throws IllegalStateException {
        Hashtable hashtable = new Hashtable();
        String string = file.getPath().replace('\\', '/');
        Session session = null;
        ConfigServiceProxy configServiceProxy = null;
        try {
            Vector<String> vector = new Vector<String>();
            session = new Session();
            configServiceProxy = new ConfigServiceProxy(this.client);
            for (int i = 0; i < targetArray.length; ++i) {
                String string2 = ((TargetImpl)targetArray[i]).getNode();
                if (string2 != null) {
                    if (vector.contains(string2)) continue;
                    vector.add(string2);
                    InstallRARTask installRARTask = new InstallRARTask(configServiceProxy);
                    ObjectName objectName = installRARTask.installResourceAdapter(session, string2, string, hashtable);
                    TargetModuleIDImpl targetModuleIDImpl = this.createRARTargetModule(targetArray[i], objectName);
                    ((ProgressObjectImpl)progressObject).addSuccessfulResult(targetModuleIDImpl);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Rar installed=" + objectName.getCanonicalKeyPropertyListString());
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Rar not installed. Cluster target is not supported.");
                }
                throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1028E"));
            }
            configServiceProxy.save(session, false);
            configServiceProxy.discard(session);
            ((ProgressObjectImpl)progressObject).setFinalStateAndNotify(StateType.COMPLETED);
        }
        catch (Exception exception) {
            this.cleanUpSession(configServiceProxy, session);
            if (exception instanceof IllegalStateException) {
                throw (IllegalStateException)exception;
            }
            throw new J2EEDeployIllegalStateException(exception.getMessage(), exception);
        }
        return progressObject;
    }

    private void cleanUpSession(ConfigService configService, Session session) {
        block3: {
            try {
                if (configService != null && session != null) {
                    configService.discard(session);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "cleanUpSession", exception);
            }
        }
    }

    private TargetModuleIDImpl[] createTargetModules(Target[] targetArray, String string, boolean bl, ModuleType moduleType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTargetModules");
        }
        TargetModuleIDImpl[] targetModuleIDImplArray = null;
        if (targetArray != null) {
            targetModuleIDImplArray = new TargetModuleIDImpl[targetArray.length];
            TargetModuleIDImpl targetModuleIDImpl = null;
            TargetImpl targetImpl = null;
            for (int i = 0; i < targetArray.length; ++i) {
                targetImpl = (TargetImpl)targetArray[i];
                targetModuleIDImpl = J2EEAppDeploymentImpl.createTargetMod(string, DeploymentManagerImpl.convertModuleType(moduleType), targetImpl, null);
                targetModuleIDImpl.setStartable(bl);
                targetModuleIDImplArray[i] = targetModuleIDImpl;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTargetModules");
        }
        return targetModuleIDImplArray;
    }

    private TargetModuleIDImpl createRARTargetModule(Target target, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRARTargetModule");
        }
        TargetModuleIDImpl targetModuleIDImpl = null;
        if (target != null) {
            targetModuleIDImpl = new TargetModuleIDImpl();
            targetModuleIDImpl.setModuleID(objectName.getKeyProperty("_Websphere_Config_Data_Id"));
            targetModuleIDImpl.setObjectName(objectName);
            targetModuleIDImpl.setParentTargetModuleID(null);
            targetModuleIDImpl.setChildTargetModuleID(null);
            targetModuleIDImpl.setTarget(target);
            targetModuleIDImpl.setWebURL(null);
            targetModuleIDImpl.setModuleType(RAR_MODULE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRARTargetModules");
        }
        return targetModuleIDImpl;
    }

    private String createModule2ServerValue(Target[] targetArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModule2ServerValue");
        }
        StringBuffer stringBuffer = new StringBuffer();
        TargetImpl targetImpl = null;
        for (int i = 0; i < targetArray.length; ++i) {
            targetImpl = (TargetImpl)targetArray[i];
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append("WebSphere:cell=");
            stringBuffer.append(targetImpl.getCell());
            if (targetImpl.isCluster()) {
                stringBuffer.append(",cluster=");
                stringBuffer.append(targetImpl.getServerName());
                continue;
            }
            stringBuffer.append(",node=");
            stringBuffer.append(targetImpl.getNode());
            stringBuffer.append(",server=");
            stringBuffer.append(targetImpl.getServerName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModule2ServerValue");
        }
        return stringBuffer.toString();
    }

    private boolean isEarFile(File file) throws FileNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEarFile");
        }
        Archive archive = null;
        boolean bl = false;
        try {
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            archive = commonarchiveFactory.openArchive(file.getAbsolutePath());
            boolean bl2 = bl = archive.isEARFile();
            return bl2;
        }
        catch (OpenFailureException openFailureException) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        finally {
            if (archive != null) {
                archive.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isEarFile", Boolean.toString(bl));
            }
        }
    }

    private boolean isClientOnlyEarFile(String string) throws FileNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isClientOnlyEarFile");
        }
        boolean bl = true;
        EARFile eARFile = null;
        try {
            eARFile = AppInstallHelper.getEarFile(string, false, true, null);
            Iterator iterator = eARFile.getModuleRefs().iterator();
            ModuleRef moduleRef = null;
            while (iterator.hasNext() && bl) {
                moduleRef = (ModuleRef)iterator.next();
                if (moduleRef.isClient()) continue;
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (AppDeploymentException appDeploymentException) {
            throw new FileNotFoundException(string);
        }
        finally {
            if (eARFile != null) {
                eARFile.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isClientOnlyEarFile", Boolean.toString(bl));
            }
        }
    }

    private ModuleType getModuleType(File file) throws FileNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleType");
        }
        ModuleType moduleType = null;
        Archive archive = null;
        try {
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            archive = commonarchiveFactory.openArchive(file.getAbsolutePath());
            if (archive.isEARFile()) {
                moduleType = ModuleType.EAR;
            } else if (archive.isEJBJarFile()) {
                moduleType = ModuleType.EJB;
            } else if (archive.isRARFile()) {
                moduleType = ModuleType.RAR;
            } else if (archive.isWARFile()) {
                moduleType = ModuleType.WAR;
            } else if (archive.isApplicationClientFile()) {
                moduleType = ModuleType.CAR;
            }
            ModuleType moduleType2 = moduleType;
            return moduleType2;
        }
        catch (OpenFailureException openFailureException) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        finally {
            if (archive != null) {
                archive.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getModuleType", moduleType.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "distribute");
        }
        this.validateConnection();
        try {
            ProgressObject progressObject;
            if (inputStream == null) {
                throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1010E"));
            }
            if (targetArray == null) {
                ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.DISTRIBUTE);
                DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus();
                deploymentStatusImpl.setState(StateType.COMPLETED.getValue());
                deploymentStatusImpl.setMessage("ADMJ1031I", null);
                ProgressObjectImpl progressObjectImpl2 = progressObjectImpl;
                return progressObjectImpl2;
            }
            File file = null;
            if (inputStream2 != null) {
                file = this.createTempFile(inputStream2, "deploymentPlan", "xml");
            }
            File file2 = this.createTempFile(inputStream, "app", ".ear");
            ProgressObject progressObject2 = progressObject = this.distributeInternal(targetArray, file2, file, null);
            return progressObject2;
        }
        catch (Exception exception) {
            ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.DISTRIBUTE);
            DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus();
            deploymentStatusImpl.setState(StateType.FAILED.getValue());
            deploymentStatusImpl.setMessage(exception.getMessage());
            ProgressObjectImpl progressObjectImpl3 = progressObjectImpl;
            return progressObjectImpl3;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "distribute");
            }
        }
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.validateConnection();
        if (targetModuleIDArray == null) {
            targetModuleIDArray = new TargetModuleIDImpl[]{};
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting " + targetModuleIDArray.length + " modules.");
        }
        ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.START);
        try {
            this.validateRootRequest(targetModuleIDArray);
            if (targetModuleIDArray.length > 0) {
                Thread thread = new Thread(new CommandProcessor(this, progressObjectImpl, CommandType.START, targetModuleIDArray));
                thread.setDaemon(true);
                thread.start();
            } else {
                progressObjectImpl.setFinalStateAndNotify(StateType.COMPLETED);
                ((DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus()).setMessage("ADMJ1027I", null);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start failed with exception: " + exception.getMessage());
            }
            DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus();
            deploymentStatusImpl.setState(StateType.FAILED.getValue());
            deploymentStatusImpl.setMessage(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
        return progressObjectImpl;
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.validateConnection();
        if (targetModuleIDArray == null) {
            targetModuleIDArray = new TargetModuleIDImpl[]{};
        }
        ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.STOP);
        try {
            this.validateRootRequest(targetModuleIDArray);
            if (targetModuleIDArray.length > 0) {
                Thread thread = new Thread(new CommandProcessor(this, progressObjectImpl, CommandType.STOP, targetModuleIDArray));
                thread.setDaemon(true);
                thread.start();
            } else {
                progressObjectImpl.setFinalStateAndNotify(StateType.COMPLETED);
                ((DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus()).setMessage("ADMJ1027I", null);
            }
        }
        catch (Exception exception) {
            DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus();
            deploymentStatusImpl.setState(StateType.FAILED.getValue());
            deploymentStatusImpl.setMessage(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
        return progressObjectImpl;
    }

    private void startCommand(TargetModuleID[] targetModuleIDArray, ProgressObject progressObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startCommand");
        }
        Object var3_3 = null;
        Object var4_4 = null;
        TargetModuleIDImpl targetModuleIDImpl = null;
        String string = "";
        Object var7_7 = null;
        String string2 = "";
        Object var9_9 = null;
        boolean bl = true;
        boolean bl2 = true;
        String string3 = null;
        Object[] objectArray = null;
        try {
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                bl = true;
                string3 = null;
                objectArray = null;
                targetModuleIDImpl = (TargetModuleIDImpl)targetModuleIDArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Starting module:" + targetModuleIDImpl.getObjectName().toString());
                    Tr.debug(tc, "TargetModuleID: " + targetModuleIDImpl.toString());
                }
                if (!targetModuleIDImpl.isStartable() || targetModuleIDImpl.isRar()) {
                    ((ProgressObjectImpl)progressObject).addSuccessfulResult(targetModuleIDImpl);
                    continue;
                }
                try {
                    Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
                    hashtable.put("app.client.locale", this.getCurrentLocale());
                    AppManagement appManagement = this.getAppManagementProxy(this.client);
                    appManagement.startApplication(targetModuleIDImpl.getObjectName().getKeyProperty("name"), targetModuleIDImpl.getTarget().getName(), hashtable, null);
                    bl = true;
                }
                catch (MBeanException mBeanException) {
                    if (mBeanException.getTargetException() instanceof ConfigurationWarning && mBeanException.getTargetException().getMessage() != null && mBeanException.getTargetException().getMessage().startsWith("Duplicate application")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Application " + targetModuleIDImpl.getObjectName().getKeyProperty("name") + " was already started.");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception starting " + targetModuleIDImpl.getObjectName().getKeyProperty("name") + ".", mBeanException);
                        }
                        string3 = "ADMJ1014E";
                        objectArray = new Object[]{mBeanException};
                        bl = false;
                    }
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception starting " + targetModuleIDImpl.getObjectName().getKeyProperty("name") + ".", throwable);
                    }
                    string3 = "ADMJ1014E";
                    objectArray = new Object[]{throwable};
                    bl = false;
                }
                if (bl) {
                    string3 = "ADMJ1018I";
                    objectArray = new Object[]{targetModuleIDImpl.getApplicationName()};
                    ((ProgressObjectImpl)progressObject).addSuccessfulResult(targetModuleIDImpl);
                } else {
                    ((ProgressObjectImpl)progressObject).addFailedResult(targetModuleIDImpl);
                }
                ((ProgressObjectImpl)progressObject).sendModuleEvent(targetModuleIDImpl, bl ? StateType.COMPLETED : StateType.FAILED, string3, objectArray);
                bl2 &= bl;
            }
            ((ProgressObjectImpl)progressObject).setFinalStateAndNotify(bl2 ? StateType.COMPLETED : StateType.FAILED);
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMJ1014E", new Object[]{exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startCommand");
        }
    }

    public void stopCommand(TargetModuleID[] targetModuleIDArray, ProgressObject progressObject) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopCommand");
        }
        Object var3_3 = null;
        Object var4_4 = null;
        TargetModuleIDImpl targetModuleIDImpl = null;
        String string = "";
        Object var7_7 = null;
        String string2 = "";
        Object var9_9 = null;
        boolean bl = true;
        boolean bl2 = true;
        String string3 = null;
        Object[] objectArray = null;
        try {
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                targetModuleIDImpl = (TargetModuleIDImpl)targetModuleIDArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stopping module:" + targetModuleIDImpl.getObjectName().toString());
                    Tr.debug(tc, "TargetModuleID: " + targetModuleIDImpl.toString());
                }
                bl = true;
                string3 = null;
                objectArray = null;
                Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
                hashtable.put("app.client.locale", this.getCurrentLocale());
                try {
                    AppManagement appManagement = this.getAppManagementProxy(this.client);
                    appManagement.stopApplication(targetModuleIDImpl.getObjectName().getKeyProperty("name"), targetModuleIDImpl.getTarget().getName().toString(), hashtable, null);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception stopping " + targetModuleIDImpl.getObjectName().toString(), throwable);
                        Tr.debug(tc, "TargetModuleID: " + targetModuleIDImpl.toString());
                    }
                    bl = false;
                    string3 = "ADMJ1015E";
                    objectArray = new Object[]{throwable};
                }
                if (bl) {
                    string3 = "ADMJ1019I";
                    objectArray = new Object[]{targetModuleIDImpl.getApplicationName()};
                    ((ProgressObjectImpl)progressObject).addSuccessfulResult(targetModuleIDImpl);
                } else {
                    ((ProgressObjectImpl)progressObject).addFailedResult(targetModuleIDImpl);
                }
                ((ProgressObjectImpl)progressObject).sendModuleEvent(targetModuleIDImpl, bl ? StateType.COMPLETED : StateType.FAILED, string3, objectArray);
                bl2 &= bl;
            }
            ((ProgressObjectImpl)progressObject).setFinalStateAndNotify(bl2 ? StateType.COMPLETED : StateType.FAILED);
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMJ1015E", new Object[]{exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopCommand");
        }
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "undeploy");
        }
        this.validateConnection();
        if (targetModuleIDArray == null) {
            targetModuleIDArray = new TargetModuleIDImpl[]{};
        }
        ProgressObjectImpl progressObjectImpl = new ProgressObjectImpl(CommandType.UNDEPLOY);
        if (targetModuleIDArray.length > 0) {
            try {
                this.validateRootRequest(targetModuleIDArray);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("app.client.locale", this.getCurrentLocale());
                AppManagement appManagement = this.getAppManagementProxy(this.client);
                hashtable.put("app.client.locale", this.getCurrentLocale());
                Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
                boolean bl = true;
                TargetModuleIDImpl targetModuleIDImpl = null;
                for (int i = 0; i < targetModuleIDArray.length; ++i) {
                    targetModuleIDImpl = (TargetModuleIDImpl)targetModuleIDArray[i];
                    if (targetModuleIDImpl.isRar()) {
                        this.undeployRar(targetModuleIDImpl, progressObjectImpl);
                        continue;
                    }
                    bl = false;
                    String string = targetModuleIDImpl.getApplicationName();
                    String string2 = Long.toHexString(System.currentTimeMillis());
                    hashtable.put("HandBackForClient", string2);
                    this.commandpoAssociation.put(string2, new DataHolder(progressObjectImpl, targetModuleIDImpl, null));
                    if (!hashtable2.containsKey(string)) {
                        hashtable2.put(string, Boolean.TRUE);
                        appManagement.uninstallApplication(string, hashtable, null);
                        progressObjectImpl.increaseEventCount();
                        continue;
                    }
                    progressObjectImpl.addSuccessfulResult(targetModuleIDImpl);
                }
                if (bl) {
                    progressObjectImpl.setFinalStateAndNotify(StateType.COMPLETED);
                }
            }
            catch (Exception exception) {
                DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus();
                deploymentStatusImpl.setState(StateType.FAILED.getValue());
                deploymentStatusImpl.setMessage(exception.getMessage());
            }
        } else {
            progressObjectImpl.setFinalStateAndNotify(StateType.COMPLETED);
            ((DeploymentStatusImpl)progressObjectImpl.getDeploymentStatus()).setMessage("ADMJ1027I", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "undeploy");
        }
        return progressObjectImpl;
    }

    private ProgressObject undeployRar(TargetModuleIDImpl targetModuleIDImpl, ProgressObjectImpl progressObjectImpl) throws IllegalStateException {
        Session session = null;
        ConfigServiceProxy configServiceProxy = null;
        try {
            session = new Session();
            configServiceProxy = new ConfigServiceProxy(this.client);
            if (targetModuleIDImpl != null && targetModuleIDImpl.getObjectName() != null) {
                configServiceProxy.deleteConfigData(session, targetModuleIDImpl.getObjectName());
                configServiceProxy.save(session, false);
                configServiceProxy.discard(session);
                progressObjectImpl.addSuccessfulResult(targetModuleIDImpl);
            } else {
                progressObjectImpl.addFailedResult(targetModuleIDImpl);
            }
        }
        catch (Exception exception) {
            progressObjectImpl.addFailedResult(targetModuleIDImpl);
            this.cleanUpSession(configServiceProxy, session);
        }
        return progressObjectImpl;
    }

    private AppManagement getAppManagementProxy(AdminClient adminClient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppManagementProxy");
        }
        if (this.appM == null) {
            this.appM = AppManagementProxy.getJMXProxyForClient(adminClient);
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("websphere.admin.appmgmt");
            ObjectName objectName = this.getAppManagementObjectName();
            adminClient.addNotificationListener(objectName, this, (NotificationFilter)notificationFilterSupport, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppManagementProxy");
        }
        return this.appM;
    }

    private void releaseAppManagementProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseAppManagementProxy");
        }
        if (this.appM != null && this.client != null) {
            block5: {
                try {
                    this.client.removeNotificationListener(this.getAppManagementObjectName(), this);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "The notification listener could not be removed.", exception);
                }
            }
            this.appM = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseAppManagementProxy");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        DataHolder dataHolder;
        Object object2;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        AppNotification appNotification = (AppNotification)notification.getUserData();
        if ((appNotification.taskName.equals("InstallApplication") && appNotification.subtaskName.equals("ConfigureTask") || appNotification.taskName.equals("UninstallApplication") && appNotification.subtaskName.equals("DeleteSIEntryTask")) && appNotification.subtaskStatus.equals("Completed")) {
            string = (String)appNotification.props.get("HandBackForClient");
            object2 = (String)appNotification.props.get("nodes");
            if (string != null && object2 != null) {
                dataHolder = (DataHolder)this.commandpoAssociation.get(string);
                dataHolder.setNodes(((String)object2).split("+"));
            }
        }
        if ((appNotification.taskName.equals("InstallApplication") || appNotification.taskName.equals("UninstallApplication")) && (appNotification.taskStatus.equals("Completed") || appNotification.taskStatus.equals("Failed")) && (string = (String)appNotification.props.get("HandBackForClient")) != null) {
            object2 = (DataHolder)this.commandpoAssociation.get(string);
            dataHolder = null;
            if (((DataHolder)object2).po != null) {
                boolean bl;
                dataHolder = this.getStateFromEventStatus(appNotification);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "assocData.tm " + ((DataHolder)object2).tm);
                    Tr.debug(tc, "assocData.tms " + ((DataHolder)object2).tms);
                }
                if (((DataHolder)object2).tm != null) {
                    if (appNotification.taskStatus.equals("Completed")) {
                        TargetModuleID[] targetModuleIDArray;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "moduleType: " + ((DataHolder)object2).tm.getModuleType());
                        }
                        if (((DataHolder)object2).tm.getModuleType().equals(EAR_MODULE) && (targetModuleIDArray = this.getAvailableChildren(((DataHolder)object2).tm, appNotification.props.getProperty("appname"))) != null) {
                            ((DataHolder)object2).tm.setChildTargetModuleID(targetModuleIDArray);
                        }
                        ((DataHolder)object2).po.addSuccessfulResult(((DataHolder)object2).tm);
                    } else if (appNotification.taskStatus.equals("Failed")) {
                        ((DataHolder)object2).po.addFailedResult(((DataHolder)object2).tm);
                    }
                    ((DataHolder)object2).po.sendModuleEvent(((DataHolder)object2).tm, (StateType)dataHolder, appNotification.message, null);
                } else if (((DataHolder)object2).tms != null) {
                    for (int i = 0; i < ((DataHolder)object2).tms.length; ++i) {
                        if (appNotification.taskStatus.equals("Completed")) {
                            TargetModuleID[] targetModuleIDArray;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "moduleType: " + ((DataHolder)object2).tms[i].getModuleType());
                            }
                            if (((DataHolder)object2).tms[i].getModuleType().equals(EAR_MODULE) && (targetModuleIDArray = this.getAvailableChildren(((DataHolder)object2).tms[i], appNotification.props.getProperty("appname"))) != null) {
                                ((DataHolder)object2).tms[i].setChildTargetModuleID(targetModuleIDArray);
                            }
                            ((DataHolder)object2).po.addSuccessfulResult(((DataHolder)object2).tms[i]);
                        } else if (appNotification.taskStatus.equals("Failed")) {
                            ((DataHolder)object2).po.addFailedResult(((DataHolder)object2).tms[i]);
                        }
                        ((DataHolder)object2).po.sendModuleEvent(((DataHolder)object2).tms[i], (StateType)dataHolder, appNotification.message, null);
                    }
                }
                if (((DataHolder)object2).po.isLast()) {
                    this.synchronizeNodes((DataHolder)object2);
                }
                if (bl = ((DataHolder)object2).po.setFinalStateAndNotify((StateType)dataHolder)) {
                    this.commandpoAssociation.remove(string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void synchronizeNodes(DataHolder dataHolder) {
        if (this.isDistributed() && dataHolder != null && dataHolder.nodes != null) {
            Enumeration<Object> enumeration = dataHolder.nodes.keys();
            String string = null;
            while (enumeration.hasMoreElements()) {
                try {
                    string = (String)enumeration.nextElement();
                    ObjectName objectName = new ObjectName("WebSphere:*,type=NodeSync,process=nodeagent,node=" + string);
                    Set set = this.client.queryNames(objectName, null);
                    if (set != null && !set.isEmpty()) {
                        Object[] objectArray = set.toArray();
                        ObjectName objectName2 = (ObjectName)objectArray[0];
                        this.client.invoke(objectName2, "sync", null, null);
                        continue;
                    }
                    Tr.warning(tc, "ADMJ1029W", new Object[]{string});
                }
                catch (Exception exception) {
                    Tr.error(tc, "ADMJ1030E", exception);
                }
            }
        }
    }

    private boolean isDistributed() {
        if (this.distributed == null) {
            try {
                ObjectName objectName = this.client.getServerMBean();
                this.distributed = objectName.getKeyProperty("process").equals("dmgr") ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception exception) {
                this.distributed = Boolean.TRUE;
            }
        }
        return this.distributed;
    }

    private StateType getStateFromEventStatus(AppNotification appNotification) {
        StateType stateType = null;
        stateType = appNotification.taskStatus.equals("Completed") ? StateType.COMPLETED : (appNotification.taskStatus.equals("Failed") ? StateType.FAILED : StateType.RUNNING);
        return stateType;
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        ResourceBundle resourceBundle = AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", this.getCurrentLocale());
        throw new UnsupportedOperationException(AppUtils.getMessage(resourceBundle, "ADMJ1007E"));
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        ResourceBundle resourceBundle = AppUtils.getBundle(DeploymentManagerImpl.getLocalePrefs());
        throw new UnsupportedOperationException(AppUtils.getMessage(resourceBundle, "ADMJ1007E"));
    }

    public void release() {
        this.releaseAppManagementProxy();
        this.client = null;
        this.connected = false;
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public Locale getCurrentLocale() {
        Locale locale = null;
        locale = this.userLocale != null ? this.userLocale : this.getDefaultLocale();
        return locale;
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        this.userLocale = locale;
        localePrefs.put("app.client.locale", locale);
    }

    public static Hashtable getLocalePrefs() {
        return localePrefs;
    }

    public Locale[] getSupportedLocales() {
        return Locale.getAvailableLocales();
    }

    public boolean isLocaleSupported(Locale locale) {
        boolean bl = false;
        Locale[] localeArray = this.getSupportedLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            if (!localeArray[i].equals(locale)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return this.configBeanVersion;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return DConfigBeanVersionType.V1_4.equals(dConfigBeanVersionType) || DConfigBeanVersionType.V1_3.equals(dConfigBeanVersionType);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        if (!this.isDConfigBeanVersionSupported(dConfigBeanVersionType)) {
            throw new DConfigBeanVersionUnsupportedException(dConfigBeanVersionType + " is unsupported");
        }
        this.configBeanVersion = dConfigBeanVersionType;
    }

    private Object invokeGetTarget() {
        Object object = null;
        try {
            object = this.invokeJ2EEAppDeploymentMBean("getTarget", null, null);
        }
        catch (TargetException targetException) {
            Tr.warning(tc, "ADMJ1023E", new Object[]{targetException});
        }
        return object;
    }

    private Object invokeJ2EEAppDeploymentMBean(String string, Object[] objectArray, String[] stringArray) throws TargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeAppManagementMBean");
        }
        Object object = null;
        try {
            ObjectName objectName = this.getJ2EEAppDeploymentObjectName();
            object = this.client.invoke(objectName, string, objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            Tr.warning(tc, "ADMJ1023E", new Object[]{mBeanException});
            if (mBeanException.getTargetException() != null) {
                if (mBeanException.getTargetException() instanceof TargetException) {
                    throw (TargetException)((Object)mBeanException.getTargetException());
                }
                throw new J2EEDeployIllegalStateException(mBeanException.getTargetException().getMessage(), mBeanException.getTargetException());
            }
            throw new J2EEDeployIllegalStateException(mBeanException.getMessage(), mBeanException);
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMJ1023E", new Object[]{exception});
            throw new J2EEDeployIllegalStateException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeAppManagementMBean");
        }
        return object;
    }

    private ObjectName getJ2EEAppDeploymentObjectName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEAppDeploymentObjectName");
        }
        if (this.j2eeAppDeploymentON == null) {
            this.j2eeAppDeploymentON = this.getObjectName("J2EEAppDeployment");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEAppDeploymentObjectName");
        }
        return this.j2eeAppDeploymentON;
    }

    private ObjectName getAppManagementObjectName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppManagementObjectName");
        }
        if (this.appManagementON == null) {
            this.appManagementON = this.getObjectName("AppManagement");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppManagementObjectName");
        }
        return this.appManagementON;
    }

    private ObjectName getObjectName(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppMgmtObjectName");
        }
        ObjectName objectName = null;
        String string2 = null;
        ObjectName objectName2 = this.client.getServerMBean();
        string2 = objectName2.getKeyProperty("process");
        ObjectName objectName3 = new ObjectName("WebSphere:*,type=" + string + ",process=" + string2);
        Set set = this.client.queryNames(objectName3, null);
        if (set != null && !set.isEmpty()) {
            if (set.size() != 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "There are " + set.size() + string + " objects.");
            }
            Object[] objectArray = set.toArray();
            objectName = (ObjectName)objectArray[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ObjectName is " + objectName.getCanonicalName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppMgmtObjectName");
        }
        return objectName;
    }

    public static String convertModuleType(ModuleType moduleType) {
        String string = EAR_MODULE;
        if (moduleType.equals(ModuleType.EAR)) {
            string = EAR_MODULE;
        } else if (moduleType.equals(ModuleType.WAR)) {
            string = WAR_MODULE;
        } else if (moduleType.equals(ModuleType.EJB)) {
            string = EJB_MODULE;
        } else if (moduleType.equals(ModuleType.CAR)) {
            string = CAR_MODULE;
        } else if (moduleType.equals(ModuleType.RAR)) {
            string = RAR_MODULE;
        }
        return string;
    }

    private File createTempFile(InputStream inputStream, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTempFile");
        }
        File file = null;
        try {
            file = File.createTempFile(string, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[8192];
            int n = inputStream.read(byArray);
            while (n != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            Tr.warning(tc, "ADMJ1016E", iOException);
            throw new J2EEDeployIllegalStateException(iOException.getMessage(), iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTempFile");
        }
        return file;
    }

    private void validateConnection() throws IllegalStateException {
        if (!this.connected) {
            throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1009E"));
        }
    }

    private void validateRootRequest(TargetModuleID[] targetModuleIDArray) {
        TargetModuleID targetModuleID = null;
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            targetModuleID = targetModuleIDArray[i];
            if (targetModuleID.getParentTargetModuleID() == null) continue;
            throw new J2EEDeployIllegalStateException(AppUtils.getMessage(this.getResourceBundle(), "ADMJ1021E"));
        }
    }

    private ResourceBundle getResourceBundle() {
        return AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", this.getCurrentLocale());
    }

    private String prepareOnServer(String string, Hashtable hashtable) throws ConnectorException, AdminException, TransferFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareOnServer", new Object[]{string});
        }
        String string2 = AppInstallHelper.copyToServer(this.client, string);
        hashtable.put("DeleteSourceEar", Boolean.TRUE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareOnServer", new Object[]{string2});
        }
        return string2;
    }

    private TargetModuleID[] getAvailableChildren(TargetModuleIDImpl targetModuleIDImpl, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableChildren", new Object[]{targetModuleIDImpl, string});
        }
        TargetModuleID[] targetModuleIDArray = null;
        try {
            AppManagement appManagement = this.getAppManagementProxy(this.client);
            Hashtable hashtable = new Hashtable();
            J2EEAppDeploymentImpl j2EEAppDeploymentImpl = new J2EEAppDeploymentImpl(hashtable);
            targetModuleIDArray = j2EEAppDeploymentImpl.getAvailableChildren(appManagement, string, targetModuleIDImpl, hashtable, null);
        }
        catch (Exception exception) {
            Tr.warning(tc, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailableChildren", new Object[]{targetModuleIDArray});
        }
        return targetModuleIDArray;
    }

    private class DataHolder {
        ProgressObjectImpl po = null;
        TargetModuleIDImpl tm = null;
        TargetModuleIDImpl[] tms = null;
        Properties nodes = new Properties();

        DataHolder(ProgressObjectImpl progressObjectImpl, TargetModuleIDImpl targetModuleIDImpl, TargetModuleIDImpl[] targetModuleIDImplArray) {
            this.po = progressObjectImpl;
            this.tm = targetModuleIDImpl;
            this.tms = targetModuleIDImplArray;
        }

        void setNodes(String[] stringArray) {
            if (this.nodes != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.nodes.setProperty(stringArray[i], "1");
                }
            }
        }
    }

    private class CommandProcessor
    implements Runnable {
        private CommandType command = null;
        private TargetModuleID[] targetMods = null;
        private DeploymentManagerImpl dm = null;
        private ProgressObject po = null;

        CommandProcessor(DeploymentManagerImpl deploymentManagerImpl2, ProgressObject progressObject, CommandType commandType, TargetModuleID[] targetModuleIDArray) {
            this.command = commandType;
            this.targetMods = targetModuleIDArray;
            this.dm = deploymentManagerImpl2;
            this.po = progressObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CommandProcessor.run");
            }
            try {
                if (this.command.equals(CommandType.START)) {
                    this.dm.startCommand(this.targetMods, this.po);
                } else if (this.command.equals(CommandType.STOP)) {
                    this.dm.stopCommand(this.targetMods, this.po);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "CommandProcessor.run");
                }
            }
        }
    }
}

