/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi.factories;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.management.application.j2ee.deploy.spi.DeploymentManagerImpl;
import java.util.StringTokenizer;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;

public class DeploymentFactoryImpl
implements DeploymentFactory {
    private static TraceComponent tc = Tr.register(DeploymentFactoryImpl.class, "Admin", "com.ibm.ws.management.resources.J2eeDeploymentMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.J2eeDeploymentMessages");
    private static final String VERSION = "1.0";
    private static final int PARAM_LENGTH = 6;
    private static final int DEPLOYER = 0;
    private static final int NAME = 1;
    private static final int HOST = 2;
    private static final int PORT = 3;
    private static final int CONN_TYPE = 4;
    private static final int MODE = 5;

    public boolean handlesURI(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handlesURI", string);
        }
        String[] stringArray = this.parseURI(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handlesURI");
        }
        return this.isValid(stringArray);
    }

    private String[] parseURI(String string) {
        String string2;
        String[] stringArray = new String[6];
        String string3 = null;
        String string4 = null;
        if (string.indexOf("?") > 0) {
            string3 = string.substring(0, string.indexOf("?"));
            string4 = string.substring(string.indexOf("?") + 1, string.length());
        } else {
            string3 = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < 4; ++i) {
            string2 = stringTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token", string2);
            }
            stringArray[i] = string2;
        }
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(string4, "?");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "token", string2);
                }
                if (string2.startsWith("connectorType=")) {
                    stringArray[4] = string2.substring(string2.indexOf("=") + 1, string2.length());
                    continue;
                }
                if (!string2.startsWith("mode=")) continue;
                stringArray[5] = string2.substring(string2.indexOf("=") + 1, string2.length());
            }
        }
        return stringArray;
    }

    private boolean isValid(String[] stringArray) {
        boolean bl = false;
        if ("deployer".equals(stringArray[0]) && "WebSphere".equals(stringArray[1]) && stringArray[2] != null && stringArray[2].length() > 0 && stringArray[3] != null && stringArray[3].length() > 0) {
            try {
                int n = Integer.parseInt(stringArray[3]);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                Tr.error(tc, "ADMJ1000E", stringArray);
            }
        }
        return bl;
    }

    public DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentManager", new Object[]{string, string2, string3});
        }
        String[] stringArray = this.parseURI(string);
        if (!this.handlesURI(string)) {
            throw new DeploymentManagerCreationException(nls.getFormattedMessage("ADMJ1001E", new Object[]{string}, "The URI is not valid."));
        }
        DeploymentManagerImpl deploymentManagerImpl = null;
        try {
            deploymentManagerImpl = new DeploymentManagerImpl();
            deploymentManagerImpl.connect(stringArray[2], stringArray[3], stringArray[4], string2, string3);
        }
        catch (Exception exception) {
            DeploymentManagerCreationException deploymentManagerCreationException;
            Tr.error(tc, "ADMJ1002E", exception);
            if (!(exception instanceof DeploymentManagerCreationException)) {
                deploymentManagerCreationException = new DeploymentManagerCreationException(nls.getFormattedMessage("ADMJ1002E", new Object[]{exception.getMessage()}, "An error occurred creating the deployment manager."));
            }
            throw (DeploymentManagerCreationException)deploymentManagerCreationException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeploymentManager");
        }
        return deploymentManagerImpl;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDisconnectedDeploymentManager", new Object[]{string});
        }
        String[] stringArray = this.parseURI(string);
        if (!this.handlesURI(string)) {
            throw new DeploymentManagerCreationException(nls.getFormattedMessage("ADMJ1001E", new Object[]{string}, "The URI is not valid."));
        }
        DeploymentManagerImpl deploymentManagerImpl = new DeploymentManagerImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDisconnectedDeploymentManager");
        }
        return deploymentManagerImpl;
    }

    public String getDisplayName() {
        return nls.getString("j2ee.deployer.name");
    }

    public String getProductVersion() {
        return VERSION;
    }
}

