/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.sync.AppDataMgr;
import com.ibm.ws.management.application.sync.AppSyncEventsTask;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.DefaultAppSyncTaskProvider;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.security.auth.Subject;
import org.eclipse.emf.ecore.resource.Resource;

public class AppBinaryProcessor
implements ConfigRepositoryListener,
NotificationListener {
    private static TraceComponent tc = Tr.register(AppBinaryProcessor.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String DMGR = "dmgr";
    private static final long SYNC_ID = -1L;
    private ConfigRepository _repository;
    private boolean _isLocal;
    private String _cellName = null;
    private int _cellType = -1;
    private String _nodeName = null;
    private String _serverName = null;
    private String _cRoot = null;
    private boolean _isInNodeSync = false;
    private Hashtable _changeTables = null;
    private Object notify = null;
    private Class cls = null;
    private String __renamecellcmdexc__ = null;
    private static ResourceBundle _bundle;
    private static AppBinaryProcessor processor;
    private static AppBinThread binThread;
    private static List allSaveThreads;
    private boolean notificationSignaled = false;
    static Vector appAddedTasks;
    static Vector appRemovedTasks;
    static Vector appModifiedTasks;

    public static ResourceBundle getBundle() {
        if (_bundle == null) {
            _bundle = AppUtils.getBundle(null);
        }
        return _bundle;
    }

    public static AppBinaryProcessor getAppBinInstance() {
        return processor;
    }

    public static List getAllSaveThreads() {
        return allSaveThreads;
    }

    public static List getAppsInProgress() {
        ArrayList arrayList = new ArrayList();
        List list = AppBinaryProcessor.getAllSaveThreads();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = ((AppBinThread)iterator.next()).getAppsBeingProcessed();
            if (list2 == null) continue;
            arrayList.addAll(list2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Apps in progress: ", arrayList);
        }
        return arrayList;
    }

    public void waitForThreadCompletion() {
        if (binThread == null) {
            return;
        }
        AppBinaryProcessor.binThread.waitForThreadCompletion();
    }

    public void notifyWaiter() {
        AppBinaryProcessor.binThread.notifyWaiter();
    }

    public AppBinaryProcessor(Boolean bl, ConfigRepository configRepository) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppBinaryProcessor: " + bl);
        }
        this._isLocal = bl;
        this._repository = configRepository;
        this._cRoot = (String)this._repository.getConfig().get("was.repository.root");
        this._changeTables = new Hashtable();
        NodeSync.addLocalSyncEventListener(this);
        if (processor != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Other instance exist!");
        }
        processor = this;
        try {
            ExtClassLoader extClassLoader;
            String string = "com.ibm.ws.security.authorize.AppInstallNotify";
            try {
                AppUtils.dbg(tc, "trying loading of class " + string);
                this.cls = Class.forName(string);
                AppUtils.dbg(tc, "class = " + this.cls);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AppUtils.dbg(tc, "ClassNotFoundException expected");
                extClassLoader = ExtClassLoader.getInstance();
                AppUtils.dbg(tc, "ecl = " + extClassLoader);
                if (extClassLoader == null) {
                    throw classNotFoundException;
                }
                this.cls = Class.forName(string, true, (ClassLoader)ExtClassLoader.getInstance());
                AppUtils.dbg(tc, "after class.forname " + string);
            }
            String string2 = "getInstance";
            extClassLoader = null;
            Object[] objectArray = null;
            Method method2 = this.cls.getMethod(string2, (Class<?>)extClassLoader);
            this.notify = method2.invoke(null, objectArray);
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMA7012E", new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", "178", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppBinaryProcessor");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(final ConfigRepositoryEvent configRepositoryEvent) {
        block3: {
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            Object object = ExtClassLoader.getInstance();
                            if (object == null) {
                                object = this.getClass().getClassLoader();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "setting CCL = " + object);
                            }
                            Thread.currentThread().setContextClassLoader((ClassLoader)object);
                            AppBinaryProcessor.this._onChangeStart(configRepositoryEvent);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in doPriv() " + privilegedActionException + " cause  = " + privilegedActionException.getCause());
                }
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", "216", this);
                if (privilegedActionException.getCause() == null) break block3;
                privilegedActionException.getCause().printStackTrace();
            }
        }
    }

    private void _onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
        Tr.entry(tc, "onChangeStart");
        this.__renamecellcmdexc__ = System.getProperty("__renamecellcmdexc__");
        if (this.__renamecellcmdexc__ != null) {
            System.clearProperty("__renamecellcmdexc__");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_onChangeStart - cell renamed XXXX needs special processing");
            }
            return;
        }
        ChangeTable changeTable = null;
        long l = this._isInNodeSync ? -1L : configRepositoryEvent.getId();
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            try {
                int n;
                boolean bl = false;
                if (this._cellName == null || this._nodeName == null) {
                    this.createNodeInfo(configChangeNotifierArray[i].getUri());
                    bl = true;
                }
                if ((n = AppSyncUtils.shouldProcess(configChangeNotifierArray[i].getUri(), this._cellName, this._nodeName, this._isInNodeSync, this._isLocal)) == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "URI: " + configChangeNotifierArray[i].getUri() + " is not processed by by AppBinaryProcessor");
                    }
                    if (!bl) continue;
                    this._nodeName = null;
                    this._cellName = null;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "process: " + configChangeNotifierArray[i].getUri() + " id=" + l);
                }
                if (changeTable == null && (changeTable = (ChangeTable)this._changeTables.get(new Long(l))) == null) {
                    changeTable = new ChangeTable(this._cellName, this._nodeName, this._serverName, this._repository, this._isLocal);
                    this._changeTables.put(new Long(l), changeTable);
                }
                String string = AppSyncUtils.getSyncEventFromRepoEvent(configChangeNotifierArray[i].getChangeType());
                switch (n) {
                    case 1: {
                        changeTable.handleAppDocument(configChangeNotifierArray[i].getUri(), string);
                        break;
                    }
                    case 3: {
                        changeTable.handleSIDocument(configChangeNotifierArray[i].getUri(), string, this._nodeName);
                        break;
                    }
                    case 2: {
                        changeTable.handleVarDocument(configChangeNotifierArray[i].getUri(), string);
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMA7000W", new Object[]{throwable});
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.onChangeStart", "266", this);
            }
        }
        if (!this._isInNodeSync) {
            this.printTable("pre", l, (ChangeTable)this._changeTables.get(new Long(l)));
        }
        Tr.exit(tc, "onChangeStart");
    }

    public void onChangeCompletion(final ConfigRepositoryEvent configRepositoryEvent) {
        block3: {
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            Object object = ExtClassLoader.getInstance();
                            if (object == null) {
                                object = this.getClass().getClassLoader();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "setting CCL onChangecompletion = " + object);
                            }
                            Thread.currentThread().setContextClassLoader((ClassLoader)object);
                            AppBinaryProcessor.this._onChangeCompletion(configRepositoryEvent);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(classLoader);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in doPriv() " + privilegedActionException + " cause  = " + privilegedActionException.getCause());
                }
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", "216", this);
                if (privilegedActionException.getCause() == null) break block3;
                privilegedActionException.getCause().printStackTrace();
            }
        }
    }

    public void _onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        boolean bl;
        Tr.entry(tc, "onChangeCompletion");
        if (this.__renamecellcmdexc__ != null) {
            String string = this.__renamecellcmdexc__;
            this.__renamecellcmdexc__ = null;
            this.processCellNameChange(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_onChangeCompletion - cell renamed XXXX needs special processing");
            }
            return;
        }
        boolean bl2 = bl = this._isLocal ? true : "UnManagedProcess".equals(AdminServiceFactory.getAdminService().getProcessType());
        if (!this._isInNodeSync) {
            this.postProcess(this._isInNodeSync ? -1L : configRepositoryEvent.getId(), bl);
        }
        Tr.exit(tc, "onChangeCompletion");
    }

    public void onRepositoryEpochRefresh() {
    }

    public void handleNotification(Notification notification, Object object) {
        Tr.entry(tc, "handleNotification");
        if (notification.getType().equals("websphere.nodesync.initiated")) {
            this._isInNodeSync = true;
        } else if (notification.getType().equals("websphere.nodesync.complete")) {
            boolean bl;
            this._isInNodeSync = false;
            this.printTable("pre", -1L, (ChangeTable)this._changeTables.get(new Long(-1L)));
            if (notification.getUserData() != null && Boolean.TRUE.equals(notification.getUserData())) {
                this.postProcess(-1L, this._isLocal);
            }
            if (bl = this.checkForFailedEars()) {
                this.postProcess(-1L, this._isLocal);
            }
        }
        Tr.exit(tc, "handleNotification");
    }

    public boolean checkForFailedEars() {
        boolean bl;
        block14: {
            int n;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkForFailedEars");
            }
            bl = false;
            String string = CommonAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), "");
            String string2 = string.substring(0, n = string.lastIndexOf(46));
            File file = new File(string2);
            String[] stringArray = file.list();
            if (stringArray != null) {
                try {
                    Hashtable hashtable = AppSyncUtils.buildSIMap(this._cellName, this._nodeName, this._repository);
                    if (hashtable == null) {
                        return bl;
                    }
                    Enumeration enumeration = hashtable.keys();
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        boolean bl2 = false;
                        String string3 = null;
                        String string4 = (String)enumeration.nextElement();
                        String string5 = AppSyncUtils.getBinName(string4, this._cellName);
                        try {
                            string3 = CommonAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), string4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Marker file to check is = " + string3);
                            }
                            FileInputStream fileInputStream = new FileInputStream(string3);
                            int n2 = fileInputStream.available();
                            fileInputStream.close();
                            if (n2 > 4) {
                                bl = true;
                                ChangeTable changeTable = null;
                                changeTable = (ChangeTable)this._changeTables.get(new Long(-1L));
                                if (changeTable == null) {
                                    changeTable = new ChangeTable(this._cellName, this._nodeName, this._serverName, this._repository, this._isLocal);
                                    this._changeTables.put(new Long(-1L), changeTable);
                                }
                                try {
                                    changeTable.handleAppDocument(AppSyncUtils.getDeplURI(string4, this._cellName), "DOCSADDED_KEY");
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "885", this);
                                }
                                Tr.error(tc, "ADMA7008E", string4 + " application FAILED to expand - will retry ear expansion");
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Still in process of expanding application = " + string4);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Marker file doesn't exist for application " + string5);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Failed to create SI map ex=" + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForFailedEars returns " + bl);
        }
        return bl;
    }

    public void postProcess(long l, boolean bl) {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "postProcess: " + l + ", synchronous=: " + bl);
            }
            AppBinThread appBinThread = null;
            try {
                ChangeTable changeTable = (ChangeTable)this._changeTables.remove(new Long(l));
                if (changeTable == null) {
                    if (tc.isEntryEnabled() && changeTable == null) {
                        Tr.exit(tc, "postProcess  table is null or BAD !!!! " + l);
                    }
                    return;
                }
                changeTable.postProcess(this._nodeName);
                this.printTable("post", l, changeTable);
                appBinThread = new AppBinThread(this._cellName, this._cellType, this._nodeName, changeTable, this._repository);
                allSaveThreads.add(appBinThread);
                binThread = appBinThread;
                appBinThread.setSecurity(this.notify, this.cls);
                appBinThread.setLocal(this._isLocal);
                if (!bl) {
                    Thread thread = new Thread(appBinThread);
                    Object object = ExtClassLoader.getInstance();
                    if (object == null) {
                        object = this.getClass().getClassLoader();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting context classloader: " + object);
                    }
                    thread.setContextClassLoader((ClassLoader)object);
                    thread.start();
                } else {
                    appBinThread.run();
                }
            }
            catch (Throwable throwable) {
                Tr.error(tc, "ADMA7007E", new Object[]{throwable, new Long(l)});
                if (appBinThread == null) break block11;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to launch the AppBinThread," + appBinThread + "so removing it from the cached threads.");
                }
                allSaveThreads.remove(appBinThread);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postProcess: " + l);
        }
    }

    private void createNodeInfo(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeInfo: " + string);
        }
        if (!this._isLocal) {
            this._cellName = AdminServiceFactory.getAdminService().getCellName();
            this._nodeName = AdminServiceFactory.getAdminService().getNodeName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "!_isLocal, _cellName = " + this._cellName + ", _nodeName = " + this._nodeName);
            }
        } else if (this._isInNodeSync) {
            this._cellName = NodeSync.getNodeSync().getCellName();
            this._nodeName = NodeSync.getNodeSync().getNodeName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_isInNodeSync, _cellName = " + this._cellName + ", _nodeName = " + this._nodeName);
            }
        } else {
            if (string.indexOf(CELLS_CONTEXT) == -1) {
                return;
            }
            if (string.indexOf("node-metadata.properties") != -1) {
                return;
            }
            this._cellName = string.substring(string.indexOf(CELLS_CONTEXT) + CELLS_CONTEXT.length());
            if (this._cellName.indexOf(47) <= 0) {
                this._cellName = null;
                return;
            }
            this._cellName = this._cellName.substring(0, this._cellName.indexOf(47));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell: " + this._cellName);
            }
            Resource resource = AppSyncUtils.getResource(this._repository, CELLS_CONTEXT + this._cellName + "/" + "cell.xml", "cell.xml");
            Cell cell = (Cell)resource.getContents().get(0);
            WorkSpace workSpace = ConfigRepoHelper.getWorkSpace(null);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", this._cellName, null, null, workSpace, true);
            this._cellType = cell.getCellType().getValue();
            if (cell.getCellType().getValue() == 1) {
                this._nodeName = AppSyncUtils.getDmgrNodeName(this._repository, this._cellName);
                if (this._nodeName == null) {
                    RepositoryContext repositoryContext2 = AppUtils.findContext("servers", DMGR, null, repositoryContext, workSpace, true);
                    if (repositoryContext2 == null) {
                        Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
                        repositoryContext2 = (RepositoryContext)objectArray[0];
                    }
                    this._nodeName = repositoryContext2.getParent().getName();
                }
            } else {
                this._nodeName = AppSyncUtils.getNodeNameFromBaseServer(this._repository, this._cellName);
                Object[] objectArray = AppUtils.getContextArray("nodes", repositoryContext, workSpace);
                RepositoryContext repositoryContext3 = (RepositoryContext)objectArray[0];
                if (this._nodeName == null) {
                    this._nodeName = ((RepositoryContext)objectArray[0]).getName();
                }
                List list = repositoryContext3.getChildren();
                RepositoryContext repositoryContext4 = null;
                if (list.size() > 0) {
                    repositoryContext4 = (RepositoryContext)list.get(0);
                    this._serverName = repositoryContext4.getName();
                }
            }
            ConfigRepoHelper.removeWorkSpace(false, workSpace);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell: " + this._cellName + ", node: " + this._nodeName, " , serverName " + this._serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeInfo");
        }
    }

    private void printTable(String string, long l, ChangeTable changeTable) {
        if (tc.isDebugEnabled()) {
            if (changeTable == null) {
                Tr.debug(tc, "xxxxxxxxxxx " + string + ": " + l + " xxxxxxxxxx: NULL");
                return;
            }
            Tr.debug(tc, "xxxxxxxxxxx " + string + ": " + l + " xxxxxxxxxx");
            String string2 = null;
            AppDataMgr appDataMgr = null;
            Enumeration enumeration = changeTable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                appDataMgr = changeTable.getTableEntry(string2);
                Tr.debug(tc, "\n=================================\n" + appDataMgr.toString() + "\n" + "=================================\n");
            }
            Tr.debug(tc, "xxxxENDxxxx id: " + l + " xxxxENDxxxx");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCellNameChange(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCellNameChange: " + string);
        }
        WorkSpace workSpace = null;
        try {
            File file;
            Object object;
            RepositoryContext repositoryContext;
            Object object2;
            String string2;
            workSpace = ConfigRepoHelper.getWorkSpace(null);
            Collection collection = workSpace.findContext(AppUtils.getContextType("cells"));
            RepositoryContext repositoryContext2 = (RepositoryContext)collection.toArray()[0];
            String string3 = repositoryContext2.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + string3);
            }
            if ((string2 = System.getProperty("local.node")) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no local node defined.  This command will not work on managed node");
                }
                string2 = (object2 = (Cell)(repositoryContext = AppSyncUtils.getResource(this._repository, CELLS_CONTEXT + string3 + "/" + "cell.xml", "cell.xml")).getContents().get(0)).getCellType().getValue() == 1 ? AppSyncUtils.getDmgrNodeName(this._repository, string3) : AppSyncUtils.getNodeNameFromBaseServer(this._repository, string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node = " + string2);
            }
            repositoryContext = workSpace.findContext(CELLS_CONTEXT + string3 + "/nodes/" + string2);
            object2 = null;
            if (repositoryContext.getChildren().size() > 0) {
                object2 = ((RepositoryContext)repositoryContext.getChildren().get(0)).getName();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server = " + (String)object2);
            }
            String string4 = (String)this._repository.getConfig().get("was.repository.root");
            VariableMap variableMap = AppUtils.createVarMap(string4, string3, string2, (String)object2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got var map: " + variableMap);
            }
            Vector vector = new Vector();
            EditApplication.listAppsOnNode(vector, string2, null, repositoryContext2, workSpace, AppBinaryProcessor.getBundle(), true);
            collection = workSpace.findContext(AppUtils.getContextType("deployments"));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (RepositoryContext)iterator.next();
                if (!vector.contains(object.getName())) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "app not for this node: " + object.getName());
                    continue;
                }
                file = null;
                try {
                    ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)object);
                    if ((applicationDeployment.isZeroBinaryCopy() || applicationDeployment.isZeroEarCopy() || !applicationDeployment.isEnableDistribution()) && tc.isDebugEnabled()) {
                        Tr.debug(tc, "not processing app: " + object.getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing app: " + object.getName());
                    }
                    String string5 = applicationDeployment.getBinariesURL();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "bin url = " + string5);
                    }
                    string5 = variableMap.expand(string5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "expanded bin url = " + string5);
                    }
                    if (!string5.contains("/" + string3 + "/")) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "no cell name so don't process: " + string5);
                        continue;
                    }
                    String string6 = string5.replaceAll("/" + string3 + "/", "/" + string + "/");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Delete from: " + string6);
                    }
                    AppUtils.deleteDirTree(string6);
                    String string7 = EditionHelper.getAppEarName(object.getName(), (String)null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EAR name: " + string7);
                    }
                    if (!object.getParent().isAvailable(string7)) continue;
                    object.getParent().extract(string7, false);
                    String string8 = object.getParent().getPath() + "/" + string7;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EAR path: " + string8);
                    }
                    file = EarUtils.getEarFile(string8, false, true);
                    EarUtils.extractEar((EARFile)file, string5, true);
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "error processing app: " + object.getName(), throwable);
                }
                finally {
                    if (file == null) continue;
                    file.close();
                }
            }
            object = variableMap.expand("$(APP_INSTALL_ROOT)");
            file = new File((String)object + "/" + string);
            boolean bl = file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old app install dir: " + file + ", " + bl);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error processCellNameChange: " + string, throwable);
            }
        }
        finally {
            block40: {
                if (workSpace != null) {
                    try {
                        ConfigRepoHelper.removeWorkSpace(false, workSpace);
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) break block40;
                        Tr.debug(tc, "Exception in removing workspace: " + throwable);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCellNameChange: " + string);
        }
    }

    static /* synthetic */ AppBinThread access$402(AppBinThread appBinThread) {
        binThread = appBinThread;
        return binThread;
    }

    static /* synthetic */ List access$500() {
        return allSaveThreads;
    }

    static {
        processor = null;
        binThread = null;
        allSaveThreads = new ArrayList();
    }

    private class ChangeTable {
        private Hashtable _table = new Hashtable();
        private String cellName;
        private boolean variablexml;
        private VariableMap vMap = null;
        private Hashtable cachedsiMap = null;
        private Hashtable newsiMap = null;
        ConfigRepository repository;
        boolean _isLocal;
        boolean varChanged = false;
        Hashtable varTable = null;
        String cRoot = null;

        ChangeTable(String string, String string2, String string3, ConfigRepository configRepository, boolean bl) {
            this.cellName = string;
            this.repository = configRepository;
            this._isLocal = bl;
            try {
                this.cRoot = (String)configRepository.getConfig().get("was.repository.root");
                this.vMap = AppUtils.createVarMap(this.cRoot, string, string2, string3);
            }
            catch (Exception exception) {
                Tr.warning(tc, "ADMA7016W", new Object[]{exception, "ChangeTable"});
            }
        }

        public void handleAppDocument(String string, String string2) {
            String string3 = AppSyncUtils.getAppNameFromAppDoc(string, this.cellName);
            AppDataMgr appDataMgr = (AppDataMgr)this._table.get(string3);
            if (appDataMgr == null) {
                appDataMgr = new AppDataMgr(string3, this.cellName, this.repository, this.vMap);
                this._table.put(string3, appDataMgr);
            }
            appDataMgr.addAppDocument(string, string2, this.vMap);
        }

        public void handleSIDocument(String string, String string2, String string3) {
            try {
                if (this.cachedsiMap == null) {
                    this.cachedsiMap = AppSyncUtils.buildSIMap(this.cellName, string3, this.repository);
                }
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "1108", this);
            }
        }

        public void handleVarDocument(String string, String string2) {
            this.varChanged = true;
            this.varTable = this.getBinURLTable();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "oldVarTable: " + this.varTable);
            }
        }

        public Hashtable getCachedSIMap() {
            return this.cachedsiMap;
        }

        public Hashtable getNewSIMap() {
            return this.newsiMap;
        }

        public void postProcess(String string) {
            try {
                this.newsiMap = AppSyncUtils.buildSIMap(this.cellName, string, this.repository);
                if (this.cachedsiMap == null) {
                    this.cachedsiMap = this.newsiMap;
                }
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "869", this);
            }
            if (this.varChanged && this.varTable != null) {
                try {
                    this.vMap = AppUtils.createVarMap(this.cRoot, AppBinaryProcessor.this._cellName, AppBinaryProcessor.this._nodeName, AppBinaryProcessor.this._serverName);
                    Hashtable hashtable = this.getBinURLTable();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "newVarTable: " + hashtable);
                    }
                    Hashtable<String, String[]> hashtable2 = new Hashtable<String, String[]>();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        String string3 = (String)enumeration.nextElement();
                        String string4 = (String)this.varTable.get(string3);
                        if (string4 == null || (string2 = (String)hashtable.get(string3)).equals(string4)) continue;
                        hashtable2.put(string3, new String[]{string4, string2});
                        if (this._table.get(string3) != null) continue;
                        try {
                            this.handleAppDocument(AppSyncUtils.getDeplURI(string3, AppBinaryProcessor.this._cellName), "DOCSMODIFIED_KEY");
                        }
                        catch (Throwable throwable) {
                            if (this._isLocal) {
                                throwable.printStackTrace();
                            }
                            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "885", this);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "diffTable: " + hashtable2);
                    }
                    this.varTable = hashtable2;
                }
                catch (Exception exception) {
                    if (this._isLocal) {
                        exception.printStackTrace();
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "861", this);
                }
            }
        }

        public void postProcessVarChanged(AppDataMgr appDataMgr, String string) {
            if (!this.varChanged || this.varTable == null || this.varTable.get(string) == null) {
                return;
            }
            String[] stringArray = (String[])this.varTable.get(string);
            appDataMgr.processVarChanged(stringArray[0], stringArray[1]);
        }

        public VariableMap getVarMap() {
            return this.vMap;
        }

        public Enumeration keys() {
            return this._table.keys();
        }

        public AppDataMgr getTableEntry(String string) {
            return (AppDataMgr)this._table.get(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hashtable getBinURLTable() {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "getBinURLTable");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                String[] stringArray = this.repository.listResourceNames(AppBinaryProcessor.CELLS_CONTEXT + AppBinaryProcessor.this._cellName + "/applications", 1, Integer.MAX_VALUE, new ResourceNameFilter(){

                    public boolean accept(String string, String string2) {
                        return string.indexOf("/deployments/") != -1 && string2.equals("deployment.xml");
                    }
                });
                for (int i = 0; i < stringArray.length; ++i) {
                    Resource resource = null;
                    try {
                        String string = AppSyncUtils.getAppNameFromAppDoc(stringArray[i], AppBinaryProcessor.this._cellName);
                        resource = AppSyncUtils.getResource(this.repository, stringArray[i], "deployment.xml");
                        String string2 = ConfigRepoHelper.getAppDeploymentForApp(resource).getBinariesURL();
                        string2 = this.vMap.expand(string2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appname:" + string + ", path: " + string2);
                        }
                        if (hashtable.containsKey(string) && tc.isDebugEnabled()) {
                            Tr.debug(tc, "appname:" + string + " already exist in the BinURLTable overriding the path: " + hashtable.get(string));
                        }
                        hashtable.put(string, string2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (this._isLocal && !(throwable instanceof IllegalArgumentException)) {
                            throwable.printStackTrace();
                        }
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "891", this);
                        continue;
                    }
                    finally {
                        if (resource != null) {
                            resource.unload();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", "877", this);
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getBinURLTable");
            }
            return hashtable;
        }
    }

    private class AppBinThread
    implements Runnable {
        ConfigRepository _repository;
        String _cellName;
        String _nodeName;
        ResourceBundle _resBundle;
        Subject _subject = null;
        boolean _isLocal;
        ChangeTable _changeTbl;
        Hashtable appStatusTbl = new Hashtable();
        Hashtable appTypeTbl = new Hashtable();
        Object _notify;
        Class _cls;
        AbstractAppSyncTask _task;
        protected int nextTaskNum = 0;
        boolean bSuccess = true;

        public AppBinThread(String string, int n, String string2, ChangeTable changeTable, ConfigRepository configRepository) {
            this._cellName = string;
            this._nodeName = string2;
            this._changeTbl = changeTable;
            this._repository = configRepository;
            this._resBundle = AppBinaryProcessor.getBundle();
            AppSyncUtils.setCellInfo(string, n);
        }

        public void setSecurity(Object object, Class clazz) {
            this._notify = object;
            this._cls = clazz;
        }

        public void setLocal(boolean bl) {
            this._isLocal = bl;
            if (!bl) {
                this._subject = SecurityHelper.getOwnedSubject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block51: {
                block50: {
                    if (AppBinaryProcessor.access$200().isEntryEnabled()) {
                        Tr.entry(AppBinaryProcessor.access$200(), "run");
                    }
                    if (this._subject != null) {
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "Push creds: " + this._subject);
                        }
                        this._subject = SecurityHelper.pushInvocationSubject(this._subject);
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "After push: " + this._subject);
                        }
                    }
                    var1_1 = this._changeTbl.keys();
                    var3_2 = null;
                    var4_3 = null;
                    var5_4 = null;
                    try {
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "Cached SI = " + this._changeTbl.getCachedSIMap());
                        }
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "New SI = " + this._changeTbl.getNewSIMap());
                        }
                        while (var1_1.hasMoreElements()) {
                            block54: {
                                block48: {
                                    block53: {
                                        block47: {
                                            this._task = null;
                                            var5_4 = null;
                                            this.nextTaskNum = 0;
                                            var2_5 = (String)var1_1.nextElement();
                                            var4_3 = this._changeTbl.getTableEntry(var2_5);
                                            try {
                                                try {
                                                    var4_3.postProcess(this._changeTbl.getVarMap(), this._changeTbl.getNewSIMap(), this._changeTbl.getCachedSIMap(), this._isLocal, this._resBundle);
                                                    this._changeTbl.postProcessVarChanged(var4_3, var2_5);
                                                    if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                        Tr.debug(AppBinaryProcessor.access$200(), "" + var4_3);
                                                    }
                                                    if (var4_3.getNewAD() == null && var4_3.getCachedAD() == null) {
                                                        var8_8 = null;
                                                        break block47;
                                                    }
                                                    var5_4 = this.getTaskList(var4_3.getNewAD().getOperations());
                                                    this._task = this.getNextTask(var5_4);
                                                    while (this._task != null && this.bSuccess) {
                                                        this._task.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                        this._task.setSecurity(this._subject, this._notify, this._cls);
                                                        Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + this._task);
                                                        this.bSuccess = this._task.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                        if (!this.bSuccess) break;
                                                        this._task = this.getNextTask(var5_4);
                                                    }
                                                    var4_3.getProps().put("syncstatus", new Boolean(this.bSuccess));
                                                    if (this.bSuccess) {
                                                        var4_3.getProps().put("appSyncMessage", AppUtils.getMessage(this._resBundle, "ADMA7021I", new Object[]{var2_5}));
                                                        Tr.info(AppBinaryProcessor.access$200(), "ADMA7021I", new Object[]{var2_5});
                                                        break block48;
                                                    } else {
                                                        this.logAppSyncFailure(var2_5, var4_3.getProps(), this._task, var5_4, null);
                                                    }
                                                    break block48;
                                                }
                                                catch (Throwable var6_6) {
                                                    var4_3.getProps().put("syncstatus", new Boolean(false));
                                                    this.logAppSyncFailure(var2_5, var4_3.getProps(), this._task, var5_4, var6_6);
                                                    var8_8 = null;
                                                    try {
                                                        if (var4_3.getProps().get("syncstatus") != null) {
                                                            this.appStatusTbl.put(var2_5, var4_3.getProps().get("syncstatus"));
                                                        }
                                                        if (var4_3.getNewAD() != null) {
                                                            this.appTypeTbl.put(var2_5, AppSyncEventsTask.getNotifTypeFromOP(var4_3.getNewAD().getOperations()));
                                                        }
                                                        var9_9 = new AppSyncEventsTask();
                                                        Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + var9_9);
                                                        var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                        var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                    }
                                                    catch (Throwable var9_9) {
                                                        if (this._isLocal) {
                                                            var9_9.printStackTrace();
                                                        }
                                                        FFDCFilter.processException((Throwable)var9_9, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                                                    }
                                                    var4_3.cleanup(true);
                                                    continue;
                                                }
                                            }
                                            catch (Throwable var7_10) {
                                                block52: {
                                                    var8_8 = null;
                                                    ** try [egrp 4[TRYBLOCK] [6 : 672->828)] { 
lbl84:
                                                    // 1 sources

                                                    if (var4_3.getProps().get("syncstatus") != null) {
                                                        this.appStatusTbl.put(var2_5, var4_3.getProps().get("syncstatus"));
                                                    }
                                                    if (var4_3.getNewAD() != null) {
                                                        this.appTypeTbl.put(var2_5, AppSyncEventsTask.getNotifTypeFromOP(var4_3.getNewAD().getOperations()));
                                                    }
                                                    var9_9 = new AppSyncEventsTask();
                                                    Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + var9_9);
                                                    var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                    var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                    break block52;
lbl96:
                                                    // 1 sources

                                                    catch (Throwable var9_9) {
                                                        if (this._isLocal) {
                                                            var9_9.printStackTrace();
                                                        }
                                                        FFDCFilter.processException((Throwable)var9_9, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                                                    }
                                                }
                                                var4_3.cleanup(true);
                                                throw var7_10;
                                            }
                                        }
                                        ** try [egrp 4[TRYBLOCK] [6 : 672->828)] { 
lbl105:
                                        // 1 sources

                                        if (var4_3.getProps().get("syncstatus") != null) {
                                            this.appStatusTbl.put(var2_5, var4_3.getProps().get("syncstatus"));
                                        }
                                        if (var4_3.getNewAD() != null) {
                                            this.appTypeTbl.put(var2_5, AppSyncEventsTask.getNotifTypeFromOP(var4_3.getNewAD().getOperations()));
                                        }
                                        var9_9 = new AppSyncEventsTask();
                                        Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + var9_9);
                                        var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                        var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                        break block53;
lbl117:
                                        // 1 sources

                                        catch (Throwable var9_9) {
                                            if (this._isLocal) {
                                                var9_9.printStackTrace();
                                            }
                                            FFDCFilter.processException((Throwable)var9_9, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                                        }
                                    }
                                    var4_3.cleanup(true);
                                    continue;
                                }
                                var8_8 = null;
                                ** try [egrp 4[TRYBLOCK] [6 : 672->828)] { 
lbl127:
                                // 1 sources

                                if (var4_3.getProps().get("syncstatus") != null) {
                                    this.appStatusTbl.put(var2_5, var4_3.getProps().get("syncstatus"));
                                }
                                if (var4_3.getNewAD() != null) {
                                    this.appTypeTbl.put(var2_5, AppSyncEventsTask.getNotifTypeFromOP(var4_3.getNewAD().getOperations()));
                                }
                                var9_9 = new AppSyncEventsTask();
                                Tr.debug(AppBinaryProcessor.access$200(), "Executing: " + var9_9);
                                var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                break block54;
lbl139:
                                // 1 sources

                                catch (Throwable var9_9) {
                                    if (this._isLocal) {
                                        var9_9.printStackTrace();
                                    }
                                    FFDCFilter.processException((Throwable)var9_9, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                                }
                            }
                            var4_3.cleanup(true);
                        }
                        if (this._subject == null) break block50;
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "Pop creds: " + this._subject);
                        }
                        SecurityHelper.popInvocationSubject(this._subject);
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug(AppBinaryProcessor.access$200(), "After pop");
                        }
                        this._subject = null;
                    }
                    catch (Throwable var6_7) {
                        FFDCFilter.processException(var6_7, "com.ibm.ws.management.application.sync.AppBinThread.run", "1395", this);
                        if (this._isLocal) {
                            var6_7.printStackTrace();
                        }
                        var11_12 = null;
                        try {
                            var12_16 = new AppSyncEventsTask();
                            var12_16.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                            Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + var12_16);
                            var12_16.performTask(this.appStatusTbl, this.appTypeTbl);
                        }
                        catch (Throwable var12_17) {
                            if (this._isLocal) {
                                var12_17.printStackTrace();
                            }
                            FFDCFilter.processException(var12_17, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                        }
                        break block51;
                    }
                }
                var11_11 = null;
                {
                    catch (Throwable var10_20) {
                        var11_13 = null;
                        ** try [egrp 5[TRYBLOCK] [11 : 982->1069)] { 
lbl179:
                        // 1 sources

                        var12_18 = new AppSyncEventsTask();
                        var12_18.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                        Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + var12_18);
                        var12_18.performTask(this.appStatusTbl, this.appTypeTbl);
                        throw var10_20;
lbl185:
                        // 1 sources

                        catch (Throwable var12_19) {
                            if (this._isLocal) {
                                var12_19.printStackTrace();
                            }
                            FFDCFilter.processException(var12_19, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                        }
                        throw var10_20;
                    }
                    ** try [egrp 5[TRYBLOCK] [11 : 982->1069)] { 
lbl191:
                    // 1 sources

                    var12_14 = new AppSyncEventsTask();
                    var12_14.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                    Tr.debug(AppBinaryProcessor.access$200(), "Executing AppSyncEventsTask after all Apps: " + var12_14);
                    var12_14.performTask(this.appStatusTbl, this.appTypeTbl);
lbl197:
                    // 1 sources

                    catch (Throwable var12_15) {}
                    if (this._isLocal) {
                        var12_15.printStackTrace();
                    }
                    FFDCFilter.processException(var12_15, "com.ibm.ws.management.application.sync.AppBinThread.run", "1425", this);
                }
            }
            this.notifyWaiter();
            AppBinaryProcessor.access$402(null);
            AppBinaryProcessor.access$500().remove(this);
            if (AppBinaryProcessor.access$200().isEntryEnabled() == false) return;
            Tr.exit(AppBinaryProcessor.access$200(), "run");
        }

        private void logAppSyncFailure(String string, Hashtable hashtable, AbstractAppSyncTask abstractAppSyncTask, Vector vector, Throwable throwable) {
            Object[] objectArray;
            String string2;
            block18: {
                block17: {
                    String string3 = null;
                    Object[] objectArray2 = null;
                    try {
                        if (abstractAppSyncTask != null) {
                            string2 = abstractAppSyncTask.getClass().getName();
                            hashtable.put("appSyncTaskFailed", string2);
                            if (throwable != null) {
                                string3 = "ADMA7024E";
                                objectArray2 = new Object[]{string, string2, throwable.getMessage()};
                                hashtable.put("appSyncFailure", throwable.getMessage());
                            } else {
                                string3 = "ADMA7023E";
                                objectArray2 = new Object[]{string, string2};
                            }
                        } else {
                            string3 = "ADMA7022E";
                            objectArray2 = new Object[]{string, null};
                            if (throwable != null) {
                                objectArray2[1] = throwable.getMessage();
                                hashtable.put("appSyncFailure", throwable.getMessage());
                            }
                        }
                        hashtable.put("appSyncMessage", AppUtils.getMessage(this._resBundle, string3, objectArray2));
                        Tr.error(tc, string3, objectArray2);
                    }
                    catch (Throwable throwable2) {
                        if (!tc.isDebugEnabled()) break block17;
                        Tr.debug(tc, "Error logging appsync failure" + throwable2.getMessage());
                    }
                }
                string2 = null;
                try {
                    if (vector != null) {
                        List list = this.getUnExecutedTaskNames(vector);
                        hashtable.put("appSyncTasksNotExecuted", list);
                        if (!list.isEmpty()) {
                            string2 = "For application " + string + " following application synchronization tasks will not be executed " + list.toString().replaceAll("[\\[{1}\\]{1}]", "\"");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "For application " + string + " following application synchronization tasks will not be executed ", list.toArray());
                            }
                        }
                    } else {
                        string2 = "For application " + string + " none of the application synchronization tasks will be executed.";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string2);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Error identifying unexecuted tasks" + throwable3.getMessage());
                }
            }
            if (this._isLocal && throwable != null) {
                throwable.printStackTrace();
            }
            Throwable throwable4 = throwable != null ? throwable : new AdminException((String)hashtable.get("appSyncTaskFailed"));
            if (string2 != null) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = string2;
            } else {
                objectArray = null;
            }
            FFDCFilter.processException(throwable4, "com.ibm.ws.management.application.sync.AppBinaryProcessor.run", "1245", this, objectArray);
        }

        public List getAppsBeingProcessed() {
            if (this._changeTbl == null) {
                return null;
            }
            Enumeration enumeration = this._changeTbl.keys();
            ArrayList arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            return arrayList;
        }

        private synchronized void waitForThreadCompletion() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForThreadCompletion");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Entering waitForThreadCompletion notificationSignaled = " + AppBinaryProcessor.this.notificationSignaled);
            }
            if (!AppBinaryProcessor.this.notificationSignaled) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AppBinaryProcessor.this.notificationSignaled = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exiting waitForThreadCompletion");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForThreadCompletion");
            }
        }

        private synchronized void notifyWaiter() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyWaiter");
            }
            AppBinaryProcessor.this.notificationSignaled = true;
            this.notify();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyWaiter");
            }
        }

        private Vector getTaskList(int n) throws Exception {
            DefaultAppSyncTaskProvider defaultAppSyncTaskProvider = new DefaultAppSyncTaskProvider();
            if ((n & 1) != 0) {
                Vector vector = new Vector();
                defaultAppSyncTaskProvider.provideAppAddedSyncTasks(vector);
                vector = ExtensionHelper.processAppAddedSyncExtensions(vector);
                return vector;
            }
            if ((n & 0x10) != 0) {
                Vector vector = new Vector();
                defaultAppSyncTaskProvider.provideAppRemovedSyncTasks(vector);
                vector = ExtensionHelper.processAppRemovedSyncExtensions(vector);
                return vector;
            }
            Vector vector = new Vector();
            defaultAppSyncTaskProvider.provideAppModifiedSyncTasks(vector);
            vector = ExtensionHelper.processAppModifiedSyncExtensions(vector);
            return vector;
        }

        private AbstractAppSyncTask getNextTask(Vector vector) throws AdminException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNextTask");
            }
            if (this.nextTaskNum >= vector.size()) {
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNextTask");
            }
            return (AbstractAppSyncTask)vector.elementAt(this.nextTaskNum++);
        }

        private List getUnExecutedTaskNames(Vector vector) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.nextTaskNum < vector.size()) {
                List list = vector.subList(this.nextTaskNum, vector.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next().getClass().getName());
                }
            }
            return arrayList;
        }
    }
}

