/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.application.sync.AppSyncChange;
import com.ibm.websphere.management.application.sync.AppSyncConstants;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DeltaFile;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.security.util.JaccUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ChangeProcessor
implements AppSyncChange,
AppSyncConstants {
    private static TraceComponent tc = Tr.register(ChangeProcessor.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private String earURI;
    private String earChange;
    private String deplURI;
    private String deplChange;
    private Hashtable deltaChanges;
    private Hashtable uriChanges;
    private EARFile earFile;
    private boolean isLocal;
    private int _recycleMode = 256;
    private List _stopModules = new ArrayList();
    private List _startModules = new ArrayList();
    private List _recycleModules = new ArrayList();
    private int _op = 0;
    private String _configRoot;
    private Hashtable _result_files = new Hashtable();
    private Hashtable _result_uri = new Hashtable();
    private Hashtable _result_modules = new Hashtable();

    public ChangeProcessor(EARFile eARFile, boolean bl, String string) {
        this.earFile = eARFile;
        this.isLocal = bl;
        this._configRoot = string;
        this._result_uri.put("DOCSADDED_KEY", new ArrayList());
        this._result_uri.put("DOCSREMOVED_KEY", new ArrayList());
        this._result_modules.put("DOCSADDED_KEY", new ArrayList());
        this._result_modules.put("DOCSREMOVED_KEY", new ArrayList());
        this._result_modules.put("DOCSMODIFIED_KEY", new ArrayList());
    }

    public void init(String string, String string2, String string3, String string4, Hashtable hashtable, Hashtable hashtable2) {
        this.earURI = string;
        this.earChange = string2;
        this.deplURI = string3;
        this.deplChange = string4;
        this.deltaChanges = hashtable;
        this.uriChanges = hashtable2;
    }

    public String toString() {
        return ">>ChangeProcessor(" + this.deplURI + ")" + "\n" + "op = " + Integer.toHexString(this._op) + "\n" + "recyclemode = " + Integer.toHexString(this._recycleMode) + "\n" + "startMod = " + this._startModules + "\n" + "stopMod = " + this._stopModules + "\n" + "recycleMod = " + this._recycleModules + "\n" + "uri table = " + this._result_uri + "\n" + "module_table = " + this._result_modules + "\n" + "<<ChangeProcessor  \n";
    }

    public void setOp(int n) {
        if (n == 1 || n == 16 || n == 65536) {
            this._op = n;
            this._result_files.clear();
            ((List)this._result_uri.get("DOCSADDED_KEY")).clear();
            ((List)this._result_uri.get("DOCSREMOVED_KEY")).clear();
        } else {
            this._op |= n;
        }
    }

    public void setRecycle(int n) {
        if (this._recycleMode == 1) {
            return;
        }
        this._recycleMode = n;
        if (1 == this._recycleMode) {
            this._stopModules.clear();
            this._startModules.clear();
            this._recycleModules.clear();
        }
    }

    public void setForceRecycle(int n) {
        this._recycleMode = n;
        if (1 == this._recycleMode) {
            this._stopModules.clear();
            this._startModules.clear();
            this._recycleModules.clear();
        }
    }

    private int getRecycle() {
        return this._recycleMode;
    }

    public void processDeltaAsV5(ApplicationDeployment applicationDeployment, ApplicationDeployment applicationDeployment2, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processDeltaAsV5: " + applicationDeployment + ", NEW = " + applicationDeployment2 + ", binURL= " + string2);
        }
        if ("DOCSADDED_KEY".equals(this.deplChange) || "DOCSREMOVED_KEY".equals(this.deplChange) || "DOCSADDED_KEY".equals(this.earChange) || "DOCSMODIFIED_KEY".equals(this.earChange) || "DOCSREMOVED_KEY".equals(this.earChange) || string != null && !string.equals(string2)) {
            this.processDelta(applicationDeployment, applicationDeployment2, string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processDeltaAsV5");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDelta(ApplicationDeployment applicationDeployment, ApplicationDeployment applicationDeployment2, String string, String string2) {
        block61: {
            DeltaFile deltaFile;
            List list;
            boolean bl;
            boolean bl2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processDelta: " + applicationDeployment + ", NEW = " + applicationDeployment2 + ", binURL= " + string2);
            }
            if ("DOCSADDED_KEY".equals(this.deplChange)) {
                this.setOp(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected install: " + this.deplURI);
                }
                return;
            }
            if ("DOCSREMOVED_KEY".equals(this.deplChange)) {
                this.setOp(16);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected uninstall: " + this.deplURI);
                }
                return;
            }
            if (((List)this.deltaChanges.get("DOCSREMOVED_KEY")).size() > 0) {
                this.setOp(65536);
                this.setRecycle(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected fullupdate(deltaDelete): " + this.deplURI);
                }
                return;
            }
            if (applicationDeployment != null && applicationDeployment2 != null && applicationDeployment.isEnableDistribution() != applicationDeployment2.isEnableDistribution()) {
                this.setOp(65536);
                this.setRecycle(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ear just came in: " + this.earURI);
                }
                return;
            }
            if (string != null && !string.equals(string2)) {
                this.setOp(65536);
                this.setRecycle(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "binURL changed: " + string);
                }
                return;
            }
            if ("DOCSADDED_KEY".equals(this.earChange)) {
                this.setOp(65536);
                this.setRecycle(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ear just came in: " + this.earURI);
                }
                return;
            }
            boolean bl3 = bl2 = ((List)this.deltaChanges.get("DOCSADDED_KEY")).size() != 0 || ((List)this.deltaChanges.get("DOCSREMOVED_KEY")).size() != 0;
            if (!bl2 && "DOCSMODIFIED_KEY".equals(this.earChange)) {
                this.setOp(65536);
                this.setRecycle(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected fullupdate (noDeltaChange, earChange): " + this.deplURI);
                }
                return;
            }
            if (!bl2 && "DOCSMODIFIED_KEY".equals(this.deplChange)) {
                this.setRecycle(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Detected fullupdate (noDeltaChange, deplChange): " + this.deplURI);
                }
                return;
            }
            boolean bl4 = bl = ((List)this.uriChanges.get("DOCSADDED_KEY")).size() != 0 || ((List)this.uriChanges.get("DOCSREMOVED_KEY")).size() != 0 || ((List)this.uriChanges.get("DOCSMODIFIED_KEY")).size() != 0;
            if (!bl2 && bl) {
                List list2 = this.earFile != null ? this.earFile.getWebModuleRefs() : new ArrayList();
                ArrayList<String> arrayList = new ArrayList<String>();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                for (int i = 0; i < list2.size(); ++i) {
                    ModuleRef moduleRef = (ModuleRef)list2.get(i);
                    arrayList.add(moduleRef.getUri());
                    if (AppUtils.isEmpty(moduleRef.getAltRoot())) continue;
                    hashtable.put(moduleRef.getUri(), moduleRef.getAltRoot());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modURI: " + arrayList);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "altMap: " + hashtable);
                }
                this.handleConfigChange((List)this.uriChanges.get("DOCSADDED_KEY"), arrayList, hashtable);
                this.handleConfigChange((List)this.uriChanges.get("DOCSREMOVED_KEY"), arrayList, hashtable);
                this.handleConfigChange((List)this.uriChanges.get("DOCSMODIFIED_KEY"), arrayList, hashtable);
                return;
            }
            if (!this.isLocal && this.getRecycle() != 1 && applicationDeployment2 != null && ClassLoaderPolicy.SINGLE_LITERAL.equals(applicationDeployment2.getWarClassLoaderPolicy())) {
                this.setRecycle(1);
            }
            FileInputStream fileInputStream = null;
            try {
                list = (List)this.deltaChanges.get("DOCSADDED_KEY");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process all deltas: " + list);
                }
                for (int i = 0; i < list.size(); ++i) {
                    fileInputStream = new FileInputStream(this._configRoot + "/" + (String)list.get(i));
                    deltaFile = new DeltaFile(fileInputStream);
                    this.processDeltaFile(deltaFile, (String)list.get(i));
                    fileInputStream.close();
                    fileInputStream = null;
                }
            }
            catch (DeltaProcessDoneEx deltaProcessDoneEx) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Delta Processing Done - " + deltaProcessDoneEx.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception: " + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.ChangeProcessor", "176", this);
                if (this.isLocal) {
                    throwable.printStackTrace();
                }
                this.setRecycle(1);
                if ("DOCSMODIFIED_KEY".equals(this.earChange)) {
                    this.setOp(65536);
                }
            }
            finally {
                block60: {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Excpetion closing delta file " + iOException);
                            }
                            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.application.sync.ChangeProcessor", "213", this);
                            if (!this.isLocal) break block60;
                            iOException.printStackTrace();
                        }
                    }
                }
            }
            if (!this.isLocal && this.getRecycle() != 1 && this.earFile != null && !applicationDeployment2.isZeroEarCopy()) {
                list = null;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checking security stuff");
                    }
                    if (WSSecurityHelper.isGlobalSecurityEnabled() && !JaccUtil.supportsAppDynamicUpdates()) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        deltaFile = this.earFile.getDeploymentDescriptor().getSecurityRoles();
                        for (int i = 0; i < deltaFile.size(); ++i) {
                            SecurityRole securityRole = (SecurityRole)deltaFile.get(i);
                            arrayList.add(securityRole.getRoleName());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "new roles = " + arrayList);
                        }
                        list = AppInstallHelper.getEarFile(string2, false, true, AppUtils.getBundle(null));
                        EList eList = list.getDeploymentDescriptor().getSecurityRoles();
                        for (int i = 0; i < eList.size(); ++i) {
                            SecurityRole securityRole = (SecurityRole)eList.get(i);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "role from old ear = " + securityRole.getRoleName());
                            }
                            if (arrayList.contains(securityRole.getRoleName())) {
                                arrayList.remove(securityRole.getRoleName());
                                continue;
                            }
                            arrayList.add(securityRole.getRoleName());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "After diff = " + arrayList);
                        }
                        if (arrayList.size() != 0) {
                            this.setRecycle(1);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception checking security stuff: " + throwable);
                    }
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.ChangeProcessor", "268", this);
                    if (list == null) break block61;
                    list.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processDelta");
        }
    }

    private String getModuleFromURI(String string, List list, Hashtable hashtable) {
        for (int i = 0; i < list.size(); ++i) {
            if (!string.startsWith((String)list.get(i) + "/")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " is in war " + list.get(i));
            }
            return (String)list.get(i);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            if (!string.startsWith(string3 + "/")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " found in alt dd for: " + string2);
            }
            return string2;
        }
        return null;
    }

    private void handleConfigChange(List list, List list2, Hashtable hashtable) {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            String string2 = this.getModuleFromURI(string, list2, hashtable);
            if (string2 == null) {
                this.setRecycle(1);
                continue;
            }
            this.addModuleForStartStop(string2, "update");
        }
    }

    private void processDeltaFile(DeltaFile deltaFile, String string) throws Exception {
        Element element;
        NodeList nodeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processing: " + string);
        }
        if ((nodeList = (element = deltaFile.getDocumentElement()).getElementsByTagName("change_input")).getLength() < 1) {
            throw new Exception("Malformed delta file " + string + ". No update stanza.");
        }
        Element element2 = (Element)nodeList.item(0);
        boolean bl = this.processUpdateElement(element2, string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processFilesForRecycle: " + bl + ", recycleMode=" + this.getRecycleMode());
        }
        if (this.getRecycleMode() == 1) {
            bl = false;
        }
        if (this.earFile == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "distribution disabled on ND or zero bin copy");
            }
            if (bl) {
                this.setRecycle(1);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processDeltaFile");
            }
            return;
        }
        nodeList = element.getElementsByTagName("files");
        if (nodeList.getLength() > 0) {
            Element element3 = (Element)nodeList.item(0);
            if ((nodeList = element3.getElementsByTagName("file")).getLength() == 0) {
                Tr.warning(tc, "ADMA7018W", new Object[]{string});
                return;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.processFileURI((Element)nodeList.item(i), bl);
                if (this.getRecycleMode() != 1) continue;
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processed: " + string);
        }
    }

    private boolean processUpdateElement(Element element, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processUpdateElement");
        }
        boolean bl = false;
        Properties properties = this.getProps(element);
        String string2 = properties.getProperty("changetype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "u_op = " + string2);
        }
        if ("install".equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "full update detected");
            }
            this.setOp(65536);
            this.setRecycle(1);
            throw new DeltaProcessDoneEx("Full recycle detected due to add in delta file: " + string);
        }
        if ("edit".equals(string2)) {
            boolean bl2 = "true".equals(properties.getProperty("useMetaDataFromBinary"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "edit detected, useMetadataFromBinaries: " + bl2);
            }
            this.setRecycle(1);
            this.setOp(bl2 ? 4096 : 256);
        } else if ("fg-update".equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fine-grained update detected");
            }
            this.setOp(0x100000);
            String string3 = properties.getProperty("update.recycle");
            String string4 = properties.getProperty("contenttype");
            String string5 = properties.getProperty("operation");
            String string6 = properties.getProperty("contenturi");
            String string7 = properties.getProperty("moduletype");
            if (string3 != null) {
                if ("update.recycle.app".equals(string3)) {
                    this.setForceRecycle(1);
                } else if ("update.recycle.none".equals(string3)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "recycle none set explicitly");
                    }
                    this.setForceRecycle(256);
                } else if ("update.recycle.modules".equals(string3)) {
                    String string8 = properties.getProperty("update.recycle.modules");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "recycle modules as specified in user input: " + string8);
                    }
                    if (string8 != null) {
                        String[] stringArray = string8.split("\\+");
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.addModuleForStartStop(stringArray[i], "delete");
                            this.addModuleForStartStop(stringArray[i], "add");
                        }
                        this.setForceRecycle(16);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unknown recycle type: " + string3 + ", treat as full recycle");
                    }
                    this.setForceRecycle(1);
                }
            } else if (this.getRecycle() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In fgupdate, recycle mode already set to full so no processing");
                }
            } else if ("modulefile".equals(string4)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modulefile op=" + string5 + ", uri=" + string6 + ", mType=" + string7);
                }
                if (this.isWeb(string7, string6)) {
                    this.addModuleForStartStop(string6, string5);
                } else if ("add".equals(string5)) {
                    this.addModuleForStartStop(string6, string5);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "needs a full recycle");
                    }
                    this.setRecycle(1);
                }
            } else if ("file".equals(string4) || "partialapp".equals(string4)) {
                bl = true;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "recycle not set and cType not known - full recycle");
                }
                this.setRecycle(1);
            }
            if ("modulefile".equals(string4)) {
                if ("add".equals(string5)) {
                    ((List)this._result_modules.get("DOCSADDED_KEY")).add(string6);
                }
                if ("update".equals(string5)) {
                    ((List)this._result_modules.get("DOCSMODIFIED_KEY")).add(string6);
                }
                if ("delete".equals(string5)) {
                    ((List)this._result_modules.get("DOCSREMOVED_KEY")).add(string6);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processUpdateElement");
        }
        return bl;
    }

    private void processFileURI(Element element, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processFileURI: " + bl);
        }
        Properties properties = this.getProps(element);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "file tag props = " + properties);
        }
        String string = properties.getProperty("uri");
        String string2 = properties.getProperty("operation");
        Object[] objectArray = AppUtils.getContainerAndOffset((Container)this.earFile, string);
        Container container2 = (Container)objectArray[0];
        String string3 = (String)objectArray[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Container for  " + string + " is:" + container2 + " offset is: " + string3);
        }
        this._result_files.put(string, new Object[]{string2, container2, string3});
        if (container2.containsFile(string3)) {
            ((List)this._result_uri.get("DOCSADDED_KEY")).add(string);
        } else {
            ((List)this._result_uri.get("DOCSREMOVED_KEY")).add(string);
        }
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = container2 instanceof WARFile || container2.getContainer() != null && container2.getContainer() instanceof WARFile;
            if (bl2) {
                String string4 = string.substring(container2.getURI().length() + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uri_in: " + string4);
                }
                if (container2 instanceof EJBJarFile) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + " is inside a JAR in a WAR so bounce the web app");
                    }
                    this.addModuleForStartStop(container2.getContainer().getURI(), "update");
                } else if (string4.matches("META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*") || string4.startsWith("WEB-INF/lib/") || string4.startsWith("WEB-INF/classes/") || string4.startsWith("WEB-INF/tld/")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + " is metadata of a WAR so bounce the web app");
                    }
                    this.addModuleForStartStop(container2.getURI(), "update");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + " is non metadata of WARFile so no recycle.");
                }
            } else if (container2 instanceof EARFile && !string.matches("META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*") && "add".equals(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + " is non metadata add at app level. Hence no-op.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "full recycle as something changed/deleted at app or non web level: " + string + ", action=" + string2);
                }
                this.setRecycle(1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processFileURI");
        }
    }

    private Properties getProps(Element element) {
        Properties properties = new Properties();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            properties.put(attr.getName(), attr.getValue());
        }
        return properties;
    }

    private boolean isWeb(String string, String string2) {
        if ("moduletype.web".equals(string)) {
            return true;
        }
        if (this.earFile == null) {
            return false;
        }
        EList eList = this.earFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (!moduleRef.getUri().equals(string2) || !moduleRef.isWeb()) continue;
            return true;
        }
        return false;
    }

    private void addModuleForStartStop(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addModuleForStartStop: " + string + ", change=" + string2);
        }
        if (this.getRecycle() == 1) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "Already in full recycle mode");
            }
            return;
        }
        this.setRecycle(16);
        if ("add".equals(string2)) {
            if (!this._startModules.contains(string)) {
                this._startModules.add(string);
            }
            if (this._recycleModules.contains(string)) {
                this._recycleModules.remove(string);
            }
        } else if ("delete".equals(string2)) {
            if (!this._stopModules.contains(string)) {
                this._stopModules.add(string);
            }
            if (this._startModules.contains(string)) {
                this._startModules.remove(string);
            }
            if (this._recycleModules.contains(string)) {
                this._recycleModules.remove(string);
            }
        } else if ("update".equals(string2)) {
            if (!this._recycleModules.contains(string)) {
                this._recycleModules.add(string);
            }
            if (this._startModules.contains(string)) {
                this._startModules.remove(string);
            }
            if (this._stopModules.contains(string)) {
                this._stopModules.remove(string);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ERROR - unknown change type for module recycle: " + string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addModuleForStartStop: " + string + ", start=" + this._startModules + ", stop=" + this._stopModules + ", recycle=" + this._recycleModules);
        }
    }

    public int getOperations() {
        return this._op;
    }

    public String getEarURI() {
        return this.earURI;
    }

    public String getEarURIChangeType() {
        return this.earChange;
    }

    public String getDeploymentURI() {
        return this.deplURI;
    }

    public String getDeploymentURIChangeType() {
        return this.deplChange;
    }

    public Hashtable getPartialUpdateDetails() {
        return this._result_uri;
    }

    public Hashtable getPatialStruct() {
        return this._result_files;
    }

    public int getRecycleMode() {
        return this.getRecycle();
    }

    public List getModulesToStop() {
        return this._stopModules;
    }

    public List getModulesToStart() {
        return this._startModules;
    }

    public List getModulesToRecycle() {
        return this._recycleModules;
    }

    public static void main(String[] stringArray) {
    }

    public Hashtable getFileChangesInRepository() {
        return this.uriChanges;
    }

    public Hashtable getPartialUpdateModuleDetails() {
        return this._result_modules;
    }

    class DeltaProcessDoneEx
    extends Exception {
        private static final long serialVersionUID = 3480906202801981104L;

        public DeltaProcessDoneEx(String string) {
            super(string);
        }
    }
}

