/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class FilePermissionTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(FilePermissionTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private String _cachedPerm;
    private String _newPerm;
    private String _binUrl;
    private String _appName;
    private int _op;
    private int _binUrlLength;
    private int _lengthToStrip;
    private Set _changeFromPartialUpdate;
    private boolean _isPartialUpdate = false;
    private Hashtable _permissionTbl;
    private Hashtable _maxPermissionTbl;
    private Hashtable _compiledFilePatternsTbl;
    private static final String PERM_MULTIPLE_SEPARATOR = "#";
    private static final String PERM_TYPE_ACL_SEPARATOR = "=";
    private static final String FILE_SEPARATOR = "/";

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask", new Object[]{appData, appData2, hashtable});
        }
        if (!this.appIsDeployedOnNode(appData.getAppName())) {
            return true;
        }
        if (!appData2.isDistEnabled()) {
            return true;
        }
        this._binUrl = appData2.getBinURL();
        this._appName = appData2.getAppName();
        this._binUrlLength = this._binUrl.length();
        this._lengthToStrip = this._binUrlLength - (this._appName.length() + 4);
        this._cachedPerm = (String)appData.getProperties().get("filepermission");
        this._newPerm = (String)appData2.getProperties().get("filepermission");
        this._op = appData2.getOperations();
        AppUtils.dbg(tc, "_cachedPerm = " + this._cachedPerm);
        AppUtils.dbg(tc, "_newPerm = " + this._newPerm);
        AppUtils.dbg(tc, "_op = " + this._op);
        AppUtils.dbg(tc, "_binUrl = + " + this._binUrl);
        AppUtils.dbg(tc, "_appname = + " + this._appName);
        if (this._cachedPerm == null && this._newPerm == null) {
            AppUtils.dbg(tc, "_cachedPerm and _newPerm = null, return");
            return true;
        }
        if (this._op == 0) {
            AppUtils.dbg(tc, "return - noop operation");
            return true;
        }
        if ((this._op & 1) != 0 || (this._op & 0x100) != 0 || (this._op & 0x10000) != 0 || (this._op & 0x100000) != 0) {
            this._permissionTbl = this.getPermissionsTable(this._newPerm);
            this._maxPermissionTbl = this.getMaxAllowedPermissionTable();
            if ((this._op & 0x100000) != 0) {
                AppUtils.dbg(tc, "SYNC_PARTIALUPDATE");
                this._isPartialUpdate = true;
                this._changeFromPartialUpdate = new HashSet();
                List list = (List)appData2.getPartialUpdateDetails().get("DOCSADDED_KEY");
                this.buildChangeFromPartialUpdateList(list);
            }
            this._compiledFilePatternsTbl = this.compileFilePatterns(this._permissionTbl.keySet());
            this.setPermissions(appData2.getBinURL(), -1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private void buildChangeFromPartialUpdateList(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildChangeFromPartialUpdateList - " + list);
        }
        if (list == null) {
            this._changeFromPartialUpdate = null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AppUtils.dbg(tc, "cDoc = " + string);
            if (string.indexOf(47) == -1) {
                AppUtils.dbg(tc, "did not find '/'");
                this._changeFromPartialUpdate.add(string);
                continue;
            }
            int n = 0;
            while (string.indexOf(47, n) != -1) {
                int n2 = string.indexOf(47, n);
                String string2 = string.substring(0, n2);
                AppUtils.dbg(tc, "adding " + string2);
                this._changeFromPartialUpdate.add(string2);
                n = n2 + 1;
            }
            AppUtils.dbg(tc, "adding... " + string);
            this._changeFromPartialUpdate.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildChangeFromPartialUpdateList - " + this._changeFromPartialUpdate);
        }
    }

    private boolean isFilePartialUpdate(String string) {
        boolean bl = false;
        Iterator iterator = this._changeFromPartialUpdate.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.endsWith(string2)) continue;
            bl = true;
        }
        if (bl) {
            AppUtils.dbg(tc, "isFilePartialupdate true - " + string);
        }
        return bl;
    }

    private void setPermissions(String string, int n) throws AdminException {
        int n2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPermissions " + string + ", parentDirPerm = " + n);
        }
        string = string.replace('\\', '/');
        AppUtils.dbg(tc, "new dirName = " + string);
        File file = new File(string);
        if (!this._isPartialUpdate || this._isPartialUpdate && this.isFilePartialUpdate(string)) {
            object = this.resolveACL(string.substring(this._lengthToStrip));
            if (object != null) {
                n2 = Integer.parseInt((String)object);
                AppUtils.dbg(tc, "Set permission on dir = " + string);
                this.setPermission(string, n2);
                n = n2;
            } else if (n != -1) {
                this.setPermission(string, n);
            }
        }
        int n3 = n2 = (object = file.listFiles()) != null ? ((File[])object).length : 0;
        if (tc.isDebugEnabled()) {
            AppUtils.dbg(tc, "Number of files = " + n2);
        }
        for (int i = 0; i < n2; ++i) {
            String string2;
            String string3 = object[i].getAbsolutePath().replace('\\', '/');
            AppUtils.dbg(tc, "Check dir entry =" + string3);
            if (object[i].isDirectory()) {
                this.setPermissions(string3, n);
                continue;
            }
            if (this._isPartialUpdate && (!this._isPartialUpdate || !this.isFilePartialUpdate(string3)) || (string2 = this.resolveACL(string3.substring(this._lengthToStrip))) == null) continue;
            int n4 = Integer.parseInt(string2);
            AppUtils.dbg(tc, "Set permission on file = " + string3);
            this.setPermission(string3, n4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPermissions");
        }
    }

    private String resolveACL(String string) {
        String string2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveACL : " + string);
        }
        String string3 = null;
        Set set = this._permissionTbl.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (Pattern)this._compiledFilePatternsTbl.get(object2);
            if (!((Pattern)object).matcher(string).matches()) continue;
            AppUtils.dbg(tc, "ttt found matching file_pattern = " + (String)object2);
            string2 = (String)this._permissionTbl.get(object2);
            AppUtils.dbg(tc, "ttt permission from match = " + string2);
            if (string3 != null) {
                AppUtils.dbg(tc, "aclStr exists! Now resolving most least lenient acl");
                string2 = this.getLeastLenientFilePermission(string2, string3);
            }
            string3 = string2;
        }
        AppUtils.dbg(tc, "ttt aclStr before max filter = " + string3);
        if (this._maxPermissionTbl == null || this._maxPermissionTbl.size() == 0 || string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveACL : " + string3);
            }
            return string3;
        }
        object2 = this._maxPermissionTbl.keySet();
        object = object2.iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            if (!string.matches(string2)) continue;
            AppUtils.dbg(tc, "ttt found matching max_file_name_pattern = " + string2);
            String string4 = (String)this._maxPermissionTbl.get(string2);
            AppUtils.dbg(tc, "ttt permission from max match = " + string4);
            if (string3 == null) continue;
            AppUtils.dbg(tc, "aclStr exists! Now filtering with max acl");
            string3 = this.getLeastLenientFilePermission(string4, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveACL : " + string3);
        }
        return string3;
    }

    private Hashtable getPermissionsTable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissionTable", new Object[]{string});
        }
        Hashtable hashtable = new Hashtable();
        hashtable = this.buildPermissionsTable(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissionTable", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable compileFilePatterns(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compileFilePatterns", new Object[]{set});
        }
        Hashtable<String, Pattern> hashtable = new Hashtable<String, Pattern>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Pattern pattern = Pattern.compile(string);
            AppUtils.dbg(tc, "compiled pattern:  " + string);
            hashtable.put(string, pattern);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compileFilePatterns", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable buildPermissionsTable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildPermissionTable", new Object[]{string});
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "buildPermissionsTable", new Object[]{hashtable});
            }
            return null;
        }
        String[] stringArray = string.split(PERM_MULTIPLE_SEPARATOR);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split(PERM_TYPE_ACL_SEPARATOR, 2);
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            if (hashtable.containsKey(string2) && !string3.equals((String)hashtable.get(string2))) {
                string3 = this.getLeastLenientFilePermission(string3, (String)hashtable.get(string2));
            }
            AppUtils.dbg(tc, "ttt pattern = " + string2 + ", acl = " + string3);
            hashtable.put(string2, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildPermissionsTable", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable getMaxAllowedPermissionTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxAllowedPermissionTable");
        }
        Hashtable hashtable = new Hashtable();
        if (this.getMaxFilePermissionForApps() != null) {
            hashtable = this.buildPermissionsTable(this.getMaxFilePermissionForApps());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxAllowedPermissionTable", new Object[]{hashtable});
        }
        return hashtable;
    }

    private String getLeastLenientFilePermission(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLeastLenientFilePermission", new Object[]{string, string2});
        }
        if (string.equals(string2)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = Character.getNumericValue(cArray[0]);
        int n2 = Character.getNumericValue(cArray[1]);
        int n3 = Character.getNumericValue(cArray[2]);
        char[] cArray2 = string2.toCharArray();
        int n4 = Character.getNumericValue(cArray2[0]);
        int n5 = Character.getNumericValue(cArray2[1]);
        int n6 = Character.getNumericValue(cArray2[2]);
        int n7 = n <= n4 ? n : n4;
        int n8 = n2 <= n5 ? n2 : n5;
        int n9 = n3 <= n6 ? n3 : n6;
        String string3 = "" + n7 + n8 + n9;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLeastLenientFilePermission = " + string3);
        }
        return string3;
    }

    private void setPermission(String string, int n) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPermission");
        }
        char[] cArray = Integer.toString(n).toCharArray();
        int n2 = Character.getNumericValue(cArray[0]);
        int n3 = Character.getNumericValue(cArray[1]);
        int n4 = Character.getNumericValue(cArray[2]);
        this.doSetPermission(string, n2, n3, n4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPermission");
        }
    }

    private void doSetPermission(String string, int n, int n2, int n3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doSetPermission:  file = " + string + " u = " + n + ", g = " + n2 + ", w = " + n3);
        }
        NativeFile nativeFile = new NativeFile(string);
        try {
            nativeFile.setPermissions(n, n2, n3);
        }
        catch (NativeFileIOException nativeFileIOException) {
            Tr.error(tc, "failure in setting file permissions", nativeFileIOException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doSetPermission");
        }
    }

    private String getMaxFilePermissionForApps() {
        String string = AppSyncUtils.getMaxFilePermissionForApps(this._cellName, this._nodeName, this._repository);
        return string;
    }
}

