/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class StartDeploymentTask
extends AbstractAppSyncTask {
    private static final TraceComponent tc = Tr.register(StartDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private AppData _cachedAd;
    private AppData _newAd;

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StartDeploymentTask.performTask", new Object[]{"cachedAD=" + appData, "newAD=" + appData2, "props=" + hashtable});
        }
        if (this._isLocal || !this.appIsDeployedOnNode(appData.getAppName())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StartDeploymentTask.performTask", "Is local or app not deployed on node.");
            }
            return true;
        }
        this._cachedAd = appData;
        this._newAd = appData2;
        int n = this._newAd.getRecycleMode();
        int n2 = this._newAd.getOperations();
        boolean bl = true;
        if (n == 16) {
            bl = this.fineGrainUpdate(hashtable);
        } else if (n == 1) {
            bl = this.fullAppUpdate(hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StartDeploymentTask.performTask", Boolean.toString(bl));
        }
        return bl;
    }

    private boolean fullAppUpdate(Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fullAppUpdate", "props=" + hashtable);
        }
        Vector vector = (Vector)hashtable.get("stoppedlist");
        this.startDeployment("startApplication", new String[]{this._cachedAd.getAppName()}, vector, (Vector)this._newSIMap.get(this._cachedAd.getAppName()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fullAppUpdate", Boolean.TRUE);
        }
        return true;
    }

    private boolean fineGrainUpdate(Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fineGrainedUpdate", "props=" + hashtable);
        }
        Resource resource = null;
        try {
            Object object;
            List list = this._newAd.getModulesToStart();
            List list2 = this._newAd.getModulesToRecycle();
            if (list.size() == 0 && list2.size() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fineGrainUpdate", "Start or recycle size is 0: " + list + "---" + list2);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "fineGrainUpdate", Boolean.TRUE);
                }
                boolean bl = true;
                return bl;
            }
            resource = AppSyncUtils.getResource(this._repository, this._cachedAd.getDeplURI(), "deployment.xml");
            if (resource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fineGrainUpdate", "Could not get deployment resources for " + this._cachedAd.getDeplURI());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "fineGrainUpdate", Boolean.FALSE);
                }
                boolean bl = false;
                return bl;
            }
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(resource);
            String string = this._cachedAd.getAppName();
            if (EditionHelper.isEditionSupportEnabled()) {
                String[] stringArray = EditionHelper.getAppAndEdition(string);
                string = stringArray[0];
            }
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fineGrainUpdate", "Starting " + string2);
                }
                object = this.getServersForModule(string2, applicationDeployment);
                this.startDeployment("_startModule", new String[]{string, string2}, this.servers2AppMgrON((Vector)object), (Vector)object);
            }
            Hashtable hashtable2 = (Hashtable)hashtable.get("stoppedlist");
            if (hashtable2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "fineGrainUpdate", "No stopped table so nothing to recycle");
                }
                boolean bl = true;
                return bl;
            }
            for (int i = 0; i < list2.size(); ++i) {
                object = (String)list2.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fineGrainUpdate", "Recycling " + (String)list2.get(i));
                }
                Vector vector = (Vector)hashtable2.get(object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fineGrainUpdate", (String)object + " was stopped at: " + vector);
                }
                if (vector == null || vector.size() == 0) continue;
                Vector vector2 = this.getServersForModule((String)object, applicationDeployment);
                this.startDeployment("_startModule", new String[]{string, object}, vector, vector2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, CLASS_NAME + ".fineGrainedUpdate", "188", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fineGrainedUpdate", exception);
            }
            throw exception;
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fineGrainedUpdate", Boolean.TRUE);
        }
        return true;
    }

    private void startDeployment(String string, String[] stringArray, Vector vector, Vector vector2) {
        String[] stringArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDeployment", new Object[]{"methodName=" + string, "params=" + Arrays.toString(stringArray), "stopped=" + vector, "shouldStart=" + vector2});
        }
        if (vector == null || vector.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "startDeployment", "No objects were stopped.  Nothing to restart.");
            }
            return;
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (stringArray.length == 1) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = String.class.getName();
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = String.class.getName();
            stringArray2 = stringArray4;
            stringArray4[1] = String.class.getName();
        }
        String[] stringArray5 = stringArray2;
        for (int i = 0; i < vector.size(); ++i) {
            ObjectName objectName = (ObjectName)vector.elementAt(i);
            String string2 = objectName.getKeyProperty("process");
            if (vector2.contains(string2)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "startDeployment", new Object[]{"Starting...", "on=" + objectName});
                    }
                    adminService.invoke(objectName, string, stringArray, stringArray5);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "startDeployment", "Start successful.");
                }
                catch (Throwable throwable) {
                    String string3 = "Start failed.  ApplicationManager MBean: " + objectName + ", operation: " + string + ", params: " + Arrays.toString(stringArray);
                    Tr.warning(tc, string3);
                    FFDCFilter.processException(throwable, CLASS_NAME + ".startDeployment", "241", this, new Object[]{string3});
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "startDeployment", "Start list does not include process " + string2);
        }
    }

    private Vector servers2AppMgrON(Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "servers2AppMgrON", "s=" + vector);
        }
        Vector vector2 = new Vector();
        AdminService adminService = AdminServiceFactory.getAdminService();
        for (int i = 0; i < vector.size(); ++i) {
            ObjectName objectName = new ObjectName("WebSphere:type=Application,node=" + this._nodeName + ",process=" + vector.elementAt(i) + ",name=" + this._cachedAd.getAppName() + ",*");
            Set set = adminService.queryNames(objectName, null);
            if (set.size() == 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "servers2AppMgrON", "No app running for: " + objectName);
                continue;
            }
            objectName = new ObjectName("WebSphere:type=ApplicationManager,node=" + this._nodeName + ",process=" + vector.elementAt(i) + ",*");
            Iterator iterator = adminService.queryNames(objectName, null).iterator();
            if (iterator.hasNext()) {
                vector2.add(iterator.next());
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "servers2AppMgrON", "Internal error: No result for: " + objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "servers2AppMgrON", vector2);
        }
        return vector2;
    }

    private Vector getServersForModule(String string, ApplicationDeployment applicationDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModule", "mod=" + string);
        }
        Vector<String> vector = new Vector<String>();
        EList eList = applicationDeployment.getModules();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            if (!moduleDeployment.getUri().equals(string)) continue;
            EList eList2 = moduleDeployment.getTargetMappings();
            for (int j = 0; j < eList2.size(); ++j) {
                DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList2.get(j);
                DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getServersForModule", "Module target: " + deploymentTarget);
                }
                if (deploymentTarget instanceof ServerTarget) {
                    if (!((ServerTarget)deploymentTarget).getNodeName().equals(this._nodeName)) continue;
                    vector.add(((ServerTarget)deploymentTarget).getName());
                    continue;
                }
                if (!(deploymentTarget instanceof ClusteredTarget)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getServersForModule", "Handle clusters");
                }
                String string2 = ((ClusteredTarget)deploymentTarget).getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getServersForModule", "Cluster target: " + string2);
                }
                this.addClusterMembers(string2, vector);
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModule", vector);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClusterMembers(String string, Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addClusterMembers", new Object[]{"clName=" + string, "retVal=" + vector});
        }
        String string2 = "cells/" + this._cellName + "/clusters/" + string + "/cluster.xml";
        Resource resource = null;
        try {
            resource = AppSyncUtils.getResource(this._repository, string2, "cluster.xml");
            if (resource == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addClusterMembers", "Cluster res not found for: " + string2);
                }
                return;
            }
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addClusterMembers", "Cluster obj: " + serverCluster);
            }
            EList eList = serverCluster.getMembers();
            for (int i = 0; i < eList.size(); ++i) {
                ClusterMember clusterMember = (ClusterMember)eList.get(i);
                if (!clusterMember.getNodeName().equals(this._nodeName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "addClusterMembers", "Need to add " + clusterMember.getMemberName());
                }
                if (vector.contains(clusterMember.getMemberName())) continue;
                vector.add(clusterMember.getMemberName());
            }
        }
        catch (Throwable throwable) {
            String string3 = "Unexpected error finding cluster members on the node for " + string + ". The application " + this._cachedAd.getAppName() + " will not be started on some cluster members.";
            Tr.warning(tc, string3);
            FFDCFilter.processException(throwable, CLASS_NAME + ".addClusterMembers", "360", this, new Object[]{string3});
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClusterMembers", vector);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/StartDeploymentTask.java, WAS.admin.appmgmt.sync, WAS61.SERV1, cf311012.09, ver. 1.6.2.1");
        }
        CLASS_NAME = StartDeploymentTask.class.getName();
    }
}

