/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;

public class StopDeploymentTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(StopDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String PROCESS_PROP = "process";
    private AppData _cachedAd;
    private AppData _newAd;

    public StopDeploymentTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StopDeploymentTask");
            Tr.exit(tc, "StopDeploymentTask");
        }
    }

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StopDeploymentTask.performTask", new Object[]{"cachedAD=" + appData, "newAD=" + appData2, "props=" + hashtable});
        }
        if (this._isLocal || !this.appWasDeployedOnNode(appData.getAppName())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StopDeploymentTask.performTask", "Local mode or app was not deployed on node.");
            }
            return true;
        }
        this._cachedAd = appData;
        this._newAd = appData2;
        int n = this._newAd.getRecycleMode();
        int n2 = appData.getOperations();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "StopDeploymentTask.performTask", new Object[]{"recycleMode=" + n, "cachedAppDataOps=" + n2});
        }
        if (n == 16 || n == 1 || (n2 & 0x10) != 0) {
            String string;
            String string2;
            Object object;
            String string3 = this._cachedAd.getAppName();
            boolean bl = EditionHelper.isEditionSupportEnabled();
            if (bl) {
                object = EditionHelper.getAppAndEdition(string3);
                string2 = object[0];
                string = object[1];
            } else {
                string2 = string3;
                string = null;
            }
            object = this.getAppMBeansForUpdatedApp(string2, string);
            if (n == 16) {
                Set set = bl ? this.createProcessFilter((Set)object) : null;
                this.fineGrainUpdate(string2, set, hashtable);
            } else if (n == 1 || (appData.getOperations() & 0x10) != 0) {
                this.fullAppUpdate(string3, string2, (Set)object, hashtable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StopDeploymentTask.performTask", Boolean.TRUE.toString());
        }
        return true;
    }

    private Set getAppMBeansForUpdatedApp(String string, String string2) throws Exception {
        HashSet<ObjectName> hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppMBeansForUpdatedApp", new Object[]{"parsedAppName=" + string, "appEdition=" + string2});
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        HashSet<ObjectName> hashSet2 = this.queryForAppMBeans(string);
        if (string2 == null) {
            hashSet = hashSet2;
        } else {
            hashSet = new HashSet<ObjectName>();
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAppMBeansForUpdatedApp", "Querying application MBean for edition: " + objectName);
                }
                Object object = adminService.invoke(objectName, "getEdition", null, null);
                String string3 = (String)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAppMBeansForUpdatedApp", "runningEdition=" + string3);
                }
                if (!string2.equals(string3)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAppMBeansForUpdatedApp", "Have edition match.  Adding to the result set.");
                }
                hashSet.add(objectName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppMBeansForUpdatedApp", hashSet);
        }
        return hashSet;
    }

    private Set createProcessFilter(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createProcessFilter", "appMBeanSet=" + set);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            String string = objectName.getKeyProperty(PROCESS_PROP);
            hashSet.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createProcessFilter", hashSet);
        }
        return hashSet;
    }

    private void fineGrainUpdate(String string, Set set, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fineGrainedUpdate", new Object[]{"parsedAppName=" + string, "processFilter=" + set, "props=" + hashtable});
        }
        List list = this._newAd.getModulesToStop();
        List list2 = this._newAd.getModulesToRecycle();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fineGrainUpdate", "Stopping " + string2);
                }
                this.stopModule(string, string2, set);
            }
        }
        if (list2 != null && list2.size() > 0) {
            Hashtable<String, Vector> hashtable2 = new Hashtable<String, Vector>();
            hashtable.put("stoppedlist", hashtable2);
            for (int i = 0; i < list2.size(); ++i) {
                String string3 = (String)list2.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fineGrainUpdate", "Recycling " + string3);
                }
                Vector vector = this.stopModule(string, string3, set);
                hashtable2.put(string3, vector);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fineGrainUpdate", "After stop part of recycle work the table is: " + hashtable2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fineGrainedUpdate");
        }
    }

    private Vector stopModule(String string, String string2, Set set) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopModule", new Object[]{"parsedAppName=" + string, "moduleName=" + string2, "processFilter=" + set});
        }
        Set set2 = this.queryForModuleMBeans(string, string2, set);
        String[] stringArray = new String[]{string, string2};
        Vector vector = this.stopJavaEEObject(set2, "_stopModule", stringArray, new String[]{String.class.getName(), String.class.getName()});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopModule", vector);
        }
        return vector;
    }

    private void fullAppUpdate(String string, String string2, Set set, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fullAppUpdate", new Object[]{"compositeAppName=" + string, "parsedAppName=" + string2, "appMBeanSet=" + set, "props=" + hashtable});
        }
        Vector vector = this.stopApp(string, string2, set);
        hashtable.put("stoppedlist", vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fullAppUpdate");
        }
    }

    private Vector stopApp(String string, String string2, Set set) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopApp", new Object[]{"compositeAppName=" + string, "parsedAppName=" + string2, "appMBeanSet=" + set});
        }
        String[] stringArray = new String[]{string};
        Vector vector = this.stopJavaEEObject(set, "stopApplication", stringArray, new String[]{String.class.getName()});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopApp", vector);
        }
        return vector;
    }

    private Vector stopJavaEEObject(Set set, String string, String[] stringArray, String[] stringArray2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopJavaEEObject", new Object[]{"jeeMBeanSet=" + set, "appMgrMBeanMethod=" + string, "appMgrMBeanParams=" + Arrays.toString(stringArray), "appMgrMBeanParamTypes=" + Arrays.toString(stringArray2)});
        }
        Vector<ObjectName> vector = new Vector<ObjectName>();
        AdminService adminService = AdminServiceFactory.getAdminService();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            String string2 = objectName.getKeyProperty(PROCESS_PROP);
            ObjectName objectName2 = null;
            try {
                Set set2 = this.queryForApplicationManagerMBean(string2);
                if (set2.size() == 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "stopJavaEEObject", "Could not find ApplicationManager MBean for process: " + string2);
                    continue;
                }
                Iterator iterator2 = set2.iterator();
                objectName2 = (ObjectName)iterator2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopJavaEEObject", "Invoking method " + string + " on ApplicationManager MBean " + objectName2);
                }
                adminService.invoke(objectName2, string, stringArray, stringArray2);
                vector.addElement(objectName2);
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopJavaEEObject", new Object[]{"Attempt to stop Java EE object " + objectName + " by invoking MBean " + objectName2 + " failed.", throwable});
                }
                FFDCFilter.processException(throwable, CLASS_NAME + ".stopJavaEEObject", "411", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopJavaEEObject", vector);
        }
        return vector;
    }

    private Set queryForAppMBeans(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryForAppMBeans", new Object[]{"parsedAppName=" + string});
        }
        ObjectName objectName = this.createAppMBeanQueryName(string);
        AdminService adminService = AdminServiceFactory.getAdminService();
        Set set = adminService.queryNames(objectName, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryForAppMBeans", set);
        }
        return set;
    }

    private Set queryForModuleMBeans(String string, String string2, Set set) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryForModuleMBeans", new Object[]{"parsedAppName=" + string, "moduleName=" + string2, "processFilter=" + set});
        }
        ObjectName objectName = this.createModuleMBeanQueryName(string, string2);
        AdminService adminService = AdminServiceFactory.getAdminService();
        HashSet<ObjectName> hashSet = adminService.queryNames(objectName, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "queryForModuleMBeans", "moduleMBeanSet=" + hashSet);
        }
        if (set != null && set.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "queryForModuleMBeans", "Filtering...");
            }
            HashSet<ObjectName> hashSet2 = hashSet;
            hashSet = new HashSet<ObjectName>();
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                if (!this.objectPassesFilter(objectName2, set)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "queryForModuleMBeans", "Adding to filtered list.  moduleMBean=" + objectName2);
                }
                hashSet.add(objectName2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryForModuleMBeans", hashSet);
        }
        return hashSet;
    }

    private boolean objectPassesFilter(ObjectName objectName, Set set) {
        boolean bl;
        if (set != null) {
            String string;
            bl = false;
            if (set.size() > 0 && set.contains(string = objectName.getKeyProperty(PROCESS_PROP))) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private Set queryForApplicationManagerMBean(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryForApplicationManagerMBean", new Object[]{"processName=" + string});
        }
        ObjectName objectName = this.createApplicationManagerMBeanQueryName(string);
        AdminService adminService = AdminServiceFactory.getAdminService();
        Set set = adminService.queryNames(objectName, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryForApplicationManagerMBean", set);
        }
        return set;
    }

    private ObjectName createModuleMBeanQueryName(String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModuleMBeanQueryName", new Object[]{"parsedAppName=" + string, "moduleName=" + string2});
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WebSphere:node=");
        stringBuilder.append(this._nodeName);
        stringBuilder.append(",name=");
        stringBuilder.append(string2);
        stringBuilder.append(",Application=");
        stringBuilder.append(string);
        stringBuilder.append(",*");
        String string3 = stringBuilder.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createModuleMBeanQueryName", "queryNameString=" + string3);
        }
        ObjectName objectName = new ObjectName(string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModuleMBeanQueryName", objectName);
        }
        return objectName;
    }

    private ObjectName createAppMBeanQueryName(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAppMBeanQueryName", new Object[]{"parsedAppName=" + string});
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WebSphere:type=Application,node=");
        stringBuilder.append(this._nodeName);
        stringBuilder.append(",name=");
        stringBuilder.append(string);
        stringBuilder.append(",*");
        String string2 = stringBuilder.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createAppMBeanQueryName", "queryNameString=" + string2);
        }
        ObjectName objectName = new ObjectName(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAppMBeanQueryName", objectName);
        }
        return objectName;
    }

    private ObjectName createApplicationManagerMBeanQueryName(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createApplicationManagerMBeanQueryName", new Object[]{"processName=" + string});
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WebSphere:type=ApplicationManager,node=");
        stringBuilder.append(this._nodeName);
        stringBuilder.append(",process=");
        stringBuilder.append(string);
        stringBuilder.append(",*");
        String string2 = stringBuilder.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createApplicationManagerMBeanQueryName", "queryNameString=" + string2);
        }
        ObjectName objectName = new ObjectName(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createApplicationManagerMBeanQueryName", objectName);
        }
        return objectName;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/StopDeploymentTask.java, WAS.admin.appmgmt.sync, WAS61.SERV1, cf311012.09, ver. 1.7.2.1");
        }
        CLASS_NAME = StopDeploymentTask.class.getName();
    }
}

