/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.ConnectorModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;

public class ConfigRepoHelper {
    private static final TraceComponent tc = Tr.register(ConfigRepoHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME = ConfigRepoHelper.class.getName();
    private static Object workSpaceIdLock;
    private static int workSpaceIdCounter;

    public static boolean containsEList(EList eList, Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < eList.size(); ++i) {
            if (!eList.get(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkSpace getWorkSpace(String string) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpace", "wID=" + string);
        }
        ModelMgr.initialize("ws-server");
        RepositoryMetaDataFactory.initialize();
        AppdeploymentPackageImpl.init();
        String string2 = string;
        if (string2 == null) {
            object = workSpaceIdLock;
            synchronized (object) {
                workSpaceIdCounter = (workSpaceIdCounter + 1) % 100;
                string2 = "" + System.currentTimeMillis() + workSpaceIdCounter;
            }
        }
        object = WorkSpaceManagerFactory.getManager().getWorkSpace(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpace", object);
        }
        return object;
    }

    public static void removeWorkSpace(boolean bl, WorkSpace workSpace) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeWorkSpace");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sync workspace");
            }
            workSpace.synch(new HashMap());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "remove workspace");
        }
        String string = workSpace.getUserName();
        WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeWorkSpace");
        }
    }

    public static boolean isEditAllowed(ApplicationDeployment applicationDeployment) {
        return !applicationDeployment.isZeroBinaryCopy() && (!applicationDeployment.isZeroEarCopy() || !applicationDeployment.isUseMetadataFromBinaries());
    }

    public static EARFile getEarFileForApp(WorkSpace workSpace, RepositoryContext repositoryContext, ResourceBundle resourceBundle, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarFileForApp", new Object[]{"ws=" + workSpace, "rc=" + repositoryContext, "readyOnly=" + bl});
        }
        EARFile eARFile = null;
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
        eARFile = applicationDeployment.isUseMetadataFromBinaries() ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, resourceBundle, bl) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileForApp", eARFile);
        }
        return eARFile;
    }

    public static EARFile getEarFileFromDeployment(WorkSpace workSpace, RepositoryContext repositoryContext) throws Exception {
        ApplicationDeployment applicationDeployment;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarFileFromDeployment", new Object[]{"ws=" + workSpace, "rc=" + repositoryContext});
        }
        if ((applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext)).isZeroBinaryCopy()) {
            AdminException adminException = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0144E", new Object[]{repositoryContext.getName()}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getEarFileFromDeployment", adminException);
            }
            throw adminException;
        }
        repositoryContext.extract(false);
        EARFile eARFile = AppInstallHelper.getEarFile(repositoryContext.getPath(), false, AppUtils.getBundle(null));
        if (eARFile == null) {
            AdminException adminException = new AdminException("Cannot instantiate ear file for " + repositoryContext.getName());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getEarFileFromDeployment", adminException);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileFromDeployment", eARFile);
        }
        return eARFile;
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, String string) throws Exception {
        return ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, resourceBundle, true);
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, String string, boolean bl) throws Exception {
        return ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, resourceBundle, bl);
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, boolean bl) throws Exception {
        EARFile eARFile;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEarFileFromBinaries", new Object[]{"rc=" + repositoryContext, "readOnly=" + bl});
            }
            eARFile = null;
            RepositoryContext repositoryContext2 = repositoryContext.getParent();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            try {
                String string = repositoryContext.getName() + ".ear";
                if (repositoryContext.getParent().isAvailable(string)) {
                    repositoryContext.getParent().extract(string, false);
                    eARFile = AppInstallHelper.getEarFile(repositoryContext2.getPath() + File.separator + string, false, bl, resourceBundle);
                    break block11;
                }
                if (!bl) {
                    AdminException adminException = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), applicationDeployment.isZeroBinaryCopy() ? "ADMA0145E" : "ADMA0147E", new Object[]{repositoryContext.getName()}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getEarFileFromBinaries", adminException);
                    }
                    throw adminException;
                }
                String string2 = ConfigRepoHelper.getAbsoluteBinariesURL(repositoryContext, workSpace);
                if (new File(string2).exists()) {
                    EList eList = applicationDeployment.getProperties();
                    for (int i = 0; i < eList.size(); ++i) {
                        Property property = (Property)eList.get(i);
                        if (!property.getName().equals("was.loose.config")) continue;
                        LooseConfigRegister.singleton().addLooseMapping(string2, property.getValue());
                        break;
                    }
                    eARFile = AppInstallHelper.getEarFile(string2, false, bl, resourceBundle);
                    break block11;
                }
                AdminException adminException = new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0173E", new String[]{repositoryContext.getName(), "getEarFile"}));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getEarFileFromBinaries", adminException);
                }
                throw adminException;
            }
            catch (Throwable throwable) {
                AdminException adminException = new AdminException(throwable, "Cannot instantiate ear file for " + repositoryContext2.getName());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getEarFileFromBinaries", adminException);
                }
                throw adminException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileFromBinaries", eARFile);
        }
        return eARFile;
    }

    public static String getAbsoluteBinariesURL(RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAbsoluteBinariesURL", new Object[]{"rc=" + repositoryContext, "ws=" + workSpace});
        }
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
        String string2 = applicationDeployment.getBinariesURL();
        String string3 = System.getProperty("was.repository.root");
        if (string3 == null) {
            string3 = System.getProperty("user.install.root") + "/config";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAbsoluteBinariesURL", "configRoot=" + string3);
        }
        if ((string = ConfigRepoHelper.getAdministrativeNode(applicationDeployment, workSpace, false)) != null) {
            VariableMap variableMap = AppUtils.createVarMap(string3, repositoryContext.getParent().getParent().getName(), string, null);
            string2 = AppUtils.convert2AbsPath(string2, variableMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "binURL = " + string2);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The binariesURL can be resolved only if the app is deployed in Base or on the Dmgr in ND");
            }
            string2 = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAbsoluteBinariesURL", string2);
        }
        return string2;
    }

    private static String getAdministrativeNode(ApplicationDeployment applicationDeployment, WorkSpace workSpace, boolean bl) throws AdminException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdministrativeNode", new Object[]{"appDepl=" + applicationDeployment, "ws=" + workSpace, "okToReturnNonAdminNode=" + bl});
        }
        try {
            if (ConfigRepoHelper.isND(workSpace)) {
                string = "dmgr";
            } else {
                string = "server1";
                bl = true;
            }
        }
        catch (AdminException adminException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdministrativeNode", "Rethrowing exception: " + adminException);
            }
            throw adminException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAdministrativeNode", "adminServerName=" + string);
        }
        String string2 = null;
        EList eList = applicationDeployment.getModules();
        int n = eList.size();
        boolean bl2 = false;
        block2: for (int i = 0; !bl2 && i < n; ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            EList eList2 = moduleDeployment.getTargetMappings();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)iterator.next();
                DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
                if (deploymentTarget instanceof ServerTarget) {
                    String string3 = ((ServerTarget)deploymentTarget).getNodeName();
                    String string4 = deploymentTarget.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getAdministrativeNode", new Object[]{"targetNodeName=" + string3, "targetServerName=" + string4});
                    }
                    if (string.equals(string4)) {
                        string2 = string3;
                        bl2 = true;
                        if (!tc.isDebugEnabled()) continue block2;
                        Tr.debug(tc, "getAdministrativeNode", "Found admin server match.");
                        continue block2;
                    }
                    if (!(moduleDeployment instanceof EJBModuleDeployment) && !(moduleDeployment instanceof ConnectorModuleDeployment) && string2 != null) continue;
                    string2 = string3;
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getAdministrativeNode", "Target not ServerTarget: " + deploymentTarget.getClass().getName());
            }
        }
        if (!bl2 && !bl) {
            string2 = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdministrativeNode", string2);
        }
        return string2;
    }

    public static Resource getAppDeploymentResource(RepositoryContext repositoryContext) throws Exception {
        URI uRI = URI.createURI((String)"deployment.xml");
        Resource resource = repositoryContext.getResourceSet().createResource(uRI);
        HashMap hashMap = new HashMap();
        resource.load(hashMap);
        return resource;
    }

    public static ApplicationDeployment getAppDeploymentForApp(RepositoryContext repositoryContext) throws Exception {
        return ConfigRepoHelper.getAppDeploymentForApp(ConfigRepoHelper.getAppDeploymentResource(repositoryContext));
    }

    public static ApplicationDeployment getAppDeploymentForApp(Resource resource) throws Exception {
        AppdeploymentPackageImpl.init();
        Deployment deployment = (Deployment)resource.getContents().get(0);
        return (ApplicationDeployment)deployment.getDeployedObject();
    }

    public static Vector getServersForAppDeployment(ApplicationDeployment applicationDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForAppDeployment");
        }
        Vector vector2 = new Vector();
        EList eList = applicationDeployment.getModules();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            Vector vector3 = ConfigRepoHelper.getServersForModuleDeployment(moduleDeployment, vector, repositoryContext, workSpace, bl);
            vector2.addAll(vector3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForAppDeployment", vector2);
        }
        return vector2;
    }

    public static Vector getServersForAppDeploymentModule(ApplicationDeployment applicationDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForAppDeploymentModule");
        }
        Vector vector2 = new Vector();
        EList eList = applicationDeployment.getModules();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            if (moduleDeployment.getUri().equals(string)) continue;
            Vector vector3 = ConfigRepoHelper.getServersForModuleDeployment(moduleDeployment, vector, repositoryContext, workSpace, bl);
            vector2.addAll(vector3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForAppDeploymentModule", vector2);
        }
        return vector2;
    }

    public static Vector getServersForModuleDeployment(ModuleDeployment moduleDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModuleDeployment");
        }
        Vector<Object> vector2 = new Vector<Object>();
        EList eList = moduleDeployment.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            Object object;
            Object object2;
            DeploymentTarget deploymentTarget = ((DeploymentTargetMapping)eList.get(i)).getTarget();
            if (deploymentTarget == null) continue;
            if (deploymentTarget instanceof ClusteredTarget) {
                object2 = AppUtils.findContext("clusters", deploymentTarget.getName(), null, repositoryContext, workSpace, true);
                if (object2 == null) {
                    if (vector != null) {
                        if (vector.contains(deploymentTarget.getName())) continue;
                        vector.addElement(deploymentTarget.getName());
                        continue;
                    }
                    object = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5027E", new Object[]{deploymentTarget.getName()}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getServersForModuleDeployment", object);
                    }
                    throw object;
                }
                if (!vector2.contains(object2)) {
                    vector2.addElement(object2);
                }
            }
            if (!(deploymentTarget instanceof ServerTarget)) continue;
            object2 = ((ServerTarget)deploymentTarget).getNodeName();
            object = ((ServerTarget)deploymentTarget).getName();
            RepositoryContext repositoryContext2 = AppUtils.findContext("servers", (String)object, (String)object2, repositoryContext, workSpace, false);
            if (repositoryContext2 == null) {
                if (vector != null) {
                    if (vector.contains(object)) continue;
                    vector.addElement(object);
                    continue;
                }
                AdminException adminException = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5028E", new Object[]{object, object2}));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServersForModuleDeployment", adminException);
                }
                throw adminException;
            }
            if (!bl && AppUtils.getClusterFromMember(AppUtils.findContext("servers", deploymentTarget.getName(), (String)object2, repositoryContext, workSpace, false), workSpace) != null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Ignoring  cluster member: " + deploymentTarget.getName());
                continue;
            }
            if (vector2.contains(repositoryContext2)) continue;
            vector2.addElement(repositoryContext2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModuleDeployment", vector2);
        }
        return vector2;
    }

    public static boolean validateTarget(List list, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTarget", new Object[]{"mappings=" + list, "cellContext=" + repositoryContext, "ws=" + workSpace});
        }
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            String string;
            Object object;
            DeploymentTarget deploymentTarget = ((DeploymentTargetMapping)list.get(i)).getTarget();
            if (deploymentTarget == null) continue;
            if (deploymentTarget instanceof ClusteredTarget && (object = AppUtils.findContext("clusters", string = deploymentTarget.getName(), null, repositoryContext, workSpace, true)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validateTarget", "No RepositoryContext for cluster " + string);
                }
                bl = false;
                break;
            }
            if (!(deploymentTarget instanceof ServerTarget)) continue;
            string = ((ServerTarget)deploymentTarget).getNodeName();
            object = deploymentTarget.getName();
            RepositoryContext repositoryContext2 = AppUtils.findContext("servers", (String)object, string, repositoryContext, workSpace, false);
            if (repositoryContext2 != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateTarget", "No RepositoryContext for server " + (String)object + " on node " + string);
            }
            bl = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTarget", Boolean.toString(bl));
        }
        return bl;
    }

    public static Hashtable getNodeServerRelation(WorkSpace workSpace, Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeServerRelation", new Object[]{"ws=" + workSpace, "svrs=" + vector});
        }
        Hashtable hashtable = new Hashtable();
        Vector vector2 = ConfigRepoHelper.getAllServers(workSpace, vector);
        for (int i = 0; i < vector2.size(); ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)vector2.elementAt(i);
            Vector<RepositoryContext> vector3 = (Vector<RepositoryContext>)hashtable.get(repositoryContext.getParent());
            if (vector3 == null) {
                vector3 = new Vector<RepositoryContext>();
                hashtable.put(repositoryContext.getParent(), vector3);
            }
            if (vector3.contains(repositoryContext)) continue;
            vector3.addElement(repositoryContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeServerRelation", hashtable);
        }
        return hashtable;
    }

    public static Vector getAllServers(WorkSpace workSpace, final Vector vector) throws Exception {
        final WorkSpace workSpace2 = workSpace;
        Vector vector2 = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            vector2 = (Vector)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ConfigRepoHelper._getAllServersAsSystem(workSpace2, vector);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            AdminException adminException = new AdminException(exception, "Failed to get the servers.");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAllServers", adminException);
            }
            throw adminException;
        }
        return vector2;
    }

    private static Vector _getAllServersAsSystem(WorkSpace workSpace, Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getAllServersAsSystem", "svrClusterCtxs=" + vector);
        }
        Vector<RepositoryContext> vector2 = new Vector<RepositoryContext>();
        int n = vector.size();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_getAllServersAsSystem", "svrClusterCtxsSize=" + n);
        }
        for (int i = 0; i < n; ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)vector.elementAt(i);
            if (AppUtils.isServer(repositoryContext)) {
                if (vector2.contains(repositoryContext)) continue;
                vector2.addElement(repositoryContext);
                continue;
            }
            if (!AppUtils.isCluster(repositoryContext)) continue;
            URI uRI = URI.createURI((String)"cluster.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cluster obj: " + serverCluster);
            }
            EList eList = serverCluster.getMembers();
            for (int j = 0; j < eList.size(); ++j) {
                ClusterMember clusterMember = (ClusterMember)eList.get(j);
                RepositoryContext repositoryContext2 = AppUtils.findContext("servers", clusterMember.getMemberName(), clusterMember.getNodeName(), repositoryContext.getParent(), workSpace, false);
                if (repositoryContext2 == null) {
                    AdminException adminException = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{clusterMember.getMemberName(), repositoryContext.getName()}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "_getAllServersAsSystem", adminException);
                    }
                    throw adminException;
                }
                if (vector2.contains(repositoryContext2)) continue;
                vector2.addElement(repositoryContext2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getAllServersAsSystem", vector2);
        }
        return vector2;
    }

    public static String getSIEntryText(RepositoryContext repositoryContext) {
        return repositoryContext.getParent().getName() + "/" + "deployments" + "/" + repositoryContext.getName();
    }

    public static RepositoryContext getAppContextFromSIEntry(String string, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppContextFromSIEntry", "siEntry=" + string);
        }
        int n = string.indexOf("/");
        int n2 = string.lastIndexOf("/");
        if (n == -1 || n2 == -1 || n == n2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppContextFromSIEntry", " Malformed si entry");
            }
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + 1, string.length());
        RepositoryContext repositoryContext2 = AppUtils.findContext("deployments", string3, string2, repositoryContext, workSpace, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppContextFromSIEntry", repositoryContext2);
        }
        return repositoryContext2;
    }

    public static Hashtable updateServerIndexDocs(RepositoryContext repositoryContext, WorkSpace workSpace, Vector vector, boolean bl, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerIndexDocs", new Object[]{"svrs=" + vector, "bAdd=" + bl});
        }
        Hashtable hashtable = ConfigRepoHelper.getNodeServerRelation(workSpace, vector);
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6018I", new Object[]{hashtable}));
        Hashtable hashtable2 = ConfigRepoHelper.getServerIndexDocs(workSpace, hashtable.keys());
        if (hashtable2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServerIndexDocs", "Server index docs not found!!");
            }
            return new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        Hashtable hashtable3 = new Hashtable();
        String string = ConfigRepoHelper.getSIEntryText(repositoryContext);
        String string2 = "";
        try {
            while (enumeration.hasMoreElements()) {
                Object object;
                RepositoryContext repositoryContext2 = (RepositoryContext)enumeration.nextElement();
                Vector vector2 = (Vector)hashtable.get(repositoryContext2);
                Vector<String> vector3 = new Vector<String>();
                for (int i = 0; i < vector2.size(); ++i) {
                    vector3.addElement(((RepositoryContext)vector2.elementAt(i)).getName());
                }
                Resource resource = (Resource)hashtable2.get(repositoryContext2);
                if (resource.getContents().size() == 0) {
                    object = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5070E", new Object[]{repositoryContext2.getName()}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateServerIndexDocs", object);
                    }
                    throw object;
                }
                object = (ServerIndex)resource.getContents().get(0);
                ArrayList<String> arrayList = new ArrayList<String>();
                hashtable3.put(repositoryContext2.getName(), arrayList);
                string2 = repositoryContext2.getName();
                EList eList = object.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "servers for " + repositoryContext2.getName() + " are " + vector3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + repositoryContext2.getName() + " are " + eList);
                }
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    if (!vector3.contains(serverEntry.getServerName())) continue;
                    if (bl) {
                        EList eList2 = serverEntry.getDeployedApplications();
                        if (!eList2.contains((Object)string)) {
                            eList2.add((Object)string);
                            AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6020I", new Object[]{repositoryContext, serverEntry.getServerName(), repositoryContext2.getName()}));
                        }
                    } else {
                        boolean bl2 = serverEntry.getDeployedApplications().remove((Object)string);
                        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6021I", new Object[]{string, serverEntry.getServerName(), repositoryContext2.getName(), "" + bl2}));
                    }
                    arrayList.add(serverEntry.getServerName());
                }
                HashMap hashMap = new HashMap();
                resource.save(hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServerIndexDocs", hashtable3);
            }
            return hashtable3;
        }
        catch (AdminException adminException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServerIndexDocs", "Rethrowing exception:" + adminException);
            }
            throw adminException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, CLASS_NAME + ".updateServerIndexDocs", "960");
            AdminException adminException = new AdminException(throwable, "Server Index update failed at the last node of " + string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServerIndexDocs", adminException);
            }
            throw adminException;
        }
    }

    public static String getNodeStrFromNodeSvrTable(Hashtable hashtable, String string) {
        if (hashtable == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = bl ? "" : "+";
            stringBuffer.append(string2 + "WebSphere:cell=" + string + ",node=" + enumeration.nextElement());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static Hashtable getServerIndexDocs(WorkSpace workSpace, Enumeration enumeration) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndexDocs");
        }
        Hashtable<RepositoryContext, Resource> hashtable = new Hashtable<RepositoryContext, Resource>();
        while (enumeration.hasMoreElements()) {
            RepositoryContext repositoryContext = (RepositoryContext)enumeration.nextElement();
            URI uRI = URI.createURI((String)"serverindex.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            if (resource == null) {
                AdminException adminException = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{"serverindex.xml", repositoryContext}));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerIndexDocs", adminException);
                }
                throw adminException;
            }
            hashtable.put(repositoryContext, resource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndexDocs", hashtable);
        }
        return hashtable;
    }

    public static String getDDUri(ModuleRef moduleRef) throws Exception {
        if (moduleRef.getAltDeploymentDescriptor() != null && !moduleRef.getAltDeploymentDescriptor().eResource().getURI().toString().equals("")) {
            return moduleRef.getDeploymentDescriptor().eResource().getURI().toString();
        }
        if (moduleRef.isEJB()) {
            return "META-INF/ejb-jar.xml";
        }
        if (moduleRef.isWeb()) {
            return "WEB-INF/web.xml";
        }
        if (moduleRef.isConnector()) {
            return "META-INF/ra.xml";
        }
        return moduleRef.getDeploymentDescriptor().eResource().getURI().toString();
    }

    public static String getDDUri(ModuleDeployment moduleDeployment) throws Exception {
        if (moduleDeployment.getAltDD() != null && !moduleDeployment.getAltDD().equals("")) {
            return moduleDeployment.getAltDD();
        }
        if (moduleDeployment instanceof EJBModuleDeployment) {
            return "META-INF/ejb-jar.xml";
        }
        if (moduleDeployment instanceof WebModuleDeployment) {
            return "WEB-INF/web.xml";
        }
        if (moduleDeployment instanceof ConnectorModuleDeployment) {
            return "META-INF/ra.xml";
        }
        return null;
    }

    public static Hashtable getCNP(String string, ApplicationDeployment applicationDeployment, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCNP", new Object[]{"unique=" + string, "appDepl=" + applicationDeployment, "cellName=" + string2});
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        EList eList = applicationDeployment.getModules();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            String string3 = ConfigRepoHelper.getDDUri(moduleDeployment);
            if (string3 == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unknown module deployment: " + moduleDeployment);
                continue;
            }
            String string4 = util.createUniqueModuleName(string3, moduleDeployment.getUri());
            if (!AppUtils.isEmpty(string)) {
                if (!string.equals(string4)) continue;
                hashtable.put(string4, ConfigRepoHelper.getCNP(moduleDeployment, string2));
                break;
            }
            hashtable.put(string4, ConfigRepoHelper.getCNP(moduleDeployment, string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCNP", hashtable);
        }
        return hashtable;
    }

    public static String getCNP(ModuleDeployment moduleDeployment, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCNP", new Object[]{"md=" + moduleDeployment, "cell=" + string});
        }
        String string2 = "";
        EList eList = moduleDeployment.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList.get(i);
            DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
            String string3 = "";
            if (deploymentTarget instanceof ClusteredTarget) {
                string3 = "WebSphere:cell=" + string + ",cluster=" + deploymentTarget.getName();
            } else {
                if (!(deploymentTargetMapping.getTarget() instanceof ServerTarget)) continue;
                string3 = "WebSphere:cell=" + string + ",node=" + ((ServerTarget)deploymentTarget).getNodeName() + ",server=" + deploymentTarget.getName();
            }
            if (deploymentTargetMapping.getConfig() != null && !AppUtils.isEmpty(((ModuleConfig)deploymentTargetMapping.getConfig()).getName())) {
                string3 = string3 + ",config=" + ((ModuleConfig)deploymentTargetMapping.getConfig()).getName();
            }
            string2 = AppUtils.isEmpty(string2) ? string3 : string2 + "+" + string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCNP", string2);
        }
        return string2;
    }

    public static String getTargetString(RepositoryContext repositoryContext, String string) {
        String string2 = null;
        string2 = AppUtils.isCluster(repositoryContext) ? "WebSphere:cell=" + repositoryContext.getParent().getName() + ",cluster=" + repositoryContext.getName() : "WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName();
        if (AppUtils.isEmpty(string)) {
            return string2;
        }
        return string + "+" + string2;
    }

    public static String getTargetString(ObjectName objectName, String string) {
        String string2 = "WebSphere:cell=" + objectName.getKeyProperty("cell") + ",node=" + objectName.getKeyProperty("node") + ",server=" + objectName.getKeyProperty("process");
        if (AppUtils.isEmpty(string)) {
            return string2;
        }
        return string + "+" + string2;
    }

    public static Vector getServerNames(String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        return ConfigRepoHelper.getServerNames(string, string2, true, repositoryContext, workSpace);
    }

    public static Vector getServerNames(String string, String string2, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        Vector vector = ConfigRepoHelper.getAddRemoveServerNames(string, string2, bl, repositoryContext, workSpace);
        return (Vector)vector.elementAt(0);
    }

    private static boolean parseServersString(String string, Vector vector, Vector vector2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseServerString", new Object[]{"names=" + string, "addList=" + vector, "remList=" + vector2});
        }
        boolean bl = false;
        String string2 = "-WebSphere:";
        String string3 = "+WebSphere:";
        if (!string.startsWith("+") && !string.startsWith("-")) {
            bl = true;
            if (string.indexOf(string2) > -1) {
                AdminException adminException = new AdminException("Target string: " + string + " without any delimiter prefix is specified for replacement, should" + "contain " + "+" + " delimiters only.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "parseServerString", adminException);
                }
                throw adminException;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        } else {
            Object object;
            String[] stringArray;
            Vector<String> vector3 = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "WebSphere:");
            while (stringTokenizer.hasMoreTokens()) {
                stringArray = (String[])stringTokenizer.nextElement();
                object = stringArray.substring(stringArray.length() - 1);
                if (!"+".equals(object) && !"-".equals(object)) continue;
                vector3.add((String)object);
            }
            stringArray = string.split("\\" + string3 + "|" + string2);
            object = new ArrayList<String>(Arrays.asList(stringArray));
            ((ArrayList)object).remove(0);
            AppUtils.dbg(tc, "delims = " + vector3);
            AppUtils.dbg(tc, "tokens = " + object);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string4 = (String)((ArrayList)object).get(i);
                String string5 = (String)vector3.elementAt(i);
                if ("+".equals(string5)) {
                    vector.add("WebSphere:" + string4);
                    continue;
                }
                if (!"-".equals(string5)) continue;
                vector2.add("WebSphere:" + string4);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parseServerString", new Object[]{"addList=" + vector, "remList=" + vector2});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseServerString", Boolean.toString(bl));
        }
        return bl;
    }

    public static Vector getAddRemoveServerNames(String string, String string2, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAddRemoveServerNames");
        }
        if (AppUtils.isEmpty(string)) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getAddRemoveServerNames", "Empty name list.");
            }
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        boolean bl2 = ConfigRepoHelper.parseServersString(string, vector, vector2);
        Iterator iterator = vector2.iterator();
        Vector<String> vector3 = new Vector<String>();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!vector.contains(string3)) continue;
            vector.remove(string3);
            vector3.add(string3);
        }
        for (int i = 0; i < vector3.size(); ++i) {
            vector2.remove(vector3.elementAt(i));
        }
        Vector<Serializable> vector4 = new Vector<Serializable>();
        Vector vector5 = ConfigRepoHelper.getServerNames(vector, string2, bl, repositoryContext, workSpace);
        Vector vector6 = ConfigRepoHelper.getServerNames(vector2, string2, bl, repositoryContext, workSpace);
        vector4.add(0, vector5);
        vector4.add(1, vector6);
        vector4.add(2, new Boolean(bl2));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAddRemoveServerNames", new Object[]{"addNames=" + vector5, "remNames=" + vector6, "replacement=" + bl2});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAddRemoveServerNames", vector4);
        }
        return vector4;
    }

    public static Vector getServerNames(Vector vector, String string, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        RepositoryContext repositoryContext2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerNames", new Object[]{"names=" + vector, "unique=" + string, "returnConfig=" + bl, "cellContext=" + repositoryContext, "ws=" + workSpace});
        }
        Vector<Object> vector2 = new Vector<Object>();
        if (vector == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerNames", "Null input names vector.");
            }
            return vector2;
        }
        Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object object3;
            String string2 = ((String)iterator.next()).trim();
            if (AppUtils.isEmpty(string2)) continue;
            object2 = null;
            try {
                object2 = new ObjectName(string2);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                object = new AdminException(malformedObjectNameException, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{string2}));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerNames", object);
                }
                throw object;
            }
            repositoryContext2 = null;
            object = ((ObjectName)object2).getKeyProperty("cluster");
            if (!AppUtils.isEmpty((String)object)) {
                repositoryContext2 = AppUtils.findContext("clusters", (String)(object = ((String)object).trim()), null, repositoryContext, workSpace, true);
                if (repositoryContext2 == null) {
                    object3 = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5022E", new Object[]{object, string}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getServerNames", object3);
                    }
                    throw object3;
                }
            } else {
                object3 = ((ObjectName)object2).getKeyProperty("server");
                if (AppUtils.isEmpty((String)object3)) {
                    object3 = ((ObjectName)object2).getKeyProperty("process");
                }
                String string3 = ((ObjectName)object2).getKeyProperty("node");
                if (AppUtils.isEmpty((String)object3)) {
                    AdminException adminException = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{string2, string}));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getServerNames", adminException);
                    }
                    throw adminException;
                }
                object3 = ((String)object3).trim();
                repositoryContext2 = AppUtils.getContextFromArray(objectArray, (String)object3, string3, false);
            }
            if (repositoryContext2 == null) {
                object3 = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{string2, string}));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerNames", object3);
                }
                throw object3;
            }
            object3 = ((ObjectName)object2).getKeyProperty("config");
            if (object3 == null) {
                object3 = "";
            }
            if (!vector2.contains(repositoryContext2)) {
                vector2.addElement(repositoryContext2);
                if (!bl) continue;
                vector2.addElement(object3);
                continue;
            }
            Tr.warning(tc, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5032W", new Object[]{repositoryContext2.getName(), vector, string2}));
        }
        for (int i = 0; i < vector2.size(); i += 2) {
            object2 = (RepositoryContext)vector2.elementAt(i);
            if (AppUtils.isCluster((RepositoryContext)object2) || (repositoryContext2 = AppUtils.getClusterFromMember((RepositoryContext)object2, workSpace)) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target has member: " + object2 + " which belongs to " + repositoryContext2);
            }
            if (vector2.contains(repositoryContext2)) continue;
            object = new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5033E", new Object[]{object2.getName(), repositoryContext2.getName(), string}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerNames", object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerNames", vector2);
        }
        return vector2;
    }

    public static String getModuleType(Object object) {
        if (object instanceof ModuleRef) {
            ModuleRef moduleRef = (ModuleRef)object;
            if (moduleRef.isEJB()) {
                return "moduletype.ejb";
            }
            if (moduleRef.isWeb()) {
                return "moduletype.web";
            }
            if (moduleRef.isConnector()) {
                return "moduletype.connector";
            }
        } else if (object instanceof ModuleFile) {
            ModuleFile moduleFile = (ModuleFile)object;
            if (moduleFile.isEJBJarFile()) {
                return "moduletype.ejb";
            }
            if (moduleFile.isWARFile()) {
                return "moduletype.web";
            }
            if (moduleFile.isRARFile()) {
                return "moduletype.connector";
            }
        }
        return "moduletype.unknown";
    }

    public static boolean isDeployable(Object object) {
        if (object instanceof ModuleRef) {
            ModuleRef moduleRef = (ModuleRef)object;
            return moduleRef.isEJB() || moduleRef.isWeb() || moduleRef.isConnector();
        }
        if (object instanceof ModuleFile) {
            ModuleFile moduleFile = (ModuleFile)object;
            return moduleFile.isEJBJarFile() || moduleFile.isWARFile() || moduleFile.isRARFile();
        }
        return false;
    }

    public static String find_index(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        String string3 = string;
        while (string2 != null) {
            int n = string3.lastIndexOf("-");
            if (n == -1) {
                string3 = string + "-" + Integer.toString(1);
            } else {
                String string4 = string3.substring(n + 1);
                try {
                    int n2 = Integer.valueOf(string4);
                    string3 = string.substring(0, n) + "-" + Integer.toString(++n2);
                }
                catch (NumberFormatException numberFormatException) {
                    string3 = string + "-" + Integer.toString(999);
                }
            }
            string2 = (String)hashtable.get(string3);
        }
        return string3;
    }

    public static ObjectName getObjectName(RepositoryContext repositoryContext) throws MalformedObjectNameException {
        if (AppUtils.isServer(repositoryContext)) {
            return new ObjectName("WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName());
        }
        return new ObjectName("WebSphere:cell=" + repositoryContext.getParent().getName() + ",cluster=" + repositoryContext.getName());
    }

    public static List getServerNameForServerEntries(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerNameForServerEntries", "serverEntries=" + list);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)list.get(i);
            String string = serverEntry.getServerName();
            arrayList.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerNameForServerEntries", arrayList);
        }
        return arrayList;
    }

    public static ServerEntry createServerEntry(ServerIndex serverIndex, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerEntry", new Object[]{"si=" + serverIndex, "serverName=" + string});
        }
        ServerindexFactory serverindexFactory = null;
        ServerEntry serverEntry = null;
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        serverindexFactory = serverindexPackage.getServerindexFactory();
        serverEntry = serverindexFactory.createServerEntry();
        serverEntry.setServerName(string);
        serverEntry.setServerType("APPLICATION_SERVER");
        serverEntry.setServerDisplayName(string);
        serverIndex.getServerEntries().add((Object)serverEntry);
        serverEntry.eResource().save(new HashMap());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerEntry", serverEntry);
        }
        return serverEntry;
    }

    public static ServerIndex getReferenceToSystemAppsXML(WorkSpace workSpace, Hashtable hashtable) throws WorkSpaceException, IOException {
        ServerIndex serverIndex;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReferenceToSystemAppsXML", new Object[]{"ws=" + workSpace, "props=" + hashtable});
        }
        String string = (String)hashtable.get("cell.name");
        String string2 = (String)hashtable.get("node.name");
        WorkSpace workSpace2 = workSpace;
        String string3 = "/cells/" + string + "/nodes/" + string2 + "/" + "systemapps.xml";
        File file = new File(workSpace2.getPath() + string3);
        String string4 = System.getProperty("was.repository.root");
        File file2 = new File(string4 + string3);
        AppUtils.dbg(tc, "xxx systemappsXMLPath = " + file);
        AppUtils.dbg(tc, "xxx systemappsXMLPathConfig  = " + file2);
        if (file.exists() || file2.exists()) {
            RepositoryContext repositoryContext = workSpace2.findContext("cells/" + string + "/nodes/" + string2);
            repositoryContext.extract("systemapps.xml", false);
            Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)"systemapps.xml"));
            resource.load(new HashMap());
            serverIndex = (ServerIndex)resource.getContents().get(0);
        } else {
            RepositoryContext repositoryContext = workSpace2.findContext("cells/" + string + "/nodes/" + string2);
            serverIndex = ConfigRepoHelper.createSystemAppsXML(repositoryContext, workSpace2, hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReferenceToSystemAppsXML", serverIndex);
        }
        return serverIndex;
    }

    public static ServerIndex createSystemAppsXML(RepositoryContext repositoryContext, WorkSpace workSpace, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSystemAppsXML", new Object[]{"nodeContext=" + repositoryContext, "props=" + hashtable});
        }
        ServerindexFactory serverindexFactory = null;
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        serverindexFactory = serverindexPackage.getServerindexFactory();
        ServerIndex serverIndex = serverindexFactory.createServerIndex();
        String string = (String)hashtable.get("host.name");
        serverIndex.setHostName(string);
        String string2 = ConfigRepoHelper.makeTemporary((EObject)serverIndex);
        ServerIndex serverIndex2 = (ServerIndex)ConfigRepoHelper.getTemporaryObject(string2);
        String string3 = ConfigRepoHelper.createFileInWorkSpace(workSpace, repositoryContext.getURI(), "systemapps.xml", (EObject)serverIndex2, "systemapps.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSystemAppsXML");
        }
        return serverIndex2;
    }

    private static String createFileInWorkSpace(WorkSpace workSpace, String string, String string2, EObject eObject, String string3) {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFileInWorkSpace", new Object[]{"workSpace=" + workSpace, "contextId=" + string, "resourceUri=" + string2, "eObject=" + eObject, "fileName=" + string3});
        }
        RepositoryContext repositoryContext = null;
        Resource resource = null;
        String string4 = null;
        String string5 = ConfigRepoHelper.decodeContextUri(string);
        AppUtils.dbg(tc, "contextURI = " + string5);
        try {
            repositoryContext = workSpace.findContext(string5);
            AppUtils.dbg(tc, "context = " + repositoryContext);
        }
        catch (WorkSpaceException workSpaceException) {
            Tr.error(tc, "Error in finding context " + workSpaceException.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createFileInWorkSpace", null);
            }
            return null;
        }
        ResourceSet resourceSet = repositoryContext.getResourceSet();
        AppUtils.dbg(tc, "resourceSet = " + resourceSet);
        URI uRI = URI.createURI((String)string3);
        AppUtils.dbg(tc, "resourceSet.getResource " + resourceSet.getResource(uRI, false));
        if (!repositoryContext.isAvailable(string3) || resourceSet.getResource(uRI, false) == null) {
            Tr.warning(tc, "File " + string3 + " was not available in context, " + repositoryContext.getURI());
            eList = workSpace.getResourceFactoryRegistry().getFactory(URI.createURI((String)string3));
            resource = eList.createResource(URI.createURI((String)string3));
            resourceSet.getResources().add((Object)resource);
            AppUtils.dbg(tc, "resource = " + resource);
        }
        if (eObject.eResource() != null) {
            ((XMIResource)eObject.eResource()).setID(eObject, null);
        }
        eList = resource.getContents();
        eList.add(eObject);
        try {
            resource.save(new HashMap());
            string4 = ((XMIResource)eObject.eResource()).getID(eObject);
        }
        catch (Exception exception) {
            Tr.error(tc, "Error in saving resource for root object " + exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFileInWorkSpace", string4);
        }
        return string4;
    }

    private static String decodeContextUri(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        string2 = string.replace(':', '/');
        return string2;
    }

    private static String makeTemporary(EObject eObject) {
        String string = RefObjectHelperFactory.getRefObjectHelper().makeTemporary(eObject);
        return string;
    }

    private static EObject getTemporaryObject(String string) {
        EObject eObject = RefObjectHelperFactory.getRefObjectHelper().getTemporaryObject(string);
        return eObject;
    }

    private static boolean isND(WorkSpace workSpace) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isND", new Object[]{"workspace=" + workSpace});
        }
        boolean bl = false;
        try {
            RepositoryContext repositoryContext = ConfigRepoHelper.findCellContext(workSpace);
            Resource resource = ConfigArchiveUtils.getResource(repositoryContext, "cell.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource for cell.xml: " + resource);
            }
            Cell cell = (Cell)resource.getContents().get(0);
            String string = cell.getCellType().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellType: " + string);
            }
            bl = string.equalsIgnoreCase("DISTRIBUTED");
        }
        catch (AdminException adminException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isND", "Rethrowing exception: " + adminException);
            }
            throw adminException;
        }
        catch (Throwable throwable) {
            AdminException adminException = new AdminException(throwable, "Error reading cell.xml");
            FFDCFilter.processException(adminException, CLASS_NAME + ".isND", "1752");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isND", adminException);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isND", Boolean.toString(bl));
        }
        return bl;
    }

    private static RepositoryContext findCellContext(WorkSpace workSpace) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findCellContext", "workspace=" + workSpace);
        }
        RepositoryContext repositoryContext = null;
        try {
            RepositoryContextType repositoryContextType = ConfigRepoHelper.getContextType("cells");
            repositoryContext = (RepositoryContext)workSpace.findContext(repositoryContextType).toArray()[0];
        }
        catch (AdminException adminException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findCellContext", "Rethrowing exception: " + adminException);
            }
            throw adminException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASS_NAME + ".findCellContext", "1786");
            AdminException adminException = new AdminException(exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findCellContext", adminException);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findCellContext", repositoryContext);
        }
        return repositoryContext;
    }

    private static RepositoryContextType getContextType(String string) throws AdminException {
        RepositoryContextType repositoryContextType;
        try {
            repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType(string);
        }
        catch (Exception exception) {
            AdminException adminException = new AdminException(exception);
            FFDCFilter.processException(adminException, CLASS_NAME + ".getContextType", "1818");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getContextType", adminException);
            }
            throw adminException;
        }
        return repositoryContextType;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/ConfigRepoHelper.java, WAS.admin.appmgmt.server, WAS61.SERV1, cf311012.09, ver. 1.107.1.3");
        }
        workSpaceIdLock = new Object();
        workSpaceIdCounter = 0;
    }
}

