/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DeltaFile;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeltaDataTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(DeltaDataTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private DeltaFile _deltaFile;
    private RepositoryContext _appC;
    public static final String DelFiles = "DeltaDataTask.DelFiles";
    public static final String AddFiles = "DeltaDataTask.AddFiles";
    public static final String UpdateFiles = "DeltaDataTask.UpdateFiles";
    public static final String FULLUPDATE_PROP = "com.ibm.websphere.management.application.fullupdate";

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            Object object;
            this._appC = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            String string = EditionHelper.getCompositeName(this.scheduler.getAppName(), this.scheduler.getProperties());
            String string2 = "deltas/" + string;
            this._deltaFile = new DeltaFile(this._appC.getParent().getPath() + "/" + string2);
            Element element = this._deltaFile.createElement("change_input");
            this._deltaFile.appendChild(element);
            if (this.scheduler instanceof InstallScheduler) {
                element.setAttribute("contenttype", "app");
                object = this._appC.getParent().getName();
                if (EditionHelper.isEditionSupportEnabled()) {
                    object = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
                }
                element.setAttribute("contenturi", this._appC.getParent().getName());
                element.setAttribute("changetype", "install");
            } else if (this.scheduler instanceof EditScheduler) {
                element.setAttribute("contenttype", "app");
                object = this._appC.getParent().getName();
                if (EditionHelper.isEditionSupportEnabled()) {
                    object = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
                }
                element.setAttribute("contenturi", this._appC.getParent().getName());
                element.setAttribute("changetype", "edit");
                String string3 = ((EditScheduler)this.scheduler).getEarFile().getURI();
                if (string3.replace('\\', '/').endsWith("deployments/" + this.scheduler.getAppName())) {
                    element.setAttribute("useMetaDataFromBinary", "false");
                } else {
                    element.setAttribute("useMetaDataFromBinary", "true");
                }
            } else if (this.scheduler instanceof UpdateScheduler) {
                object = string.replace(' ', '_');
                if ("true".equalsIgnoreCase((String)this.scheduler.getProperties().get(FULLUPDATE_PROP)) || Boolean.getBoolean(FULLUPDATE_PROP) || Boolean.getBoolean("com.ibm.websphere.management.application.fullupdate." + (String)object)) {
                    this.handleAsFullUpdate(element, string2);
                } else {
                    this.handleFGUpdate(element);
                }
            }
            this._deltaFile.writeToDisk();
            this._appC.getParent().notifyChanged(0, string2 + "/" + this._deltaFile.getFileName());
            object = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            this.scheduler.propagateTaskEvent((AppNotification)object);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.DeltaDataTask.performTask", "124", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
        }
        finally {
            this.scheduler.getProperties().remove(DelFiles);
            this.scheduler.getProperties().remove(AddFiles);
        }
    }

    private void handleAsFullUpdate(Element element, String string) throws Exception {
        String string2;
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleAsFullUpdate - " + string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Set set = this._appC.getParent().getFiles();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file = " + (String)object);
            }
            if (!((String)object).startsWith(string)) continue;
            arrayList.add(object);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleting file = " + string2);
            }
            this._appC.getParent().delete(string2);
        }
        element.setAttribute("contenttype", "app");
        string2 = this._appC.getParent().getName();
        if (EditionHelper.isEditionSupportEnabled()) {
            string2 = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
        }
        element.setAttribute("contenturi", string2);
        element.setAttribute("changetype", "install");
    }

    private void handleFGUpdate(Element element) throws Exception {
        Object object;
        int n;
        Object object2;
        String string;
        UpdateScheduler updateScheduler = (UpdateScheduler)this.scheduler;
        String string2 = null;
        element.setAttribute("changetype", "fg-update");
        element.setAttribute("contenttype", updateScheduler.getContentType());
        if (!AppUtils.isEmpty(updateScheduler.getOperation())) {
            element.setAttribute("operation", updateScheduler.getOperation());
        }
        if (!AppUtils.isEmpty(updateScheduler.getContentURI())) {
            element.setAttribute("contenturi", updateScheduler.getContentURI());
        }
        if ("modulefile".equals(updateScheduler.getContentType()) && "delete".equals(updateScheduler.getOperation())) {
            element.setAttribute("moduletype", (String)this.scheduler.getProperties().get("moduletype"));
        }
        if ((string = (String)this.scheduler.getProperties().get("update.recycle")) != null) {
            if (string.equals("update.recycle.modules") && this.scheduler.getProperties().get("update.recycle.modules") == null) {
                object2 = this.createNotification("InProgress", "ADMA5063W", new String[]{"update.recycle.modules"});
                this.scheduler.propagateTaskEvent((AppNotification)object2);
            } else {
                element.setAttribute("update.recycle", string);
                if (this.scheduler.getProperties().get("update.recycle.modules") != null) {
                    element.setAttribute("update.recycle.modules", (String)this.scheduler.getProperties().get("update.recycle.modules"));
                }
            }
        }
        object2 = this._deltaFile.createElement("files");
        this._deltaFile.appendChild((Element)object2);
        List list = this.getFileList("delete", DelFiles);
        List list2 = this.getFileList("add", AddFiles);
        List list3 = this.getFileList("update", UpdateFiles);
        List list4 = ((UpdateSchedulerImpl)updateScheduler).getDeltaContents();
        for (n = 0; n < list4.size(); n += 2) {
            string2 = (String)list4.get(n);
            object = (String)list4.get(n + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "delta contents: " + string2 + ", " + (String)object);
            }
            if ("add".equals(object)) {
                list2.add(string2);
                continue;
            }
            if ("delete".equals(object)) {
                list.add(string2);
                continue;
            }
            if ("update".equals(object)) {
                list3.add(string2);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Unexpected behavior: " + string2 + ", " + (String)object);
        }
        for (n = 0; n < list.size(); ++n) {
            string2 = (String)list.get(n);
            object = this._deltaFile.createElement("file");
            object.setAttribute("uri", string2);
            object.setAttribute("operation", "delete");
            object2.appendChild((Node)object);
        }
        for (n = 0; n < list2.size(); ++n) {
            string2 = (String)list2.get(n);
            object = this._deltaFile.createElement("file");
            object.setAttribute("uri", string2);
            object.setAttribute("operation", "add");
            object2.appendChild((Node)object);
        }
        for (n = 0; n < list3.size(); ++n) {
            string2 = (String)list3.get(n);
            object = this._deltaFile.createElement("file");
            object.setAttribute("uri", string2);
            object.setAttribute("operation", "update");
            object2.appendChild((Node)object);
        }
    }

    private List getFileList(String string, String string2) {
        Hashtable hashtable;
        ArrayList<String> arrayList = (ArrayList<String>)this.scheduler.getProperties().get(string2);
        if (arrayList == null && (hashtable = (Hashtable)this.scheduler.getProperties().get("contenturi_table")) != null) {
            arrayList = (List)hashtable.get(string);
        }
        if (arrayList == null) {
            hashtable = this.scheduler.getProperties().get(string);
            if (hashtable instanceof List) {
                arrayList = (List)((Object)hashtable);
            } else if (hashtable instanceof String) {
                String[] stringArray = ((String)((Object)hashtable)).split("\\+");
                arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
            }
        }
        if (arrayList == null) {
            return new ArrayList();
        }
        return arrayList;
    }
}

