/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DistributionStatusSchedulerImpl;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.transform.RepositoryAdapter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DistributionStatusTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(DistributionStatusTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String OPNAME = "_getAppDistributionStatus";
    private static final String CLASS_NAME = DistributionStatusTask.class.getName();
    private static final String SERVER_INDEX = "serverindex.xml";
    private Map _serverIndexObjs;

    public DistributionStatusTask() {
        this.appTaskName = "AppDistribution";
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean bl = true;
        Hashtable hashtable = J2CAppUtils.getAppDocuments(this.scheduler.getAppName());
        if (hashtable == null || hashtable.size() == 0) {
            throw new AdminException("Error getting application documents from master repository.  The application may not be in the repository.");
        }
        List list = ((DistributionStatusSchedulerImpl)this.scheduler).get_nodes();
        Set set = this.getNodesToSkip();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Inside the performTask for node=" + string);
            }
            boolean bl2 = set.contains(string);
            String string2 = this.handleNode(string, hashtable, bl2);
            String string3 = ((DistributionStatusSchedulerImpl)this.scheduler).addCompStatus(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "distStatus=" + string2 + " compositeStatus=" + string3);
            }
            Properties properties = new Properties();
            properties.put("AppDistributionNode", string2);
            properties.put("AppDistributionAll", string3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " nprops=" + properties);
            }
            AppNotification appNotification = this.createTranslatedNotification("InProgress", string2, null);
            appNotification.setProperties(properties);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " PROPOGATING TASK .." + appNotification.toString());
            }
            this.scheduler.propagateTaskEvent(appNotification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(bl));
        }
        return bl;
    }

    private String handleNode(String string, Hashtable hashtable, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNode=", new String[]{"node=" + string, "uris=" + hashtable, "skipNode=" + bl});
        }
        String string2 = null;
        try {
            string2 = this.scheduler.getCellContext().getName();
            String string3 = this.scheduler.getAppName();
            if (bl) {
                String string4 = this.getStr(string2, string, "true", "skipped");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "handleNode", "Skipping node " + string + " because application " + string3 + " targets only a webserver on this node.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handlNode", string4);
                }
                return string4;
            }
            ObjectName objectName = new ObjectName("WebSphere:type=AdminOperations,node=" + string + ",process=" + (AdminServiceFactory.getAdminService().getNodeName().equals(string) ? AdminServiceFactory.getAdminService().getProcessName() : "nodeagent") + ",*");
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            if (set == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNode: set is null");
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            Iterator iterator = set.iterator();
            if (!iterator.hasNext()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "No MBean on the node");
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            objectName = (ObjectName)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "on = " + objectName);
            }
            if (!this.checkForOp(objectName)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Back level MBean on " + string);
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            Hashtable hashtable2 = (Hashtable)AdminServiceFactory.getAdminService().invoke(objectName, OPNAME, new Object[]{string3, new Hashtable()}, new String[]{String.class.getName(), Hashtable.class.getName()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tbl = " + hashtable2);
            }
            if (hashtable2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Table returned from node is null " + string);
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            Object object = hashtable2.get(string3);
            if (object != null) {
                object = object instanceof Boolean ? ((object = ((Boolean)object).toString()).equals("true") ? "0" : "-1") : (String)object;
            }
            if (object == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file status returned from node is null " + string);
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            if (object.equals("0")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file still exists " + string);
                }
                return this.getStr(string2, string, "false", "inprogress");
            }
            if (!object.equals("-1")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file contains error " + object + " on " + string);
                }
                return this.getStr(string2, string, "false", "error");
            }
            Hashtable hashtable3 = (Hashtable)hashtable2.get("uri");
            if (hashtable3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "URI Table returned from node is null " + string);
                }
                return this.getStr(string2, string, "unknown", "notprocessing");
            }
            if (hashtable.size() != hashtable3.size()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "URI Tables of different size for " + string + ", " + hashtable.size() + ", " + hashtable3.size());
                }
                return this.getStr(string2, string, "false", "notprocessing");
            }
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            RepositoryAdapter repositoryAdapter = RepositoryAdapter.getRepositoryAdapter(configRepository, string);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                DocumentDigest documentDigest;
                String string5 = (String)enumeration.nextElement();
                if (!hashtable3.containsKey(string5)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "URI " + string5 + "does not exist on " + string);
                    }
                    return this.getStr(string2, string, "false", "notprocessing");
                }
                DocumentDigest documentDigest2 = repositoryAdapter.getDigest(string5);
                if (((Object)documentDigest2).equals(documentDigest = (DocumentDigest)hashtable3.get(string5))) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Digest diff for " + string5);
                }
                return this.getStr(string2, string, "false", "notprocessing");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "All fine for " + string);
            }
            return this.getStr(string2, string, "true", "notprocessing");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, CLASS_NAME + ".handleNode", "283", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exception thrown in handleNode: " + throwable);
            }
            return this.getStr(string2, string, "unknown", "unknown");
        }
    }

    private String getStr(String string, String string2, String string3, String string4) {
        return "WebSphere:cell=" + string + ",node=" + string2 + ",distribution=" + string3 + ",expansion=" + string4;
    }

    private boolean checkForOp(ObjectName objectName) throws Exception {
        MBeanInfo mBeanInfo = AdminServiceFactory.getAdminService().getMBeanInfo(objectName);
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            if (!OPNAME.equals(mBeanOperationInfoArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    private Set getNodesToSkip() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodesToSkip");
        }
        Set set = new HashSet();
        boolean bl = Boolean.getBoolean("com.ibm.websphere.management.nodesync.skipWebServerTarget");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNodesToSkip", "skipWebServerTargets=" + bl);
        }
        if (bl) {
            try {
                set = this.gatherNodesToSkip();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, CLASS_NAME + ".getNodesToSkip", "341", this);
                AdminException adminException = new AdminException(exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNodesToSkip", adminException.toString());
                }
                throw adminException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodesToSkip", set);
        }
        return set;
    }

    private Set gatherNodesToSkip() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "gatherNodesToSkip");
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
        Vector vector = new Vector();
        Vector vector2 = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, vector, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "svrs=" + vector2);
        }
        Vector vector3 = ConfigRepoHelper.getAllServers(this.scheduler.getWorkSpace(), vector2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "vAllServers=" + vector3);
        }
        int n = vector3.size();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numAllTargetedServers=" + n);
        }
        for (int i = 0; i < n; ++i) {
            RepositoryContext repositoryContext2 = (RepositoryContext)vector3.get(i);
            RepositoryContext repositoryContext3 = repositoryContext2.getParent();
            String string = repositoryContext3.getName();
            String string2 = repositoryContext2.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "gatherNodesToSkip", new String[]{"appTargetNodeName=" + string, "appTargetSrvName=" + string2});
            }
            if (hashSet2.contains(string)) continue;
            ServerIndex serverIndex = this.getServerIndex(string);
            EList eList = serverIndex.getServerEntries();
            boolean bl = this.isTargetWebServer((List)eList, string2);
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "gatherNodesToSkip", "Adding node " + string + " to the list of nodes where app targets non webservers.");
                }
                hashSet2.add(string);
                boolean bl2 = hashSet.remove(string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "gatherNodesToSkip", "removedNode=" + bl2);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "gatherNodesToSkip", "Adding node " + string + " to the list of nodes where the app targets webservers.");
            }
            hashSet.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "gatherNodesToSkip", hashSet);
        }
        return hashSet;
    }

    private boolean isTargetWebServer(List list, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetWebServer", new String[]{"serversOnNode=" + list.toString(), "appTargetServerName=" + string});
        }
        boolean bl = false;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ServerEntry serverEntry = (ServerEntry)list.get(i);
            String string2 = serverEntry.getServerName();
            String string3 = serverEntry.getServerType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isTargetWebServer", new String[]{"serverOnNodeName=" + string2, "serverOnNodeType=" + string3});
            }
            if (!string2.equals(string)) continue;
            if (!"WEB_SERVER".equals(string3)) break;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTargetWebServer", Boolean.toString(bl));
        }
        return bl;
    }

    private synchronized ServerIndex getServerIndex(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndex", "nodeName=" + string);
        }
        if (this._serverIndexObjs == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_serverIndexObjs was null");
            }
            this._serverIndexObjs = new HashMap();
        }
        ServerIndex serverIndex = null;
        if (this._serverIndexObjs.containsKey(string)) {
            serverIndex = (ServerIndex)this._serverIndexObjs.get(string);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_serverIndexObjs does not contain " + string);
            }
            RepositoryContext repositoryContext = AppUtils.findContext("nodes", string, null, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), false);
            URI uRI = URI.createURI((String)SERVER_INDEX);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerIndex", "uri=" + uRI);
            }
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            Resource resource = resourceSet.getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerIndex", "res=" + resource);
            }
            if (resource == null) {
                resource = resourceSet.createResource(uRI);
                resource.load(new HashMap());
            }
            EList eList = resource.getContents();
            serverIndex = (ServerIndex)eList.get(0);
            this._serverIndexObjs.put(string, serverIndex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndex", serverIndex);
        }
        return serverIndex;
    }
}

