/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilterImpl;

public class ExtractionTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(ExtractionTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        Hashtable hashtable = this.scheduler.getProperties();
        String string = null;
        try {
            string = AppUtils.getAppTempExtractDir(this.scheduler);
            new File(string).mkdirs();
            if (this.scheduler instanceof InstallScheduler) {
                AppUtils.dbg(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA6013I", new Object[]{string}));
                EarUtils.extractEar(((InstallScheduler)this.scheduler).getEarFile(false, true), string, true);
                ((InstallScheduler)this.scheduler).setEarPath(string);
            } else if (this.scheduler instanceof UpdateScheduler) {
                Object object;
                Object object2;
                UpdateScheduler updateScheduler = (UpdateScheduler)this.scheduler;
                boolean bl = false;
                RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
                boolean bl2 = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext).isZeroEarCopy();
                if (updateScheduler.getContentType().equals("partialapp")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expanding partial ear to: " + string);
                    }
                    this.extractZip(updateScheduler.getContentPath(), string);
                    updateScheduler.setContentPath(string);
                    if (updateScheduler.getOrigContentType().equals("modulefile") && AppUtils.isPreCompileJSPs(updateScheduler)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Expanding module " + updateScheduler.getContentURI() + " from partial ear to: " + string);
                        }
                        if (new File((String)(object2 = string + File.separator + updateScheduler.getContentURI())).exists()) {
                            object = AppInstallHelper.getArchive((String)object2, false, true, this.getResourceBundle(), false);
                            if (object.isWARFile()) {
                                object.extractNoReopen(2);
                                bl = true;
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Not a war in partial app");
                            }
                            object.close();
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ExtractionTask:Error " + (String)object2 + " does not exist");
                        }
                    }
                } else if (updateScheduler.getContentType().equals("modulefile") && !updateScheduler.getOperation().equals("delete")) {
                    string = string + "/" + updateScheduler.getContentURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copying modulefile to: " + string);
                    }
                    object2 = updateScheduler.getContentAsArchive();
                    if (AppUtils.isPreCompileJSPs(updateScheduler) && object2.isWARFile()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Expanding modulefile to: " + string);
                        }
                        object = new File(string);
                        ((File)object).mkdirs();
                        object2.extractTo(string, 2);
                        bl = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Copying modulefile to: " + string);
                        }
                        if (bl2) {
                            object = new MetadataSaveFilter(repositoryContext, (Archive)object2);
                            object2.setSaveFilter((SaveFilter)object);
                        }
                        object2.saveAsNoReopen(string);
                    }
                    updateScheduler.setContentPath(string);
                } else if (updateScheduler.getContentType().equals("file") && !updateScheduler.getOperation().equals("delete")) {
                    AppUtils.copyFile(new File(updateScheduler.getContentPath()), string + "/" + updateScheduler.getContentURI());
                    updateScheduler.setContentPath(string);
                }
                if (!bl) {
                    this.scheduler.getProperties().remove("preCompileJSPs");
                }
                if (bl2) {
                    object2 = ConfigRepoHelper.getEarFileFromDeployment(this.scheduler.getWorkSpace(), repositoryContext);
                    object = new AppSaveFiler(repositoryContext, (EARFile)object2);
                    object2.setSaveFilter((SaveFilter)object);
                    object2.saveAs(repositoryContext.getParent().getPath() + "/" + repositoryContext.getParent().getName());
                    repositoryContext.getParent().notifyChanged(0, repositoryContext.getParent().getName());
                    object2.close();
                }
            }
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5009I", new String[]{string}));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.ExtractionTask.performTask", "96", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5010E", new String[]{string, throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0064E"));
        }
    }

    public Vector extractZip(String string, String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        Vector vector = this.extractZip(fileInputStream, string2);
        fileInputStream.close();
        return vector;
    }

    private Vector extractZip(InputStream inputStream, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractZip");
        }
        FileOutputStream fileOutputStream = null;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        File file = null;
        File file2 = null;
        Vector<String> vector = new Vector<String>();
        byte[] byArray = null;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                long l = zipEntry.getTime();
                String string3 = (string + File.separator + string2).replace('/', File.separatorChar);
                file = new File(string3);
                file2 = new File(file.getParent());
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                if (!zipEntry.isDirectory()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "extracted: " + string2);
                    }
                    vector.addElement(string2);
                    fileOutputStream = new FileOutputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = bufferedInputStream.read();
                    while (n != -1) {
                        fileOutputStream.write(n);
                        byteArrayOutputStream.write(n);
                        n = bufferedInputStream.read();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (byteArrayOutputStream != null) {
                        byArray = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.close();
                    }
                }
                file.setLastModified(l);
                if (!tc.isDebugEnabled() || file.lastModified() == l) continue;
                Tr.debug(tc, "Error modifying timestamp of memberfile " + file.getName());
            }
        }
        catch (IOException iOException) {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractZip");
        }
        return vector;
    }

    private class MetadataSaveFilter
    extends SaveFilterImpl {
        RepositoryContext rc;
        List metadataToSave = new ArrayList();
        String pattern = "META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*";

        public MetadataSaveFilter(RepositoryContext repositoryContext, Archive archive) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "MetadataSaveFilter");
            }
            EList eList = archive.getFiles();
            for (int i = 0; i < eList.size(); ++i) {
                org.eclipse.jst.j2ee.commonarchivecore.internal.File file = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)eList.get(i);
                if (file instanceof Container || file.isSetDirectoryEntry() && file.isDirectoryEntry()) continue;
                String string = file.getURI();
                if (!(string = string.replace('\\', '/')).matches(this.pattern)) continue;
                this.metadataToSave.add(string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "to save " + string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MetadataSaveFilter");
            }
        }

        public boolean shouldSave(String string, Archive archive) {
            boolean bl = false;
            if (this.metadataToSave.contains(string)) {
                bl = true;
            }
            return bl;
        }
    }

    private class AppSaveFiler
    extends SaveFilterImpl {
        RepositoryContext appc;
        List l = new ArrayList();

        public AppSaveFiler(RepositoryContext repositoryContext, EARFile eARFile) {
            this.appc = repositoryContext;
            EList eList = eARFile.getModuleRefs();
            for (int i = 0; i < eList.size(); ++i) {
                this.l.add(((ModuleRef)eList.get(i)).getUri());
            }
        }

        public boolean shouldSave(String string, Archive archive) {
            boolean bl;
            boolean bl2 = bl = this.l.contains(string) || this.appc.isAvailable(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri = " + string + " res = " + bl);
            }
            return bl;
        }
    }
}

