/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.NestedArchiveIterator;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class MetadataTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(MetadataTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String METADATA_PATTERN = "META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*";
    public static final String THISDIR_PATTERN = "/[^/]*";
    public static final String WHOLEDIR_PATTERN = "/.*";
    public static final String DelModules = "MetadataTask.deletedMods";
    public static final String AddedModules = "MetadataTask.addedMods";

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        EARFile eARFile = null;
        try {
            Object object;
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (this.scheduler instanceof InstallScheduler) {
                object = MetadataTask.saveEarConfigDocs(repositoryContext.getPath(), ((InstallScheduler)this.scheduler).getEarFile(false, true), this.getResourceBundle());
                repositoryContext.notifyChanged(0, (List)object);
            } else if (this.scheduler instanceof UpdateScheduler) {
                eARFile = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, this.scheduler.getWorkSpace(), this.getResourceBundle(), true);
                this.updateDeploymentFromPartialEar(repositoryContext, eARFile);
                if (ConfigRepoHelper.getAppDeploymentForApp(repositoryContext).isZeroEarCopy()) {
                    repositoryContext.getParent().notifyChanged(2, repositoryContext.getParent().getName());
                }
            }
            object = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            this.scheduler.propagateTaskEvent((AppNotification)object);
            if (repositoryContext.isAvailable("META-INF/ibm-application-ha.props")) {
                AppUtils.dbg(tc, "ttt hidden app flag found from MetadataTask");
                object = this.createNotification("Completed", "ADMA5110I", new String[]{this.scheduler.getAppName()});
                this.scheduler.propagateTaskEvent((AppNotification)object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.ConfigureTask.performTask", "134", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
        }
        finally {
            if (eARFile != null) {
                eARFile.close();
            }
            this.scheduler.getProperties().remove(DelModules);
            this.scheduler.getProperties().remove(AddedModules);
        }
    }

    private void updateDeploymentFromPartialEar(RepositoryContext repositoryContext, EARFile eARFile) throws Exception {
        int n;
        Object object;
        String string;
        String string2;
        Object object2;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentFromPartialEar");
        }
        repositoryContext.extract(false);
        String string3 = repositoryContext.getPath() + "/";
        UpdateScheduler updateScheduler = (UpdateScheduler)this.scheduler;
        String string4 = AppUtils.getAppTempExtractDir(updateScheduler);
        List list = (List)this.scheduler.getProperties().get("DeltaDataTask.DelFiles");
        List list2 = (List)this.scheduler.getProperties().get(DelModules);
        List list3 = (List)this.scheduler.getProperties().get(AddedModules);
        AppUtils.dbg(tc, "delFiles: " + list);
        AppUtils.dbg(tc, "delM: " + list2);
        AppUtils.dbg(tc, "addM: " + list3);
        Object object3 = "";
        for (n2 = 0; n2 < list.size(); ++n2) {
            object3 = ((String)object3).equals("") ? (String)list.get(n2) : (String)object3 + "|" + list.get(n2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pattern for remove loose: " + (String)object3);
        }
        if (list2 != null) {
            for (n2 = 0; n2 < list2.size(); n2 += 2) {
                object2 = (String)list2.get(n2);
                string2 = (String)list2.get(n2 + 1);
                if (!this.hasModule(eARFile, (String)object2)) {
                    object2 = (String)object2 + WHOLEDIR_PATTERN;
                    Object object4 = object3 = ((String)object3).equals("") ? object2 : (String)object3 + "|" + (String)object2;
                }
                if (AppUtils.isEmpty(string2)) continue;
                object3 = ((String)object3).equals("") ? string2 : (String)object3 + "|" + string2;
                object3 = (String)object3 + "|ALT-INF/" + list2.get(n2) + WHOLEDIR_PATTERN;
            }
        }
        AppUtils.dbg(tc, "Pattern for remove loose and mod: " + (String)object3);
        if (!AppUtils.isEmpty((String)object3)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object2 = repositoryContext.getFiles().iterator();
            while (object2.hasNext()) {
                string2 = (String)object2.next();
                if (!string2.matches((String)object3)) continue;
                arrayList.add(string2);
            }
            AppUtils.dbg(tc, "Delete files: " + arrayList);
            if (arrayList.size() > 0) {
                repositoryContext.notifyChanged(2, arrayList);
            }
        }
        String string5 = METADATA_PATTERN;
        object2 = eARFile.getModuleRefs();
        for (int i = 0; i < object2.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)object2.get(i);
            if (moduleRef.getAltDeploymentDescriptor() == null) continue;
            string = moduleRef.getAltDeploymentDescriptor().eResource().getURI().toString();
            object = moduleRef.getAltRoot();
            string5 = string5 + "|" + string + "|" + (String)object + WHOLEDIR_PATTERN;
        }
        AppUtils.dbg(tc, "Loose add pattern: " + string5);
        EList eList = eARFile.getFiles();
        for (n = 0; n < eList.size(); ++n) {
            string = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)eList.get(n);
            if (!string.getURI().matches(string5) || repositoryContext.isAvailable(string.getURI()) && !new File(string4 + "/" + string.getURI()).exists()) continue;
            object = repositoryContext.getPath() + "/" + string.getURI();
            AppUtils.dbg(tc, "root file to be copied: " + string.getURI() + " to " + (String)object);
            AppUtils.copyFile(eARFile.getInputStream(string.getURI()), (String)object);
            if (repositoryContext.isAvailable(string.getURI())) {
                repositoryContext.notifyChanged(1, string.getURI());
                continue;
            }
            repositoryContext.notifyChanged(0, string.getURI());
        }
        object2 = eARFile.getModuleRefs();
        for (n = 0; n < object2.size(); ++n) {
            Object object5;
            List<String> list4;
            boolean bl;
            string = (ModuleRef)object2.get(n);
            object = new File(string4 + "/" + string.getUri());
            boolean bl2 = list3 != null && list3.contains(string.getUri()) || ((File)object).exists() && ((File)object).isFile();
            boolean bl3 = bl = ((File)object).exists() && ((File)object).isDirectory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mUri: " + string.getUri() + ", " + bl2 + "," + bl);
            }
            if (bl2) {
                Object object6;
                list4 = new ArrayList();
                String string6 = string.getUri() + WHOLEDIR_PATTERN;
                object5 = repositoryContext.getFiles().iterator();
                while (object5.hasNext()) {
                    object6 = (String)object5.next();
                    if (!((String)object6).matches(string6)) continue;
                    list4.add((String)object6);
                }
                AppUtils.dbg(tc, "del files for full module add/update: " + list4);
                repositoryContext.notifyChanged(2, list4);
                object6 = new ArrayList();
                MetadataTask.saveArchiveConfigDocs((Archive)string.getModuleFile(), METADATA_PATTERN, string3, string.getUri(), (List)object6, this.getResourceBundle());
                repositoryContext.notifyChanged(0, (List)object6);
                AppUtils.dbg(tc, "add files for full module add/update: " + object6);
            }
            if (!bl) continue;
            list4 = AppUtils.getURIs(string4 + "/" + string.getUri());
            for (int i = 0; i < list4.size(); ++i) {
                object5 = (String)list4.get(i);
                if (((String)object5).equals("META-INF/ibm-partialapp-delete.props") || !((String)object5).matches(METADATA_PATTERN)) continue;
                object5 = string.getUri() + "/" + (String)object5;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loose metadata file: " + (String)object5);
                }
                AppUtils.dbg(tc, "Loose metadata file: " + (String)object5);
                AppUtils.copyFile(new File(string4 + "/" + (String)object5), string3 + (String)object5);
                if (repositoryContext.isAvailable((String)object5)) {
                    repositoryContext.notifyChanged(1, (String)object5);
                    continue;
                }
                repositoryContext.notifyChanged(0, (String)object5);
            }
        }
        if (updateScheduler.getContentType().equals("modulefile") && (n = (int)(this.updateAppDDInDeployment(eARFile, list2, list3, repositoryContext) ? 1 : 0)) != 0) {
            repositoryContext.notifyChanged(1, "META-INF/application.xml");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentFromPartialEar");
        }
    }

    private boolean hasModule(EARFile eARFile, String string) {
        EList eList = eARFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            if (!((ModuleRef)eList.get(i)).getUri().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean updateAppDDInDeployment(EARFile eARFile, List list, List list2, RepositoryContext repositoryContext) throws Exception {
        EARFile eARFile2 = null;
        boolean bl = false;
        try {
            Module module;
            String string;
            String string2;
            int n;
            EList eList;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifying app DD for module type");
            }
            eARFile2 = ConfigRepoHelper.getEarFileFromDeployment(this.scheduler.getWorkSpace(), repositoryContext);
            if (list != null) {
                eList = new ArrayList();
                for (n = 0; n < list.size(); n += 2) {
                    string2 = (String)list.get(n);
                    string = (String)list.get(n + 1);
                    if (string.equals("")) {
                        string = null;
                    }
                    module = eARFile2.getModule(string2, string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "delMod: " + module);
                    }
                    if (module == null) {
                        throw new AdminException("Internal error in module del: no module with " + string2 + ":" + string);
                    }
                    eList.add(module);
                }
                for (n = 0; n < eList.size(); ++n) {
                    eARFile2.getDeploymentDescriptor().getModules().remove(eList.get(n));
                    bl = true;
                }
            }
            if (list2 != null) {
                for (int i = 0; i < list2.size(); i += 2) {
                    String string3 = (String)list2.get(i);
                    string2 = (String)list2.get(i + 1);
                    if (string2.equals("")) {
                        string2 = null;
                    }
                    if ((string = eARFile.getModule(string3, string2)) != null) {
                        module = (Module)EtoolsCopyUtility.createCopy((EObject)string);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "newMod: " + module);
                        }
                    } else {
                        throw new AdminException("Internal error in module add: no module with " + string3 + ":" + string2);
                    }
                    eARFile2.getDeploymentDescriptor().getModules().add((Object)module);
                    bl = true;
                }
            }
            eList = eARFile.getDeploymentDescriptor().getSecurityRoles();
            for (n = 0; n < eList.size(); ++n) {
                string2 = (SecurityRole)eList.get(n);
                if (eARFile2.getDeploymentDescriptor().getSecurityRoleNamed(string2.getRoleName()) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new role to be added: " + string2.getRoleName());
                    }
                    string = (SecurityRole)EtoolsCopyUtility.createCopy((EObject)string2);
                    eARFile2.getDeploymentDescriptor().getSecurityRoles().add((Object)string);
                    bl = true;
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "role unchanged: " + string2.getRoleName());
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Saving app DD");
                }
                FileOutputStream fileOutputStream = new FileOutputStream(repositoryContext.getPath() + "/META-INF/application.xml");
                eARFile2.getDeploymentDescriptor().eResource().save((OutputStream)fileOutputStream, new HashMap());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, null);
        }
        finally {
            if (eARFile2 != null) {
                eARFile2.close();
            }
        }
        return bl;
    }

    public static List saveEarConfigDocs(String string, EARFile eARFile, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveEarConfigDocs");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = string;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        MetadataTask.saveArchiveConfigDocs((Archive)eARFile, METADATA_PATTERN, string2, null, linkedList, resourceBundle);
        EList eList = eARFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleRef moduleRef = (ModuleRef)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving docs for: " + moduleRef.getUri());
            }
            MetadataTask.saveArchiveConfigDocs((Archive)moduleRef.getModuleFile(), METADATA_PATTERN, string2, moduleRef.getUri(), linkedList, resourceBundle);
            if (moduleRef.getAltDeploymentDescriptor() == null) continue;
            String string3 = moduleRef.getAltDeploymentDescriptor().eResource().getURI().toString();
            InputStream inputStream = eARFile.getInputStream(string3);
            MetadataTask.save2File(inputStream, string2 + string3, resourceBundle);
            inputStream.close();
            linkedList.add(string3);
            String string4 = moduleRef.getAltBindings().eResource().getURI().toString();
            String string5 = string4.substring(0, string4.lastIndexOf(47));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving alt docs from : " + string3 + " and binding: " + string5);
            }
            MetadataTask.saveArchiveConfigDocs((Archive)eARFile, string5 + THISDIR_PATTERN, string2, null, linkedList, resourceBundle);
        }
        return linkedList;
    }

    public static void saveArchiveConfigDocs(Archive archive, String string, String string2, String string3, List list, ResourceBundle resourceBundle) throws Exception {
        String string4 = string2;
        if (string3 != null) {
            string4 = string4 + string3 + File.separator;
        }
        FileIterator fileIterator = null;
        fileIterator = archive.getLoadStrategy().getFileIterator();
        while (fileIterator != null && fileIterator.hasNext()) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File file = fileIterator.next();
            if (file instanceof Container || file.isSetDirectoryEntry() && file.isDirectoryEntry()) continue;
            String string5 = file.getURI();
            if (!(string5 = string5.replace('\\', '/')).matches(string)) continue;
            String string6 = (string3 == null ? "" : string3 + "/") + string5;
            if (list.contains(string6)) continue;
            InputStream inputStream = fileIterator.getInputStream(file);
            MetadataTask.save2File(inputStream, string4 + string5, resourceBundle);
            inputStream.close();
            AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6016I", new Object[]{string6}));
            list.add(string6);
        }
        if (fileIterator != null && fileIterator instanceof NestedArchiveIterator) {
            ((NestedArchiveIterator)fileIterator).close();
        }
    }

    static void save2File(InputStream inputStream, String string, ResourceBundle resourceBundle) throws Exception {
        byte[] byArray;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save2File");
        }
        FileOutputStream fileOutputStream = MetadataTask.getFOStream(string);
        int n2 = inputStream.available();
        while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) >= 1) {
            fileOutputStream.write(byArray, 0, n);
            n2 = inputStream.available();
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6017I", new Object[]{string}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save2File");
        }
    }

    static void save2File(Resource resource, String string, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save2File: " + resource);
        }
        FileOutputStream fileOutputStream = MetadataTask.getFOStream(string);
        resource.save((OutputStream)fileOutputStream, new HashMap());
        fileOutputStream.flush();
        fileOutputStream.close();
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6017I", new Object[]{string}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save2File");
        }
    }

    private static FileOutputStream getFOStream(String string) throws Exception {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        File file = new File(string2);
        FileOutputStream fileOutputStream = null;
        file.getParentFile().mkdirs();
        fileOutputStream = new FileOutputStream(file);
        return fileOutputStream;
    }
}

