/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.commands.authzgroup.AuthzGroupUtil;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public class UpdateAuthzGroupTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(UpdateAuthzGroupTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            Object v;
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (this.scheduler instanceof UninstallSchedulerImpl && (v = this.scheduler.getProperties().get("contenttype")) == null) {
                String string = repositoryContext.getURI();
                string = string + "|deployment.xml";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Uninstall ", string);
                }
                Session session = new Session(repositoryContext.getWorkSpace().getUserName(), true);
                ConfigService configService = null;
                this.notifyAuthzGroup(configService, session, string, "Application");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
    }

    private void notifyAuthzGroup(ConfigService configService, Session session, String string, String string2) throws Exception {
        final ConfigService configService2 = configService;
        final Session session2 = session;
        final String string3 = string;
        final String string4 = string2;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthzGroupUtil.removeResourceFromAuthorizationGroup(configService2, session2, string3, string4);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new AdminException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
    }
}

