/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateClusterScheduler;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class UpdateClusterTask
extends AbstractTask
implements NotificationListener {
    private static TraceComponent tc = Tr.register(UpdateClusterTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static int SERVER_STOPPED = 1;
    private static int SERVER_FAILED_TO_STOP = 2;
    private static int SERVER_NOT_STARTED = 3;
    private String waitObject = null;
    private String waitTarget = null;
    private static final long WAIT_TIME = 600000L;
    private static final String WAIT_TIME_PROP = "com.ibm.websphere.management.application.updateClusterTask.serverStopWaitTimeout";
    private static final long APPEXP_WAIT_TIME = 60L;
    private static final String APPEXP_WAIT_PROP = "com.ibm.websphere.management.application.updatesync.appExpansionTimeout";
    private String waitResult = null;
    private boolean waitStarting = false;
    private int launchTimeout;
    private Map autoSyncMap = new HashMap();
    private int appSyncEvtCount;
    private Hashtable appExpWaitResult = null;
    private HashMap hAppTargetTab = new HashMap();

    public UpdateClusterTask() {
        this.waitObject = new String("UpdateClusterTaskWaitObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performTask() throws AdminException {
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean bl = true;
        try {
            try {
                Object object;
                RepositoryContext repositoryContext;
                Hashtable hashtable = this.getTargetServers(((UpdateClusterScheduler)this.scheduler).getAppNames());
                if (hashtable.isEmpty()) {
                    bl = false;
                    this.sendNotification("ADMA8021I", "InProgress", this.scheduler.getAppName());
                    throw new AdminException("Target server for a given list of applications is not found");
                }
                Hashtable hashtable2 = new Hashtable();
                Hashtable hashtable3 = new Hashtable();
                this.getNodeSeversAndNodeAppsRelation(this.scheduler.getWorkSpace(), hashtable2, hashtable3, hashtable);
                Enumeration enumeration = hashtable3.keys();
                Set set = hashtable3.keySet();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    repositoryContext = (RepositoryContext)iterator2.next();
                    object = this.getAutoSyncEnabled(repositoryContext.getName());
                    if (object != null && Boolean.TRUE.equals(object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Disabling Sync for Node: " + repositoryContext.getName());
                        }
                        this.setAutoSyncEnabled(repositoryContext.getName(), Boolean.FALSE);
                    }
                    this.autoSyncMap.put(repositoryContext.getName(), object);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "performing cluster update" + hashtable3);
                }
                while (enumeration.hasMoreElements()) {
                    int n;
                    Object object2;
                    repositoryContext = (RepositoryContext)enumeration.nextElement();
                    object = repositoryContext.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node Name: " + (String)object);
                    }
                    Hashtable hashtable4 = this.getServerTypes(repositoryContext);
                    boolean bl2 = this.zosPauseResume(repositoryContext);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "For node " + (String)object + ", zosPauseNodes = " + bl2);
                    }
                    Vector vector = (Vector)hashtable3.get(repositoryContext);
                    boolean bl3 = false;
                    Vector vector2 = new Vector(vector);
                    for (int i = 0; i < vector.size(); ++i) {
                        block58: {
                            block60: {
                                int n2;
                                block59: {
                                    String string;
                                    object2 = ((RepositoryContext)vector.elementAt(i)).getName();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "stopping " + (String)object2);
                                    }
                                    if ((string = (String)hashtable4.get(object2)) == null || !string.equals("APPLICATION_SERVER")) break block58;
                                    this.setClusterMemberEnabled((RepositoryContext)vector.elementAt(i), repositoryContext, Boolean.FALSE);
                                    if (!bl2) break block59;
                                    n2 = this.pauseServer((RepositoryContext)vector.elementAt(i), repositoryContext.getName(), (String)object2);
                                    if (n2 == SERVER_STOPPED || n2 == SERVER_NOT_STARTED) {
                                        bl3 = true;
                                        if (n2 == SERVER_NOT_STARTED) {
                                            vector2.remove(vector.elementAt(i));
                                        }
                                        break block60;
                                    } else {
                                        bl3 = false;
                                        vector2.remove(vector.elementAt(i));
                                    }
                                    break block60;
                                }
                                n2 = this.stopServer(repositoryContext.getName(), (String)object2);
                                if (n2 == SERVER_STOPPED || n2 == SERVER_NOT_STARTED) {
                                    bl3 = true;
                                    if (n2 == SERVER_NOT_STARTED) {
                                        vector2.remove(vector.elementAt(i));
                                    }
                                } else {
                                    bl3 = false;
                                    vector2.remove(vector.elementAt(i));
                                }
                            }
                            if (bl3) continue;
                            break;
                        }
                        Tr.audit(tc, "Server " + (String)object2 + " is not an Application Server. This server will not be restarted during application ripple of application" + this.scheduler.getAppName() + ".");
                        vector2.remove(vector.elementAt(i));
                    }
                    if (!bl3) continue;
                    if (bl2) {
                        Thread.sleep(10000L);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "syncing  " + repositoryContext.getName());
                    }
                    this.sendNotification("ADMA8005I", "NodeSyncInitiated", repositoryContext.getName());
                    Hashtable hashtable5 = new Hashtable();
                    hashtable5.put("Completed", new Vector());
                    hashtable5.put("Failed", new Vector());
                    hashtable5.put("InProgress", new Vector());
                    object2 = (Vector)hashtable2.get(repositoryContext.getName());
                    if (vector2.size() > 0) {
                        ((Vector)hashtable5.get("InProgress")).addAll(object2);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Servers in the node will not be started; so app expansion wait is not required");
                    }
                    if (this.synchNode(repositoryContext.getName(), hashtable5)) {
                        this.sendNotification("ADMA8006I", "NodeSyncComplete", repositoryContext.getName());
                        if (((Vector)hashtable5.get("Completed")).size() <= 0 && ((Vector)hashtable5.get("Failed")).size() <= 0 && ((Vector)hashtable5.get("InProgress")).size() <= 0) {
                            this.sendNotification("ADMA8031I", "AppDistributionNode", new Object[]{"", repositoryContext.getName()});
                        } else {
                            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                                String string = (String)((Vector)object2).get(i);
                                if (((Vector)hashtable5.get("Completed")).contains(string)) {
                                    this.sendNotification("ADMA8028I", "AppDistributionNode", new Object[]{string, repositoryContext.getName()});
                                    continue;
                                }
                                if (((Vector)hashtable5.get("Failed")).contains(string)) {
                                    this.sendNotification("ADMA8029E", "AppDistributionNode", new Object[]{string, repositoryContext.getName()});
                                    continue;
                                }
                                if (!((Vector)hashtable5.get("InProgress")).contains(string)) continue;
                                this.sendNotification("ADMA8030W", "AppDistributionNode", new Object[]{string, repositoryContext.getName()});
                            }
                        }
                    } else {
                        this.sendNotification("ADMA8011I", "NodeSyncFailed", repositoryContext.getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "synced  " + repositoryContext.getName());
                    }
                    this.establishLaunchTimeout();
                    for (n = 0; n < vector2.size(); ++n) {
                        String string = ((RepositoryContext)vector2.elementAt(n)).getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "starting " + string);
                        }
                        if (bl2) {
                            this.sendNotification("ADMA8024I", "ServerStarting", string);
                            if (this.resumeServer((RepositoryContext)vector2.elementAt(n), repositoryContext.getName(), string)) {
                                this.sendNotification("ADMA8025I", "ServerStarted", string);
                                this.setClusterMemberEnabled((RepositoryContext)vector2.elementAt(n), repositoryContext, Boolean.TRUE);
                                continue;
                            }
                            bl = false;
                            this.sendNotification("ADMA8027I", "ServerStartFailed", string);
                            continue;
                        }
                        this.sendNotification("ADMA8007I", "ServerStarting", string);
                        if (this.startServer(repositoryContext.getName(), string)) {
                            this.sendNotification("ADMA8008I", "ServerStarted", string);
                            if (!this.applicationsStarted(repositoryContext.getName(), string)) {
                                this.sendNotification("ADMA8020I", "InProgress", string);
                            }
                            this.setClusterMemberEnabled((RepositoryContext)vector2.elementAt(n), repositoryContext, Boolean.TRUE);
                            continue;
                        }
                        bl = false;
                        this.sendNotification("ADMA8010I", "ServerStartFailed", string);
                    }
                    n = 60;
                    try {
                        String string = System.getProperty("com.ibm.ws.management.application.clusterupdate.nodedelay");
                        if (string != null) {
                            n = Integer.parseInt(string);
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " invalid delay specified, using default delay of 60 secs");
                        }
                        n = 60;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "waiting for " + new Integer(n) + " secs before rippling the next node");
                    }
                    if (n > 0) {
                        Thread.sleep(n * 1000);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "done wait. Started ripple of next node");
                }
                Object var20_28 = null;
                Set set2 = this.autoSyncMap.entrySet();
                iterator = set2.iterator();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster Update of cluster failed for applicaiton " + this.scheduler.getAppName());
                }
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8014I", new String[]{this.scheduler.getAppName()}));
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), exception});
                boolean bl6 = bl = false;
                Object var20_29 = null;
                Set set = this.autoSyncMap.entrySet();
                Iterator iterator4 = set.iterator();
                while (true) {
                    Boolean bl7;
                    if (!iterator4.hasNext()) {
                        return bl6;
                    }
                    Map.Entry entry = iterator4.next();
                    if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl7 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl7)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Re-enabling Sync for Node: " + (String)entry.getKey());
                    }
                    this.setAutoSyncEnabled((String)entry.getKey(), bl7);
                }
            }
        }
        catch (Throwable throwable) {
            Object var20_30 = null;
            Set set = this.autoSyncMap.entrySet();
            Iterator iterator3 = set.iterator();
            while (true) {
                Boolean bl4;
                if (!iterator3.hasNext()) {
                    throw throwable;
                }
                Map.Entry entry = iterator3.next();
                if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl4 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl4)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Re-enabling Sync for Node: " + (String)entry.getKey());
                }
                this.setAutoSyncEnabled((String)entry.getKey(), bl4);
            }
        }
        while (iterator.hasNext()) {
            Boolean bl5;
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl5 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl5)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Re-enabling Sync for Node: " + (String)entry.getKey());
            }
            this.setAutoSyncEnabled((String)entry.getKey(), bl5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClusterMemberEnabled(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterMemberEnabled", new Object[]{repositoryContext, repositoryContext2, bl});
        }
        URI uRI = URI.createURI((String)"server.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        Server server2 = (Server)resource.getContents().get(0);
        String string = server2.getClusterName();
        String string2 = repositoryContext.getName();
        String string3 = repositoryContext2.getName();
        ObjectName objectName = this.getClusterObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "ClusterMbean", new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string4 = this.waitObject;
                synchronized (string4) {
                    if (Boolean.TRUE.equals(bl)) {
                        AdminServiceFactory.getAdminService().invoke(objectName, "setAvailable", new Object[]{string2, string3}, new String[]{"java.lang.String", "java.lang.String"});
                    } else {
                        AdminServiceFactory.getAdminService().invoke(objectName, "setUnavailable", new Object[]{string2, string3}, new String[]{"java.lang.String", "java.lang.String"});
                    }
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterMemberEnabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean getAutoSyncEnabled(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAutoSyncEnabled", new Object[]{string});
        }
        Boolean bl = null;
        ObjectName objectName = this.getNodesyncObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "NodeSyncMbean", new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string2 = this.waitObject;
                synchronized (string2) {
                    bl = (Boolean)AdminServiceFactory.getAdminService().invoke(objectName, "getAutoSyncEnabled", new Object[0], new String[0]);
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoSyncEnabled", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean setAutoSyncEnabled(String string, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAutoSyncEnabled", new Object[]{string, bl});
        }
        Boolean bl2 = null;
        ObjectName objectName = this.getNodesyncObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "NodeSyncMbean", new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string2 = this.waitObject;
                synchronized (string2) {
                    AdminServiceFactory.getAdminService().invoke(objectName, "setAutoSyncEnabled", new Object[]{bl}, new String[]{Boolean.class.getName()});
                }
                bl2 = Boolean.TRUE;
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), exception});
                bl2 = Boolean.FALSE;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoSyncEnabled", new Object[]{bl});
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopServer(String string, String string2) {
        int n = SERVER_STOPPED;
        ObjectName objectName = this.getNodeagentObjectName(string);
        try {
            ObjectName objectName2 = this.getServerObjectName(string, string2);
            if (objectName2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " appears to be stopped");
                }
                int n2 = SERVER_NOT_STARTED;
                return n2;
            }
            this.sendNotification("ADMA8003I", "ServerStopping", string2);
            String string3 = "UpdateCluster:" + string + ":" + string2;
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("websphere.process.stopped");
            notificationFilterSupport.enableType("websphere.process.failed");
            notificationFilterSupport.enableType("websphere.process.starting");
            notificationFilterSupport.enableType("websphere.process.stopping");
            notificationFilterSupport.enableType("websphere.process.running");
            AdminServiceFactory.getAdminService().addNotificationListener(objectName, this, (NotificationFilter)notificationFilterSupport, (Object)string3);
            String string4 = this.waitObject;
            synchronized (string4) {
                long l;
                block28: {
                    AdminServiceFactory.getAdminService().invoke(objectName2, "stop", new Object[0], new String[0]);
                    this.waitTarget = string2;
                    l = 600000L;
                    if (System.getProperty(WAIT_TIME_PROP) != null) {
                        String string5 = System.getProperty(WAIT_TIME_PROP);
                        try {
                            l = Long.parseLong(string5) * 1000L;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException(exception, "com.ibm.ws.management.application.task.UpdateClusterTask.stopServer", "982", this, new Object[]{WAIT_TIME_PROP, string5});
                            if (!tc.isDebugEnabled()) break block28;
                            Tr.debug(tc, "Invalid stopServer time out value - " + string5);
                            Tr.debug(tc, "Using default stopServer time out: " + l);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopServer time out is: " + l);
                }
                this.waitObject.wait(l);
                if (this.waitTarget != null) {
                    Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8009I", new String[]{string2}));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "timed out waiting for server to stop ", new String[]{string2});
                    }
                    n = SERVER_FAILED_TO_STOP;
                }
            }
        }
        catch (Exception exception) {
            Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8009I", new String[]{string2}));
            n = SERVER_FAILED_TO_STOP;
        }
        finally {
            block30: {
                try {
                    if (objectName != null) {
                        AdminServiceFactory.getAdminService().removeNotificationListener(objectName, this);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block30;
                    Tr.debug(tc, "Failed to remove notification listener");
                }
            }
        }
        Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8004I", new String[]{string2}));
        if (n == SERVER_STOPPED) {
            this.sendNotification("ADMA8004I", "ServerStopped", string2);
        } else {
            this.sendNotification("ADMA8009I", "ServerStopFailed", string2);
        }
        return n;
    }

    private int pauseServer(RepositoryContext repositoryContext, String string, String string2) {
        int n = SERVER_FAILED_TO_STOP;
        URI uRI = URI.createURI((String)"server.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        Server server2 = (Server)resource.getContents().get(0);
        String string3 = "MODIFY " + server2.getShortName() + ",PAUSELISTENERS";
        ObjectName objectName = this.getMVSServericesObjectName(string);
        if (objectName != null) {
            this.sendNotification("ADMA8022I", "ServerStopping", string2);
            try {
                AdminServiceFactory.getAdminService().invoke(objectName, "issueCommand", new Object[]{string3}, new String[]{String.class.getName()});
                n = SERVER_STOPPED;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pauseServer() successfull for node:server " + string + ":" + string2);
                }
                this.sendNotification("ADMA8023I", "ServerStopped", string2);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pauseServer() Exception invoking MVSServices MBean ");
                    exception.printStackTrace();
                    this.sendNotification("ADMA8026I", "ServerStopFailed", string2);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pauseServer() could not find MVSServices MBean ");
            }
            n = SERVER_NOT_STARTED;
        }
        return n;
    }

    private boolean resumeServer(RepositoryContext repositoryContext, String string, String string2) {
        boolean bl;
        block6: {
            bl = false;
            URI uRI = URI.createURI((String)"server.xml");
            Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
            Server server2 = (Server)resource.getContents().get(0);
            String string3 = "MODIFY " + server2.getShortName() + ",RESUMELISTENERS";
            ObjectName objectName = this.getMVSServericesObjectName(string);
            if (objectName != null) {
                try {
                    AdminServiceFactory.getAdminService().invoke(objectName, "issueCommand", new Object[]{string3}, new String[]{String.class.getName()});
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resumeServer() successfull for node:server " + string + ":" + string2);
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resumeServer() Exception invoking MVSServices MBean ");
                        exception.printStackTrace();
                    }
                    break block6;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resumeServer() could not find MVSServices MBean ");
            }
        }
        return bl;
    }

    private boolean zosPauseResume(RepositoryContext repositoryContext) {
        boolean bl;
        block21: {
            Object object;
            String string;
            Iterator iterator;
            EList eList;
            Collection collection;
            RepositoryContextType repositoryContextType;
            Server server2;
            block20: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "zosPauseResume");
                }
                bl = false;
                server2 = null;
                try {
                    repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers");
                    collection = repositoryContext.findContext(repositoryContextType);
                    eList = collection.iterator();
                    while (eList.hasNext()) {
                        iterator = (RepositoryContext)eList.next();
                        string = iterator.getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found Repository Context for " + string);
                        }
                        if (string == null || !string.equalsIgnoreCase("nodeagent")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "NodeAgent Server Repository Context found");
                        }
                        object = iterator.getResourceSet();
                        Resource resource = null;
                        Object var11_13 = null;
                        String string2 = "server.xml";
                        try {
                            if (!iterator.isExtracted(string2)) {
                                iterator.extract(string2, false);
                            }
                            resource = object.createResource(URI.createURI((String)string2));
                            resource.load(new HashMap());
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Exception loading NodeAgent server.xml");
                            exception.printStackTrace();
                            continue;
                        }
                        EList eList2 = resource.getContents();
                        Iterator iterator2 = eList2.iterator();
                        while (iterator2.hasNext()) {
                            Object e2 = iterator2.next();
                            if (!(e2 instanceof Server)) continue;
                            server2 = (Server)e2;
                            break;
                        }
                        if (server2 == null) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "Exception finding NodeAgent Server object");
                    exception.printStackTrace();
                }
            }
            if (server2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to find NodeAgent server.xml");
                }
            } else {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found Server object in the NodeAgent server.xml file");
                    }
                    repositoryContextType = null;
                    collection = null;
                    eList = server2.getServices();
                    iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        repositoryContextType = (Service)iterator.next();
                        if (!(repositoryContextType instanceof AdminService)) continue;
                        collection = repositoryContextType.getProperties();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Found AdminService properties " + collection);
                        break;
                    }
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        string = (Property)iterator.next();
                        object = string.getName();
                        if (!"com.ibm.websphere.zos.rollout.pauseresume".equals(object) || !"true".equalsIgnoreCase(string.getValue())) continue;
                        bl = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Pause/Resume enabled");
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Exception finding Pause/Resume property");
                    exception.printStackTrace();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zosPauseResume");
        }
        return bl;
    }

    private ObjectName getMVSServericesObjectName(String string) {
        try {
            String string2 = "WebSphere:type=MVSServices,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting MVSServices object");
                exception.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startServer(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "UpdateClusterTask.startServer node: " + string + " Server: " + string2);
        }
        ObjectName objectName = this.getNodeagentObjectName(string);
        com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("websphere.process.running");
        notificationFilterSupport.enableType("websphere.process.failed");
        notificationFilterSupport.enableType("websphere.process.starting");
        String string3 = "UpdateCluster:" + string + ":" + string2;
        try {
            this.waitResult = null;
            this.waitTarget = string2;
            this.waitStarting = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startServer adds listener & launches thread... " + string3);
            }
            adminService.addNotificationListener(objectName, this, (NotificationFilter)notificationFilterSupport, (Object)string3);
            LaunchThread launchThread = new LaunchThread(string, string2, this.launchTimeout);
            launchThread.setDaemon(true);
            launchThread.start();
        }
        catch (Exception exception) {
            block33: {
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8010I", new String[]{string2}));
                try {
                    if (objectName != null) {
                        adminService.removeNotificationListener(objectName, this);
                    }
                }
                catch (Exception exception2) {
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug(tc, "Failed to remove notification listener");
                }
            }
            return false;
        }
        boolean bl = false;
        try {
            String string4 = this.waitObject;
            synchronized (string4) {
                if (!this.waitStarting) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wait for STARTING status first....");
                    }
                    this.waitObject.wait();
                }
                if (this.waitResult == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for server to complete START: ", new String[]{string2});
                    }
                    this.waitObject.wait(this.launchTimeout * 1000);
                    if (this.waitTarget != null) {
                        this.waitResult = "LaunchProcess timeout occurred.";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "timed out waiting for server to start ", new String[]{string2});
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while launchThread was waiting" + exception);
            }
            this.waitResult = "Exception occurred while launchThread was waiting.";
            exception.printStackTrace();
        }
        finally {
            block35: {
                try {
                    if (objectName != null) {
                        adminService.removeNotificationListener(objectName, this);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block35;
                    Tr.debug(tc, "Failed to remove notification listener");
                }
            }
        }
        if (this.waitResult != null) {
            if (this.waitResult.equals("websphere.process.running")) {
                bl = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "launchProcess result: " + this.waitResult);
            }
        }
        if (bl) {
            Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8008I", new String[]{string2}));
        }
        return bl;
    }

    private boolean applicationsStarted(String string, String string2) {
        if (this.scheduler instanceof UpdateClusterScheduler) {
            String[] stringArray = ((UpdateClusterScheduler)this.scheduler).getAppNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.isServerTheTarget(string, string2, stringArray[i]) || this.appStarted(string, string2, stringArray[i])) continue;
                return false;
            }
            return true;
        }
        return this.appStarted(string, string2, this.scheduler.getAppName());
    }

    private boolean appStarted(String string, String string2, String string3) {
        String string4 = "WebSphere:type=Application,node=" + string + ",process=" + string2 + ",name=" + string3 + ",*";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appStarted: query = " + string4);
        }
        try {
            ObjectName objectName = new ObjectName(string4);
            int n = 180000;
            String string5 = System.getProperty("com.ibm.websphere.management.application.UpdateAppOnCluster.AppMbeanAvailableTimeOut");
            if (null != string5 && !string5.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the value for AppMbeanAvailableTimeOut", string5);
                }
                n = new Integer(string5) > 0 ? new Integer(string5) * 60 * 1000 : 180000;
            }
            int n2 = 10000;
            for (int i = 0; i <= n; i += 10000) {
                if (AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator().hasNext()) {
                    return true;
                }
                Thread.sleep(n2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.task.UpdateClusterTask.appStarted", "402", this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean synchNode(String string, Hashtable hashtable) {
        boolean bl;
        block37: {
            String string2;
            ObjectName objectName;
            long l;
            ObjectName objectName2;
            block36: {
                bl = false;
                objectName2 = null;
                l = 0L;
                objectName = this.getNodesyncObjectName(string);
                if (((Vector)hashtable.get("InProgress")).size() > 0 && (objectName2 = this.getNotificationServiceObjectName(string)) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NotificationService Mbean is not available, AppExpasion wait cannot be executed on the Node " + string);
                    }
                    ((Vector)hashtable.get("InProgress")).removeAllElements();
                }
                if (objectName2 != null) {
                    string2 = "UpdateCluster:updatesync:" + string;
                    NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                    notificationFilterSupport.enableType("websphere.admin.appmgmt.sync");
                    try {
                        AdminServiceFactory.getAdminService().addNotificationListener(objectName2, this, (NotificationFilter)notificationFilterSupport, (Object)string2);
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to add notification listener");
                        }
                        objectName2 = null;
                    }
                    l = (long)((Vector)hashtable.get("InProgress")).size() * 60L;
                    if (System.getProperty(APPEXP_WAIT_PROP) != null) {
                        String string3 = System.getProperty(APPEXP_WAIT_PROP);
                        try {
                            l = Long.parseLong(string3);
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block36;
                            Tr.debug(tc, "Invalid App expansion time out value - " + string3);
                            Tr.debug(tc, "Using default App expansion time out: " + l);
                        }
                    }
                }
            }
            string2 = this.waitObject;
            synchronized (string2) {
                this.waitTarget = "updatesync";
                this.appExpWaitResult = hashtable;
                this.appSyncEvtCount = ((Vector)hashtable.get("InProgress")).size();
                AdminServiceFactory.getAdminService().invoke(objectName, "sync", null, null);
                bl = true;
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8006I", new String[]{string, this.scheduler.getAppName()}));
                if (objectName2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Entering into wait for app binaries expansion", "Wait time: " + l + "secs");
                    }
                    this.waitObject.wait(l * 1000L);
                    if (this.waitTarget != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AppExpansion timed out");
                            if (((Vector)this.appExpWaitResult.get("InProgress")).size() > 0) {
                                Tr.debug(tc, "Following Apps expansions are not completed", ((Vector)this.appExpWaitResult.get("InProgress")).toArray());
                            }
                            if (((Vector)this.appExpWaitResult.get("Failed")).size() > 0) {
                                Tr.debug(tc, "Following Apps expansions are failed", ((Vector)this.appExpWaitResult.get("Failed")).toArray());
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppExpansion competed successfully, for all applications");
                    }
                }
            }
            try {
                if (objectName2 != null) {
                    AdminServiceFactory.getAdminService().removeNotificationListener(objectName2, this);
                }
                break block37;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to remove notification listener");
                }
                break block37;
            }
            catch (Exception exception) {
                block38: {
                    try {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.application.task.UpdateClusterTask.syncNode", "981", this);
                        if (!bl) {
                            Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8011I", new String[]{string}));
                            break block38;
                        }
                        if (!(exception instanceof InterruptedException) || !tc.isDebugEnabled()) break block38;
                        Tr.debug(tc, "app exp wait interrupted.");
                    }
                    catch (Throwable throwable) {
                        block39: {
                            try {
                                if (objectName2 != null) {
                                    AdminServiceFactory.getAdminService().removeNotificationListener(objectName2, this);
                                }
                            }
                            catch (Exception exception2) {
                                if (!tc.isDebugEnabled()) break block39;
                                Tr.debug(tc, "Failed to remove notification listener");
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    if (objectName2 != null) {
                        AdminServiceFactory.getAdminService().removeNotificationListener(objectName2, this);
                    }
                }
                catch (Exception exception3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to remove notification listener");
                    }
                }
            }
        }
        return bl;
    }

    private ObjectName getServerObjectName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerObjectName", new Object[]{string, string2});
        }
        String string3 = "WebSphere:type=Server,node=" + string + ",process=" + string2 + ",*";
        try {
            ObjectName objectName = new ObjectName(string3);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerObjectName: return null");
                }
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerObjectName", new Object[]{objectName2});
            }
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerObjectName: return null");
            }
            return null;
        }
    }

    private ObjectName getNodeagentObjectName(String string) {
        try {
            String string2 = "WebSphere:type=NodeAgent,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            return null;
        }
    }

    private ObjectName getClusterObjectName(String string) {
        try {
            String string2 = "WebSphere:type=Cluster,name=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            return null;
        }
    }

    private ObjectName getNodesyncObjectName(String string) {
        try {
            String string2 = "WebSphere:type=NodeSync,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            return null;
        }
    }

    private ObjectName getNotificationServiceObjectName(String string) {
        try {
            String string2 = "WebSphere:type=NotificationService,node=" + string + ",process=nodeagent,*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            return null;
        }
    }

    private void sendNotification(String string, String string2, Object[] objectArray) {
        AppNotification appNotification = this.createNotification(string2, string, objectArray);
        this.scheduler.propagateTaskEvent(appNotification);
    }

    private void sendNotification(String string, String string2, String string3) {
        this.sendNotification(string, string2, new String[]{string3, this.scheduler.getAppName()});
    }

    private Hashtable getTargetServers(String[] stringArray) throws Exception {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (repositoryContext == null) continue;
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Vector vector = new Vector();
            Vector vector2 = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, vector, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), true);
            Vector vector3 = ConfigRepoHelper.getAllServers(this.scheduler.getWorkSpace(), vector2);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int j = 0; j < vector3.size(); ++j) {
                arrayList.add(ConfigRepoHelper.getTargetString((RepositoryContext)vector3.elementAt(j), (String)null));
            }
            this.hAppTargetTab.put(string, arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target servers are alAppTarget", arrayList);
            }
            if (vector.size() != 0) {
                this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA8016I", new Object[]{vector}));
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8016I", new Object[]{vector}));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target servers are " + vector2);
            }
            if (vector2.size() <= 0) continue;
            hashtable.put(string, new Vector(vector2));
        }
        return hashtable;
    }

    private void getNodeSeversAndNodeAppsRelation(WorkSpace workSpace, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeSeversAndNodeAppsRelation");
        }
        Enumeration enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable3.get(string);
            Hashtable hashtable4 = ConfigRepoHelper.getNodeServerRelation(workSpace, vector);
            Enumeration enumeration2 = hashtable4.keys();
            while (enumeration2.hasMoreElements()) {
                RepositoryContext repositoryContext = (RepositoryContext)enumeration2.nextElement();
                String string2 = repositoryContext.getName();
                Vector<String> vector2 = (Vector<String>)hashtable.get(string2);
                if (vector2 == null) {
                    vector2 = new Vector<String>();
                    hashtable.put(string2, vector2);
                }
                if (!vector2.contains(string)) {
                    vector2.add(string);
                }
                Vector vector3 = (Vector)hashtable4.get(repositoryContext);
                Vector vector4 = (Vector)hashtable2.get(repositoryContext);
                if (vector4 == null) {
                    vector4 = new Vector();
                    hashtable2.put(repositoryContext, vector4);
                }
                for (int i = 0; i < vector3.size(); ++i) {
                    if (vector4.contains(vector3.get(i))) continue;
                    vector4.add(vector3.get(i));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeAppsTbl ", hashtable);
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "nodeSvrsTbl ", hashtable2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeSeversAndNodeAppsRelation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UpdateClusterTask::handleNotification", new Object[]{notification, object});
        }
        Properties properties = null;
        if (notification == null) {
            return;
        }
        String string = notification.getType();
        Object object2 = notification.getUserData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got notification ", new Object[]{string, object2});
        }
        if (string.equals("websphere.process.stopped") || string.equals("websphere.process.failed") || string.equals("websphere.process.running") || string.equals("websphere.process.starting")) {
            if (object2 != null) {
                properties = (Properties)object2;
                String string2 = properties.getProperty("processName");
                String string3 = this.waitObject;
                synchronized (string3) {
                    if (string2.equals(this.waitTarget)) {
                        if (string.equals("websphere.process.starting")) {
                            this.waitStarting = true;
                        } else {
                            this.waitTarget = null;
                            this.waitResult = string;
                        }
                        this.waitObject.notifyAll();
                    }
                }
            }
        } else if (string.equals("websphere.admin.appmgmt.sync") && object2 != null && object2 instanceof AppNotification) {
            AppNotification appNotification = (AppNotification)object2;
            if (appNotification.taskName.equals(this.waitTarget) && (appNotification.taskStatus.equals("Completed") || appNotification.taskStatus.equals("Failed"))) {
                String string4 = (String)appNotification.props.get("appname");
                String string5 = this.waitObject;
                synchronized (string5) {
                    if (string4 != null && ((Vector)this.appExpWaitResult.get("InProgress")).contains(string4)) {
                        --this.appSyncEvtCount;
                        ((Vector)this.appExpWaitResult.get("InProgress")).remove(string4);
                        if (appNotification.message.equals("completed")) {
                            ((Vector)this.appExpWaitResult.get("Completed")).add(string4);
                        }
                        if (appNotification.message.equals("failed")) {
                            ((Vector)this.appExpWaitResult.get("Failed")).add(string4);
                        }
                    }
                    if (this.appSyncEvtCount <= 0) {
                        this.waitTarget = null;
                        this.waitObject.notifyAll();
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UpdateClusterTask::handleNotification");
        }
    }

    private Hashtable getServerTypes(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTypes");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        URI uRI = URI.createURI((String)"serverindex.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            String string = serverEntry.getServerName();
            String string2 = serverEntry.getServerType();
            hashtable.put(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTypes");
        }
        return hashtable;
    }

    private void establishLaunchTimeout() {
        Integer n = UpdateClusterScheduler.DEFAULT_LAUNCH_TIMEOUT;
        Object v = this.scheduler.getProperties().get("LAUNCH_TIMEOUT");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "time", v);
        }
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        this.launchTimeout = n;
    }

    private boolean isServerTheTarget(String string, String string2, String string3) {
        ArrayList arrayList;
        String string4;
        String string5;
        block9: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "isServerTheTarget: NodeName = " + string + ":ServerName=" + string2 + ":AppName=" + string3 + "");
            }
            string5 = string;
            String string6 = string2;
            String string7 = string3;
            string4 = new String();
            arrayList = (ArrayList)this.hAppTargetTab.get(string3);
            try {
                string4 = ((UpdateClusterScheduler)this.scheduler).getCellContext().getName();
                if (null == string4) {
                    string4 = AdminServiceFactory.getAdminService().getCellName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The Value of CellName from AdminService in try is " + string4);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Value of CellName from Scheduler is " + string4);
                }
            }
            catch (Exception exception) {
                string4 = AdminServiceFactory.getAdminService().getCellName();
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "The Value of CellName from AdminService is " + string4);
            }
        }
        String string8 = "WebSphere:cell=" + string4 + ",node=" + string5 + ",server=" + string2;
        if (null != arrayList && arrayList.contains(string8)) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isServerTheTarget:true");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isServerTheTarget:false");
        }
        return false;
    }

    private class LaunchThread
    extends Thread {
        String launchNode;
        String launchServer;
        int timeout;

        public LaunchThread(String string, String string2, int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "LaunchThread");
            }
            this.launchNode = string;
            this.launchServer = string2;
            this.timeout = n;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LaunchThread");
            }
        }

        public void run() {
            block6: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run");
                }
                Object object = null;
                try {
                    Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                    object = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            LaunchThread.this.invokeUpdateCluster();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception invoking launchProcess" + exception);
                    }
                    exception.printStackTrace();
                    return;
                }
                catch (Exception exception) {
                    Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Exception invoking launchProcess" + exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }

        private void invokeUpdateCluster() {
            com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = UpdateClusterTask.this.getNodeagentObjectName(this.launchNode);
            ObjectName objectName2 = UpdateClusterTask.this.getServerObjectName(this.launchNode, this.launchServer);
            Object var4_4 = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initiating launch for " + this.launchNode + "/" + this.launchServer);
                }
                AdminServiceFactory.getAdminService().invoke(objectName, "launchProcess", new Object[]{this.launchServer, new Integer(this.timeout)}, new String[]{"java.lang.String", "java.lang.Integer"});
            }
            catch (Exception exception) {
                Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception invoking launchProcess" + exception);
                }
                return;
            }
        }
    }
}

