/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.BindJndiForEJBMessageBindingHelper;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.ecore.resource.Resource;

public class ValidateAppTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(ValidateAppTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static int[][] versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}};

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            Serializable serializable;
            Object object;
            EARFile eARFile = this.scheduler instanceof InstallScheduler ? ((InstallScheduler)this.scheduler).getEarFile(false, true) : ((EditScheduler)this.scheduler).getEarFile();
            int n = EarUtils.getAppVersionForDeployment(eARFile);
            List list = ValidateAppTask.getSelectedOptions(eARFile, this.scheduler.getProperties(), this.scheduler.getWorkSpace());
            int n2 = ValidateAppTask.getAppVersion(eARFile, list);
            int n3 = ValidateAppTask.getHighestRarVersion(eARFile);
            Hashtable hashtable = (Hashtable)this.scheduler.getProperties().get("moduleToServer");
            Hashtable hashtable2 = AppDeploymentUtil.getNodeVersionForAppTargets(hashtable, this.scheduler.getCellContext(), this.scheduler.getWorkSpace());
            Vector vector = AppDeploymentUtil.appValidation(n3, n, n2, list, hashtable2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Messages from AppValidationTask: " + vector);
            }
            AppUtils.dbg(tc, "App validation: " + vector.size());
            AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo(eARFile);
            BindJndiForEJBMessageBindingHelper bindJndiForEJBMessageBindingHelper = new BindJndiForEJBMessageBindingHelper();
            AppDeploymentTask appDeploymentTask = bindJndiForEJBMessageBindingHelper.createTask(null, "BindJndiForEJBMessageBinding");
            bindJndiForEJBMessageBindingHelper.prepareTask(appDeploymentInfo, appDeploymentTask);
            Vector vector2 = AppDeploymentUtil.MDBValidation(hashtable2, hashtable, appDeploymentTask);
            Tr.debug(tc, "Messages from MDBValidation: " + vector2);
            vector.addAll(vector2);
            Vector vector3 = AppDeploymentUtil.validateLightweightEJBs(eARFile, hashtable2);
            Tr.debug(tc, "Messages from LightweightEJBs validation: " + vector3);
            vector.addAll(vector3);
            Vector vector4 = AppDeploymentUtil.envEntryValidation(eARFile);
            for (int i = 0; i < vector4.size(); ++i) {
                object = (String)vector4.elementAt(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error " + (String)object);
                }
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Warning", (String)object, null));
            }
            if (hashtable2 != null) {
                this.scheduler.getProperties().put("nodeVersionTable", hashtable2);
            }
            try {
                serializable = new Vector();
                object = new ArrayList();
                ExtensionHelper.provideValidationExtensions(serializable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validation helpers are: " + serializable);
                }
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    AppManagementExtensions.AppValidationHelper appValidationHelper = (AppManagementExtensions.AppValidationHelper)((Vector)serializable).elementAt(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing helper: " + appValidationHelper);
                    }
                    appValidationHelper.validateOperation_Required(this.scheduler, (List)object);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validation errors = " + object);
                }
                if (object.size() > 0) {
                    vector.addAll(object);
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting validation errors from extensions: " + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.ValidateAppTask.performTask", "130", this);
            }
            if (vector.size() != 0) {
                serializable = new StringBuffer();
                for (int i = 0; i < vector.size(); ++i) {
                    ((StringBuffer)serializable).append("\n" + (String)vector.elementAt(i));
                }
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA5055E", new String[]{this.scheduler.getAppName(), ((StringBuffer)serializable).toString()}));
            }
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5058I", new Object[0]));
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.ValidateAppTask.performTask", "82", this);
            if (throwable instanceof AdminException) {
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", throwable.getMessage(), null));
                throw (AdminException)throwable;
            }
            String string = AppUtils.getMessage(this.getResourceBundle(), "ADMA5057E", new String[]{throwable.toString()});
            this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
            throw new AdminException(throwable, string);
        }
    }

    private static List getSelectedOptions(EARFile eARFile, Hashtable hashtable, WorkSpace workSpace) throws Exception {
        Resource resource;
        List list;
        EnhancedEarConfigurator enhancedEarConfigurator;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectedOptions");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = hashtable.get("deployejb") != null && hashtable.get("deployejb").equals(Boolean.TRUE);
        boolean bl3 = hashtable.get("preCompileJSPs") != null && hashtable.get("preCompileJSPs").equals(Boolean.TRUE);
        boolean bl4 = hashtable.get("enhancedEarDisableValidation") != null;
        Tr.debug(tc, "enhancedEarDisable " + bl4);
        boolean bl5 = hashtable.get("deployws") != null && hashtable.get("deployws").equals(Boolean.TRUE);
        boolean bl6 = bl = hashtable.get("useMetaDataFromBinary") != null && hashtable.get("useMetaDataFromBinary").equals(Boolean.TRUE);
        if (bl2) {
            arrayList.add("deployejb");
        }
        if (bl3) {
            arrayList.add("preCompileJSPs");
        }
        if (!bl4 && (enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, eARFile, true, "default", "appName", "appName.ear_")).isEnhancedEar() && (list = enhancedEarConfigurator.getDeploymentResources()).size() == 1 && !(resource = (Resource)list.get(0)).getURI().toString().endsWith("deployment.xml")) {
            arrayList.add("enhancedEar");
        }
        if (bl5) {
            arrayList.add("deployws");
        }
        if (bl) {
            arrayList.add("useMetaDataFromBinary");
        }
        Tr.debug(tc, "selected Options: " + arrayList);
        return arrayList;
    }

    private static int getAppVersion(EARFile eARFile, List list) throws Exception {
        int n;
        if (list.size() > 0) {
            for (n = 0; n < list.size(); ++n) {
                String string = (String)list.get(n);
                Tr.debug(tc, "deplOption: " + string);
                if (!string.equals("deployejb") && !string.equals("preCompileJSPs") && !string.equals("enhancedEar") && !string.equals("deployws") && !string.equals("useMetaDataFromBinary")) continue;
                return versionTable[versionTable.length - 1][0];
            }
        }
        n = EarUtils.getAppVersionForDeployment(eARFile);
        Tr.debug(tc, "AppVersion: " + n);
        return n;
    }

    private static int getHighestRarVersion(EARFile eARFile) throws Exception {
        int n = 99;
        int n2 = 15;
        List list = eARFile.getRARFiles();
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RARFile rARFile = (RARFile)iterator.next();
                n = rARFile.getDeploymentDescriptor().getVersionID();
                if (n < n2) continue;
                n = n2;
            }
        }
        Tr.debug(tc, "the highest rar version " + n);
        return n;
    }
}

