/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.client.ResourceValidationHelper;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.application.WebModule;

public class ValidateResourceTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(ValidateResourceTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME = ValidateResourceTask.class.getName();
    protected static AppdeploymentFactory appFactory;

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        ResourceValidationHelper resourceValidationHelper = null;
        try {
            Hashtable hashtable = this.scheduler.getProperties();
            String string = (String)hashtable.get("validateinstall");
            WorkSpace workSpace = this.scheduler.getWorkSpace();
            String string2 = this.scheduler.getCellContext().getName();
            EARFile eARFile = this.scheduler instanceof InstallScheduler ? ((InstallScheduler)this.scheduler).getEarFile() : ((EditScheduler)this.scheduler).getEarFile();
            String string3 = eARFile.getURI();
            hashtable.put("earfile", eARFile);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tbl " + hashtable);
            }
            resourceValidationHelper = new ResourceValidationHelper(string3, workSpace.getUserName(), hashtable, "resource.mapper.app.validation.op", true);
            Vector vector = resourceValidationHelper.appResourceValidation();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < vector.size(); ++i) {
                String string4 = (String)vector.elementAt(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error " + string4);
                }
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Warning", string4, null));
                stringBuffer.append("\n" + string4);
            }
            Vector vector2 = this.checkDuplicateWebContext(eARFile, workSpace);
            if (vector2.size() != 0) {
                vector.addAll(vector2);
            }
            if (vector.size() > 0 && "fail".equals(string)) {
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA5059E", new Object[]{this.scheduler.getAppName(), stringBuffer.toString()}));
            }
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", vector.size() > 0 ? "ADMA5068I" : "ADMA5067I", new Object[]{this.scheduler.getAppName()}));
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, CLASS_NAME + ".performTask", "147", this);
            if (throwable instanceof AdminException) {
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", throwable.getMessage(), null));
                throw (AdminException)throwable;
            }
            String string = AppUtils.getMessage(this.getResourceBundle(), "ADMA5060E", new String[]{this.scheduler.getAppName(), throwable.toString()});
            this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
            throw new AdminException(throwable, string);
        }
        finally {
            if (resourceValidationHelper != null) {
                resourceValidationHelper.close();
            }
        }
    }

    private Vector checkDuplicateWebContext(EARFile eARFile, WorkSpace workSpace) {
        Object object;
        Vector<String> vector = new Vector<String>();
        String string = this.scheduler.getAppName();
        Hashtable hashtable = this.scheduler.getProperties();
        if (appFactory == null) {
            object = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            appFactory = object.getAppdeploymentFactory();
        }
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string2;
            Object object7;
            Object object8;
            String string3;
            String string4;
            Object object9;
            Hashtable hashtable2;
            Object object10;
            object = this.scheduler.getCellContext();
            EList eList = eARFile.getModuleRefs();
            String string5 = "WEB-INF/web.xml";
            ModuleRef moduleRef = null;
            Hashtable<String, Hashtable> hashtable3 = new Hashtable<String, Hashtable>(10);
            for (int i = 0; i < eList.size(); ++i) {
                object10 = new ArrayList(10);
                moduleRef = (ModuleRef)eList.get(i);
                if (!moduleRef.isWeb()) continue;
                hashtable2 = (WebModule)moduleRef.getModule();
                object9 = new ArrayList(3);
                string4 = hashtable2.getUri();
                string3 = (WebAppBinding)moduleRef.getBindings();
                if (string3 == null) continue;
                object8 = string3.getVirtualHostName();
                object7 = hashtable2.getContextRoot();
                string2 = (String)object8 + "+" + (String)object7;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "croot = " + (String)object7 + "vhost=" + (String)object8);
                }
                if ((object6 = (Hashtable)this.scheduler.getProperties().get("moduleToServer")) == null) {
                    return vector;
                }
                object5 = util.createUniqueModuleName(string5, string4);
                object4 = this.getTargets((Hashtable)object6, (String)object5, string4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "key: " + (String)object5 + " .. targets: " + (String)object4);
                }
                object3 = ConfigRepoHelper.getServerNames((String)object4, (String)object5, this.scheduler.getCellContext(), workSpace);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tlist: " + object3);
                }
                object2 = new Vector();
                object2 = this.getServersForModule((Vector)object3, (RepositoryContext)object, workSpace, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "svrs: " + object2);
                }
                Hashtable hashtable4 = ConfigRepoHelper.getNodeServerRelation(workSpace, (Vector)object2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "allNodes: " + hashtable4);
                }
                hashtable3.put(string2, hashtable4);
            }
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                object10 = (String)enumeration.nextElement();
                hashtable2 = (Hashtable)hashtable3.get(object10);
                object9 = ((String)object10).split("\\+");
                string4 = object9[0];
                string3 = "";
                if (((String[])object9).length > 1) {
                    string3 = object9[1];
                }
                object8 = hashtable2.keys();
                while (object8.hasMoreElements()) {
                    object7 = (RepositoryContext)object8.nextElement();
                    string2 = object7.getName();
                    object6 = URI.createURI((String)"serverindex.xml");
                    object5 = object7.getResourceSet().createResource(object6);
                    object4 = new HashMap();
                    object5.load(object4);
                    if (object5 == null || object5.getContents().size() == 0) continue;
                    object3 = (ServerIndex)object5.getContents().get(0);
                    object2 = object3.getServerEntries();
                    for (int i = 0; i < object2.size(); ++i) {
                        ServerEntry serverEntry = (ServerEntry)object2.get(i);
                        EList eList2 = serverEntry.getDeployedApplications();
                        for (int j = 0; j < eList2.size(); ++j) {
                            int n;
                            String string6 = (String)eList2.get(j);
                            String string7 = string6.substring((n = string6.lastIndexOf(47)) + 1);
                            if (string7.equals(string)) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "The same application " + string7 + " skip this");
                                continue;
                            }
                            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string7, workSpace, hashtable);
                            if (repositoryContext == null) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Error getting rc for application " + string6);
                                continue;
                            }
                            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
                            EARFile eARFile2 = ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
                            EList eList3 = applicationDeployment.getModules();
                            EList eList4 = eARFile2.getModuleRefs();
                            for (int k = 0; k < eList4.size(); ++k) {
                                String string8;
                                moduleRef = (ModuleRef)eList4.get(k);
                                if (!moduleRef.isWeb()) continue;
                                WebModule webModule = (WebModule)moduleRef.getModule();
                                String string9 = webModule.getUri();
                                String string10 = webModule.getContextRoot();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "module = " + string9 + " Context root  = " + string10);
                                }
                                if (!string3.equals(string10)) continue;
                                ModuleDeployment moduleDeployment = null;
                                boolean bl = false;
                                for (int i2 = 0; i2 < eList3.size(); ++i2) {
                                    moduleDeployment = (ModuleDeployment)eList3.get(i2);
                                    if (!moduleDeployment.getUri().equals(string9)) continue;
                                    bl = true;
                                    break;
                                }
                                if (!bl) continue;
                                WebModuleDeployment webModuleDeployment = (WebModuleDeployment)moduleDeployment;
                                EList eList5 = webModuleDeployment.getTargetMappings();
                                WebAppBinding webAppBinding = (WebAppBinding)moduleRef.getBindings();
                                if (webAppBinding == null || !(string8 = webAppBinding.getVirtualHostName()).equals(string4) || !string10.equals(string3)) continue;
                                DeploymentTargetMapping deploymentTargetMapping = null;
                                for (int i3 = 0; i3 < eList5.size(); ++i3) {
                                    deploymentTargetMapping = (DeploymentTargetMapping)eList5.get(i3);
                                    DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
                                    Vector vector2 = new Vector(0);
                                    Vector vector3 = ConfigRepoHelper.getServersForModuleDeployment((ModuleDeployment)webModuleDeployment, vector2, (RepositoryContext)object, workSpace, true);
                                    Hashtable hashtable5 = ConfigRepoHelper.getNodeServerRelation(workSpace, vector3);
                                    Enumeration enumeration2 = hashtable5.keys();
                                    while (enumeration2.hasMoreElements()) {
                                        RepositoryContext repositoryContext2 = (RepositoryContext)enumeration2.nextElement();
                                        if (!repositoryContext2.getName().equals(string2)) continue;
                                        String string11 = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0159W", new Object[]{string10, string2, string4});
                                        vector.addElement(string11);
                                        this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Warning", string11, null));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, CLASS_NAME + ".performTask", "345", this);
            if (throwable instanceof AdminException) {
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", throwable.getMessage(), null));
            }
            String string12 = AppUtils.getMessage(this.getResourceBundle(), "ADMA5060E", new String[]{this.scheduler.getAppName(), throwable.toString()});
            this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string12, null));
        }
        return vector;
    }

    private Vector getServersForModule(Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        Object object;
        Object object2;
        RepositoryContext repositoryContext2;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModule");
        }
        Vector<Object> vector2 = new Vector<Object>();
        ArrayList<DeploymentTargetMapping> arrayList = new ArrayList<DeploymentTargetMapping>(10);
        try {
            for (n = 0; n < vector.size(); n += 2) {
                repositoryContext2 = (RepositoryContext)vector.elementAt(n);
                object2 = (String)vector.elementAt(n + 1);
                object = ValidateResourceTask.createTarget(repositoryContext2, appFactory);
                DeploymentTargetMapping deploymentTargetMapping = appFactory.createDeploymentTargetMapping();
                deploymentTargetMapping.setTarget(object);
                arrayList.add(deploymentTargetMapping);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, CLASS_NAME + ".performTask", "386", this);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            repositoryContext2 = ((DeploymentTargetMapping)arrayList.get(n)).getTarget();
            if (repositoryContext2 == null) continue;
            if (repositoryContext2 instanceof ClusteredTarget) {
                object2 = AppUtils.findContext("clusters", repositoryContext2.getName(), null, repositoryContext, workSpace, true);
                if (object2 == null) continue;
                if (!vector2.contains(object2)) {
                    vector2.addElement(object2);
                }
            }
            if (!(repositoryContext2 instanceof ServerTarget)) continue;
            object2 = ((ServerTarget)repositoryContext2).getNodeName();
            object = AppUtils.findContext("servers", repositoryContext2.getName(), (String)object2, repositoryContext, workSpace, false);
            if (object == null) continue;
            if (!bl && AppUtils.getClusterFromMember(AppUtils.findContext("servers", repositoryContext2.getName(), (String)object2, repositoryContext, workSpace, false), workSpace) != null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Ignoring  cluster member: " + repositoryContext2.getName());
                continue;
            }
            if (vector2.contains(object)) continue;
            vector2.addElement(object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server for depl: " + vector2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModule");
        }
        return vector2;
    }

    private static DeploymentTarget createTarget(RepositoryContext repositoryContext, AppdeploymentFactory appdeploymentFactory) throws Exception {
        Object object = null;
        object = AppUtils.isCluster(repositoryContext) ? appdeploymentFactory.createClusteredTarget() : appdeploymentFactory.createServerTarget();
        object.setName(repositoryContext.getName());
        if (object instanceof ServerTarget) {
            ((ServerTarget)object).setNodeName(repositoryContext.getParent().getName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created target: " + object);
        }
        return object;
    }

    private String getTargets(Hashtable hashtable, String string, String string2) {
        String string3 = (String)hashtable.get(string);
        if (string3 != null) {
            return string3;
        }
        int n = string2.lastIndexOf(46);
        if (n != -1 && (string3 = (String)hashtable.get("*" + string2.substring(n))) != null) {
            return string3;
        }
        return (String)hashtable.get("*");
    }
}

