/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.authorizer.AuthorizationGroup;
import com.ibm.ws.management.authorizer.AuthorizationGroups;
import com.ibm.ws.management.authorizer.AuthzCache;
import com.ibm.ws.management.authorizer.ExcludeList;
import com.ibm.ws.management.authorizer.ResourceInstanceRelations;
import com.ibm.ws.management.authorizer.RoleRelations;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AdminAuthorizerImpl
implements AdminAuthorizer {
    private static TraceComponent tc = Tr.register(AdminAuthorizerImpl.class, "AdminAuthorizerImpl", "com.ibm.ws.management.authorizer");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private RoleBasedConfigurator rbc = null;
    private AuthzCache authzCache = null;
    private static AdminAuthorizerImpl authorizer = null;
    private static String scope = "scope";
    private Session session = null;
    private ConfigService configService = null;
    private static ExcludeList excludeList;
    private String cell = null;
    private String node = null;
    private String server = null;
    private String CELLXML = null;
    private String JDBCPROVIDERTEMPLATE = null;

    public static AdminAuthorizerImpl create() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        if (authorizer == null) {
            authorizer = new AdminAuthorizerImpl();
            excludeList = new ExcludeList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", authorizer);
        }
        return authorizer;
    }

    public static AdminAuthorizer getInstance() {
        return authorizer;
    }

    public boolean isFineGrainedAdminSecurity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFineGrainedAdminSecurity");
        }
        Collection collection = null;
        collection = AuthorizationGroups.getInstance().getGroups();
        if (collection != null && !collection.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFineGrainedAdminSecurity", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFineGrainedAdminSecurity", new Boolean(false));
        }
        return false;
    }

    public boolean checkAccess(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", string + " : " + string2);
        }
        try {
            String[] stringArray;
            String[] stringArray2;
            String string3 = null;
            if (this.runningAsSystem()) {
                return true;
            }
            if ((string.endsWith("serverindex.xml") || string.endsWith("node-metadata.properties")) && string2 == "monitor") {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                return true;
            }
            string3 = string.indexOf("cells/") < 0 ? (string.startsWith("/") ? "cells/" + this.cell + string : "cells/" + this.cell + "/" + string) : ((stringArray2 = ResourceInstanceRelations.getInstance().getResourceType(string)) != null ? ResourceInstanceRelations.getInstance().convertCfgId(string, (String)stringArray2) : string);
            stringArray2 = null;
            List list = RoleRelations.getInstance().getAllParentRoles(string2);
            list.add(string2);
            if (string3 == null) {
                string3 = "cells/" + this.cell;
            }
            String string4 = ResourceInstanceRelations.getInstance().getResourceType(string3);
            if (string2.equals("configurator") && string4 != null && string4.equals("Application")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding deployer for " + string);
                }
                list.add("deployer");
            }
            stringArray2 = list.toArray(new String[0]);
            if (string3.equals(this.CELLXML) && string2.equals("monitor")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                return true;
            }
            if (string3.equals(this.JDBCPROVIDERTEMPLATE) && string2.equals("monitor")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                return true;
            }
            if (this.checkAccess(stringArray2, "admin-authz")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                return true;
            }
            if (string.endsWith("serverindex.xml") && string2.equals("configurator")) {
                stringArray = new String[]{"deployer"};
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking for celllevel deployer for serverindex.xml file ");
                }
                if (this.checkAccess(stringArray, "admin-authz")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkAccess", new Boolean(true));
                    }
                    return true;
                }
            }
            if ((string.endsWith("admin-authz.xml") || string.endsWith("authorizationgroup.xml")) && string2.equals("configurator")) {
                stringArray = new String[]{"adminsecuritymanager"};
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking for celllevel adminsecuritymanager for admin resources ");
                }
                if (this.checkAccess(stringArray, "admin-authz")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkAccess", new Boolean(true));
                    }
                    return true;
                }
            }
            if (!this.isFineGrainedAdminSecurity()) {
                return false;
            }
            stringArray = null;
            if (string4 != null) {
                stringArray = AuthorizationGroups.getInstance().getAllResourceGroupNames(string3, string4);
            }
            if (stringArray != null) {
                Iterator iterator = stringArray.iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    if (!this.checkAccess(stringArray2, string5)) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkAccess", new Boolean(true));
                    }
                    return true;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAccess", "198", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(false));
        }
        return false;
    }

    public boolean checkAccess(String string, String string2, String string3) {
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        stringArray[0] = this.node;
        stringArray[1] = this.server;
        stringArray2[0] = "Node";
        stringArray2[1] = "Server";
        return this.checkAccess(string, null, stringArray, stringArray2, string3);
    }

    public boolean checkAccess(ObjectName objectName, String[] stringArray, String[] stringArray2, String string) {
        return this.checkAccess(null, objectName, stringArray, stringArray2, string);
    }

    public boolean checkAccess(String string, ObjectName objectName, String[] stringArray, String[] stringArray2, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", objectName + " " + stringArray[0] + " " + stringArray2[0] + " " + string2);
        }
        try {
            List list;
            int n;
            if (this.runningAsSystem()) {
                return true;
            }
            String string3 = null;
            string3 = string != null ? string : ObjectNameHelper.getMBeanType(objectName);
            String string4 = string3 + ":" + string2;
            if (string4.equals("Server:getProcessType")) {
                return this.isGrantedRoleInAnyGroup("monitor");
            }
            if (excludeList.isExcluded(string3, string3, string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                return true;
            }
            if (this.checkAccess("admin-authz", string3, string3, string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAccess", new Boolean(true));
                }
                return true;
            }
            if (!this.isFineGrainedAdminSecurity()) {
                return false;
            }
            String string5 = new String();
            String string6 = null;
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    string5 = string5 + "/";
                }
                string5 = string5 + this.getResType(stringArray2[n]) + "/" + stringArray[n];
            }
            String string7 = stringArray2[n - 1];
            if (stringArray2.length == 1 && stringArray2[0].equals("Server")) {
                string5 = "nodes/" + this.node + "/" + string5;
            }
            if (string5.indexOf("cells/") < 0) {
                string6 = string5.startsWith("/") ? "cells/" + this.cell + string5 : "cells/" + this.cell + "/" + string5;
            }
            if (stringArray2 != null && stringArray2.length > 0 && stringArray2[0].equals("ResourceURI")) {
                string7 = ResourceInstanceRelations.getInstance().getResourceType(stringArray[0]);
                string6 = string7 != null ? ResourceInstanceRelations.getInstance().convertCfgId(stringArray[0], string7) : string5;
            }
            if ((list = AuthorizationGroups.getInstance().getAllResourceGroupNames(string6, string7)) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string8 = (String)iterator.next();
                    if (!this.checkAccess(string8, string3, string3, string2)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAccess", "300", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(false));
        }
        return false;
    }

    public boolean isCallerInRole(String string, String string2) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerInRole", string + " " + string2);
        }
        if (this.runningAsSystem()) {
            return true;
        }
        RoleBasedAuthorizer roleBasedAuthorizer = null;
        boolean bl = false;
        if (string == null) {
            return false;
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String string3 = contextManager.getProperty("com.ibm.websphere.security.authorizationTable", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "groupName ", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzTableName ", string3);
        }
        boolean bl2 = false;
        if (string.equals("admin-authz-merge") && string3 != null && string3.length() != 0) {
            bl2 = true;
        }
        if (bl2) {
            bl = this.checkAllGroups(string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole ", new Boolean(bl));
            }
            return bl;
        }
        try {
            object = string;
            if (!string.startsWith("admin-authz")) {
                object = "admin-authz-" + string;
            }
            roleBasedAuthorizer = this.rbc.getRoleBasedAuthorizer((String)object, scope);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isCallerInRole", "327", this);
        }
        if (roleBasedAuthorizer != null) {
            object = this.getAllParentRoles(string2);
            object.add(string2);
            String[] stringArray = object.toArray(new String[0]);
            bl = roleBasedAuthorizer.isGrantedAnyRole(stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole", new Boolean(bl));
        }
        return bl;
    }

    public boolean isCallerInRole(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerInRole", string);
        }
        if (this.runningAsSystem()) {
            return true;
        }
        String string2 = null;
        String string3 = string;
        boolean bl = false;
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            bl = this.checkAccess(string2, string3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole", new Boolean(bl));
            }
            return bl;
        }
        n = string.indexOf("-");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string2 == null || string2.equals("Any")) {
            bl = this.isCallerInRole("admin-authz-merge", string3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole", new Boolean(bl));
            }
            return bl;
        }
        if (this.isCallerInRole("admin-authz", string3)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole", new Boolean(true));
            }
            return true;
        }
        Collection collection = AuthorizationGroups.getInstance().getGroups();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AuthorizationGroup authorizationGroup = (AuthorizationGroup)iterator.next();
            if (!authorizationGroup.hasResourceType(string2) || !this.isCallerInRole(authorizationGroup.getGroupName(), string3)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isCallerInRole", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole", new Boolean(bl));
        }
        return bl;
    }

    public List getAllParentRoles(String string) {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllParentRoles", string);
        }
        if ((arrayList = RoleRelations.getInstance().getAllParentRoles(string)) == null) {
            arrayList = new ArrayList();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent roles are");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Tr.debug(tc, "role=", string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllParentRoles");
        }
        return arrayList;
    }

    public List getParentRoles(String string) {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParentRoles", string);
        }
        if ((arrayList = RoleRelations.getInstance().getParentRoles(string)) == null) {
            arrayList = new ArrayList();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent roles are");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Tr.debug(tc, "role=", string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentRoles");
        }
        return arrayList;
    }

    public void setRoleBasedConfigurator(RoleBasedConfigurator roleBasedConfigurator) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(adminPermission);
        }
        this.rbc = roleBasedConfigurator;
    }

    public RoleBasedConfigurator getRoleBasedConfigurator() {
        return this.rbc;
    }

    private boolean checkAccess(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", "Group = " + string + " resource = " + string3);
        }
        RoleBasedAuthorizer roleBasedAuthorizer = null;
        boolean bl = false;
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccess", new Boolean(bl));
            }
            return bl;
        }
        try {
            String string5 = string;
            if (!string.startsWith("admin-authz")) {
                string5 = "admin-authz-" + string;
            }
            roleBasedAuthorizer = this.rbc.getRoleBasedAuthorizer(string5, scope);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAccess", "467", this);
        }
        if (roleBasedAuthorizer != null) {
            bl = roleBasedAuthorizer.checkAccess(string2, string3, string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(bl));
        }
        return bl;
    }

    private boolean checkAccess(String[] stringArray, String stringArray2) {
        String[] stringArray3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", (String)stringArray2 + " " + this.arrToStr(stringArray));
        }
        RoleBasedAuthorizer roleBasedAuthorizer = null;
        boolean bl = false;
        if (stringArray2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccess", new Boolean(bl));
            }
            return bl;
        }
        try {
            stringArray3 = stringArray2;
            if (!stringArray2.startsWith("admin-authz")) {
                stringArray3 = "admin-authz-" + (String)stringArray2;
            }
            roleBasedAuthorizer = this.rbc.getRoleBasedAuthorizer((String)stringArray3, scope);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.checkAccess", "496", this);
        }
        stringArray3 = this.getValidRoles(stringArray, (String)stringArray2);
        if (roleBasedAuthorizer != null) {
            bl = roleBasedAuthorizer.isGrantedAnyRole(stringArray3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(bl));
        }
        return bl;
    }

    public void setCellName(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(adminPermission);
        }
        this.cell = string;
        this.CELLXML = "cells/" + this.cell + "/cell.xml";
        this.JDBCPROVIDERTEMPLATE = "templates/system/jdbc-resource-provider-templates.xml";
    }

    public void setNodeName(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(adminPermission);
        }
        this.node = string;
    }

    public void setServerName(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(adminPermission);
        }
        this.server = string;
    }

    private void getSession() {
        if (this.session == null) {
            this.session = new Session();
            this.configService = ConfigServiceFactory.getConfigService();
        }
    }

    private String getCfgId(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCfgId", string);
        }
        this.getSession();
        ObjectName[] objectNameArray = null;
        final String string2 = string;
        final ConfigService configService = this.configService;
        final Session session = this.session;
        try {
            object = ContextManagerFactory.getInstance().getServerSubject();
            objectNameArray = (ObjectName[])ContextManagerFactory.getInstance().runAsSpecified((Subject)object, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ObjectName[] objectNameArray = configService.resolve(session, string2);
                    return objectNameArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception resolving");
            }
            objectNameArray = null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Generic Exception resolving");
            }
            objectNameArray = null;
        }
        if (objectNameArray == null || objectNameArray.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCfgId");
            }
            return null;
        }
        object = ConfigServiceHelper.getConfigDataId((ObjectName)objectNameArray[0]).toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCfgId", object);
        }
        return object;
    }

    public boolean runningAsSystem() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runningAsSystem");
        }
        try {
            Subject subject = ContextManagerFactory.getInstance().getInvocationSubject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InvocationSubject = ", subject);
            }
            if (subject != null && ContextManagerFactory.getInstance().isServerSubject(subject)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "runningAsSystem", new Boolean(true));
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runningAsSystem", new Boolean(false));
        }
        return false;
    }

    private boolean isGrantedRoleInAnyGroup(String string) {
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRoleInAnyGroup", string);
        }
        RoleBasedAuthorizer roleBasedAuthorizer = null;
        boolean bl = false;
        String[] stringArray2 = null;
        List list = RoleRelations.getInstance().getAllParentRoles(string);
        list.add(string);
        stringArray2 = list.toArray(new String[0]);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "checking for roles ", "admin-authz");
            for (int i = 0; i < stringArray2.length; ++i) {
                Tr.debug(tc, "role=", stringArray2[i]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking group ", "admin-authz");
        }
        try {
            stringArray = "admin-authz";
            roleBasedAuthorizer = this.rbc.getRoleBasedAuthorizer((String)stringArray, scope);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedRoleInAnyGroup", "617", this);
        }
        if (roleBasedAuthorizer != null) {
            bl = roleBasedAuthorizer.isGrantedAnyRole(stringArray2);
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedRoleInAnyGroup", new Boolean(bl));
            }
            return bl;
        }
        stringArray = this.getValidRoles(stringArray2, null);
        List list2 = AuthorizationGroups.getInstance().getGroupNames();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking group ", string2);
            }
            try {
                String string3 = "admin-authz-" + string2;
                roleBasedAuthorizer = this.rbc.getRoleBasedAuthorizer(string3, scope);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedRoleInAnyGroup", "636", this);
            }
            if (roleBasedAuthorizer != null) {
                bl = roleBasedAuthorizer.isGrantedAnyRole(stringArray);
            }
            if (!bl) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedRoleInAnyGroup", new Boolean(bl));
            }
            return bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRoleInAnyGroup", new Boolean(bl));
        }
        return bl;
    }

    private String getResType(String string) {
        return ResourceInstanceRelations.getInstance().getUniversalResourceType(string);
    }

    private String[] getValidRoles(String[] stringArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValidRoles", new Object[]{this.arrToStr(stringArray), string});
        }
        if (string != null && string.startsWith("admin-authz")) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = RoleRelations.getInstance().getCustomRoles();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equals(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValidRoles", this.arrToStr(stringArray2));
        }
        return stringArray2;
    }

    private String arrToStr(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append(stringArray[i]);
                continue;
            }
            stringBuffer.append(":");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private boolean checkAllGroups(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAllGroups", string);
        }
        boolean bl = false;
        if (this.isCallerInRole("admin-authz", string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAllGroups", new Boolean(true));
            }
            return true;
        }
        Collection collection = AuthorizationGroups.getInstance().getGroups();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AuthorizationGroup authorizationGroup = (AuthorizationGroup)iterator.next();
            if (!this.isCallerInRole(authorizationGroup.getGroupName(), string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAllGroups", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAllGroups", new Boolean(bl));
        }
        return bl;
    }

    public void setAuthzCache(AuthzCache authzCache) {
        this.authzCache = authzCache;
    }

    private String getCallerId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerId");
        }
        String string = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getInvocationSubject();
            if (subject != null) {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                if (wSCredential != null) {
                    string = wSCredential.getAccessId();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCallerId", string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerId", string);
        }
        return null;
    }

    public boolean isGrantedMinimumRolesForMBean(String string, String string2, String string3) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedMinimumRolesForMBean", new Object[]{string, string2, string3});
        }
        boolean bl = false;
        String string4 = "admin-authz-merge";
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String string5 = contextManager.getProperty("com.ibm.websphere.security.authorizationTable", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzTableName ", string5);
        }
        boolean bl2 = false;
        if (string5 != null && string5.length() != 0) {
            bl2 = true;
        }
        if (!bl2) {
            string4 = "admin-authz-merge";
            try {
                RoleBasedAuthorizer roleBasedAuthorizer = this.rbc.getRoleBasedAuthorizer(string4, scope);
                bl = roleBasedAuthorizer.checkAccess(string, string2, string3);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedMinimumRolesForMBean", "617", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedMinimumRolesForMBean", new Boolean(bl));
            }
            return bl;
        }
        try {
            string4 = "admin-authz";
            object = this.rbc.getRoleBasedAuthorizer(string4, scope);
            bl = object.checkAccess(string, string2, string3);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedMinimumRolesForMBean", "617", this);
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedMinimumRolesForMBean", new Boolean(bl));
            }
            return bl;
        }
        object = AuthorizationGroups.getInstance().getGroups();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            AuthorizationGroup authorizationGroup = (AuthorizationGroup)iterator.next();
            string4 = "admin-authz-" + authorizationGroup.getGroupName();
            try {
                RoleBasedAuthorizer roleBasedAuthorizer = this.rbc.getRoleBasedAuthorizer(string4, scope);
                bl = roleBasedAuthorizer.checkAccess(string, string2, string3);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthorizerImpl.isGrantedMinimumRolesForMBean", "617", this);
            }
            if (!bl) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedMinimumRolesForMBean", new Boolean(bl));
            }
            return bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedMinimumRolesForMBean", new Boolean(bl));
        }
        return bl;
    }
}

