/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.authorizer.service.AdminAuthzService;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceEvent;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceListener;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.rolebasedauthz.AllAuthenticatedUsersExt;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.EveryoneExt;
import com.ibm.websphere.models.config.rolebasedauthz.GroupExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzFactory;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzPackage;
import com.ibm.websphere.models.config.rolebasedauthz.ServerExt;
import com.ibm.websphere.models.config.rolebasedauthz.SpecialSubjectExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.models.config.topology.authorizationgroup.AuthorizationGroupMember;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.authorizer.AdminAuthorizerImpl;
import com.ibm.ws.management.authorizer.AuthorizationGroup;
import com.ibm.ws.management.authorizer.AuthorizationGroupManager;
import com.ibm.ws.management.authorizer.AuthorizationGroups;
import com.ibm.ws.management.authorizer.AuthzCache;
import com.ibm.ws.management.authorizer.GroupsParser;
import com.ibm.ws.management.authorizer.ResourceInstanceRelations;
import com.ibm.ws.management.authorizer.ResourceRelationHandler;
import com.ibm.ws.management.authorizer.RoleRelationHandler;
import com.ibm.ws.management.authorizer.RoleRelations;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public final class AdminAuthzComponentImpl
extends ComponentImpl
implements AdminAuthzService,
SecurityServiceListener {
    private static TraceComponent tc = Tr.register(AdminAuthzComponentImpl.class, "AdminAuthzComponentImpl", "com.ibm.ws.management.authorizer");
    private ArrayList listeners = new ArrayList(4);
    private String cellName = null;
    private String nodeName = null;
    private String serverName = null;
    private AdminAuthorizerImpl aa = null;
    private AuthzCache authzCache = null;
    private RoleBasedConfigurator rbc = null;
    protected RolebasedauthzFactory authFactory;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        AuthorizationGroups.create();
        this.aa = AdminAuthorizerImpl.create();
        this.authzCache = new AuthzCache();
        this.aa.setAuthzCache(this.authzCache);
        RolebasedauthzPackage rolebasedauthzPackage = (RolebasedauthzPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi");
        this.authFactory = rolebasedauthzPackage.getRolebasedauthzFactory();
        try {
            ConfigInit.init();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthzComponentImpl.initialize", "99", this);
            throw new ConfigurationWarning(exception);
        }
        this.addService(AdminAuthzService.class);
        SecurityService securityService = (SecurityService)this.getService(SecurityService.class);
        securityService.addListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void realStart() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "realStart");
        }
        try {
            SecurityService securityService = (SecurityService)this.getService(SecurityService.class);
            Server server2 = (Server)this.getService(Server.class);
            this.cellName = server2.getCellName();
            this.nodeName = server2.getNodeName();
            this.serverName = server2.getName();
            this.aa.setCellName(this.cellName);
            this.aa.setNodeName(this.nodeName);
            this.aa.setServerName(this.serverName);
            GroupsParser groupsParser = new GroupsParser(new ResourceRelationHandler());
            groupsParser.loadConfigFile("com/ibm/ws/management/authorizer/xml/resourceTypeRelation.xml");
            groupsParser = new GroupsParser(new RoleRelationHandler());
            groupsParser.loadConfigFile("com/ibm/ws/management/authorizer/xml/roleRelation.xml");
            if (securityService.isSecurityEnabled()) {
                RoleBasedConfigurator roleBasedConfigurator = null;
                try {
                    this.rbc = roleBasedConfigurator = securityService.getConfigurator();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthzComponentImpl.realStart", "1555", this);
                    throw new RuntimeError(exception);
                }
                try {
                    this.refreshAll();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthzComponentImpl.realStart", "163", this);
                    throw new RuntimeError(exception);
                }
                Repository repository2 = (Repository)this.getService(Repository.class);
                Object var6_9 = null;
                try {
                    ConfigRoot configRoot = repository2.getConfigRoot();
                    AuthorizationGroupManager authorizationGroupManager = new AuthorizationGroupManager(this);
                    MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
                    DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(authorizationGroupManager, "AuthorizationGroupManager");
                    mBeanFactory.activateMBean("AuthorizationGroupManager", defaultRuntimeCollaborator, mBeanFactory.getConfigId("AuthorizationGroupManager"), null);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthzComponentImpl.realStart", "180", this);
                    throw new RuntimeError(exception);
                }
                finally {
                    if (repository2 != null) {
                        this.releaseService(repository2);
                    }
                }
                this.aa.setRoleBasedConfigurator(roleBasedConfigurator);
                AdminAuthorizerFactory.create();
            }
            this.fireStartedEvent();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthzComponentImpl.realStart", "192", this);
            throw new RuntimeError(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "realStart");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AdminAuthzServiceListener adminAuthzServiceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", adminAuthzServiceListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(adminAuthzServiceListener)) {
                this.listeners.add(adminAuthzServiceListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AdminAuthzServiceListener adminAuthzServiceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", adminAuthzServiceListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(adminAuthzServiceListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireStartedEvent");
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int n = list.size();
            AdminAuthzServiceEvent adminAuthzServiceEvent = new AdminAuthzServiceEvent(1);
            for (int i = 0; i < n; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "notifying " + list.get(i));
                }
                ((AdminAuthzServiceListener)list.get(i)).stateChanged(adminAuthzServiceEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireStartedEvent");
        }
    }

    public void refresh(String[] stringArray) throws Exception {
        throw new Exception("Not Implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAll() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAll");
        }
        if (this.rbc == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "refreshAll");
            }
            return;
        }
        AuthorizationTableExt authorizationTableExt = null;
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        Repository repository2 = (Repository)this.getService(Repository.class);
        try {
            String string;
            String string2;
            AuthorizationGroupMember authorizationGroupMember;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            this.authzCache.clear();
            ConfigRoot configRoot = repository2.getConfigRoot();
            Object object8 = AuthorizationGroups.getInstance();
            synchronized (object8) {
                AuthorizationGroups.getInstance().flush();
                object7 = configRoot.list(0, "authorizationgroups/");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "list of groups in the cell " + object7);
                }
                for (int i = 0; object7 != null && i < ((String[])object7).length; ++i) {
                    object6 = "authorizationgroups/" + object7[i] + "/authorizationgroup.xml";
                    object5 = configRoot.getResource(0, (String)object6);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource = " + object5);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource contents = " + object5.getContents());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource contents first element = " + object5.getContents().get(0));
                    }
                    object4 = (com.ibm.websphere.models.config.topology.authorizationgroup.AuthorizationGroup)object5.getContents().get(0);
                    object3 = new AuthorizationGroup();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loading group " + object4.getName());
                    }
                    ((AuthorizationGroup)object3).setAuthorizationGroupName(object4.getName());
                    object2 = object4.getMembers();
                    if (object2 != null) {
                        object = object2.iterator();
                        while (object.hasNext()) {
                            String string3;
                            Object object9;
                            Object object10;
                            authorizationGroupMember = (AuthorizationGroupMember)object.next();
                            string = string2 = authorizationGroupMember.getResourceName();
                            String string4 = authorizationGroupMember.getResourceType();
                            if (string2 == null || string4 == null) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Resource Name or Resource type cannot be null " + string2 + " " + string4);
                                continue;
                            }
                            string2 = ResourceInstanceRelations.getInstance().convertCfgId(string2, string4);
                            EList eList = authorizationGroupMember.getMemberProperties();
                            ArrayList<String> arrayList = new ArrayList<String>();
                            if (eList != null) {
                                Iterator iterator = eList.iterator();
                                while (iterator.hasNext()) {
                                    object10 = (Property)iterator.next();
                                    object9 = object10.getValue();
                                    string3 = object10.getName();
                                    if (object9 == null || string3 == null) {
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "Parent Resource Name or Parent Resource type cannot be null " + (String)object9 + " " + string3);
                                        continue;
                                    }
                                    object9 = ResourceInstanceRelations.getInstance().convertCfgId((String)object9, string3);
                                    arrayList.add((String)object9);
                                }
                            }
                            ((AuthorizationGroup)object3).addResource(string2, string4, arrayList);
                            AuthorizationGroups.getInstance().addResource(string2, (AuthorizationGroup)object3);
                            if (!string4.equals("Application")) continue;
                            int n = string.indexOf("/deployments/");
                            if (n > 0) {
                                string = string.substring(0, n);
                            }
                            string = ResourceInstanceRelations.getInstance().convertCfgId(string, string4);
                            object10 = new ArrayList();
                            object9 = arrayList.iterator();
                            while (object9.hasNext()) {
                                string3 = (String)object9.next();
                                object10.add(string3);
                            }
                            ((AuthorizationGroup)object3).addResource(string, string4, (List)object10);
                            AuthorizationGroups.getInstance().addResource(string, (AuthorizationGroup)object3);
                        }
                    }
                    AuthorizationGroups.getInstance().addGroup(object4.getName(), (AuthorizationGroup)object3);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loaded all authorization groups ");
            }
            object8 = null;
            object7 = "admin-authz.xml";
            Object object11 = configRoot.getResource(0, (String)object7);
            object8 = object6 = (AuthorizationTableExt)object11.getContents().get(0);
            authorizationTableExt = (AuthorizationTableExt)etoolsCopyUtility.copy((EObject)object6);
            this.rbc.loadApplication("admin-authz", (AuthorizationTableExt)object6);
            this.updateRoleRelationsForCustomRoles((AuthorizationTableExt)object8);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loaded cell level authorization table ");
            }
            object11 = AuthorizationGroups.getInstance();
            object6 = ((AuthorizationGroups)object11).getGroups();
            object5 = object6.iterator();
            object4 = new ArrayList();
            while (object5.hasNext()) {
                object3 = (AuthorizationGroup)object5.next();
                object2 = ((AuthorizationGroup)object3).getGroupName();
                object = "/authorizationgroups/" + (String)object2 + "/" + "admin-authz" + ".xml";
                authorizationGroupMember = null;
                try {
                    authorizationGroupMember = configRoot.getResource(0, (String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (authorizationGroupMember != null) {
                    string2 = (AuthorizationTableExt)authorizationGroupMember.getContents().get(0);
                    string = (AuthorizationTableExt)etoolsCopyUtility.copy((EObject)string2);
                    this.merge(authorizationTableExt, (AuthorizationTableExt)string);
                    this.rbc.loadApplication("admin-authz-" + (String)object2, (AuthorizationTableExt)string2);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No Authorization table for authorization group " + (String)object2);
                    }
                    object4.add(object2);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "loaded authorization table " + (String)object);
            }
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                ((AuthorizationGroups)object11).removeGroup((String)object2);
            }
            this.rbc.loadApplication("admin-authz-merge", authorizationTableExt);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loaded mergedauthorization table ");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (repository2 != null) {
                this.releaseService(repository2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAll");
        }
    }

    public void refreshGroups(String[] stringArray) throws Exception {
        throw new Exception("Not Implemented");
    }

    public void refreshAllGroups() throws Exception {
        throw new Exception("Not Implemented");
    }

    public void refreshAllAuthTables() throws Exception {
        throw new Exception("Not Implemented");
    }

    public void refreshAuthTables(String[] stringArray) throws Exception {
        throw new Exception("Not Implemented");
    }

    private void merge(AuthorizationTableExt authorizationTableExt, AuthorizationTableExt authorizationTableExt2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge", authorizationTableExt + "  " + authorizationTableExt2);
        }
        EList eList = authorizationTableExt2.getAuthorizations();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EList eList2;
            EList eList3;
            RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
            EList eList4 = roleAssignmentExt.getSpecialSubjects();
            Iterator iterator2 = eList4.iterator();
            while (iterator2.hasNext()) {
                eList3 = (SpecialSubjectExt)iterator2.next();
                this.addTo(authorizationTableExt, roleAssignmentExt.getRole().getRoleName(), (SpecialSubjectExt)eList3);
            }
            eList3 = roleAssignmentExt.getUsers();
            Iterator iterator3 = eList3.iterator();
            while (iterator3.hasNext()) {
                eList2 = (UserExt)iterator3.next();
                this.addTo(authorizationTableExt, roleAssignmentExt.getRole().getRoleName(), (UserExt)eList2);
            }
            eList2 = roleAssignmentExt.getGroups();
            Iterator iterator4 = eList2.iterator();
            while (iterator4.hasNext()) {
                GroupExt groupExt = (GroupExt)iterator4.next();
                this.addTo(authorizationTableExt, roleAssignmentExt.getRole().getRoleName(), groupExt);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
    }

    private void addTo(AuthorizationTableExt authorizationTableExt, String string, UserExt userExt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTo", authorizationTableExt + " user " + userExt + " role " + string);
        }
        String string2 = userExt.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "user", string2);
        }
        EList eList = authorizationTableExt.getAuthorizations();
        Iterator iterator = eList.iterator();
        if (string2 == null || string2.equals("")) {
            return;
        }
        while (iterator.hasNext()) {
            UserExt userExt2;
            RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
            if (!roleAssignmentExt.getRole().getRoleName().equals(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "role", roleAssignmentExt.getRole().getRoleName());
            }
            EList eList2 = roleAssignmentExt.getUsers();
            Iterator iterator2 = eList2.iterator();
            boolean bl = true;
            while (iterator2.hasNext()) {
                userExt2 = (UserExt)iterator2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user", userExt2.getName());
                }
                if (userExt2.getName() == null || !userExt2.getName().equals(string2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            userExt2 = this.authFactory.createUserExt();
            userExt2.setName(string2);
            roleAssignmentExt.getUsers().add((Object)userExt2);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTo");
        }
    }

    private void addTo(AuthorizationTableExt authorizationTableExt, String string, GroupExt groupExt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTo", authorizationTableExt + " group " + groupExt + " role " + string);
        }
        String string2 = groupExt.getName();
        EList eList = authorizationTableExt.getAuthorizations();
        Iterator iterator = eList.iterator();
        if (string2 == null || string2.equals("")) {
            return;
        }
        while (iterator.hasNext()) {
            GroupExt groupExt2;
            RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
            if (!roleAssignmentExt.getRole().getRoleName().equals(string)) continue;
            EList eList2 = roleAssignmentExt.getGroups();
            Iterator iterator2 = eList2.iterator();
            boolean bl = true;
            while (iterator2.hasNext()) {
                groupExt2 = (GroupExt)iterator2.next();
                if (groupExt2.getName() == null || !groupExt2.getName().equals(string2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            groupExt2 = this.authFactory.createGroupExt();
            groupExt2.setName(string2);
            roleAssignmentExt.getGroups().add((Object)groupExt2);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTo");
        }
    }

    private void addTo(AuthorizationTableExt authorizationTableExt, String string, SpecialSubjectExt specialSubjectExt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTo", authorizationTableExt + " special " + specialSubjectExt + "role " + string);
        }
        EList eList = authorizationTableExt.getAuthorizations();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object object;
            RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
            if (!roleAssignmentExt.getRole().getRoleName().equals(string)) continue;
            EList eList2 = roleAssignmentExt.getSpecialSubjects();
            Iterator iterator2 = eList2.iterator();
            boolean bl = true;
            while (iterator2.hasNext()) {
                object = (SpecialSubjectExt)iterator2.next();
                if (object instanceof EveryoneExt && specialSubjectExt instanceof EveryoneExt) {
                    bl = false;
                    break;
                }
                if (object instanceof ServerExt && specialSubjectExt instanceof ServerExt) {
                    bl = false;
                    break;
                }
                if (!(object instanceof AllAuthenticatedUsersExt) || !(specialSubjectExt instanceof AllAuthenticatedUsersExt)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object = null;
            object = specialSubjectExt instanceof EveryoneExt ? this.authFactory.createEveryoneExt() : (specialSubjectExt instanceof AllAuthenticatedUsersExt ? this.authFactory.createAllAuthenticatedUsersExt() : this.authFactory.createServerExt());
            roleAssignmentExt.getSpecialSubjects().add(object);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTo");
        }
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged");
        }
        if ((n = securityServiceEvent.getState()) == 1) {
            try {
                this.realStart();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AdminAuthzComponentImpl.stateChanged", "622", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    private void updateRoleRelationsForCustomRoles(AuthorizationTableExt authorizationTableExt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRoleRelationsForCustomRoles");
        }
        if (authorizationTableExt == null) {
            return;
        }
        EList eList = authorizationTableExt.getAuthorizations();
        if (eList == null) {
            return;
        }
        Iterator iterator = eList.iterator();
        List list = RoleRelations.getInstance().getAllParentRoles("monitor");
        while (iterator.hasNext()) {
            RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = roleAssignmentExt.getRole().getRoleName();
            arrayList.add(string);
            if (string.equals("monitor") || list.contains(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding roleName " + string + " as parent of monitor role");
            }
            RoleRelations.getInstance().addRoleRelations("monitor", arrayList);
            RoleRelations.getInstance().addCustomRoles(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRoleRelationsForCustomRoles");
        }
    }
}

