/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzFactory;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzPackage;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.resource.WASResourceSetImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class AuthTableParser {
    protected boolean emitTimestamp = true;
    protected boolean multiExtent = false;
    protected RolebasedauthzFactory authFactory;
    protected String url = null;
    protected EList rootExt = null;
    protected AuthorizationTableExt atx = null;
    protected Resource configResource = null;

    public AuthTableParser(String string) {
        this.url = string;
        this.initializeFactories();
    }

    public void initializeFactories() {
        ArchiveInit.init();
        CommonarchiveFactory commonarchiveFactory = ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore")).getCommonarchiveFactory();
        ConfigInit.init();
        RolebasedauthzPackage rolebasedauthzPackage = (RolebasedauthzPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi");
        this.authFactory = rolebasedauthzPackage.getRolebasedauthzFactory();
    }

    protected Resource makeResource(String string) {
        Resource resource = null;
        try {
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URIConverterImpl uRIConverterImpl = new URIConverterImpl();
            wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
            resource = wASResourceSetImpl.createResource(URI.createURI((String)string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return resource;
    }

    public void read(String string) {
        Resource resource;
        this.configResource = resource = this.makeResource(string);
        this.rootExt = resource.getContents();
        Iterator iterator = this.rootExt.iterator();
        this.atx = (AuthorizationTableExt)iterator.next();
    }

    public void write(String string) {
        try {
            this.configResource.save(new HashMap());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showUsers(String string) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>(0);
        EList eList = this.atx.getAuthorizations();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object2 = (RoleAssignmentExt)iterator.next();
            if (!object2.getRole().getRoleName().equals(string)) continue;
            object = object2.getUsers();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                UserExt userExt = (UserExt)iterator2.next();
                arrayList.add(userExt.getName());
            }
        }
        System.out.println("*** Users of Role " + string + " are : ");
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            System.out.println((String)object);
        }
    }

    public void addUser(String string, String string2) {
        UserExt userExt = this.authFactory.createUserExt();
        userExt.setName(string);
        System.out.println("Adding " + string + " to role " + string2);
        EList eList = this.atx.getAuthorizations();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
            if (!roleAssignmentExt.getRole().getRoleName().equals(string2)) continue;
            roleAssignmentExt.getUsers().add((Object)userExt);
        }
    }

    public void removeUser(String string, String string2) {
        EList eList = this.atx.getAuthorizations();
        Iterator iterator = eList.iterator();
        System.out.println("Removing " + string + " from role " + string2);
        while (iterator.hasNext()) {
            RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
            if (!roleAssignmentExt.getRole().getRoleName().equals(string2)) continue;
            EList eList2 = roleAssignmentExt.getUsers();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                UserExt userExt = (UserExt)iterator2.next();
                if (!userExt.getName().equals(string)) continue;
                iterator2.remove();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        AuthTableParser authTableParser = new AuthTableParser(string);
        authTableParser.read(string);
        authTableParser.showUsers("administrator");
        authTableParser.showUsers("configurator");
        authTableParser.showUsers("operator");
        authTableParser.showUsers("monitor");
        System.out.println("************************");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("************************");
        authTableParser.addUser("user1", "monitor");
        authTableParser.addUser("user2", "administrator");
        authTableParser.removeUser("user1", "configurator");
        System.out.println("************************");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("************************");
        authTableParser.showUsers("administrator");
        authTableParser.showUsers("configurator");
        authTableParser.showUsers("operator");
        authTableParser.showUsers("monitor");
        authTableParser.write(string);
    }
}

