/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.service.AdminAuthzService;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.authorizer.AdminAuthorizerImpl;
import com.ibm.ws.management.authorizer.AuthorizationGroups;
import java.util.Iterator;
import javax.management.ObjectName;

public final class AuthorizationGroupManager {
    private static TraceComponent tc = Tr.register(AuthorizationGroupManager.class, "AuthorizationGroupManager", "com.ibm.ws.management.authorizer");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    AuthorizationGroups groups = null;
    AdminAuthorizer aa = null;
    AdminAuthzService agService = null;
    String processType = null;
    String processName = null;
    private static AuthorizationGroupManager agmgr = null;

    public AuthorizationGroupManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DefaultConstructor");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DefaultConstructor");
        }
    }

    public AuthorizationGroupManager(AdminAuthzService adminAuthzService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthorizationGroupManager");
        }
        this.agService = adminAuthzService;
        this.initialize();
        agmgr = this;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthorizationGroupManager");
        }
    }

    public static AuthorizationGroupManager getInstance() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(adminPermission);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return agmgr;
    }

    public void initialize() {
        this.groups = AuthorizationGroups.getInstance();
        this.aa = AdminAuthorizerImpl.getInstance();
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            this.processType = adminService.getProcessType();
            this.processName = adminService.getProcessName();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AuthorizationGroupManager.initialize", "73", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAll() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshAll");
        }
        if (this.aa != null && !this.aa.isCallerInRole("admin-authz", "adminsecuritymanager") && !this.aa.isCallerInRole("admin-authz", "administrator")) {
            throw new Exception("Access Denied");
        }
        if (this.agService == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "refreshAll is notperformed as it is not initialized correctly ");
            }
            return;
        }
        Object object = this.aa;
        synchronized (object) {
            this.agService.refreshAll();
        }
        if (this.processType != null && this.processType.length() != 0 && this.processType.equals("DeploymentManager")) {
            try {
                object = new ObjectName("WebSphere:type=AuthorizationGroupManager,*");
                Iterator iterator = AdminServiceFactory.getAdminService().queryNames((ObjectName)object, null).iterator();
                while (iterator.hasNext()) {
                    object = (ObjectName)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, ((ObjectName)object).getKeyProperty("process") + " " + this.processName);
                    }
                    if (((ObjectName)object).getKeyProperty("process").equals(this.processName)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "refreshing " + this.processName);
                    }
                    AdminServiceFactory.getAdminService().invoke((ObjectName)object, "refreshAll", new Object[0], new String[0]);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.authorizer.AuthorizationGroupManager.refreshAll", "111", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAll");
        }
    }

    public void refreshGroups(String[] stringArray) throws Exception {
        this.agService.refreshGroups(stringArray);
    }

    public void refreshAllGroups() throws Exception {
        this.agService.refreshAllGroups();
    }

    public void refreshAuthTables(String[] stringArray) throws Exception {
        this.agService.refreshAuthTables(stringArray);
    }

    public void refreshAllAuthTables() throws Exception {
        this.agService.refreshAllAuthTables();
    }

    public void refresh(String[] stringArray) throws Exception {
        this.agService.refresh(stringArray);
    }
}

