/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.management.authorizer.AuthorizationGroup;
import com.ibm.ws.management.authorizer.ResourceInstanceRelations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AuthorizationGroups {
    private static TraceComponent tc = Tr.register(AuthorizationGroups.class, "AuthorizationGroups", "com.ibm.ws.management.authorizer");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private static HashMap authorizationGroups;
    private static HashMap resourceToGroupMap;
    private static AuthorizationGroups groups;

    public static AuthorizationGroups create() {
        if (groups == null) {
            groups = new AuthorizationGroups();
            authorizationGroups = new HashMap(5);
            resourceToGroupMap = new HashMap(25);
        }
        return groups;
    }

    public static AuthorizationGroups getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(adminPermission);
        }
        return groups;
    }

    public synchronized void addGroup(String string, AuthorizationGroup authorizationGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addGroup", string + " " + authorizationGroup);
        }
        authorizationGroups.put(string, authorizationGroup);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addGroup");
        }
    }

    public synchronized AuthorizationGroup getGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroup", string);
        }
        AuthorizationGroup authorizationGroup = null;
        Object v = authorizationGroups.get(string);
        if (v != null) {
            authorizationGroup = (AuthorizationGroup)v;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroup", authorizationGroup);
        }
        return authorizationGroup;
    }

    public synchronized boolean addResource(String string, AuthorizationGroup authorizationGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResource", string + " " + authorizationGroup);
        }
        if (resourceToGroupMap.containsKey(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addResource", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResource", new Boolean(true));
        }
        resourceToGroupMap.put(string, authorizationGroup);
        return true;
    }

    public synchronized AuthorizationGroup getResourceGroup(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceGroup", string);
        }
        AuthorizationGroup authorizationGroup = null;
        Object v = resourceToGroupMap.get(string);
        if (v != null) {
            authorizationGroup = (AuthorizationGroup)v;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceGroup", authorizationGroup);
        }
        return authorizationGroup;
    }

    public synchronized String getResourceGroupName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceGroupName", string);
        }
        String string2 = null;
        Object v = resourceToGroupMap.get(string);
        if (v != null) {
            string2 = ((AuthorizationGroup)v).getGroupName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceGroupName", string2);
        }
        return string2;
    }

    public synchronized List getAllResourceGroups(String string, String string2) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllResourceGroups", string + " " + string2);
        }
        ArrayList arrayList = new ArrayList();
        String string3 = ResourceInstanceRelations.getInstance().convertCfgId(string, string2);
        Object v = resourceToGroupMap.get(string3);
        List list = new ArrayList();
        if (v != null) {
            arrayList.add(v);
            object = (AuthorizationGroup)v;
            list = ((AuthorizationGroup)object).getParentResources(string3);
        } else {
            list = ResourceInstanceRelations.getInstance().getParentInstances(string3, string2);
        }
        object = list.iterator();
        while (object.hasNext()) {
            String string4 = (String)object.next();
            Object v2 = resourceToGroupMap.get(string4);
            arrayList.add(v2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllResourceGroups", arrayList);
        }
        return arrayList;
    }

    public synchronized List getAllResourceGroupNames(String string, String string2) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllResourceGroupNames", string + " " + string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = ResourceInstanceRelations.getInstance().convertCfgId(string, string2);
        Object v = resourceToGroupMap.get(string3);
        List list = new ArrayList();
        if (v != null) {
            object2 = ((AuthorizationGroup)v).getGroupName();
            arrayList.add((String)object2);
            object = (AuthorizationGroup)v;
            list = ((AuthorizationGroup)object).getParentResources(string3);
        } else {
            list = ResourceInstanceRelations.getInstance().getParentInstances(string3, string2);
        }
        object2 = list.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            Object v2 = resourceToGroupMap.get(object);
            if (v2 == null) continue;
            String string4 = ((AuthorizationGroup)v2).getGroupName();
            arrayList.add(string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllResourceGroupNames", arrayList);
        }
        return arrayList;
    }

    public synchronized List getGroupNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = authorizationGroups.keySet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public synchronized Collection getGroups() {
        return authorizationGroups.values();
    }

    public synchronized void flush() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flush");
        }
        authorizationGroups.clear();
        resourceToGroupMap.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flush");
        }
    }

    public void display() {
        Object object;
        Collection collection = authorizationGroups.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (AuthorizationGroup)iterator.next();
            System.out.println(object);
        }
        System.out.println("---------------------");
        object = resourceToGroupMap.keySet();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            System.out.println("Resource = " + string);
            AuthorizationGroup authorizationGroup = (AuthorizationGroup)resourceToGroupMap.get(string);
            System.out.println(authorizationGroup);
        }
    }

    public synchronized void removeGroup(String string) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroup", string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Set set = resourceToGroupMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (AuthorizationGroup)resourceToGroupMap.get(object2);
            if (!((AuthorizationGroup)object).getGroupName().equals(string)) continue;
            arrayList.add(object2);
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            resourceToGroupMap.remove(object);
        }
        authorizationGroups.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroup");
        }
    }

    static {
        groups = null;
    }
}

