/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataPackage;
import com.ibm.websphere.management.cmdframework.commandmetadata.BaseMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupExtension;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadataFactory;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadataPackage;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandProviderMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.Metadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandExtension;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.ParameterTypeTable;
import com.ibm.ws.management.cmdframework.impl.TaskCommandExtComparator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.osgi.framework.Bundle;

public class CommandMetadataMgr {
    private static TraceComponent tc = Tr.register(CommandMetadataMgr.class, "CommandMetadataMgr", "com.ibm.ws.management.resources.cmdframework");
    private static CommandMetadataMgr commandMetadataMgr;
    private static boolean initialized;
    private HashMap cmdGroupMetadataTable;
    private HashMap cmdGroupCommandTable;
    private HashMap cmdProviderInstanceTable;
    private HashMap cmdCommandProviderTable;
    private HashMap cmdGroupResBundleTable;
    private HashMap cmdMetadataTable;
    private Map loadOptions;
    private ArrayList cmdTaskExtsList;
    private ArrayList cmdNewTaskExtsList;
    private ArrayList cmdGrpExtList;
    private EcoreFactory fac;
    private EcorePackage pkg;
    static EFactory eFactory;
    static EPackage cmddataPackage;
    static CommandMetadataFactory cmdMetadataFactory;

    private CommandMetadataMgr(boolean bl) {
        block4: {
            this.cmdGroupMetadataTable = new HashMap();
            this.cmdGroupCommandTable = new HashMap();
            this.cmdProviderInstanceTable = new HashMap();
            this.cmdCommandProviderTable = new HashMap();
            this.cmdGroupResBundleTable = new HashMap();
            this.cmdMetadataTable = new HashMap();
            this.loadOptions = new HashMap(1);
            this.cmdTaskExtsList = new ArrayList();
            this.cmdNewTaskExtsList = new ArrayList();
            this.cmdGrpExtList = new ArrayList();
            this.fac = EcoreFactory.eINSTANCE;
            this.pkg = EcorePackage.eINSTANCE;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CommandMetadataMgr", new Boolean(bl));
            }
            this.initialize();
            if (!bl) {
                try {
                    String string = "META-INF/admin-command-def.xml";
                    this.registerMetaDataUsingv6Mechanism(string);
                    this.registerMetaDataUsingOSGiMechanism(string);
                    this.registerCommandGroupExtensions();
                    this.registerNewTaskExtensions();
                    this.registerTaskExtensions();
                    this.cleanup();
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Exception caught ", throwable);
                }
            }
        }
    }

    private void registerMetaDataUsingOSGiMechanism(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerMetaDataUsingOSGiMechanism", string);
        }
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry != null && ExtensionRegistryFactory.instance().isEclipse()) {
            String string2 = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".admin-command-def";
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string2);
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing extension point " + string2);
                    Tr.debug(tc, "There are " + iExtensionArray.length + " extensions");
                }
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing extension " + iExtensionArray[i].getNamespace());
                    }
                    Bundle bundle = Platform.getBundle((String)iExtensionArray[i].getNamespace());
                    BundleClassLocator bundleClassLocator = new BundleClassLocator(bundle);
                    if (hashSet.contains(bundle)) continue;
                    Enumeration enumeration = bundleClassLocator.locateResources(string);
                    if (enumeration == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Unable to locate resource: " + string);
                        continue;
                    }
                    hashSet.add(bundle);
                    while (enumeration.hasMoreElements()) {
                        try {
                            URL uRL = (URL)enumeration.nextElement();
                            Metadata metadata2 = this.getMetadata(uRL);
                            this.registerMetadata(metadata2, bundleClassLocator);
                        }
                        catch (Throwable throwable) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Exception caught ", throwable);
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to find extension point " + string2);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unable to get eclipse registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMetaDataUsingOSGiMechanism", string);
        }
    }

    private void registerMetaDataUsingv6Mechanism(String string) throws IOException {
        ClassLoaderClassLocator classLoaderClassLocator;
        Enumeration enumeration;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerMetaDataUsingv6Mechanism", string);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ClassLoader being used is " + classLoader);
        }
        if ((enumeration = (classLoaderClassLocator = new ClassLoaderClassLocator(classLoader)).locateResources(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to locate resource: " + string);
            }
        } else {
            while (enumeration.hasMoreElements()) {
                try {
                    URL uRL = (URL)enumeration.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loading data from " + uRL);
                    }
                    Metadata metadata2 = this.getMetadata(uRL);
                    this.registerMetadata(metadata2, classLoaderClassLocator);
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception caught ", throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMetaDataUsingv6Mechanism", string);
        }
    }

    protected Metadata getMetadata(URL uRL) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get Metadata " + uRL.getFile());
        }
        XMLResourceImpl xMLResourceImpl = new XMLResourceImpl();
        try {
            xMLResourceImpl.setURI(URI.createURI((String)uRL.toString()));
            xMLResourceImpl.load(uRL.openStream(), this.loadOptions);
        }
        catch (Exception exception) {
            EList eList = xMLResourceImpl.getErrors();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Exception exception2 = (Exception)iterator.next();
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr", "59", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught " + exception2.getMessage());
            }
        }
        return (Metadata)xMLResourceImpl.getContents().get(0);
    }

    protected void registerMetadata(Metadata metadata2, ClassLocator classLocator) {
        block3: {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Register commands");
                }
                this.registerCommandProviderMetadata(metadata2, classLocator);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception thrown during metadata", exception);
            }
        }
    }

    protected void registerCommandProviderMetadata(Metadata metadata2, ClassLocator classLocator) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get Command Provider Metadata");
        }
        EList eList = metadata2.getCommandProvider();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "provider metadata list size is " + eList.size());
        }
        if (eList != null && !eList.isEmpty()) {
            for (int i = 0; i < eList.size(); ++i) {
                CommandProviderMetadata commandProviderMetadata = (CommandProviderMetadata)eList.get(i);
                this.translate(commandProviderMetadata);
                try {
                    String string = commandProviderMetadata.getImplClass();
                    Class clazz = classLocator.locateClass(string);
                    CommandProvider commandProvider = (CommandProvider)clazz.newInstance();
                    this.cmdProviderInstanceTable.put(commandProviderMetadata.getImplClass(), commandProvider);
                    this.registerCommandGroupMetadata((List)commandProviderMetadata.getCommandGroups());
                    this.registerCommandMetadata(commandProvider.initCommandMetadata((List)commandProviderMetadata.getCommands()));
                    this.registerTaskCommandMetadata(commandProvider.initCommandMetadata((List)commandProviderMetadata.getTaskCommands()));
                    this.addCommandGroupExtensions((List)commandProviderMetadata.getCommandGroupExts());
                    this.addTaskCommandExtensions((List)commandProviderMetadata.getTaskCommandExts());
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Command Provider class not found.", classNotFoundException);
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Command Provider class not be instantiated.", instantiationException);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Command Provider class instantiated illegal access exception..", illegalAccessException);
                    continue;
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Command Provider class: " + commandProviderMetadata.getImplClass() + " cannot be invocated", throwable);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No Command Provider is defined");
        }
    }

    private void translate(CommandProviderMetadata commandProviderMetadata) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translate", commandProviderMetadata);
        }
        if ((string = commandProviderMetadata.getResourceBundle()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceBundle", string);
            }
            Object var3_3 = null;
            Object var4_4 = null;
            TreeIterator treeIterator = commandProviderMetadata.eAllContents();
            while (treeIterator.hasNext()) {
                BaseMetadata baseMetadata;
                Object e2 = treeIterator.next();
                if (e2 instanceof BaseMetadata) {
                    baseMetadata = (BaseMetadata)e2;
                    this.translate(baseMetadata, string, Locale.getDefault());
                }
                if (!(e2 instanceof CommandMetadata)) continue;
                baseMetadata = (CommandMetadata)e2;
                this.translate((CommandMetadata)baseMetadata, string, Locale.getDefault());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translate");
        }
    }

    protected void translate(BaseMetadata baseMetadata, String string, Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translate", new Object[]{baseMetadata, string, locale});
        }
        if ((string == null || string.equals("")) && baseMetadata instanceof CommandGroupMetadata) {
            string = (String)this.cmdGroupResBundleTable.get(baseMetadata.getName());
        }
        String string2 = null;
        String string3 = null;
        if (string != null) {
            string3 = baseMetadata.getDescriptionKey();
            if (string3 != null) {
                string2 = TraceNLS.getStringFromBundle(string, string3, locale);
                baseMetadata.setDescription(string2);
            }
            if ((string3 = baseMetadata.getTitleKey()) != null) {
                string2 = TraceNLS.getStringFromBundle(string, string3, locale);
                baseMetadata.setTitle(string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translate");
        }
    }

    protected void translate(CommandMetadata commandMetadata, String string, Locale locale) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "translate", commandMetadata);
        }
        if (string == null || string.equals("")) {
            object = (ProviderTableEntry)this.cmdCommandProviderTable.get(commandMetadata.getName());
            if (object != null) {
                string = ((ProviderTableEntry)object).getResouceBundle();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cannot find command provider");
            }
        }
        object = null;
        String string2 = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resourceBundle", string);
            }
            if ((string2 = commandMetadata.getTargetObjectDescriptionKey()) != null) {
                object = TraceNLS.getStringFromBundle(string, string2, locale);
                commandMetadata.setTargetObjectDescription((String)object);
            }
            if ((string2 = commandMetadata.getTargetObjectTitleKey()) != null) {
                object = TraceNLS.getStringFromBundle(string, string2, locale);
                commandMetadata.setTargetObjectTitle((String)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "translate");
        }
    }

    protected void registerCommandGroupMetadata(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCommandGroupMetadata");
        }
        ArrayList arrayList = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "group metadata list size is " + list.size());
        }
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CommandGroupMetadata commandGroupMetadata = (CommandGroupMetadata)list.get(i);
                String string = commandGroupMetadata.getName();
                if (!this.cmdGroupMetadataTable.containsKey(string)) {
                    this.cmdGroupMetadataTable.put(string, commandGroupMetadata);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command Group already exist in the group, possibly Command Group name conflict");
                }
                if (!this.cmdGroupCommandTable.containsKey(string)) {
                    this.cmdGroupCommandTable.put(string, new ArrayList());
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command Group already exist in the command group, possibly Command Group name conflict");
                }
                EList eList = commandGroupMetadata.getCommands();
                for (int j = 0; j < eList.size(); ++j) {
                    String string2 = (String)eList.get(j);
                    if (string2 != null && string2.length() != 0) {
                        arrayList = (ArrayList)this.cmdGroupCommandTable.get(string);
                        if (!arrayList.contains(string2)) {
                            arrayList.add(string2);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Command already exist in this group " + string + ", possibly command name conflict");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No command specified for this group");
                }
                String string3 = ((CommandProviderMetadata)commandGroupMetadata.eContainer()).getResourceBundle();
                if (string3 == null || string3.equals("")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resouce bundle is " + string);
                }
                this.cmdGroupResBundleTable.put(string, string3);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No Command Group is defined");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCommandGroupMetadata, ");
        }
    }

    protected void registerCommandGroupExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCommandGroupExtension");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "group extension metadata list size is " + this.cmdGrpExtList.size());
        }
        ArrayList arrayList = null;
        if (this.cmdGrpExtList != null && !this.cmdGrpExtList.isEmpty()) {
            for (int i = 0; i < this.cmdGrpExtList.size(); ++i) {
                CommandGroupExtension commandGroupExtension = (CommandGroupExtension)this.cmdGrpExtList.get(i);
                String string = commandGroupExtension.getName();
                if (this.cmdGroupMetadataTable.containsKey(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "group to add extension is " + string);
                    }
                    try {
                        CommandGroupMetadata commandGroupMetadata = this.getCommandGroupMetadata(string);
                        EList eList = commandGroupMetadata.getCommands();
                        EList eList2 = commandGroupExtension.getCommands();
                        for (int j = 0; j < eList2.size(); ++j) {
                            String string2 = (String)eList2.get(j);
                            if (string2 != null && string2.length() != 0) {
                                arrayList = (ArrayList)this.cmdGroupCommandTable.get(string);
                                if (!arrayList.contains(string2)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "add command " + string2);
                                    }
                                    arrayList.add(string2);
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Command already exist in this group " + string + ", possibly command name conflict");
                                }
                                eList.add((Object)string2);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "No command specified for this extension");
                        }
                        continue;
                    }
                    catch (CommandNotFoundException commandNotFoundException) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Command Group " + string + " does not exist");
                        continue;
                    }
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Command Group " + string + " does not exist");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No Command Group Extension defined");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCommandGroupExtension");
        }
    }

    protected void addCommandGroupExtensions(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCommandGroupExtension");
        }
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                this.cmdGrpExtList.add(list.get(i));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCommandGroupExtension");
        }
    }

    protected void registerTaskCommandMetadata(List list) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "register Task Command Metadata");
        }
        ArrayList<TaskCommandMetadata> arrayList = new ArrayList<TaskCommandMetadata>();
        for (int i = 0; i < list.size(); ++i) {
            TaskCommandMetadata taskCommandMetadata = (TaskCommandMetadata)list.get(i);
            if (!this.validateTaskCommand(taskCommandMetadata)) continue;
            arrayList.add(taskCommandMetadata);
        }
        this.registerCommandMetadata(arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTaskCommandMetadata");
        }
    }

    protected void registerNewTaskExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerNewTaskExtensions");
        }
        if (this.cmdNewTaskExtsList != null && !this.cmdNewTaskExtsList.isEmpty()) {
            for (int i = 0; i < this.cmdNewTaskExtsList.size(); ++i) {
                TaskCommandExtension taskCommandExtension = (TaskCommandExtension)this.cmdNewTaskExtsList.get(i);
                try {
                    String string = taskCommandExtension.getName();
                    if (this.cmdMetadataTable.containsKey(string)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Task command " + string + " extension base exists.  Add to cmdTaskExtsList");
                        }
                        this.cmdTaskExtsList.add(taskCommandExtension);
                        continue;
                    }
                    String string2 = taskCommandExtension.getBaseTaskCommand();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New task command extension to add is  " + string + " Task base command name is " + string2);
                    }
                    if (string2 != null && !string2.equals("")) {
                        TaskCommandMetadata taskCommandMetadata = (TaskCommandMetadata)this.getCommandMetadata(taskCommandExtension.getBaseTaskCommand());
                        TaskCommandMetadata taskCommandMetadata2 = (TaskCommandMetadata)CommandUtility.clone(taskCommandMetadata);
                        taskCommandMetadata2.setName(string);
                        taskCommandMetadata2.setPrivate(taskCommandExtension.isPrivate());
                        CommandProviderMetadata commandProviderMetadata = (CommandProviderMetadata)taskCommandExtension.eContainer();
                        this.cmdCommandProviderTable.put(string, new ProviderTableEntry(commandProviderMetadata.getImplClass(), commandProviderMetadata.getResourceBundle()));
                        this.addTaskExtStepProvider(taskCommandExtension);
                        ArrayList<TaskCommandMetadata> arrayList = new ArrayList<TaskCommandMetadata>();
                        arrayList.add(taskCommandMetadata2);
                        this.registerCommandMetadata(arrayList);
                        this.updateTaskExtStep(taskCommandMetadata2, taskCommandExtension);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Base Task command not found " + string2 + ".  Add to exist list for further processing");
                    }
                    this.cmdTaskExtsList.add(taskCommandExtension);
                    continue;
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Command " + taskCommandExtension.getName() + " not found.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTaskExtensions");
        }
    }

    protected void registerTaskExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerTaskExtensions");
        }
        if (this.cmdTaskExtsList != null && !this.cmdTaskExtsList.isEmpty()) {
            Collections.sort(this.cmdTaskExtsList, new TaskCommandExtComparator());
            for (int i = 0; i < this.cmdTaskExtsList.size(); ++i) {
                TaskCommandExtension taskCommandExtension = (TaskCommandExtension)this.cmdTaskExtsList.get(i);
                String string = taskCommandExtension.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Task command extension to add is  " + string);
                }
                try {
                    TaskCommandMetadata taskCommandMetadata = (TaskCommandMetadata)this.getCommandMetadata(string);
                    this.addTaskExtStepProvider(taskCommandExtension);
                    this.updateTaskExtStep(taskCommandMetadata, taskCommandExtension);
                    continue;
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "task Command not found " + string + ".  Proceed to add new task cmd");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTaskExtensions");
        }
    }

    private void addTaskExtStepProvider(TaskCommandExtension taskCommandExtension) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTaskExtStepProvider", taskCommandExtension.getName());
        }
        String string = taskCommandExtension.getName();
        CommandProviderMetadata commandProviderMetadata = (CommandProviderMetadata)taskCommandExtension.eContainer();
        EList eList = taskCommandExtension.getSteps();
        for (int i = 0; i < eList.size(); ++i) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)eList.get(i);
            String string2 = commandStepMetadata.getName();
            String string3 = this.getStepEClassName(string, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Step name to add to provider table is " + string3);
            }
            this.cmdCommandProviderTable.put(string3, new ProviderTableEntry(commandProviderMetadata.getImplClass(), commandProviderMetadata.getResourceBundle()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTaskExtStepProvider");
        }
    }

    private void updateTaskExtStep(TaskCommandMetadata taskCommandMetadata, TaskCommandExtension taskCommandExtension) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTaskExtStep", taskCommandMetadata.getName());
        }
        EList eList = taskCommandMetadata.getSteps();
        EList eList2 = taskCommandExtension.getSteps();
        ArrayList arrayList = new ArrayList(eList2);
        for (int i = 0; i < arrayList.size(); ++i) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)arrayList.get(i);
            int n = this.getStepIndexFromTask((List)eList, commandStepMetadata);
            if (n >= 0) {
                CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)eList.get(n);
                if (Integer.valueOf(commandStepMetadata.getPriority()) <= Integer.valueOf(commandStepMetadata2.getPriority())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Update step " + commandStepMetadata.getName() + " at index " + n);
                    }
                    eList.remove(n);
                    eList.add(n, commandStepMetadata);
                    continue;
                }
                String string = this.getStepEClassName(taskCommandExtension.getName(), commandStepMetadata.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remove stepname " + string + " in provider table");
                }
                this.cmdCommandProviderTable.remove(string);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add new step " + commandStepMetadata.getName() + " to " + taskCommandMetadata.getName());
            }
            eList.add(commandStepMetadata);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateTaskExtStep");
        }
    }

    private int getStepIndexFromTask(List list, CommandStepMetadata commandStepMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStepIndexFromTask");
        }
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)list.get(i);
            if (!commandStepMetadata2.getName().equals(commandStepMetadata.getName())) continue;
            n = i;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStepIndexFromTask " + n);
        }
        return n;
    }

    protected void addTaskCommandExtensions(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTaskCommandExtensions");
        }
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                TaskCommandExtension taskCommandExtension = (TaskCommandExtension)list.get(i);
                if (!this.validateTaskCommand(taskCommandExtension)) continue;
                this.cmdNewTaskExtsList.add(taskCommandExtension);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTaskCommandExtensions");
        }
    }

    protected void registerCommandMetadataRemote(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCommandMetadataRemote");
        }
        Object var2_2 = null;
        if (list != null && !list.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Size of meta list is " + list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                CommandMetadata commandMetadata = (CommandMetadata)list.get(i);
                if (!this.validateCmdMetadata(commandMetadata)) continue;
                String string = commandMetadata.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command registering is " + string);
                }
                this.cmdMetadataTable.put(string, commandMetadata);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCommandMetadataRemote");
        }
    }

    protected void registerCommandMetadata(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCommandMetadata");
        }
        ArrayList arrayList = null;
        if (list != null && !list.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Size of meta list is " + list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                CommandMetadata commandMetadata = (CommandMetadata)list.get(i);
                if (!this.validateCmdMetadata(commandMetadata)) continue;
                String string = commandMetadata.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command registering is " + string);
                }
                if (commandMetadata.isSupportLocalMode()) {
                    arrayList = (ArrayList)this.cmdGroupCommandTable.get("LocalModeGroup");
                    if (!arrayList.contains(string)) {
                        arrayList.add(string);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command already exist in Local Mode Group, possibly command name conflict");
                    }
                }
                if (!this.cmdMetadataTable.containsKey(string)) {
                    this.cmdMetadataTable.put(string, commandMetadata);
                    if (this.cmdCommandProviderTable.containsKey(string)) continue;
                    object = (CommandProviderMetadata)commandMetadata.eContainer();
                    this.cmdCommandProviderTable.put(string, new ProviderTableEntry(object.getImplClass(), object.getResourceBundle()));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command name conflict, Prioirty will be used");
                }
                object = commandMetadata.getPriority();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command priority is " + (String)object);
                }
                if (object == null || object == "") continue;
                CommandMetadata commandMetadata2 = (CommandMetadata)this.cmdMetadataTable.get(string);
                String string2 = commandMetadata2.getPriority();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original command priority is " + string2);
                }
                if (string2 == null || string2 == "" || Integer.valueOf((String)object) >= Integer.valueOf(string2)) continue;
                this.cmdMetadataTable.put(string, commandMetadata);
                if (this.cmdCommandProviderTable.containsKey(string)) continue;
                CommandProviderMetadata commandProviderMetadata = (CommandProviderMetadata)commandMetadata.eContainer();
                this.cmdCommandProviderTable.put(string, new ProviderTableEntry(commandProviderMetadata.getImplClass(), commandProviderMetadata.getResourceBundle()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCommandMetadata");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EClass getParamDataEClass(String string) throws CommandNotFoundException {
        EClass eClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParamDataEClass", string);
        }
        Object object = cmddataPackage;
        synchronized (object) {
            eClass = (EClass)cmddataPackage.getEClassifier(string);
        }
        if (eClass == null) {
            object = this.getCommandMetadata(string);
            eClass = this.createParamDataEClass(string, (List)object.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParamDataEClass");
        }
        return eClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EClass createParamDataEClass(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParamDataEClass", string);
        }
        EClass eClass = this.fac.createEClass();
        eClass.setName(string);
        if (list != null && !list.isEmpty()) {
            EList eList = eClass.getEStructuralFeatures();
            for (int i = 0; i < list.size(); ++i) {
                EReference eReference;
                String string2;
                ParameterMetadata parameterMetadata = (ParameterMetadata)list.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attribute Name " + i + " is " + parameterMetadata.getName());
                }
                if ((string2 = parameterMetadata.getType()).equals("GenericObject") || string2.equals("javax.management.ObjectName") || !ParameterTypeTable.isPrimitive(string2)) {
                    eReference = this.fac.createEReference();
                    eReference.setContainment(true);
                } else {
                    eReference = this.fac.createEAttribute();
                }
                eReference.setName(parameterMetadata.getName());
                eReference.setEType(ParameterTypeTable.getParamEClassifierType(parameterMetadata.getType()));
                if (parameterMetadata.getDefaultValue() != null) {
                    eReference.setDefaultValue((Object)parameterMetadata.getDefaultValue());
                }
                EPackage ePackage = cmddataPackage;
                synchronized (ePackage) {
                    eList.add(eReference);
                    continue;
                }
            }
        }
        cmddataPackage.getEClassifiers().add((Object)eClass);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParamDataEClass");
        }
        return eClass;
    }

    public EObject createParamDataEObject(String string) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParamDataEObject", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParamDataEObject");
        }
        return eFactory.create(this.getParamDataEClass(string));
    }

    public EObject createParamDataEObject(String string, String string2) throws CommandNotFoundException {
        String string3;
        EClass eClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParamDataEObject", new Object[]{string, string2});
        }
        if ((eClass = (EClass)cmddataPackage.getEClassifier(string3 = this.getStepEClassName(string, string2))) == null) {
            CommandMetadata commandMetadata = this.getCommandMetadata(string);
            CommandMetadata commandMetadata2 = null;
            EList eList = ((TaskCommandMetadata)commandMetadata).getSteps();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Steps are " + eList);
            }
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                CommandStepMetadata commandStepMetadata = (CommandStepMetadata)iterator.next();
                if (!commandStepMetadata.getName().equals(string2)) continue;
                commandMetadata2 = commandStepMetadata;
                break;
            }
            if (commandMetadata2 == null) {
                throw new CommandNotFoundException(string, string2);
            }
            eClass = this.createParamDataEClass(this.getStepEClassName(string, string2), (List)commandMetadata2.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParamDataEObject", eClass.getName());
        }
        return eFactory.create(eClass);
    }

    public Collection listCommandGroups() {
        return Collections.unmodifiableCollection(this.cmdGroupCommandTable.keySet());
    }

    public Collection listCommands(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommands", string);
        }
        if (this.cmdGroupCommandTable.containsKey(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listCommands");
            }
            return Collections.unmodifiableCollection(this.filterCommandsList((Collection)this.cmdGroupCommandTable.get(string)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommands");
        }
        return Collections.EMPTY_SET;
    }

    public Collection listCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommands");
        }
        Collection collection = this.filterCommandsList(this.cmdMetadataTable.keySet());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommands");
        }
        return Collections.unmodifiableCollection(collection);
    }

    public Collection listAllCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllCommands");
        }
        Set set = this.cmdMetadataTable.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllCommands");
        }
        return Collections.unmodifiableCollection(set);
    }

    private Collection filterCommandsList(Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterCommandsList", collection);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                CommandMetadata commandMetadata = this.getCommandMetadata((String)iterator.next());
                if (commandMetadata.isPrivate()) continue;
                arrayList.add(commandMetadata.getName());
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught while filtering commands", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterCommandsList", arrayList);
        }
        return arrayList;
    }

    public CommandProvider getCommandProvider(String string) throws CommandNotFoundException {
        ProviderTableEntry providerTableEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandProvider", string);
        }
        if ((providerTableEntry = (ProviderTableEntry)this.cmdCommandProviderTable.get(string)) != null) {
            String string2 = providerTableEntry.getImplClass();
            CommandProvider commandProvider = (CommandProvider)this.cmdProviderInstanceTable.get(string2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandProvider", commandProvider);
            }
            return commandProvider;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandProvider");
        }
        throw new CommandNotFoundException(string);
    }

    public CommandProvider getCommandProvider(String string, String string2) throws CommandNotFoundException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandProvider", new Object[]{string, string2});
        }
        if (!this.cmdCommandProviderTable.containsKey(string3 = this.getStepEClassName(string, string2))) {
            string3 = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandProvider", string3);
        }
        return this.getCommandProvider(string3);
    }

    public CommandMetadata getCommandMetadata(String string) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata", string);
        }
        if (!this.cmdMetadataTable.containsKey(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CommandName " + string + " does not exist");
            }
            throw new CommandNotFoundException(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command Provider got is " + (CommandProviderMetadata)((CommandMetadata)this.cmdMetadataTable.get(string)).eContainer());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getCommandMetadata" + (CommandMetadata)this.cmdMetadataTable.get(string));
        }
        return (CommandMetadata)this.cmdMetadataTable.get(string);
    }

    public CommandGroupMetadata getCommandGroupMetadata(String string) throws CommandNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getCommandGroupMetadata", string);
        }
        if (!this.cmdGroupMetadataTable.containsKey(string)) {
            throw new CommandNotFoundException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupMetadata");
        }
        return (CommandGroupMetadata)this.cmdGroupMetadataTable.get(string);
    }

    private boolean validateCmdMetadata(CommandMetadata commandMetadata) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validateCmdMetadata", commandMetadata);
        }
        boolean bl = true;
        if (commandMetadata.isTargetObjectAllowed() && (commandMetadata.getTargetObjectType() == null || commandMetadata.getTargetObjectType().equals(""))) {
            Tr.warning(tc, "ADMF0001W", new Object[]{commandMetadata.getName()});
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateCmdMetadata," + bl);
        }
        return bl;
    }

    private boolean validateTaskCommand(EObject eObject) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validateTaskCommand", eObject);
        }
        EList eList = null;
        String string = "";
        boolean bl = true;
        if (eObject instanceof TaskCommandMetadata) {
            eList = ((TaskCommandMetadata)eObject).getSteps();
            string = ((TaskCommandMetadata)eObject).getName();
        } else if (eObject instanceof TaskCommandExtension) {
            eList = ((TaskCommandExtension)eObject).getSteps();
            string = ((TaskCommandExtension)eObject).getName();
        }
        for (int i = 0; i < eList.size(); ++i) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)eList.get(i);
            if (!commandStepMetadata.isTable()) continue;
            EList eList2 = commandStepMetadata.getParameters();
            boolean bl2 = false;
            for (int j = 0; j < eList2.size(); ++j) {
                ParameterMetadata parameterMetadata = (ParameterMetadata)eList2.get(j);
                if (!parameterMetadata.isKeyField()) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "ADMF0002W", new Object[]{string});
            }
            bl = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTaskCommand", new Boolean(bl));
        }
        return bl;
    }

    private void initialize() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "initialize");
        }
        CommandMetadataPackage commandMetadataPackage = CommandMetadataPackage.eINSTANCE;
        cmddataPackage = CommandDataPackage.eINSTANCE;
        cmdMetadataFactory = CommandMetadataFactory.eINSTANCE;
        eFactory = CommandDataFactory.eINSTANCE;
        XMLMapImpl xMLMapImpl = new XMLMapImpl();
        this.loadOptions.put("XML_MAP", xMLMapImpl);
        this.cmdGroupCommandTable.put("LocalModeGroup", new ArrayList());
        this.cmdGroupMetadataTable.put("LocalModeGroup", cmdMetadataFactory.createCommandGroupMetadata());
        initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public String getStepEClassName(String string, String string2) {
        return string + '+' + string2;
    }

    public String[] getTaskStepName(String string) {
        String[] stringArray = new String[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        stringArray[0] = stringTokenizer.nextToken();
        stringArray[1] = stringTokenizer.nextToken();
        return stringArray;
    }

    private String[] resolveStep(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "resolveStep", string);
        }
        String[] stringArray = new String[2];
        int n = string.indexOf(43);
        if (n == -1) {
            stringArray[0] = string;
            stringArray[1] = null;
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveStep");
        }
        return stringArray;
    }

    private String getShortTypeName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getShortTypeName", string);
        }
        String string2 = "";
        int n = string.lastIndexOf(46);
        string2 = n != -1 ? string.substring(n + 1) : string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveStep", string2);
        }
        return string2;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        this.cmdTaskExtsList.clear();
        this.cmdNewTaskExtsList.clear();
        this.cmdGrpExtList.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    private static boolean isComposite(EStructuralFeature eStructuralFeature) {
        boolean bl = true;
        if (eStructuralFeature instanceof EReference) {
            bl = ((EReference)eStructuralFeature).isContainment();
        }
        return bl;
    }

    public static CommandMetadataMgr getInstance() {
        return CommandMetadataMgr.getInstance(false);
    }

    protected static CommandMetadataMgr getInstance(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup", new Boolean(initialized));
        }
        if (!initialized) {
            commandMetadataMgr = new CommandMetadataMgr(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", commandMetadataMgr);
        }
        return commandMetadataMgr;
    }

    static {
        initialized = false;
    }

    private class ProviderTableEntry {
        private String implClass;
        private String resouceBundle;

        public ProviderTableEntry(String string, String string2) {
            this.implClass = string;
            this.resouceBundle = string2;
        }

        public String getImplClass() {
            return this.implClass;
        }

        public String getResouceBundle() {
            return this.resouceBundle;
        }

        public void setImplClass(String string) {
            this.implClass = string;
        }

        public void setResouceBundle(String string) {
            this.resouceBundle = string;
        }
    }

    private class ClassLoaderClassLocator
    implements ClassLocator {
        private ClassLoader _loader;

        public ClassLoaderClassLocator(ClassLoader classLoader) {
            this._loader = classLoader;
        }

        public Class locateClass(final String string) throws ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return ClassLoaderClassLocator.this._loader.loadClass(string);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getCause();
            }
            return clazz;
        }

        public Enumeration locateResources(final String string) throws IOException {
            Enumeration enumeration;
            try {
                enumeration = (Enumeration)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return ClassLoaderClassLocator.this._loader.getResources(string);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getCause();
            }
            return enumeration;
        }
    }

    private class BundleClassLocator
    implements ClassLocator {
        private Bundle _bundle;

        public BundleClassLocator(Bundle bundle) {
            this._bundle = bundle;
        }

        public Class locateClass(final String string) throws ClassNotFoundException {
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return BundleClassLocator.this._bundle.loadClass(string);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getCause();
            }
            return clazz;
        }

        public Enumeration locateResources(final String string) throws IOException {
            Enumeration enumeration;
            try {
                enumeration = (Enumeration)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return BundleClassLocator.this._bundle.getResources(string);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getCause();
            }
            return enumeration;
        }
    }

    private static interface ClassLocator {
        public Class locateClass(String var1) throws ClassNotFoundException;

        public Enumeration locateResources(String var1) throws IOException;
    }
}

