/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CustomProperties;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class CommandSecurityUtil {
    private static TraceComponent tc = Tr.register(CommandSecurityUtil.class, "CommandSecurityUtil", "com.ibm.ws.management.cmdframework");
    private static CommandSecurityUtil cmdSecUtil = new CommandSecurityUtil();
    public static final String REQUIRED_ROLES = "RequiredRoles";
    public static final String DELEGATION_MODE = "DelegationMode";
    public static final String RESOURCE_IDENTIFIER = "ResourceIdentifier";
    public static final String ROLE_DELIM = ":|";
    public static final String RESID_DELIM = "/";
    public static final String PARAM_DELIM = "|";
    public static final String TARGET_OBJECT = "targetObject";

    private CommandSecurityUtil() {
    }

    public static CommandSecurityUtil getInstance() {
        return cmdSecUtil;
    }

    public boolean checkAccess(AdminCommand adminCommand) {
        AdminAuthorizer adminAuthorizer;
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = new String();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", adminCommand);
        }
        if ((adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccess", "No Authorizer (true) ");
            }
            return bl;
        }
        CommandMetadata commandMetadata = adminCommand.getCommandMetadata();
        EList eList = commandMetadata.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " custom = ", eList);
        }
        if (eList != null && !eList.isEmpty()) {
            Object object;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                StringTokenizer stringTokenizer;
                String string2;
                EList eList2;
                object = (CustomProperties)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " custom = ", eList);
                }
                if (object.getKey().equals(REQUIRED_ROLES) && (eList2 = object.getValue()) != null && !eList2.isEmpty()) {
                    string2 = (String)eList2.iterator().next();
                    stringTokenizer = new StringTokenizer(string2, ROLE_DELIM);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " required role = ", string3);
                        }
                        arrayList.add(string3);
                    }
                }
                if (!object.getKey().equals(RESOURCE_IDENTIFIER) || (eList2 = object.getValue()) == null || eList2.isEmpty()) continue;
                string2 = (String)eList2.iterator().next();
                stringTokenizer = new StringTokenizer(string2, RESID_DELIM);
                boolean bl2 = true;
                while (stringTokenizer.hasMoreTokens()) {
                    if (!bl2) {
                        string = string + RESID_DELIM;
                    }
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    String string6 = this.getParamValue(adminCommand, string5);
                    string = string + string4 + RESID_DELIM + string6;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " scope = ", string);
                    }
                    bl2 = false;
                }
            }
            if (string == null) {
                string = new String();
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                bl = false;
                object = (String)iterator.next();
                bl = !((String)object).startsWith("Any-") ? adminAuthorizer.checkAccess(string, (String)object) : true;
                if (!bl) continue;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(bl));
        }
        return bl;
    }

    public String getDelegationMode(AdminCommand adminCommand) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDelegationMode", adminCommand);
        }
        String string = "CallerIdentity";
        AdminAuthorizer adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (adminAuthorizer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDelegationMode", "No Authorizer ");
            }
            return string;
        }
        CommandMetadata commandMetadata = adminCommand.getCommandMetadata();
        EList eList = commandMetadata.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " custom = ", eList);
        }
        if (eList != null && !eList.isEmpty()) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                EList eList2;
                CustomProperties customProperties = (CustomProperties)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " custom = ", eList);
                }
                if (!customProperties.getKey().equals(DELEGATION_MODE) || (eList2 = customProperties.getValue()) == null || eList2.isEmpty()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " delegation mode = ", eList2);
                }
                string = (String)eList2.iterator().next();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDelegationMode", string);
        }
        return string;
    }

    private String getParamValue(AdminCommand adminCommand, String string) {
        String string2;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getParamValue", string);
            }
            string2 = null;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, PARAM_DELIM);
                boolean bl = false;
                String string3 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (!string3.equals(TARGET_OBJECT)) continue;
                    string3 = null;
                    bl = true;
                }
                if (bl) {
                    Object object = adminCommand.getTargetObject();
                    if (object instanceof ObjectName) {
                        object = ObjectName.getInstance((ObjectName)object);
                        string2 = ConfigServiceHelper.getDisplayName((ObjectName)object);
                    } else {
                        string2 = (String)object;
                    }
                }
                if (string2 == null) {
                    string2 = (String)adminCommand.getParameter(string3);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "getParamValue", exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParamValue", string2);
        }
        return string2;
    }
}

