/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.collaborator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.PmiJmxBridge;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public abstract class StatisticsProviderCollaborator
extends RuntimeCollaborator {
    private static TraceComponent tc = Tr.register(StatisticsProviderCollaborator.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private static Class pmiRegistry;
    private static Method getPmiJmxBridgeMethod;
    private boolean isStatisticsProvider = false;
    private PmiJmxBridge bridge;

    public void bindMBean(ModelMBeanInfo modelMBeanInfo, ModelMBean modelMBean) throws Exception {
        Object object;
        ModelMBeanInfo modelMBeanInfo2 = (ModelMBeanInfo)((Object)modelMBean.getMBeanInfo());
        Descriptor descriptor = modelMBeanInfo2.getMBeanDescriptor();
        if (descriptor != null && (object = descriptor.getFieldValue("statisticsProvider")) != null && object.equals(Boolean.TRUE)) {
            this.isStatisticsProvider = true;
            this.routeAttributeToThis(modelMBeanInfo2, "stats");
            this.routeOperationToThis(modelMBeanInfo2, "getStats");
            modelMBean.setModelMBeanInfo(modelMBeanInfo2);
        }
        super.bindMBean(modelMBeanInfo2, modelMBean);
    }

    protected void routeAttributeToThis(ModelMBeanInfo modelMBeanInfo, String string) throws MBeanException {
        Descriptor descriptor = modelMBeanInfo.getDescriptor(string, "attribute");
        if (descriptor != null) {
            descriptor.setField("targetObject", this);
            modelMBeanInfo.setDescriptor(descriptor, "attribute");
        }
    }

    protected void routeOperationToThis(ModelMBeanInfo modelMBeanInfo, String string) throws MBeanException {
        Descriptor descriptor = modelMBeanInfo.getDescriptor(string, "operation");
        if (descriptor != null) {
            descriptor.setField("targetObject", this);
            modelMBeanInfo.setDescriptor(descriptor, "operation");
        }
    }

    public boolean isStatisticsProvider() {
        if (!this.isStatisticsProvider || this.getBridge() == null) {
            return false;
        }
        return this.getBridge().isStatisticsProvider();
    }

    public Stats getStats() {
        if (this.getBridge() == null) {
            return null;
        }
        return this.getBridge().getStats();
    }

    private PmiJmxBridge getBridge() {
        if (this.bridge == null) {
            try {
                this.bridge = (PmiJmxBridge)getPmiJmxBridgeMethod.invoke(null, this.getObjectName());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.management.collaborator.StatisticsProviderCollaborator.setObjectName", "83");
            }
        }
        return this.bridge;
    }

    static {
        try {
            pmiRegistry = Class.forName("com.ibm.ws.pmi.j2ee.PMIJ2EEStatsHelper");
            getPmiJmxBridgeMethod = pmiRegistry.getMethod("getPmiJmxBridge", ObjectName.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.collaborator.StatisticsProviderCollaborator.<cinit>", "56");
        }
    }
}

