/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.CommandGenerator;
import com.ibm.ws.management.commands.LangUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class AdminConfigCommands
implements CommandGenerator {
    private static TraceComponent tc = Tr.register(AdminConfigCommands.class, "AdminConfigCommands", "com.ibm.ws.management.commands");
    public static final String JACL = "jacl";
    public static final String JYTHON = "jython";
    private String commandName = "";
    private String messageKey = "";
    private String jaclScript = "";
    private String jythonScript = "";

    public void setSaveCmdData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSaveCmdData");
        }
        this.commandName = "save";
        this.messageKey = "ADMINCONFIG_HELP_SAVE";
        this.jaclScript = "$AdminConfig save";
        this.jythonScript = "AdminConfig.save()";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSaveCmdData");
        }
    }

    public void setRemoveCmdData(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRemoveCmdData", new Object[]{objectName});
        }
        this.commandName = "remove";
        this.messageKey = "ADMINCONFIG_HELP_REMOVE";
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        this.jaclScript = "$AdminConfig remove \"" + configDataId.toString() + "\"";
        this.jythonScript = "AdminConfig.remove('(" + configDataId.toString() + ")')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRemoveCmdData");
        }
    }

    public void setCreateCmdData(String string, Properties properties, RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCreateCmdData", new Object[]{string, properties, repositoryContext});
        }
        this.commandName = "create";
        this.messageKey = "ADMINCONFIG_HELP_CREATE";
        String string2 = this.transformContextUri(repositoryContext.getURI());
        this.jaclScript = "$AdminConfig create " + string + " [$AdminConfig getid \"" + string2 + "\"] " + LangUtils.formDisplayString(properties, JACL);
        this.jythonScript = "AdminConfig.create('" + string + "', AdminConfig.getid('" + string2 + "'), '" + LangUtils.formDisplayString(properties, JYTHON) + "')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCreateCmdData");
        }
    }

    public void setShowCmdData(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setShowCmdData", new Object[]{objectName});
        }
        this.commandName = "show";
        this.messageKey = "ADMINCONFIG_HELP_SHOW";
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        this.jaclScript = "$AdminConfig show \"" + configDataId.toString() + "\"";
        this.jythonScript = "AdminConfig.show('(" + configDataId.toString() + ")')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setShowCmdData");
        }
    }

    public void setModifyCmdData(ObjectName objectName, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setModifyCmdData", new Object[]{objectName, properties});
        }
        this.commandName = "modify";
        this.messageKey = "ADMINCONFIG_HELP_MODIFY";
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        this.jaclScript = "$AdminConfig modify \"" + configDataId.toString() + "\" " + LangUtils.formDisplayString(properties, JACL);
        this.jythonScript = "AdminConfig.modify('(" + configDataId.toString() + ")', '" + LangUtils.formDisplayString(properties, JYTHON) + "')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setModifyCmdData");
        }
    }

    public void setListCmdData(String string, ObjectName objectName, RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setListCmdData", new Object[]{string, objectName, repositoryContext});
        }
        this.commandName = "list";
        this.messageKey = "ADMINCONFIG_HELP_LIST";
        String string2 = "";
        String string3 = "";
        if (objectName != null) {
            string2 = ConfigServiceHelper.getConfigDataType(objectName);
            string3 = ConfigServiceHelper.getDisplayName(objectName);
        }
        String string4 = this.transformContextUri(repositoryContext.getURI());
        if (string2 != null && string2.length() > 0 && (string3 == null || string3.length() == 0)) {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            this.jaclScript = "$AdminConfig list " + string + " [" + configDataId.toString() + "]";
            this.jythonScript = "AdminConfig.list('" + string + "', '(" + configDataId.toString() + ")')";
        } else {
            String string5;
            String string6 = string4;
            if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 && !string6.endsWith(string5 = string2 + ":" + string3 + "/")) {
                string6 = string6 + string5;
            }
            this.jaclScript = "$AdminConfig list " + string + " [$AdminConfig getid \"" + string6 + "\"]";
            this.jythonScript = "AdminConfig.list('" + string + "', AdminConfig.getid( '" + string6 + "'))";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setListCmdData");
        }
    }

    public String getName() {
        return this.commandName;
    }

    public String generateScript(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateScript", new Object[]{string});
        }
        String string2 = "";
        if (string.equals(JACL)) {
            string2 = this.jaclScript;
        } else if (string.equals(JYTHON)) {
            string2 = this.jythonScript;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateScript", new Object[]{string2});
        }
        return string2;
    }

    public String getDescription(Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescription");
        }
        String string = "";
        if (this.messageKey != null && this.messageKey.length() > 0) {
            string = TraceNLS.getStringFromBundle("com.ibm.ws.scripting.resources.wscpMessage", this.messageKey, locale);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescription", new Object[]{string});
        }
        return string;
    }

    public String toString() {
        return "AdminConfig " + this.getName();
    }

    private String transformContextUri(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformContextUri");
        }
        StringBuffer stringBuffer = new StringBuffer("/");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if ((string2 = String.valueOf(string2.charAt(0)).toUpperCase() + string2.substring(1)).equals("Nodegroups")) {
                string2 = "NodeGroups";
            }
            if (string2.equals("Coregroups")) {
                string2 = "CoreGroups";
            }
            if (string2.equals("Clusters")) {
                string2 = "ServerCluster";
            }
            if (string2.endsWith("s")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            String string3 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            stringBuffer.append(":");
            stringBuffer.append(string3);
            stringBuffer.append("/");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformContextUri", new Object[]{stringBuffer.toString()});
        }
        return stringBuffer.toString();
    }
}

