/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.ws.management.commands.LangUtils;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class AdminServiceCommands
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(AdminServiceCommands.class, "AdminServiceCommands", "com.ibm.ws.management.commands");
    private AdminService adminService = null;

    public AdminServiceCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminServiceCommands");
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        CommandProviderHelper commandProviderHelper = commandMgr.getCommandProviderHelper();
        this.adminService = commandProviderHelper.getAdminService();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminServiceCommands");
        }
    }

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand");
        }
        if ((string = commandMetadata.getName()).equals("adminservice_queryNames")) {
            return new QueryNamesCmd(commandMetadata);
        }
        if (string.equals("adminservice_invoke")) {
            return new InvokeCmd(commandMetadata);
        }
        if (string.equals("adminservice_getAttribute")) {
            return new GetAttributeCmd(commandMetadata);
        }
        if (string.equals("adminservice_getAttributes")) {
            return new GetAttributesCmd(commandMetadata);
        }
        if (string.equals("adminservice_setAttribute")) {
            return new SetAttributeCmd(commandMetadata);
        }
        if (string.equals("adminservice_setAttributes")) {
            return new SetAttributesCmd(commandMetadata);
        }
        if (string.equals("adminservice_getLocalServer")) {
            return new GetLocalServerCmd(commandMetadata);
        }
        if (string.equals("adminservice_getCellName")) {
            return new GetCellNameCmd(commandMetadata);
        }
        if (string.equals("adminservice_getNodeName")) {
            return new GetNodeNameCmd(commandMetadata);
        }
        if (string.equals("adminservice_getProcessName")) {
            return new GetProcessNameCmd(commandMetadata);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot find command " + string + " to create.");
        }
        return super.createCommand(commandMetadata);
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommand");
        }
        if ((string = commandData.getName()).equals("adminservice_queryNames")) {
            return new QueryNamesCmd(commandData);
        }
        if (string.equals("adminservice_invoke")) {
            return new InvokeCmd(commandData);
        }
        if (string.equals("adminservice_getAttribute")) {
            return new GetAttributeCmd(commandData);
        }
        if (string.equals("adminservice_getAttributes")) {
            return new GetAttributesCmd(commandData);
        }
        if (string.equals("adminservice_setAttribute")) {
            return new SetAttributeCmd(commandData);
        }
        if (string.equals("adminservice_setAttributes")) {
            return new SetAttributesCmd(commandData);
        }
        if (string.equals("adminservice_getLocalServer")) {
            return new GetLocalServerCmd(commandData);
        }
        if (string.equals("adminservice_getCellName")) {
            return new GetCellNameCmd(commandData);
        }
        if (string.equals("adminservice_getNodeName")) {
            return new GetNodeNameCmd(commandData);
        }
        if (string.equals("adminservice_getProcessName")) {
            return new GetProcessNameCmd(commandData);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot find command " + string + " to load.");
        }
        return super.loadCommand(commandData);
    }

    class GetProcessNameCmd
    extends SimpleAdminCommand {
        public GetProcessNameCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public GetProcessNameCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            String string = null;
            try {
                this.validate();
                string = AdminServiceCommands.this.adminService.getProcessName();
                commandResultImpl.setResult(string);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", string);
            }
        }

        public String generateScript(String string) {
            return "";
        }
    }

    class GetNodeNameCmd
    extends SimpleAdminCommand {
        public GetNodeNameCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public GetNodeNameCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            String string = null;
            try {
                this.validate();
                string = AdminServiceCommands.this.adminService.getNodeName();
                commandResultImpl.setResult(string);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", string);
            }
        }

        public String generateScript(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateScript", new Object[]{string});
            }
            String string2 = "";
            if (string.equalsIgnoreCase("jacl")) {
                string2 = "$AdminControl getNode";
            } else if (string.equalsIgnoreCase("jython")) {
                string2 = "AdminControl.getNode()";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{string2});
            }
            return string2;
        }
    }

    class GetCellNameCmd
    extends SimpleAdminCommand {
        public GetCellNameCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public GetCellNameCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            String string = null;
            try {
                this.validate();
                string = AdminServiceCommands.this.adminService.getCellName();
                commandResultImpl.setResult(string);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", string);
            }
        }

        public String generateScript(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateScript", new Object[]{string});
            }
            String string2 = "";
            if (string.equalsIgnoreCase("jacl")) {
                string2 = "$AdminControl getCell";
            } else if (string.equalsIgnoreCase("jython")) {
                string2 = "AdminControl.getCell()";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{string2});
            }
            return string2;
        }
    }

    class GetLocalServerCmd
    extends SimpleAdminCommand {
        public GetLocalServerCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public GetLocalServerCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            ObjectName objectName = null;
            try {
                this.validate();
                objectName = AdminServiceCommands.this.adminService.getLocalServer();
                commandResultImpl.setResult(objectName);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", objectName);
            }
        }

        public String generateScript(String string) {
            return "";
        }
    }

    class SetAttributesCmd
    extends SimpleAdminCommand {
        public SetAttributesCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public SetAttributesCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            AttributeList attributeList = null;
            try {
                this.validate();
                ObjectName objectName = (ObjectName)this.getTargetObject();
                AttributeList attributeList2 = (AttributeList)this.getParameter("attributeList");
                attributeList = AdminServiceCommands.this.adminService.setAttributes(objectName, attributeList2);
                commandResultImpl.setResult(attributeList);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", attributeList);
            }
        }

        public String generateScript(String string) {
            String string2;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{string});
                }
                string2 = "";
                try {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string3 = LangUtils.formDisplayString(objectName, string);
                    AttributeList attributeList = (AttributeList)this.getParameter("attributeList");
                    String string4 = LangUtils.formDisplayString(attributeList, string);
                    if (string.equalsIgnoreCase("jacl")) {
                        string2 = "$AdminControl setAttributes " + string3 + " " + string4;
                    } else if (string.equalsIgnoreCase("jython")) {
                        string2 = "AdminControl.setAttributes('" + string3 + "', '" + string4 + "')";
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + string + ") for setAttributes command. " + exception.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{string2});
            }
            return string2;
        }
    }

    class SetAttributeCmd
    extends SimpleAdminCommand {
        public SetAttributeCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public SetAttributeCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            try {
                this.validate();
                ObjectName objectName = (ObjectName)this.getTargetObject();
                Attribute attribute = (Attribute)this.getParameter("attribute");
                AdminServiceCommands.this.adminService.setAttribute(objectName, attribute);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute");
            }
        }

        public String generateScript(String string) {
            String string2;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{string});
                }
                string2 = "";
                try {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string3 = LangUtils.formDisplayString(objectName, string);
                    Attribute attribute = (Attribute)this.getParameter("attribute");
                    String string4 = attribute.getName();
                    Object object = attribute.getValue();
                    String string5 = LangUtils.formDisplayString(object, string);
                    if (string.equalsIgnoreCase("jacl")) {
                        string2 = "$AdminControl setAttribute " + string3 + " " + string4 + " " + object;
                    } else if (string.equalsIgnoreCase("jython")) {
                        string2 = "AdminControl.setAttribute('" + string3 + "', '" + string4 + "', '" + object + "')";
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + string + ") for setAttribute command. " + exception.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{string2});
            }
            return string2;
        }
    }

    class GetAttributesCmd
    extends SimpleAdminCommand {
        public GetAttributesCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public GetAttributesCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            AttributeList attributeList = null;
            try {
                this.validate();
                ObjectName objectName = (ObjectName)this.getTargetObject();
                String[] stringArray = (String[])this.getParameter("attributes");
                attributeList = AdminServiceCommands.this.adminService.getAttributes(objectName, stringArray);
                commandResultImpl.setResult(attributeList);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", attributeList);
            }
        }

        public String generateScript(String string) {
            String string2;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{string});
                }
                string2 = "";
                try {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string3 = LangUtils.formDisplayString(objectName, string);
                    String[] stringArray = (String[])this.getParameter("attributes");
                    String string4 = LangUtils.formDisplayString(stringArray, string);
                    if (string.equalsIgnoreCase("jacl")) {
                        string2 = "$AdminControl getAttributes " + string3 + " " + string4;
                    } else if (string.equalsIgnoreCase("jython")) {
                        string2 = "AdminControl.getAttributes('" + string3 + "', '" + string4 + "')";
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + string + ") for getAttributes command. " + exception.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{string2});
            }
            return string2;
        }
    }

    class GetAttributeCmd
    extends SimpleAdminCommand {
        public GetAttributeCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public GetAttributeCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            Object object = null;
            try {
                this.validate();
                ObjectName objectName = (ObjectName)this.getTargetObject();
                String string = (String)this.getParameter("attribute");
                object = AdminServiceCommands.this.adminService.getAttribute(objectName, string);
                commandResultImpl.setResult(object);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", object);
            }
        }

        public String generateScript(String string) {
            String string2;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{string});
                }
                string2 = "";
                try {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string3 = LangUtils.formDisplayString(objectName, string);
                    String string4 = (String)this.getParameter("attribute");
                    if (string.equalsIgnoreCase("jacl")) {
                        string2 = "$AdminControl getAttribute " + string3 + " " + string4;
                    } else if (string.equalsIgnoreCase("jython")) {
                        string2 = "AdminControl.getAttribute('" + string3 + "', '" + string4 + "')";
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + string + ") for getAttribute command. " + exception.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{string2});
            }
            return string2;
        }
    }

    class InvokeCmd
    extends SimpleAdminCommand {
        public InvokeCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public InvokeCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            Object object = null;
            try {
                this.validate();
                ObjectName objectName = (ObjectName)this.getTargetObject();
                String string = (String)this.getParameter("operation");
                Object[] objectArray = (Object[])this.getParameter("params");
                String[] stringArray = (String[])this.getParameter("signature");
                object = AdminServiceCommands.this.adminService.invoke(objectName, string, objectArray, stringArray);
                commandResultImpl.setResult(object);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", object);
            }
        }

        public String generateScript(String string) {
            String string2;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{string});
                }
                string2 = "";
                try {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string3 = LangUtils.formDisplayString(objectName, string);
                    String string4 = (String)this.getParameter("operation");
                    Object[] objectArray = (Object[])this.getParameter("params");
                    String string5 = LangUtils.formDisplayString(objectArray, string);
                    String[] stringArray = (String[])this.getParameter("signature");
                    String string6 = LangUtils.formDisplayString(stringArray, string);
                    if (string.equalsIgnoreCase("jacl")) {
                        string2 = "$AdminControl invoke " + string3 + " " + string4 + (string5.length() == 0 ? "" : (string6.length() == 0 ? " " + string5 : " " + string5 + " " + string6));
                    } else if (string.equalsIgnoreCase("jython")) {
                        string2 = "AdminControl.invoke('" + string3 + "', '" + string4 + (string5.length() == 0 ? "" : (string6.length() == 0 ? "', '" + string5 : "', '" + string5 + "', '" + string6)) + "')";
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + string + ") for invoke command. " + exception.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{string2});
            }
            return string2;
        }
    }

    class QueryNamesCmd
    extends SimpleAdminCommand {
        public QueryNamesCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public QueryNamesCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{this});
            }
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            Set set = null;
            try {
                this.validate();
                ObjectName objectName = (ObjectName)this.getParameter("objname");
                QueryExp queryExp = (QueryExp)this.getParameter("query");
                set = AdminServiceCommands.this.adminService.queryNames(objectName, queryExp);
                commandResultImpl.setResult(set);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
            this.setCommandResult(commandResultImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", set);
            }
        }

        public String generateScript(String string) {
            String string2;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "generateScript", new Object[]{string});
                }
                string2 = "";
                try {
                    ObjectName objectName = (ObjectName)this.getParameter("objname");
                    QueryExp queryExp = (QueryExp)this.getParameter("query");
                    String string3 = LangUtils.formDisplayString(objectName, string);
                    String string4 = LangUtils.formDisplayString(queryExp, string);
                    if (string.equalsIgnoreCase("jacl")) {
                        string2 = "$AdminControl queryNames " + string3 + (string4.length() == 0 ? "" : " " + string4);
                    } else if (string.equalsIgnoreCase("jython")) {
                        string2 = "AdminControl.queryNames('" + string3 + (string4.length() == 0 ? "" : "', '" + string4) + "')";
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception in generateScript(" + string + ") for queryNames command. " + exception.getMessage());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateScript", new Object[]{string2});
            }
            return string2;
        }
    }
}

