/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleAdminCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import java.util.HashMap;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigServiceCommandProvider
extends CommandProvider {
    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        return new ConfigServiceCommand(commandMetadata);
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        return new ConfigServiceCommand(commandData);
    }

    private class ConfigServiceCommand
    extends SimpleAdminCommand {
        public ConfigServiceCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public ConfigServiceCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        public void execute() {
            CommandMetadata commandMetadata = this.getCommandMetadata();
            String string = commandMetadata.getName();
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            Session session = this.getConfigSession();
            ConfigService configService = commandProviderHelper.getConfigService();
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            Object object = null;
            try {
                this.validate();
                if (string.equals("configservice_save")) {
                    Object object2 = this.getParameter("overwriteOnConflict");
                    configService.save(session, (Boolean)object2);
                } else if (string.equals("configservice_discard")) {
                    configService.discard(session);
                } else if (string.equals("configservice_getUnsavedChanges")) {
                    object = configService.getUnsavedChanges(session);
                } else if (string.equals("configservice_getConflictDocuments")) {
                    object = configService.getConflictDocuments(session);
                } else if (string.equals("configservice_getSupportedConfigObjectTypes")) {
                    object = configService.getSupportedConfigObjectTypes();
                } else if (string.equals("configservice_getRelationshipsMetaInfo")) {
                    String string2 = (String)this.getParameter("configObjectType");
                    object = configService.getRelationshipsMetaInfo(string2);
                } else if (string.equals("configservice_getAttributesMetaInfo")) {
                    String string3 = (String)this.getParameter("configObjectType");
                    object = configService.getAttributesMetaInfo(string3);
                } else if (string.equals("configservice_queryConfigObjects")) {
                    ObjectName objectName = (ObjectName)this.getParameter("scope");
                    ObjectName objectName2 = (ObjectName)this.getParameter("pattern");
                    object = configService.queryConfigObjects(session, objectName, objectName2, null);
                } else if (string.equals("configservice_queryTemplates")) {
                    String string4 = (String)this.getParameter("type");
                    object = configService.queryTemplates(session, string4);
                } else if (string.equals("configservice_resolve")) {
                    String string5 = (String)this.getParameter("containmentPath");
                    object = configService.resolve(session, string5);
                } else if (string.equals("configservice_setProperties")) {
                    HashMap hashMap = (HashMap)this.getParameter("props");
                    configService.setProperties(session, hashMap);
                } else if (string.equals("configservice_validate")) {
                    ObjectName objectName = (ObjectName)this.getParameter("scope");
                    configService.validate(session, objectName);
                } else if (string.equals("configservice_createConfigData")) {
                    ObjectName objectName = (ObjectName)this.getParameter("parent");
                    String string6 = (String)this.getParameter("attributeName");
                    String string7 = (String)this.getParameter("type");
                    AttributeList attributeList = (AttributeList)this.getParameter("attrList");
                    object = configService.createConfigData(session, objectName, string6, string7, attributeList);
                } else if (string.equals("configservice_createConfigDataByTemplate")) {
                    ObjectName objectName = (ObjectName)this.getParameter("parent");
                    String string8 = (String)this.getParameter("attributeName");
                    AttributeList attributeList = (AttributeList)this.getParameter("attrList");
                    ObjectName objectName3 = (ObjectName)this.getParameter("template");
                    object = configService.createConfigDataByTemplate(session, objectName, string8, attributeList, objectName3);
                } else if (string.equals("configservice_setAttributes")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    AttributeList attributeList = (AttributeList)this.getParameter("attrList");
                    configService.setAttributes(session, objectName, attributeList);
                } else if (string.equals("configservice_addElement")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string9 = (String)this.getParameter("attribute");
                    Object object3 = this.getParameter("element");
                    Integer n = (Integer)this.getParameter("index");
                    configService.addElement(session, objectName, string9, object3, n == null ? -1 : n);
                } else if (string.equals("configservice_removeElement")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string10 = (String)this.getParameter("attribute");
                    Object object4 = this.getParameter("element");
                    configService.removeElement(session, objectName, string10, object4);
                } else if (string.equals("configservice_unsetAttributes")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String[] stringArray = (String[])this.getParameter("attributes");
                    configService.unsetAttributes(session, objectName, stringArray);
                } else if (string.equals("configservice_resetAttributes")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    AttributeList attributeList = (AttributeList)this.getParameter("attrList");
                    configService.resetAttributes(session, objectName, attributeList);
                } else if (string.equals("configservice_getAttributes")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String[] stringArray = (String[])this.getParameter("attributes");
                    Boolean bl = (Boolean)this.getParameter("recursive");
                    object = configService.getAttributes(session, objectName, stringArray, bl == null ? false : bl);
                } else if (string.equals("configservice_getAttribute")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string11 = (String)this.getParameter("attribute");
                    object = configService.getAttribute(session, objectName, string11);
                } else if (string.equals("configservice_deleteConfigData")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    configService.deleteConfigData(session, objectName);
                } else if (string.equals("configservice_getRelationship")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String string12 = (String)this.getParameter("relationship");
                    object = configService.getRelationship(session, objectName, string12);
                } else if (string.equals("configservice_getRelationships")) {
                    ObjectName objectName = (ObjectName)this.getTargetObject();
                    String[] stringArray = (String[])this.getParameter("relationships");
                    object = configService.getRelationships(session, objectName, stringArray);
                }
                commandResultImpl.setResult(object);
                this.setCommandResult(commandResultImpl);
            }
            catch (Throwable throwable) {
                commandResultImpl.setException(throwable);
            }
        }
    }
}

