/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class LangUtils {
    private static TraceComponent tc = Tr.register(LangUtils.class, "LangUtils", "com.ibm.ws.management.commands");
    private static LangUtils langUtils = null;

    public static String formDisplayString(Object object, String string) {
        if (langUtils == null) {
            langUtils = new LangUtils();
        }
        return langUtils.makeString(object, string);
    }

    private LangUtils() {
    }

    private String makeString(Object object, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeString", new Object[]{object, string});
        }
        String string2 = new String();
        if (object != null && string != null) {
            if (object instanceof Properties) {
                string2 = this.propertiesToString((Properties)object, string);
            } else if (object instanceof ObjectName) {
                try {
                    string2 = this.objectNameToString((ObjectName)object);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, exception.getMessage());
                    }
                }
            } else {
                string2 = object.getClass().isArray() ? this.arrayToString((Object[])object, string) : (object instanceof AttributeList ? this.AttributeListToString((AttributeList)object, string) : (object instanceof Collection ? this.collectionToString((Collection)object, string) : object.toString()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeString", new Object[]{string2});
        }
        return string2;
    }

    private String getOpenOptionSyntax(String string) {
        String string2 = "";
        if (string.equalsIgnoreCase("jacl")) {
            string2 = "{";
        } else if (string.equalsIgnoreCase("jython")) {
            string2 = "[";
        }
        return string2;
    }

    private String getCloseOptionSyntax(String string) {
        String string2 = "";
        if (string.equalsIgnoreCase("jacl")) {
            string2 = "}";
        } else if (string.equalsIgnoreCase("jython")) {
            string2 = "]";
        }
        return string2;
    }

    private String objectNameToString(ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectNameToString", new Object[]{objectName});
        }
        String string = new String();
        String string2 = objectName.getKeyProperty("_Websphere_Config_Data_Id");
        if (string2 != null) {
            Class<?> clazz = Class.forName("com.ibm.ws.scripting.ObjectNameHelper");
            Method method2 = clazz.getMethod("getListingName", ObjectName.class);
            Object object = method2.invoke(clazz, objectName);
            string = object.toString();
        } else {
            string = objectName.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectNameToString", new Object[]{string});
        }
        return string;
    }

    private String propertiesToString(Properties properties, String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString", new Object[]{properties, string});
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(this.getOpenOptionSyntax(string));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string3 == null) {
                string3 = "null";
            }
            if ((string3 = string3.trim()).length() > 0 && string3.indexOf(32) != -1) {
                if (!string3.startsWith("\"") && !string3.startsWith(this.getOpenOptionSyntax(string))) {
                    string3 = "\"" + string3;
                }
                if (!string3.endsWith("\"") && !string3.endsWith(this.getCloseOptionSyntax(string))) {
                    string3 = string3 + "\"";
                }
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.getOpenOptionSyntax(string));
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(string3);
            stringBuffer.append(this.getCloseOptionSyntax(string));
        }
        stringBuffer.append(this.getCloseOptionSyntax(string));
        string2 = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString", new Object[]{string2});
        }
        return string2;
    }

    private String arrayToString(Object[] objectArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayToString", new Object[]{objectArray, string});
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(this.getOpenOptionSyntax(string));
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            String string2 = this.makeString(object, string);
            if ((string2 = string2.trim()).length() == 0) continue;
            if (string2.indexOf(32) != -1) {
                if (!string2.startsWith("\"") && !string2.startsWith(this.getOpenOptionSyntax(string))) {
                    string2 = "\"" + string2;
                }
                if (!string2.endsWith("\"") && !string2.endsWith(this.getCloseOptionSyntax(string))) {
                    string2 = string2 + "\"";
                }
            }
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append(this.getCloseOptionSyntax(string));
        String string3 = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayToString", new Object[]{string3});
        }
        return string3;
    }

    private String AttributeListToString(AttributeList attributeList, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AttributeListToString", new Object[]{attributeList, string});
        }
        Properties properties = new Properties();
        for (int i = 0; i < attributeList.size(); ++i) {
            String string2 = ((Attribute)attributeList.get(i)).getName();
            Object object = ((Attribute)attributeList.get(i)).getValue();
            if (object != null) {
                properties.setProperty(string2, this.makeString(object, string));
                continue;
            }
            properties.setProperty(string2, "null");
        }
        String string3 = this.propertiesToString(properties, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AttributeListToString", new Object[]{string3});
        }
        return string3;
    }

    private String collectionToString(Collection collection, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectionToString", new Object[]{collection, string});
        }
        String string2 = this.arrayToString(collection.toArray(), string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectionToString", new Object[]{string2});
        }
        return string2;
    }
}

