/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class UpdateClusterCommand
extends AbstractAdminCommand
implements NotificationListener {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static TraceComponent tc = Tr.register(UpdateClusterCommand.class, "UpdateClusterCommand", "com.ibm.ws.management.commands.application");
    private static String APPNAME_PARAM = "ApplicationName";
    private static String TIMEOUT_PARAM = "timeout";
    private static final String UPDATEAPPONCLUSTERTASK_WAIT_PROP = "com.ibm.websphere.management.application.updateapponcluster.timeout";
    private String waitTarget = null;
    private long WAIT_TIME = 3600000L;
    private String waitObject = null;
    private ArrayList res = new ArrayList();
    private boolean successFlag = false;
    private AppManagementProxy appM = null;
    private WorkSpace ws = null;
    private String[] appNames = null;

    public UpdateClusterCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        this.waitObject = new String("UpdateClusterCommandWaitObject");
    }

    public UpdateClusterCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.waitObject = new String("UpdateClusterCommandWaitObject");
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.appNames = (String[])this.getParameter("ApplicationNames");
        Locale locale = this.getLocale();
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
        hashtable.put("app.client.locale", locale);
        try {
            for (int i = 0; i < this.appNames.length; ++i) {
                boolean bl = this.appM.checkIfAppExists(this.appNames[i], hashtable, this.ws.getUserName());
                if (!bl) {
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(this.appNames[i]);
                    String string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.AppDeploymentMessages", "ADMA5045E", locale, new Object[]{this.appNames[i]}, "The application name " + this.appNames[i] + " cannot be found under any cell in the repository.");
                    this.res.add(string);
                    Tr.error(tc, string);
                    continue;
                }
                vector.add(this.appNames[i]);
            }
        }
        catch (AdminException adminException) {
            throw new CommandValidationException(adminException, adminException.getMessage());
        }
        if (vector.size() == 0) {
            throw new InvalidParameterValueException(this.getName(), "ApplicationNames", "\"" + stringBuffer.toString() + "\"");
        }
        if (stringBuffer.length() > 0) {
            this.appNames = new String[vector.size()];
            vector.toArray(this.appNames);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resetting the command result.");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        try {
            String string;
            Integer n;
            Hashtable<String, Locale> hashtable;
            block35: {
                CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
                ConfigService configService = commandProviderHelper.getConfigService();
                Session session = this.getConfigSession();
                Properties properties = new Properties();
                properties.setProperty("workspace.user.id", session.toString());
                this.ws = WorkSpaceManagerFactory.getManager().getWorkSpace(properties);
                this.appM = (AppManagementProxy)AppManagementProxy.getJMXProxyForServer();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating " + this.getName() + " command.");
                }
                this.validate();
                if (this.appNames == null) {
                    this.appNames = (String[])this.getParameter("ApplicationNames");
                }
                hashtable = new Hashtable<String, Locale>();
                hashtable.put("app.client.locale", this.getLocale());
                String string2 = new String();
                for (int i = 0; i < this.appNames.length; ++i) {
                    string2 = string2.concat(this.appNames[i]);
                    if (i >= this.appNames.length - 1) continue;
                    string2 = string2.concat(";");
                }
                n = (Integer)this.getParameter("timeout");
                String string3 = "UpdateCluster:" + string2;
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.admin.appmgmt");
                AdminServiceFactory.getAdminService().addNotificationListener(this.getAppMObjectName(), this, (NotificationFilter)notificationFilterSupport, (Object)string3);
                if (System.getProperty(UPDATEAPPONCLUSTERTASK_WAIT_PROP) != null) {
                    string = System.getProperty(UPDATEAPPONCLUSTERTASK_WAIT_PROP);
                    try {
                        this.WAIT_TIME = Long.parseLong(string) * 1000L;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block35;
                        Tr.debug(tc, "Invalid UpdateAppOnCluster time out value - " + string);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting to update clusters.");
            }
            string = this.waitObject;
            synchronized (string) {
                this.appM.updateCluster(this.appNames, n, hashtable, this.ws.getUserName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UpdateAppOnCluster Wait time: " + this.WAIT_TIME / 1000L + "secs");
                }
                this.waitTarget = "UpdateCluster";
                this.waitObject.wait(this.WAIT_TIME);
                if (this.waitTarget != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Time out performing cluster update " + this.getName());
                    }
                    this.res.add("operation timed out.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting result of " + this.getName());
            }
            commandResultImpl.setResult(this.res);
        }
        catch (CommandValidationException commandValidationException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "command validation failed with exception", commandValidationException);
            }
            this.appM = null;
            commandResultImpl.setException(commandValidationException);
            commandResultImpl.setResult(this.res);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "command execution failed with exception", exception);
            }
            commandResultImpl.setException(exception);
            commandResultImpl.setResult(this.res);
        }
        finally {
            try {
                if (this.appM != null) {
                    AdminServiceFactory.getAdminService().removeNotificationListener(this.getAppMObjectName(), this);
                }
            }
            catch (Exception exception) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification" + notification + " " + object);
        }
        if (notification == null) {
            return;
        }
        Object object2 = notification.getUserData();
        if (object2 instanceof AppNotification) {
            this.appEventReceived((AppNotification)object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appEventReceived(AppNotification appNotification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appEventReceived " + appNotification);
        }
        String string = appNotification.message;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event received : " + appNotification.toString());
        }
        String string2 = this.waitObject;
        synchronized (string2) {
            if (appNotification.taskName.equals(this.waitTarget) && appNotification.taskStatus.equals("Completed") || appNotification.taskStatus.equals("Failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "received : " + appNotification.taskStatus);
                }
                this.res.add(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got STATUS_COMPLETED");
                }
                this.successFlag = appNotification.taskStatus.equals("Completed");
                this.waitTarget = null;
                this.waitObject.notifyAll();
            } else if (appNotification.taskName.equals(this.waitTarget)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "received : " + string);
                }
                this.res.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appEventReceived");
        }
    }

    private ObjectName getAppMObjectName() throws Exception {
        String string = "WebSphere:type=AppManagement,process=";
        string = string + AdminServiceFactory.getAdminService().getProcessName();
        string = string + ",*";
        ObjectName objectName = new ObjectName(string);
        Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
        return (ObjectName)iterator.next();
    }
}

