/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.authzgroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.authorizer.ResourceInstanceRelations;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.util.AdminCommandHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class AuthzGroupCommandsProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(AuthzGroupCommandsProvider.class, "management", "com.ibm.ws.management.resources.configservice");

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        String string = commandMetadata.getName();
        if (string.equals("addResourceToAuthorizationGroup")) {
            return new AddResourceToAuthorizationGroupCmd(commandMetadata);
        }
        return super.createCommand(commandMetadata);
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        String string = commandData.getName();
        if (string.equals("addResourceToAuthorizationGroup")) {
            return new AddResourceToAuthorizationGroupCmd(commandData);
        }
        return super.loadCommand(commandData);
    }

    public String createAuthorizationGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthorizationGroup", new Object[]{abstractAdminCommand});
        }
        ObjectName objectName = null;
        try {
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string2 = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + string2);
            }
            if (string2 == null || string2.equals("CellAuthorizationGroup") || string2.equals("merge")) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "authorizationGroupName", string2);
            }
            ObjectName[] objectNameArray = this.getAuthzGroupObjectName(session, configService, string2);
            if (objectNameArray != null && objectNameArray.length > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization Group: " + string2 + " already existed");
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "authorizationGroupName", string2);
            }
            ObjectName objectName2 = this.getCellObjectName(session, configService);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "name", string2);
            objectName = configService.createConfigData(session, objectName2, "AuthorizationGroup", "AuthorizationGroup", attributeList);
            this.createAuthzTableDocument(session, configService, objectName);
            String string3 = ConfigServiceHelper.getConfigDataId(objectName).toString();
            AttributeList attributeList2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList2, "resourceName", string3);
            ConfigServiceHelper.setAttributeValue(attributeList2, "resourceType", "AuthorizationGroup");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resources attributes to be set are " + attributeList2);
            }
            configService.createConfigData(session, objectName, "members", "AuthorizationGroupMember", attributeList2);
            string = string3;
        }
        catch (Exception exception) {
            try {
                FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.createAuthorizationGroup", "88");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", exception);
                }
                throw exception;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createAuthorizationGroup", objectName);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthorizationGroup", objectName);
        }
        return string;
    }

    public boolean deleteAuthorizationGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAuthorizationGroup", new Object[]{abstractAdminCommand});
        }
        try {
            ObjectName objectName;
            ObjectName[] objectNameArray;
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name to delete is " + string);
            }
            if ((objectNameArray = this.getAuthzGroupObjectName(session, configService, string)) != null && objectNameArray.length == 1) {
                objectName = objectNameArray[0];
                ObjectName[] objectNameArray2 = configService.resolve(session, objectName, "AuthorizationTableExt");
                if (objectNameArray2 != null && objectNameArray2.length != 0) {
                    ObjectName objectName2 = objectNameArray2[0];
                    configService.deleteConfigData(session, objectName2);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "No authorization group: " + string + " found or more than one authorization group found");
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "authorizationGroupName", string);
            }
            configService.deleteConfigData(session, objectName);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.createAuthorizationGroup", "88");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteAuthorizationGroup");
            }
        }
    }

    public boolean removeResourceFromAuthorizationGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAuthorizationGroup", new Object[]{abstractAdminCommand});
        }
        try {
            int n;
            Object object;
            ObjectName[] objectNameArray;
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            String string2 = (String)abstractAdminCommand.getParameter("resourceName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorization group name is " + string);
            }
            if ((objectNameArray = AdminCommandHelper.getResources(session, configService, string2)) == null || objectNameArray.length != 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource is not unique or does not exist. " + string2);
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "resourceName", string2);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = null;
            if (string == null || string.equals("")) {
                object = this.getAuthzGroupObjectName(session, configService, null);
                objectName2 = this.findAuthzGroupsWithGivenResource(session, configService, (ObjectName[])object, objectName);
            } else {
                object = this.getAuthzGroupObjectName(session, configService, string);
                if (object != null) {
                    objectName2 = object[0];
                }
            }
            if (objectName2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find the authorization group which contains the resource, " + string2);
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "resourceName", string2);
            }
            object = ConfigServiceHelper.getConfigDataId(objectName).toString();
            String string3 = ResourceInstanceRelations.getInstance().getResourceType((String)object);
            if (string3 != null && string3.equals("AuthorizationGroup")) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "resourceName", string2);
            }
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "members", false);
            for (n = 0; n < arrayList.size(); ++n) {
                ObjectName objectName3 = (ObjectName)arrayList.get(n);
                String string4 = (String)configService.getAttribute(session, objectName3, "resourceName");
                if (!string4.equals(object)) continue;
                configService.deleteConfigData(session, objectName3);
                break;
            }
            n = 1;
            return n != 0;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.createAuthorizationGroup", "88");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteAuthorizationGroup");
            }
        }
    }

    public boolean mapUsersToAdminRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapUsersToAdminRole", new Object[]{abstractAdminCommand});
        }
        try {
            List list;
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            String string2 = (String)abstractAdminCommand.getParameter("roleName");
            String[] stringArray = (String[])abstractAdminCommand.getParameter("userids");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + string);
            }
            if (!(list = this.addRemoveRoleOrGroupID(session, configService, abstractAdminCommand.getName(), string, string2, stringArray, null)).isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer("Invalid userids are : ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    stringBuffer.append(string3);
                    stringBuffer.append(" ");
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "userids", stringBuffer.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.mapUsersToAdminRole", "200");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapUsersToAdminRole");
            }
        }
    }

    public boolean mapGroupsToAdminRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapGroupsToAdminRole", new Object[]{abstractAdminCommand});
        }
        try {
            List list;
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            String string2 = (String)abstractAdminCommand.getParameter("roleName");
            String[] stringArray = (String[])abstractAdminCommand.getParameter("groupids");
            String[] stringArray2 = (String[])abstractAdminCommand.getParameter("specialSubjects");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + string);
            }
            if (!(list = this.addRemoveRoleOrGroupID(session, configService, abstractAdminCommand.getName(), string, string2, stringArray, stringArray2)).isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer("Invalid groupids are : ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    stringBuffer.append(string3);
                    stringBuffer.append(" ");
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "groupids", stringBuffer.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.mapGroupsToAdminRole", "241");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapGroupsToAdminRole");
            }
        }
    }

    public boolean removeUsersFromAdminRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUsersFromAdminRole", new Object[]{abstractAdminCommand});
        }
        try {
            List list;
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            String string2 = (String)abstractAdminCommand.getParameter("roleName");
            String[] stringArray = (String[])abstractAdminCommand.getParameter("userids");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + string);
            }
            if (!(list = this.addRemoveRoleOrGroupID(session, configService, abstractAdminCommand.getName(), string, string2, stringArray, null)).isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer("Invalid userids are : ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    stringBuffer.append(string3);
                    stringBuffer.append(" ");
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "userids", stringBuffer.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.removeUsersFromAdminRole", "242");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeUsersFromAdminRole");
            }
        }
    }

    public boolean removeGroupsFromAdminRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeGroupsFromAdminRole", new Object[]{abstractAdminCommand});
        }
        try {
            List list;
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            String string2 = (String)abstractAdminCommand.getParameter("roleName");
            String[] stringArray = (String[])abstractAdminCommand.getParameter("groupids");
            String[] stringArray2 = (String[])abstractAdminCommand.getParameter("specialSubjects");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroups name is " + string);
            }
            if (!(list = this.addRemoveRoleOrGroupID(session, configService, abstractAdminCommand.getName(), string, string2, stringArray, stringArray2)).isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer("Invalid groupids are : ");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    stringBuffer.append(string3);
                    stringBuffer.append(" ");
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "groupids", stringBuffer.toString());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.removeGroupsFromAdminRole", "258");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeGroupsFromAdminRole");
            }
        }
    }

    public List listAuthorizationGroups(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroups", new Object[]{abstractAdminCommand});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            ObjectName[] objectNameArray = this.getAuthzGroupObjectName(session, configService, null);
            if (objectNameArray != null) {
                for (int i = 0; i < objectNameArray.length; ++i) {
                    ObjectName objectName = objectNameArray[i];
                    String string = (String)configService.getAttribute(session, objectName, "name", false);
                    if (!this.checkAccess(objectName)) continue;
                    arrayList.add(string);
                }
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listAuthorizationGroups", "300");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroups", arrayList);
            }
        }
    }

    public List listResourcesOfAuthorizationGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourcesOfAuthorizationGroup", new Object[]{abstractAdminCommand});
        }
        ArrayList arrayList = new ArrayList();
        try {
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            ObjectName[] objectNameArray = this.getAuthzGroupObjectName(session, configService, string);
            if (objectNameArray != null && objectNameArray.length == 1) {
                ObjectName objectName = objectNameArray[0];
                List list = this.getResourcesFromAuthorizationGroup(session, configService, objectName);
                return list;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No authorization group: " + string + " found or more than one authorization group found");
            }
            List list = null;
            return list;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listResourcesOfAuthorizationGroup", "316");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listResourcesOfAuthorizationGroup", arrayList);
            }
        }
    }

    public List listAuthorizationGroupsOfResource(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroupsOfResource", new Object[]{abstractAdminCommand});
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Serializable serializable;
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("resourceName");
            Boolean bl = (Boolean)abstractAdminCommand.getParameter("traverseContainedResources");
            ObjectName[] objectNameArray = AdminCommandHelper.getResources(session, configService, string);
            if (objectNameArray != null && objectNameArray.length == 1) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                serializable = objectNameArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource found is " + serializable);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string2 = ConfigServiceHelper.getConfigDataId(serializable).toString();
                arrayList2.add(string2);
                if (bl != null && bl.booleanValue()) {
                    object4 = ResourceInstanceRelations.getInstance().getResourceType(string2);
                    if (!ResourceInstanceRelations.getInstance().isValidResourceType((String)object4)) {
                        throw new InvalidParameterValueException(abstractAdminCommand.getName(), "resourceName", string);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "traverse the parent");
                    }
                    HashMap hashMap = ResourceInstanceRelations.getInstance().getAllParentInstances(session, configService, string2, (String)object4);
                    object3 = hashMap.keySet().iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        List list = (List)hashMap.get(object2);
                        object = list.iterator();
                        while (object.hasNext()) {
                            String string3 = (String)object.next();
                            arrayList2.add(string3);
                        }
                    }
                }
                if ((object4 = this.getAuthzGroupObjectName(session, configService, null)) != null) {
                    block7: for (int i = 0; i < ((ObjectName[])object4).length; ++i) {
                        object3 = object4[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "authzGroup is " + object3);
                        }
                        object2 = (ArrayList)this.getResourcesFromAuthorizationGroup(session, configService, (ObjectName)object3);
                        for (int j = 0; j < arrayList2.size(); ++j) {
                            if (!((ArrayList)object2).contains(arrayList2.get(j))) continue;
                            object = (String)configService.getAttribute(session, (ObjectName)object3, "name", false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Authorization group:  " + (String)object + ".  Contains resource: " + arrayList2.get(j));
                            }
                            arrayList.add(object);
                            continue block7;
                        }
                    }
                }
            }
            serializable = arrayList;
            return serializable;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listAuthorizationGroupsOfResource", "361");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroupsOfResource", arrayList);
            }
        }
    }

    public HashMap listResourcesForUserID(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourcesForUserID", new Object[]{abstractAdminCommand});
        }
        try {
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("userid");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user id to find is " + string);
            }
            if (!this.isUserAllowed(string, false)) {
                throw new Exception("Access Denied for " + abstractAdminCommand.getName());
            }
            HashMap hashMap = this.listAuthzGrpOrResourcesAsSystem(session, configService, true, "users", string);
            return hashMap;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listResourcesForUserID", "390");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listResourcesForUserID");
            }
        }
    }

    public HashMap listResourcesForGroupID(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourcesForGroupID", new Object[]{abstractAdminCommand});
        }
        try {
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("groupid");
            String string2 = "groups";
            if (string.equals("EVERYONE")) {
                string = "EveryoneExt";
                string2 = "specialSubjects";
            } else if (string.equals("ALLAUTHENTICATED")) {
                string = "AllAuthenticatedUsersExt";
                string2 = "specialSubjects";
            }
            if (!this.isUserAllowed(string, true)) {
                throw new Exception("Access Denied for " + abstractAdminCommand.getName());
            }
            HashMap hashMap = this.listAuthzGrpOrResourcesAsSystem(session, configService, true, string2, string);
            return hashMap;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listResourcesForGroupID", "454");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listResourcesForGroupID");
            }
        }
    }

    public HashMap listAuthorizationGroupsForUserID(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroupsForUserID", new Object[]{abstractAdminCommand});
        }
        try {
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("userid");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user id to find is " + string);
            }
            HashMap hashMap = this.listAuthzGrpOrResources(session, configService, false, "users", string);
            return hashMap;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listResourcesForUser", "390");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroupsForUser");
            }
        }
    }

    public HashMap listAuthorizationGroupsForGroupID(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthorizationGroupsForGroupID", new Object[]{abstractAdminCommand});
        }
        try {
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = abstractAdminCommand.getConfigSession();
            String string = (String)abstractAdminCommand.getParameter("groupid");
            String string2 = "groups";
            if (string.equals("EVERYONE")) {
                string = "EveryoneExt";
                string2 = "specialSubjects";
            } else if (string.equals("ALLAUTHENTICATED")) {
                string = "AllAuthenticatedUsersExt";
                string2 = "specialSubjects";
            }
            HashMap hashMap = this.listAuthzGrpOrResources(session, configService, false, string2, string);
            return hashMap;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listResourcesForUser", "421");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthorizationGroupsForGroup");
            }
        }
    }

    public HashMap listGroupIDsOfAuthorizationGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listGroupIDsOfAuthorizationGroup", new Object[]{abstractAdminCommand});
        }
        HashMap hashMap = null;
        try {
            HashMap hashMap2 = hashMap = this.listIDsOfAuthozGroup(abstractAdminCommand, "groups");
            return hashMap2;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listGroupIDsOfAuthorizationGroup", "568");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listGroupIDsOfAuthorizationGroup", hashMap);
            }
        }
    }

    public HashMap listUserIDsOfAuthorizationGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listUserIDsOfAuthorizationGroup", new Object[]{abstractAdminCommand});
        }
        HashMap hashMap = null;
        try {
            HashMap hashMap2 = hashMap = this.listIDsOfAuthozGroup(abstractAdminCommand, "users");
            return hashMap2;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listUserIDsOfAuthorizationGroup", "568");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listUserIDsOfAuthorizationGroup", hashMap);
            }
        }
    }

    private HashMap listIDsOfAuthozGroup(AbstractAdminCommand abstractAdminCommand, String string) throws Exception {
        Cloneable cloneable;
        ObjectName[] objectNameArray;
        Session session;
        ConfigService configService;
        HashMap hashMap;
        block21: {
            ObjectName objectName;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listUserIDsForAuthorizationGroup", new Object[]{abstractAdminCommand});
            }
            hashMap = null;
            CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
            configService = commandProviderHelper.getConfigService();
            session = abstractAdminCommand.getConfigSession();
            String string2 = (String)abstractAdminCommand.getParameter("authorizationGroupName");
            if (string2 == null || string2.equals("CellAuthorizationGroup")) {
                objectName = this.getCellObjectName(session, configService);
            } else {
                objectNameArray = this.getAuthzGroupObjectName(session, configService, string2);
                if (objectNameArray == null || objectNameArray.length <= 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Authorization Group: " + string2 + " does not exist");
                    }
                    throw new InvalidParameterValueException(abstractAdminCommand.getName(), "authorizationGroupName", string2);
                }
                objectName = objectNameArray[0];
            }
            objectNameArray = configService.resolve(session, objectName, "AuthorizationTableExt");
            if (objectNameArray == null || objectNameArray.length != 0) break block21;
            HashMap hashMap2 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listUserIDsOfAuthorizationGroup", hashMap);
            }
            return hashMap2;
        }
        try {
            ObjectName objectName = objectNameArray[0];
            hashMap = this.createResourceRoleMap();
            cloneable = (ArrayList)configService.getAttribute(session, objectName, "authorizations", false);
            for (int i = 0; i < cloneable.size(); ++i) {
                Object object;
                ObjectName objectName2 = (ObjectName)cloneable.get(i);
                ObjectName objectName3 = (ObjectName)configService.getAttribute(session, objectName2, "role", false);
                String string3 = this.resolveRoleIDToRoleName(session, configService, objectName, objectName3);
                ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, string, false);
                ArrayList<String> arrayList2 = (ArrayList<String>)hashMap.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<String>();
                }
                hashMap.put(string3, arrayList2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Patch applied  ");
                }
                for (int j = 0; j < arrayList.size(); ++j) {
                    ObjectName objectName4 = (ObjectName)arrayList.get(j);
                    object = (String)configService.getAttribute(session, objectName4, "name", false);
                    arrayList2.add((String)object);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Authorization role:  " + string3 + ".  Name:  " + (String)object);
                }
                ArrayList arrayList3 = (ArrayList)configService.getAttribute(session, objectName2, "specialSubjects", false);
                for (int j = 0; j < arrayList3.size(); ++j) {
                    object = (ObjectName)arrayList3.get(j);
                    String string4 = ConfigServiceHelper.getConfigDataType((ObjectName)object);
                    if (string4.equals("EveryoneExt")) {
                        arrayList2.add("EVERYONE");
                        continue;
                    }
                    if (!string4.equals("AllAuthenticatedUsersExt")) continue;
                    arrayList2.add("ALLAUTHENTICATED");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "admin-authz.xml name is " + objectName.getCanonicalName());
            }
            cloneable = hashMap;
        }
        catch (Exception exception) {
            try {
                FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.listUserIDsOfAuthorizationGroup", "568");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", exception);
                }
                throw exception;
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "listUserIDsOfAuthorizationGroup", hashMap);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listUserIDsOfAuthorizationGroup", hashMap);
        }
        return cloneable;
    }

    private ObjectName[] getAuthzGroupObjectName(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGroupObjectName", string);
        }
        ObjectName[] objectNameArray = null;
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "AuthorizationGroup");
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, null, objectName, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzGroups ObjectNames are " + objectNameArray2);
        }
        if (string == null || string.equals("")) {
            objectNameArray = objectNameArray2;
        } else if (objectNameArray2 != null) {
            for (int i = 0; i < objectNameArray2.length; ++i) {
                ObjectName objectName2 = objectNameArray2[i];
                String string2 = (String)configService.getAttribute(session, objectName2, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization group name to check:  " + string2);
                }
                if (!string2.equals(string)) continue;
                objectNameArray = new ObjectName[]{objectName2};
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzGroupObjectName", objectNameArray);
        }
        return objectNameArray;
    }

    private ObjectName findAuthzGroupsWithGivenResource(Session session, ConfigService configService, ObjectName[] objectNameArray, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGroup", new Object[]{objectNameArray, objectName});
        }
        String string = ConfigServiceHelper.getConfigDataId(objectName).toString();
        ObjectName objectName2 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName3 = objectNameArray[i];
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName3, "members", false);
            for (int j = 0; j < arrayList.size(); ++j) {
                ObjectName objectName4 = (ObjectName)arrayList.get(j);
                String string2 = (String)configService.getAttribute(session, objectName4, "resourceName");
                if (!string2.equals(string)) continue;
                objectName2 = objectName3;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResourceInAuthzGroups", objectName2);
        }
        return objectName2;
    }

    private ObjectName resolveRoleNameToRoleID(Session session, ConfigService configService, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveRoleNameToRoleID", string);
        }
        ObjectName objectName2 = null;
        ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "roles", false);
        for (int i = 0; i < arrayList.size(); ++i) {
            ObjectName objectName3 = (ObjectName)arrayList.get(i);
            String string2 = (String)configService.getAttribute(session, objectName3, "roleName", false);
            if (!string2.equalsIgnoreCase(string)) continue;
            objectName2 = objectName3;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveRoleNameToRoleID", objectName2);
        }
        return objectName2;
    }

    private String resolveRoleIDToRoleName(Session session, ConfigService configService, ObjectName objectName, ObjectName objectName2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveRoleIDToRoleName", objectName2);
        }
        String string = null;
        ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "roles", false);
        for (int i = 0; i < arrayList.size(); ++i) {
            ObjectName objectName3 = (ObjectName)arrayList.get(i);
            if (!objectName3.equals(objectName2)) continue;
            string = (String)configService.getAttribute(session, objectName3, "roleName", false);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveRoleIDToRoleName", string);
        }
        return string;
    }

    private List addRemoveRoleOrGroupID(Session session, ConfigService configService, String string, String string2, String string3, String[] stringArray, String[] stringArray2) throws ConfigServiceException, ConnectorException, InvalidParameterValueException {
        ObjectName objectName;
        ObjectName objectName2;
        int n;
        ObjectName objectName3;
        ObjectName[] objectNameArray;
        ObjectName objectName4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRoleOrGroupID", new Object[]{string, string2, string3, stringArray});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 == null || string2.equals("CellAuthorizationGroup")) {
            objectName4 = this.getCellObjectName(session, configService);
        } else {
            objectNameArray = this.getAuthzGroupObjectName(session, configService, string2);
            if (objectNameArray == null || objectNameArray.length != 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization Group: " + string2 + " does not exist");
                }
                throw new InvalidParameterValueException(string, "authorizationGroupName", string2);
            }
            objectName4 = objectNameArray[0];
        }
        objectNameArray = configService.resolve(session, objectName4, "AuthorizationTableExt");
        ObjectName objectName5 = objectNameArray != null && objectNameArray.length == 0 ? this.createAuthzTableDocument(session, configService, objectName4) : objectNameArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "admin-authz.xml name is " + objectName5.getCanonicalName());
        }
        if ((objectName3 = this.resolveRoleNameToRoleID(session, configService, objectName5, string3)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role " + string3 + " does not exist");
            }
            throw new InvalidParameterValueException(string, "roleName", string3);
        }
        ArrayList arrayList2 = (ArrayList)configService.getAttribute(session, objectName5, "authorizations", false);
        boolean bl = false;
        for (n = 0; n < arrayList2.size(); ++n) {
            objectName2 = (ObjectName)arrayList2.get(n);
            objectName = (ObjectName)configService.getAttribute(session, objectName2, "role", false);
            if (!objectName.equals(objectName3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute("role", objectName3));
            configService.createConfigDataByTemplate(session, objectName5, "authorizations", attributeList, null);
            arrayList2 = (ArrayList)configService.getAttribute(session, objectName5, "authorizations", false);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            Object object;
            objectName2 = (ObjectName)arrayList2.get(n);
            objectName = (ObjectName)configService.getAttribute(session, objectName2, "role", false);
            if (!objectName.equals(objectName3)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authorizationRole found" + objectName.getCanonicalName());
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ObjectName objectName6;
                    String string4 = stringArray[i];
                    object = new AttributeList();
                    ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", string4);
                    if (string.equals("mapUsersToAdminRole")) {
                        if (this.findRoleIDInAuthorization(session, configService, objectName2, "users", string4) == null) {
                            configService.createConfigData(session, objectName2, "users", "UserExt", (AttributeList)object);
                            continue;
                        }
                        arrayList.add(string4);
                        continue;
                    }
                    if (string.equals("removeUsersFromAdminRole")) {
                        objectName6 = this.findRoleIDInAuthorization(session, configService, objectName2, "users", string4);
                        if (objectName6 != null) {
                            configService.deleteConfigData(session, objectName6);
                            continue;
                        }
                        arrayList.add(string4);
                        continue;
                    }
                    if (string.equals("mapGroupsToAdminRole")) {
                        if (this.findRoleIDInAuthorization(session, configService, objectName2, "groups", string4) == null) {
                            configService.createConfigData(session, objectName2, "groups", "GroupExt", (AttributeList)object);
                            continue;
                        }
                        arrayList.add(string4);
                        continue;
                    }
                    if (!string.equals("removeGroupsFromAdminRole")) continue;
                    objectName6 = this.findRoleIDInAuthorization(session, configService, objectName2, "groups", string4);
                    if (objectName6 != null) {
                        configService.deleteConfigData(session, objectName6);
                        continue;
                    }
                    arrayList.add(string4);
                }
            }
            if (stringArray2 == null || stringArray2.length <= 0) continue;
            for (int i = 0; i < stringArray2.length; ++i) {
                object = stringArray2[i];
                if (((String)object).equals("ALLAUTHENTICATED")) {
                    ObjectName objectName7 = this.findRoleIDInAuthorization(session, configService, objectName2, "specialSubjects", "AllAuthenticatedUsersExt");
                    if (string.equals("mapGroupsToAdminRole")) {
                        if (objectName7 == null) {
                            configService.createConfigData(session, objectName2, "specialSubjects", "AllAuthenticatedUsersExt", new AttributeList());
                            continue;
                        }
                        arrayList.add("ALLAUTHENTICATED");
                        continue;
                    }
                    if (!string.equals("removeGroupsFromAdminRole")) continue;
                    if (objectName7 != null) {
                        configService.deleteConfigData(session, objectName7);
                        continue;
                    }
                    arrayList.add("ALLAUTHENTICATED");
                    continue;
                }
                if (!((String)object).equals("EVERYONE")) continue;
                ObjectName objectName8 = this.findRoleIDInAuthorization(session, configService, objectName2, "specialSubjects", "EveryoneExt");
                if (string.equals("mapGroupsToAdminRole")) {
                    if (objectName8 == null) {
                        configService.createConfigData(session, objectName2, "specialSubjects", "EveryoneExt", new AttributeList());
                        continue;
                    }
                    arrayList.add("EVERYONE");
                    continue;
                }
                if (!string.equals("removeGroupsFromAdminRole")) continue;
                if (objectName8 != null) {
                    configService.deleteConfigData(session, objectName8);
                    continue;
                }
                arrayList.add("EVERYONE");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRoleOrGroupID");
        }
        return arrayList;
    }

    private ObjectName createAuthzTableDocument(Session session, ConfigService configService, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthzTableDocument", objectName);
        }
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "fileName", "admin-authz.xml");
        ObjectName objectName2 = configService.queryTemplates(session, "AuthorizationTableExt")[0];
        ObjectName objectName3 = configService.createConfigDataByTemplate(session, objectName, "AuthorizationTableExt", attributeList, objectName2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthzTableDocument", objectName3);
        }
        return objectName3;
    }

    private List getResourcesFromAuthorizationGroup(Session session, ConfigService configService, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcesFromAuthorizationGroup", objectName);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = (ArrayList)configService.getAttribute(session, objectName, "members", false);
        for (int i = 0; i < arrayList2.size(); ++i) {
            ObjectName objectName2 = (ObjectName)arrayList2.get(i);
            String string = (String)configService.getAttribute(session, objectName2, "resourceName", false);
            arrayList.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesFromAuthorizationGroup", arrayList);
        }
        return arrayList;
    }

    private ObjectName findRoleIDInAuthorization(Session session, ConfigService configService, ObjectName objectName, String string, String string2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findRoleIDInAuthorization", new Object[]{objectName, string, string2});
        }
        ObjectName objectName2 = null;
        ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, string, false);
        for (int i = 0; i < arrayList.size(); ++i) {
            ObjectName objectName3 = (ObjectName)arrayList.get(i);
            String string3 = !string.equals("specialSubjects") ? (String)configService.getAttribute(session, objectName3, "name", false) : ConfigServiceHelper.getConfigDataType(objectName3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role name to check is " + string3);
            }
            if (!string3.equals(string2)) continue;
            objectName2 = objectName3;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findRoleIDInAuthorization", objectName2);
        }
        return objectName2;
    }

    private HashMap createResourceRoleMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceRoleMap");
        }
        HashMap hashMap = new HashMap(5);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        ArrayList arrayList6 = new ArrayList();
        hashMap.put("administrator", arrayList);
        hashMap.put("operator", arrayList2);
        hashMap.put("configurator", arrayList3);
        hashMap.put("monitor", arrayList4);
        hashMap.put("deployer", arrayList5);
        hashMap.put("adminsecuritymanager", arrayList6);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceRoleMap", hashMap);
        }
        return hashMap;
    }

    private HashMap listAuthzGrpOrResources(Session session, ConfigService configService, boolean bl, String string, String string2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthzGrpOrResources", new Object[]{string, string2});
        }
        HashMap hashMap = this.createResourceRoleMap();
        ObjectName[] objectNameArray = new ObjectName[]{this.getCellObjectName(session, configService)};
        this.getIdOrResourcesFromAuthzGrp(session, configService, objectNameArray, hashMap, bl, true, string, string2);
        ObjectName[] objectNameArray2 = this.getAuthzGroupObjectName(session, configService, null);
        this.getIdOrResourcesFromAuthzGrp(session, configService, objectNameArray2, hashMap, bl, false, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAuthzGrpOrResources", hashMap);
        }
        return hashMap;
    }

    private HashMap getIdOrResourcesFromAuthzGrp(Session session, ConfigService configService, ObjectName[] objectNameArray, HashMap hashMap, boolean bl, boolean bl2, String string, String string2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGrpOrResources", new Object[]{objectNameArray, string, string2});
        }
        if (objectNameArray != null) {
            block0: for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName = objectNameArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authzGroup is " + objectName);
                }
                ObjectName[] objectNameArray2 = configService.resolve(session, objectName, "AuthorizationTableExt");
                for (int j = 0; j < objectNameArray2.length; ++j) {
                    ObjectName objectName2 = objectNameArray2[j];
                    ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "authorizations", false);
                    for (int k = 0; k < arrayList.size(); ++k) {
                        ArrayList<String> arrayList2;
                        ObjectName objectName3 = (ObjectName)arrayList.get(k);
                        ObjectName objectName4 = this.findRoleIDInAuthorization(session, configService, objectName3, string, string2);
                        if (objectName4 == null) continue;
                        ObjectName objectName5 = (ObjectName)configService.getAttribute(session, objectName3, "role", false);
                        String string3 = this.resolveRoleIDToRoleName(session, configService, objectName2, objectName5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found matching userid:  " + string2 + "  Authorization role:  " + string3);
                        }
                        if ((arrayList2 = (ArrayList<String>)hashMap.get(string3)) == null) {
                            arrayList2 = new ArrayList<String>();
                        }
                        hashMap.put(string3, arrayList2);
                        if (bl) {
                            if (bl2) {
                                arrayList2.add("Cell");
                                continue;
                            }
                            arrayList2.addAll(this.getResourcesFromAuthorizationGroup(session, configService, objectName));
                            continue;
                        }
                        if (bl2) {
                            arrayList2.add("CellAuthorizationGroup");
                            continue;
                        }
                        arrayList2.add((String)configService.getAttribute(session, objectName, "name", false));
                    }
                    if (bl2) continue block0;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzGrpOrResources", hashMap);
        }
        return hashMap;
    }

    private ObjectName getCellObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellObjectName", new Object[]{session, configService, this});
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + objectName2 + ". Cell Name is " + ConfigServiceHelper.getDisplayName(objectName2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellObjectName", objectName2);
        }
        return objectName2;
    }

    private boolean checkAccess(ObjectName objectName) {
        AdminAuthorizer adminAuthorizer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess ", objectName);
        }
        if (objectName == null) {
            return true;
        }
        String string = ConfigServiceHelper.getConfigDataId(objectName).toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ResourceName = ", string);
        }
        if ((adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer()) != null) {
            return adminAuthorizer.checkAccess(string, "adminsecuritymanager");
        }
        return true;
    }

    private void checkClusterMembers(ObjectName objectName, Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClusterMembers", objectName);
        }
        List list = (List)configService.getAttribute(session, objectName, "members");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeList attributeList = (AttributeList)iterator.next();
            String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberName", string);
            }
            String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", string2);
            }
            if (this.isNodeValid(string2, session)) continue;
            throw new CommandValidationException("Cluster has one or more members that is not version 6.1 or greater. One of the members is " + string + " in node " + string2 + " that is not version 6.1 or greater ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClusterMembers");
        }
    }

    private void checkApplicationTargets(ObjectName objectName, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkApplicationTargets", objectName);
        }
        EObject eObject = MOFUtil.convertToEObject(session, objectName);
        Deployment deployment = null;
        if (eObject instanceof Deployment) {
            deployment = (Deployment)eObject;
            TreeIterator treeIterator = deployment.eAllContents();
            while (treeIterator.hasNext()) {
                ServerTarget serverTarget;
                String string;
                Object e2 = treeIterator.next();
                if (!(e2 instanceof ServerTarget) || this.isNodeValid(string = (serverTarget = (ServerTarget)e2).getNodeName(), session)) continue;
                throw new CommandValidationException("Application has one or more targets that is not version 6.1 or greater. One of the targets is " + string + " that is not version 6.1 or greater ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkApplicationTargets");
        }
    }

    private boolean isNodeValid(String string, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeValid", string);
        }
        boolean bl = true;
        Properties properties = new Properties();
        properties.setProperty("CONFIG_SESSION", session.toString());
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(properties);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
        if (string != null) {
            String string2 = managedObjectMetadataHelper.getNodeBaseProductVersion(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node product version is " + string2);
            }
            String string3 = managedObjectMetadataHelper.getNodeMajorVersion(string);
            String string4 = managedObjectMetadataHelper.getNodeMinorVersion(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeMajorVersion is " + string3 + " nodeMinorVersion is " + string4);
            }
            int n = Integer.parseInt(string3);
            int n2 = Integer.parseInt(string4);
            if (n < 7 && (n != 6 || n2 < 1)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resource is not a version 6.1 or above resource.  Version is " + string2);
                }
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeValid", new Boolean(bl));
        }
        return bl;
    }

    private HashMap listAuthzGrpOrResourcesAsSystem(Session session, ConfigService configService, boolean bl, String string, String string2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAuthzGrpOrResourcesAsSystem", new Object[]{new Boolean(bl), string, string2});
        }
        final Session session2 = session;
        final ConfigService configService2 = configService;
        final boolean bl2 = bl;
        final String string3 = string;
        final String string4 = string2;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            HashMap hashMap = (HashMap)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthzGroupCommandsProvider.this.listAuthzGrpOrResources(session2, configService2, bl2, string3, string4);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listAuthzGrpOrResourcesAsSystem", hashMap);
            }
            return hashMap;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }

    private boolean isUserAllowed(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUserAllowed", new Object[]{string, new Boolean(bl)});
        }
        boolean bl2 = false;
        AdminAuthorizer adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (adminAuthorizer == null) {
            return true;
        }
        if (adminAuthorizer.checkAccess("cell.xml", "adminsecuritymanager")) {
            bl2 = true;
        } else if (bl) {
            try {
                Subject subject = SecurityHelper.retrieveSubject();
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                String string2 = wSCredential.getRealmName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "realm", string2);
                }
                UserRegistry userRegistry = ContextManagerFactory.getInstance().getRegistry(string2);
                String string3 = userRegistry.getUniqueGroupId(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accessId", string3);
                }
                String string4 = wSCredential.getSecurityName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "logged in user securityName", string4);
                }
                List list = userRegistry.getGroupsForUser(string4);
                Object[] objectArray = list.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string5 = (String)objectArray[i];
                    String string6 = userRegistry.getUniqueGroupId(string5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "logged in user group uniqueId", string6);
                    }
                    if (string3 == null || string6 == null) {
                        bl2 = false;
                        continue;
                    }
                    if (!string6.equalsIgnoreCase(string3)) continue;
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
        } else {
            try {
                Subject subject = SecurityHelper.retrieveSubject();
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                String string7 = wSCredential.getRealmName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "realm", string7);
                }
                UserRegistry userRegistry = ContextManagerFactory.getInstance().getRegistry(string7);
                String string8 = userRegistry.getUniqueUserId(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accessId", string8);
                }
                String string9 = wSCredential.getSecurityName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "logged in user securityName", string9);
                }
                String string10 = userRegistry.getUniqueUserId(string9);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "logged in user uniqueId", string10);
                }
                if (string8 == null || string10 == null) {
                    bl2 = false;
                } else if (string10.equalsIgnoreCase(string8)) {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserAllowed", new Boolean(bl2));
        }
        return bl2;
    }

    public class AddResourceToAuthorizationGroupCmd
    extends AbstractAdminCommand {
        public AddResourceToAuthorizationGroupCmd(CommandMetadata commandMetadata) throws CommandNotFoundException {
            super(commandMetadata);
        }

        public AddResourceToAuthorizationGroupCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
            super(commandData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block16: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "execute");
                }
                CommandResultImpl commandResultImpl = new CommandResultImpl();
                commandResultImpl.reset();
                this.setCommandResult(commandResultImpl);
                try {
                    ObjectName[] objectNameArray;
                    CommandProviderHelper commandProviderHelper = AuthzGroupCommandsProvider.this.getCommandProviderHelper();
                    ConfigService configService = commandProviderHelper.getConfigService();
                    Session session = this.getConfigSession();
                    String string = (String)this.getParameter("authorizationGroupName");
                    String string2 = (String)this.getParameter("resourceName");
                    ObjectName objectName = AdminCommandHelper.getResources(session, configService, string2)[0];
                    this.validate(session, configService, null, objectName);
                    String string3 = ConfigServiceHelper.getConfigDataId(objectName).toString();
                    String string4 = ResourceInstanceRelations.getInstance().getResourceType(string3);
                    if (string4 != null && string4.equals("AuthorizationGroup")) {
                        throw new InvalidParameterValueException(this.getName(), "resourceName", string2);
                    }
                    if (!ResourceInstanceRelations.getInstance().isValidResourceType(string4)) {
                        throw new InvalidParameterValueException(this.getName(), "resourceName", string2);
                    }
                    AttributeList attributeList = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(attributeList, "resourceName", string3);
                    ConfigServiceHelper.setAttributeValue(attributeList, "resourceType", string4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resources attributes to be set are " + attributeList);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "authzGroups name is " + string);
                    }
                    if ((objectNameArray = AuthzGroupCommandsProvider.this.getAuthzGroupObjectName(session, configService, string)) != null && objectNameArray.length > 0) {
                        ObjectName objectName2 = objectNameArray[0];
                        ObjectName objectName3 = configService.createConfigData(session, objectName2, "members", "AuthorizationGroupMember", attributeList);
                        HashMap hashMap = ResourceInstanceRelations.getInstance().getAllParentInstances(session, configService, string3, string4);
                        Iterator iterator = hashMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            String string5 = (String)iterator.next();
                            List list = (List)hashMap.get(string5);
                            Iterator iterator2 = list.iterator();
                            while (iterator2.hasNext()) {
                                String string6 = (String)iterator2.next();
                                attributeList.clear();
                                ConfigServiceHelper.setAttributeValue(attributeList, "name", string5);
                                ConfigServiceHelper.setAttributeValue(attributeList, "value", string6);
                                configService.createConfigData(session, objectName3, "memberProperties", "Property", attributeList);
                            }
                        }
                        break block16;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No authorization group: " + string + " found");
                    }
                    throw new InvalidParameterValueException(this.getName(), "authorizationGroupName", string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.createAuthorizationGroup", "88");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception caught", exception);
                    }
                    commandResultImpl.setException(exception);
                }
                finally {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "execute");
                    }
                }
            }
        }

        public void validate(Session session, ConfigService configService, ObjectName[] objectNameArray, ObjectName objectName) throws CommandValidationException, ConfigServiceException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            try {
                String string = ConfigServiceHelper.getConfigDataType(objectName);
                if (!ResourceInstanceRelations.getInstance().isValidResourceType(string)) {
                    throw new CommandValidationException("Invalid Type.  " + string);
                }
                if (objectNameArray == null) {
                    objectNameArray = AuthzGroupCommandsProvider.this.getAuthzGroupObjectName(session, configService, null);
                }
                if (AuthzGroupCommandsProvider.this.findAuthzGroupsWithGivenResource(session, configService, objectNameArray, objectName) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource already existed. " + objectName);
                    }
                    throw new CommandValidationException("Resource already existed. " + objectName);
                }
                Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
                String string2 = properties.getProperty("node");
                if (string2 != null) {
                    if (!AuthzGroupCommandsProvider.this.isNodeValid(string2, session)) {
                        throw new CommandValidationException("resource " + objectName + " cannot be part of any authorization group becuase, its product version is not 6.1 or greater. Check the corresponding node's product version. ");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resource type = ", string);
                    }
                    if (string.equals("Application") || string.equals("Deployment")) {
                        AuthzGroupCommandsProvider.this.checkApplicationTargets(objectName, session);
                    }
                    if (string.equals("ServerCluster") || string.equals("Cluster")) {
                        AuthzGroupCommandsProvider.this.checkClusterMembers(objectName, session, configService);
                    }
                }
            }
            catch (ConfigServiceException configServiceException) {
                FFDCFilter.processException(configServiceException, "com.ibm.ws.management.commands.authzgroup.AddResourceToAuthorizationGroupCmd", "264");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", configServiceException);
                }
                throw configServiceException;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.management.commands.authzgroup.AddResourceToAuthorizationGroupCmd", "267");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", exception);
                }
                throw new CommandValidationException(exception, "Validation failed");
            }
            finally {
                Tr.exit(tc, "validate");
            }
        }
    }
}

