/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.authzgroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.authorizationgroup.AuthorizationGroup;
import com.ibm.websphere.models.config.topology.authorizationgroup.AuthorizationGroupMember;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class AuthzGroupUtil {
    private static TraceComponent tc = Tr.register(AuthzGroupUtil.class, "management", "com.ibm.ws.management.resources.configservice");

    public static boolean removeResourceFromAuthorizationGroup(ConfigService configService, Session session, String string, String string2) throws Exception {
        ObjectName objectName;
        int n;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeResourceFromAuthorizationGroup", new Object[]{string, string2});
        }
        if (configService == null) {
            configService = ConfigServiceFactory.getConfigService();
        }
        if (configService == null) {
            object = new Properties();
            ((Properties)object).setProperty("location", "local");
            try {
                configService = ConfigServiceFactory.createConfigService(true, (Properties)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (configService == null) {
            return false;
        }
        object = string;
        int n2 = string.indexOf("#");
        if (n2 > 0) {
            object = string.substring(0, n2);
        }
        if (string2 == null && n2 > 0 && (n = string.indexOf("_", n2)) > 0) {
            string2 = string.substring(n2 + 1, n);
        }
        if (string2 == null || string == null) {
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceType ", string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "alt ResourceID ", object);
        }
        if ((string2.equals("Server") || string2.equals("ServerCluster") || string2.equals("Application") || string2.equals("Node") || string2.equals("NodeGroup")) && (objectName = AuthzGroupUtil.findAuthzGroupForResource(configService, session, string, string2)) != null) {
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "members", false);
            for (int i = 0; i < arrayList.size(); ++i) {
                ObjectName objectName2 = (ObjectName)arrayList.get(i);
                String string3 = (String)configService.getAttribute(session, objectName2, "resourceName");
                String string4 = (String)configService.getAttribute(session, objectName2, "resourceType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member ", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type ", string4);
                }
                if (!string3.equals(string) && !string3.equals(object) || !string4.equals(string2)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting member ", string3);
                }
                configService.deleteConfigData(session, objectName2);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeResourceFromAuthorizationGroup");
        }
        return true;
    }

    private static ObjectName findAuthzGroupForResource(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAuthzGroupForResource", new Object[]{string, string2});
        }
        ObjectName objectName = null;
        ObjectName[] objectNameArray = AuthzGroupUtil.getAuthzGroupObjectName(session, configService, null);
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName2 = objectNameArray[i];
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "members", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroup ", objectName2);
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                ObjectName objectName3 = (ObjectName)arrayList.get(j);
                String string3 = (String)configService.getAttribute(session, objectName3, "resourceName");
                String string4 = (String)configService.getAttribute(session, objectName3, "resourceType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member type ", string4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member name ", string3);
                }
                if (!string3.equals(string) || !string4.equals(string2)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found member ", string3);
                }
                objectName = objectName2;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAuthzGroupForResource", objectName);
        }
        return objectName;
    }

    private static ObjectName[] getAuthzGroupObjectName(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGroupObjectName", string);
        }
        ObjectName[] objectNameArray = null;
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "AuthorizationGroup");
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, null, objectName, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzGroups ObjectNames are " + objectNameArray2);
        }
        if (string == null || string.equals("")) {
            objectNameArray = objectNameArray2;
        } else if (objectNameArray2 != null) {
            for (int i = 0; i < objectNameArray2.length; ++i) {
                ObjectName objectName2 = objectNameArray2[i];
                String string2 = (String)configService.getAttribute(session, objectName2, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization group name to check:  " + string2);
                }
                if (!string2.equals(string)) continue;
                objectNameArray = new ObjectName[]{objectName2};
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzGroupObjectName", objectNameArray);
        }
        return objectNameArray;
    }

    public static void changeNodeName(ConfigService configService, Session session, String string, String string2) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeName", new Object[]{string2, string});
        }
        String string3 = null;
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        if (objectNameArray != null && objectNameArray.length > 0) {
            object = objectNameArray[0];
            string3 = ConfigServiceHelper.getDisplayName((ObjectName)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell name " + string3);
        }
        object = "cells/" + string3 + "/nodes/" + string;
        String string4 = "cells/" + string3 + "/nodes/" + string2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "old Node uri " + (String)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new Node uri " + string4);
        }
        objectName = ConfigServiceHelper.createObjectName(null, "AuthorizationGroup");
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, null, objectName, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzGroups ObjectNames are " + objectNameArray2);
        }
        for (int i = 0; objectNameArray2 != null && i < objectNameArray2.length; ++i) {
            AuthorizationGroup authorizationGroup;
            EList eList;
            ObjectName objectName2 = objectNameArray2[i];
            String string5 = (String)configService.getAttribute(session, objectName2, "name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization group name to check:  " + string5);
            }
            if ((eList = (authorizationGroup = (AuthorizationGroup)MOFUtil.convertToEObject(session, objectName2)).getMembers()) != null) {
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    AuthorizationGroupMember authorizationGroupMember = (AuthorizationGroupMember)iterator.next();
                    boolean bl = false;
                    String string6 = authorizationGroupMember.getResourceName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "member name " + string6);
                    }
                    if (string6.startsWith((String)object)) {
                        bl = true;
                        string6 = string4 + string6.substring(((String)object).length());
                        authorizationGroupMember.setResourceName(string6);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "member name " + authorizationGroupMember.getResourceName());
                    }
                    EList eList2 = null;
                    if (bl) {
                        eList2 = authorizationGroupMember.getMemberProperties();
                    }
                    if (eList2 == null) continue;
                    Iterator iterator2 = eList2.iterator();
                    while (iterator2.hasNext()) {
                        Property property = (Property)iterator2.next();
                        String string7 = property.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "parent name " + string7);
                        }
                        if (string7.startsWith((String)object)) {
                            string7 = string4 + string7.substring(((String)object).length());
                            property.setValue(string7);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parent name " + property.getValue());
                    }
                }
            }
            authorizationGroup.eResource().save(Collections.EMPTY_MAP);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeName");
        }
    }
}

