/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.cell;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.ContextUtil;
import com.ibm.ws.sm.workspace.ContextUtilFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class RenameCell
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RenameCell.class, "Admin", "com.ibm.ws.management.resources.configservice");
    private static ResourceBundle RESOURCE_BUNDLE = null;
    private static final String ISCCTX = "/applications/isclite.ear/deployments/isclite";
    private static final String ISCURI = "isclite.war/WEB-INF/components.xml";
    private static final String SETUPCMDSTR = "SET WAS_CELL=";
    private static final String FIRSTSTEPSTR = "--cellname ";
    String oldCellName = null;
    String newCellName = null;
    boolean regenCerts = false;
    boolean updateSetupCmd = false;
    boolean updateJaccContextID = true;
    ObjectName newCellObject = null;
    RepositoryContext newCellContext = null;
    ConfigService configService = null;
    Session session = null;
    boolean isND = false;
    Properties resultProps = null;

    public RenameCell(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public RenameCell(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            String string = null;
            if (AdminServiceFactory.getAdminService() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error - can only run in local mode");
                }
                string = this.getFormattedMessage("ADMG0101E", new Object[0], "This command only runs in local mode.");
                throw new CommandValidationException(string);
            }
            this.newCellName = (String)this.getParameter("newCellName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new cell = " + this.newCellName);
            }
            if (!ConfigServiceHelper.checkIfNameValid(this.newCellName)) {
                string = this.getFormattedMessage("ADMG0102E", new Object[]{this.newCellName}, "Invalid cell name: " + this.newCellName);
                throw new CommandValidationException(string);
            }
            this.configService = ConfigServiceFactory.getConfigService();
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName objectName2 = this.configService.queryConfigObjects(this.session, null, objectName, null)[0];
            this.oldCellName = ConfigServiceHelper.getDisplayName(objectName2);
            this.regenCerts = Boolean.TRUE.equals((Boolean)this.getParameter("regenCerts"));
            this.updateSetupCmd = Boolean.TRUE.equals((Boolean)this.getParameter("changeSetupCmdBat"));
            this.updateJaccContextID = Boolean.TRUE.equals((Boolean)this.getParameter("updateJaccContextID"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "regenCerts: " + this.regenCerts + ", updateSetupCmd: " + this.updateSetupCmd + ", updateJaccContextID: " + this.updateJaccContextID);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newCellName = " + this.newCellName);
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.cell.RenameCell.validate", "54");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to validate the command", throwable);
            }
            CommandValidationException commandValidationException = new CommandValidationException(throwable, "unexpected exception during validation");
            throw commandValidationException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        if (this.resultProps == null) {
            this.resultProps = new Properties();
        }
        try {
            this.session = this.getConfigSession();
            this.renameCellContext();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.cell.RenameCell.beforeStepsExecuted", "85");
            taskCommandResultImpl.setException(new CommandException(throwable, "renameCell command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.newCellObject = this.configService.resolve(this.session, "Cell=" + this.newCellName)[0];
            String string = (String)this.configService.getAttribute(this.session, this.newCellObject, "cellType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellType = " + string);
            }
            this.isND = "DISTRIBUTED".equals(string);
            this.fixCellXML();
            this.fixVariablesXML();
            this.fixApps();
            this.fixSecurityXML();
            if (this.regenCerts) {
                this.regenCerts();
            }
            if (this.updateSetupCmd) {
                this.fixSetupCmd();
            }
            this.resultProps.put("done", "true");
            System.setProperty("local.cell", this.newCellName);
            System.setProperty("__renamecellcmdexc__", this.oldCellName);
            taskCommandResultImpl.setResult(this.resultProps);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.cell.RenameCell.afterStepsExecuted", "126");
            taskCommandResultImpl.setException(new CommandException(throwable, "renameCell command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3;
            if (RESOURCE_BUNDLE == null) {
                RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", this.getLocale());
            }
            if (RESOURCE_BUNDLE == null) {
                RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());
            }
            if ((string3 = RESOURCE_BUNDLE.getString(string)) == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    private void renameCellContext() throws ConfigServiceException, WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renameCellContext");
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(this.session);
        RepositoryContext repositoryContext = workSpace.findContext("cells/" + this.oldCellName);
        ContextUtil contextUtil = ContextUtilFactory.getUtil();
        this.newCellContext = contextUtil.rename(repositoryContext, this.newCellName);
        repositoryContext.delete(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renameCellContext");
        }
    }

    private void fixCellXML() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixCellXML");
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("name", this.newCellName));
        this.configService.setAttributes(this.session, this.newCellObject, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixCellXML");
        }
    }

    private void fixVariablesXML() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixVariablesXML");
        }
        AttributeList attributeList = new AttributeList();
        ObjectName objectName = this.configService.getRelationship(this.session, this.newCellObject, "VariableMap")[0];
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(this.session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string;
            String string2 = (String)this.configService.getAttribute(this.session, objectNameArray[i], "symbolicName");
            if (!string2.equals("WAS_CELL_NAME") || (string = (String)this.configService.getAttribute(this.session, objectNameArray[i], "value")) == null || string.length() <= 0) continue;
            String string3 = string.replaceAll(string, this.newCellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value", string3);
            }
            attributeList.add(new Attribute("value", string3));
            this.configService.setAttributes(this.session, objectNameArray[i], attributeList);
            attributeList.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixVariablesXML");
        }
    }

    private void fixApps() throws Exception {
        this.fixDeploymentXML();
        this.fixConsoleRegistry();
        this.fixAppInstallDirs();
    }

    private void fixSecurityXML() throws Exception {
        String string;
        String string2;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixSecurityXML");
        }
        AttributeList attributeList = new AttributeList();
        ObjectName objectName = null;
        ObjectName objectName2 = this.configService.getRelationship(this.session, this.newCellObject, "Security")[0];
        objectName = ConfigServiceHelper.createObjectName(null, "ManagementScope");
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
        for (n = 0; n < objectNameArray.length; ++n) {
            string2 = (String)this.configService.getAttribute(this.session, objectNameArray[n], "scopeName");
            if (string2 == null || string2.length() <= 0) continue;
            string = string2.replaceAll(this.oldCellName, this.newCellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scope name", string);
            }
            attributeList.add(new Attribute("scopeName", string));
            this.configService.setAttributes(this.session, objectNameArray[n], attributeList);
            attributeList.clear();
        }
        objectName = ConfigServiceHelper.createObjectName(null, "KeyStore");
        objectNameArray = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
        for (n = 0; n < objectNameArray.length; ++n) {
            string2 = (String)this.configService.getAttribute(this.session, objectNameArray[n], "location");
            if (string2 == null || string2.length() <= 0) continue;
            string = string2.replaceAll(this.oldCellName, this.newCellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "location", string);
            }
            attributeList.add(new Attribute("location", string));
            this.configService.setAttributes(this.session, objectNameArray[n], attributeList);
            attributeList.clear();
        }
        objectName = ConfigServiceHelper.createObjectName(null, "Property");
        objectNameArray = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
        for (n = 0; n < objectNameArray.length; ++n) {
            string2 = (String)this.configService.getAttribute(this.session, objectNameArray[n], "value");
            if (string2 == null || string2.length() <= 0 || !string2.contains(this.oldCellName)) continue;
            string = string2.replaceAll(this.oldCellName, this.newCellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "location", string);
            }
            attributeList.add(new Attribute("value", string));
            this.configService.setAttributes(this.session, objectNameArray[n], attributeList);
            attributeList.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixSecurityXML");
        }
    }

    private void fixDeploymentXML() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixDeploymentXML");
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "ApplicationDeployment");
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(this.session, this.newCellObject, objectName, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "found apps: " + (objectNameArray != null ? objectNameArray.length : 0));
        }
        for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
            String string;
            AttributeList attributeList = this.configService.getAttributes(this.session, objectNameArray[i], new String[]{"binariesURL", "appContextIDForSecurity"}, false);
            String string2 = null;
            String string3 = null;
            String string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "binariesURL");
            if (string4 != null) {
                if (string4.contains("/" + this.oldCellName + "/")) {
                    string2 = string4.replaceAll("/" + this.oldCellName + "/", "/" + this.newCellName + "/");
                } else if (string4.contains("\\" + this.oldCellName + "\\")) {
                    string2 = string4.replaceAll("\\" + this.oldCellName + "\\", "\\" + this.newCellName + "\\");
                }
            }
            if (this.updateJaccContextID && (string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "appContextIDForSecurity")) != null && string.contains(this.oldCellName)) {
                string3 = string.replaceAll(this.oldCellName, this.newCellName);
            }
            attributeList.clear();
            if (string2 != null) {
                attributeList.add(new Attribute("binariesURL", string2));
            }
            if (string3 != null) {
                attributeList.add(new Attribute("appContextIDForSecurity", string3));
            }
            if (attributeList.size() <= 0) continue;
            this.configService.setAttributes(this.session, objectNameArray[i], attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixDeploymentXML");
        }
    }

    private void fixConsoleRegistry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixConsoleRegistry");
        }
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(this.session.toString());
        RepositoryContext repositoryContext = workSpace.findContext("cells/" + this.newCellName + ISCCTX);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isc ctx: " + repositoryContext);
        }
        if (repositoryContext != null && repositoryContext.isAvailable(ISCURI)) {
            repositoryContext.extract(ISCURI, false);
            InputStream inputStream = repositoryContext.getInputStream(ISCURI);
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            inputStream.close();
            String string = new String(byArray);
            if (string.contains(this.oldCellName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "contains old cell");
                }
                string = string.replaceAll(this.oldCellName, this.newCellName);
                OutputStream outputStream = repositoryContext.getOutputStream(ISCURI);
                outputStream.write(string.getBytes());
                outputStream.flush();
                outputStream.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "done writing file: isclite.war/WEB-INF/components.xml");
                }
                repositoryContext.notifyChanged(1, ISCURI);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixConsoleRegistry");
        }
    }

    private void fixAppInstallDirs() throws Exception {
        String string;
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixAppInstallDirs");
        }
        if ((file = new File((string = System.getProperty("user.install.root")) + "/installedApps/" + this.oldCellName)).exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "renaming from " + file + " to " + "installedApps/" + this.newCellName);
            }
            file.renameTo(new File(string + "/installedApps/" + this.newCellName));
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Does not exist: " + file.getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixAppInstallDirs");
        }
    }

    private void regenCerts() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "regenCerts");
        }
        try {
            String string = System.getProperty("user.install.root");
            this.getResultProps().put("regenCerts", "true");
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in regenCert: " + throwable);
            }
            throwable.printStackTrace();
            this.getResultProps().put("regenCerts", "false");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "regenCerts");
        }
    }

    private void fixSetupCmd() {
        block6: {
            String string;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "fixSetupCmd");
            }
            if ((string = System.getProperty("user.install.root")) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user root: " + string);
                }
                try {
                    this.readAndReplace(string + "/bin/setupCmdLine.bat", SETUPCMDSTR + this.oldCellName, SETUPCMDSTR + this.newCellName);
                    this.readAndReplace(string + "/bin/setupCmdLine.sh", SETUPCMDSTR + this.oldCellName, SETUPCMDSTR + this.newCellName);
                    this.getResultProps().put("setupcmdline", "true");
                    this.readAndReplace(string + "/firststeps/firststeps.bat", FIRSTSTEPSTR + this.oldCellName, FIRSTSTEPSTR + this.newCellName);
                    this.readAndReplace(string + "/firststeps/firststeps.sh", FIRSTSTEPSTR + this.oldCellName, FIRSTSTEPSTR + this.newCellName);
                    this.getResultProps().put("firststeps", "true");
                }
                catch (Throwable throwable) {
                    this.getResultProps().put("setupcmdline", "false");
                    this.getResultProps().put("setupcmdline_exc", throwable.getMessage());
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Setup cmd failed", throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixSetupCmd");
        }
    }

    private void readAndReplace(String string, String string2, String string3) throws Exception {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readAndReplace - " + string);
        }
        if ((file = new File(string)).exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray);
            fileInputStream.close();
            String string4 = new String(byArray);
            if (string4.contains(string2)) {
                string4 = string4.replaceAll(string2, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "replaced " + string2 + " with " + string3);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                fileOutputStream.write(string4.getBytes());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readAndReplace - " + string);
        }
    }

    public Properties getResultProps() {
        if (this.resultProps == null) {
            this.resultProps = new Properties();
        }
        return this.resultProps;
    }
}

