/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.cluster;

import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.commands.cluster.ClusterConfigException;
import com.ibm.ws.management.commands.cluster.MemberNodeVersionException;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.BaseServerDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ClusterConfigHelper {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ClusterConfigHelper.class, "ClusterConfig", "com.ibm.ws.management.resources.configservice");
    private static String RESOURCES_SCOPE = "resourcesScope";
    private static String RESOURCES_SCOPE_BOTH = "both";
    private static String RESOURCES_SCOPE_CLUSTER = "cluster";
    private static String RESOURCES_SCOPE_SERVER = "server";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$List;

    public static ObjectName getClusterObj(ConfigService configService, Session session, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterObj");
        }
        ObjectName[] objectNameArray = null;
        ObjectName objectName = null;
        String string2 = "ServerCluster=" + string;
        Tr.debug(tc, "Resolving cluster object " + string2);
        objectNameArray = configService.resolve(session, string2);
        if (objectNameArray.length > 0) {
            objectName = objectNameArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterObj");
        }
        return objectName;
    }

    public static ObjectName getServerObj(ConfigService configService, Session session, String string, String string2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerObj");
        }
        ObjectName[] objectNameArray = null;
        ObjectName objectName = null;
        String string3 = "Node=" + string + ":Server=" + string2;
        Tr.debug(tc, "Resolving server object " + string3);
        objectNameArray = configService.resolve(session, string3);
        if (objectNameArray.length > 0) {
            objectName = objectNameArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerObj");
        }
        return objectName;
    }

    public static ObjectName getNodeObj(ConfigService configService, Session session, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeObj");
        }
        ObjectName[] objectNameArray = null;
        ObjectName objectName = null;
        Tr.debug(tc, "Resolving node object " + string);
        objectNameArray = configService.resolve(session, "Node=" + string);
        if (objectNameArray.length > 0) {
            objectName = objectNameArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeObj");
        }
        return objectName;
    }

    public static AppManagement getAppManagement(ConfigService configService) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppManagement");
        }
        AppManagement appManagement = null;
        try {
            appManagement = configService instanceof ConfigServiceProxy ? AppManagementProxy.getJMXProxyForClient(((ConfigServiceProxy)configService).getAdminClient()) : (AdminServiceFactory.getAdminService() == null ? AppManagementProxy.getLocalProxy() : AppManagementProxy.getJMXProxyForServer());
        }
        catch (Exception exception) {
            String string = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9240E", new Object[]{exception.toString()});
            throw new ClusterConfigException(exception, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppManagement");
        }
        return appManagement;
    }

    public static String getFormattedMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
            if (string2 == null) {
                string2 = new String("Cannot find message key " + string + "in resource bundle" + resourceBundle.toString());
                Tr.event(tc, string2);
            }
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = new String("Cannot find message key " + string + "in resource bundle " + resourceBundle.toString());
            Tr.event(tc, string2);
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            string2 = new String("Null pointer exception caught trying to find message key " + string + " in resource bundle " + resourceBundle.toString());
            Tr.event(tc, string2);
        }
        return string2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectName convertServerToClusterMember(ConfigService configService, Session session, ObjectName objectName, ObjectName objectName2, Integer n) throws ClusterConfigException, ConfigServiceException, ConnectorException {
        ObjectName objectName3;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "convertServerToClusterMember");
            }
            objectName3 = null;
            ObjectName objectName4 = null;
            Object var7_7 = null;
            ObjectName[] objectNameArray = null;
            AttributeList attributeList = new AttributeList();
            String string = ConfigServiceHelper.getDisplayName(objectName2);
            String string2 = ConfigServiceHelper.getDisplayName(objectName);
            String string3 = null;
            boolean bl = false;
            try {
                objectNameArray = null;
                objectNameArray = configService.getRelationship(session, objectName, "parent");
                if (objectNameArray.length < 1) {
                    String string4 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9241E", new Object[]{string2});
                    throw new ClusterConfigException(string4);
                }
                objectName4 = objectNameArray[0];
                string3 = ConfigServiceHelper.getDisplayName(objectName4);
                Tr.debug(tc, "Adding server to new cluster.");
                attributeList.clear();
                attributeList.add(new Attribute("memberName", string2));
                attributeList.add(new Attribute("nodeName", string3));
                if (n != null) {
                    attributeList.add(new Attribute("weight", n));
                }
                String string5 = String.valueOf(System.currentTimeMillis());
                ConfigServiceHelper.setAttributeValue(attributeList, "uniqueId", string5);
                objectName3 = configService.createConfigData(session, objectName2, "members", "ClusterMember", attributeList);
                Tr.debug(tc, "Setting server's cluster name.");
                attributeList.clear();
                attributeList.add(new Attribute("clusterName", string));
                configService.setAttributes(session, objectName, attributeList);
                Tr.debug(tc, "Informing App Management that server is now a member.");
                AppManagement appManagement = ClusterConfigHelper.getAppManagement(configService);
                Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
                ObjectName objectName5 = new ObjectName("WebSphere", properties);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverId", objectName5);
                }
                Properties properties2 = new Properties();
                String string6 = properties.getProperty("cell");
                properties2.put("cell", string6);
                properties2.put("cluster", string);
                ObjectName objectName6 = new ObjectName("WebSphere", properties2);
                appManagement.changeServerToCluster(objectName5, objectName6, null, session.toString());
                bl = true;
                if (bl || objectName3 == null) break block14;
            }
            catch (ClusterConfigException clusterConfigException) {
                try {
                    throw clusterConfigException;
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        String string7 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9242E", new Object[]{string2, string3, string, malformedObjectNameException.toString()});
                        throw new ClusterConfigException(malformedObjectNameException, string7);
                    }
                    catch (ConfigServiceException configServiceException) {
                        String string8 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9242E", new Object[]{string2, string3, string, configServiceException.toString()});
                        throw new ClusterConfigException(configServiceException, string8);
                    }
                    catch (ConnectorException connectorException) {
                        String string9 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9242E", new Object[]{string2, string3, string, connectorException.toString()});
                        throw new ClusterConfigException(connectorException, string9);
                    }
                    catch (AdminException adminException) {
                        String string10 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9242E", new Object[]{string2, string3, string, adminException.toString()});
                        throw new ClusterConfigException(adminException, string10);
                    }
                }
                catch (Throwable throwable) {
                    if (!bl && objectName3 != null) {
                        configService.deleteConfigData(session, objectName3);
                    }
                    throw throwable;
                }
            }
            configService.deleteConfigData(session, objectName3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertServerToClusterMember");
        }
        return objectName3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectName createClusterMemberFromTemplate(ConfigService configService, Session session, String string, String string2, ObjectName objectName, ObjectName objectName2, String string3, String string4, String string5, Boolean bl, String string6, String string7, Boolean bl2, String string8) throws ClusterConfigException, ConfigServiceException, ConnectorException {
        String string9;
        AttributeList attributeList;
        String string10;
        ObjectName objectName3;
        block49: {
            block50: {
                AttributeList attributeList2;
                ObjectName objectName4;
                block48: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "createClusterMemberFromTemplate", new Object[]{string, string2, objectName, objectName2, string4, string5, bl2});
                    }
                    objectName3 = null;
                    objectName4 = null;
                    ObjectName objectName6 = null;
                    Object var17_17 = null;
                    objectName6 = ClusterConfigHelper.getNodeObj(configService, session, string2);
                    if (objectName6 == null) {
                        String string11 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9218E", new Object[]{string2});
                        throw new ClusterConfigException(string11);
                    }
                    attributeList2 = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(attributeList2, "memberName", string);
                    ConfigServiceHelper.setAttributeValue(attributeList2, "nodeName", ConfigServiceHelper.getDisplayName(objectName6));
                    if (string3 == null) {
                        string3 = String.valueOf(System.currentTimeMillis());
                    }
                    ConfigServiceHelper.setAttributeValue(attributeList2, "uniqueId", string3);
                    string10 = null;
                    attributeList = new AttributeList();
                    string9 = ConfigServiceHelper.getDisplayName(objectName);
                    try {
                        if (objectName2 != null) {
                            string10 = (String)configService.getAttribute(session, objectName2, "clusterName");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "clusterName in template is " + string10);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot set clusterName when template is not choosen");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "clusterName in template is " + string10);
                        }
                        if (objectName2 == null || string10 != null && !string10.equals("") && (string10 == null || string10.equals(string9))) break block48;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "clusterName is not set in template");
                        }
                        ConfigServiceHelper.setAttributeValue(attributeList, "clusterName", string9);
                        configService.setAttributes(session, objectName2, attributeList);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "clusterName is set in template");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                attributeList.clear();
                if (bl != null) {
                    ConfigServiceHelper.setAttributeValue(attributeList, "adjustPort", bl);
                }
                boolean bl3 = false;
                try {
                    try {
                        Serializable serializable;
                        ObjectName objectName5;
                        ObjectName objectName7 = null;
                        if (string7 != null) {
                            objectName7 = objectName2;
                        } else if (objectName2 != null) {
                            string7 = ConfigServiceHelper.getDisplayName(objectName2);
                            objectName7 = ClusterConfigHelper.getTemplateLocation(configService, session, objectName2);
                        }
                        String string12 = null;
                        if (AdminHelper.getPlatformHelper().isZOS()) {
                            string12 = (String)configService.getAttribute(session, objectName, "shortName");
                        }
                        objectName4 = ClusterConfigHelper.createClusterMember(configService, session, string2, string, objectName7, string4, bl, string7, string6, string8, string12, string9);
                        if (bl2 != null && bl2.booleanValue()) {
                            objectName5 = configService.queryConfigObjects(session, objectName4, ConfigServiceHelper.createObjectName(null, "SessionManager"), null)[0];
                            serializable = new AttributeList();
                            serializable.add(new Attribute("sessionPersistenceMode", "DATA_REPLICATION"));
                            configService.setAttributes(session, objectName5, (AttributeList)serializable);
                            serializable.clear();
                            serializable.add(new Attribute("messageBrokerDomainName", ConfigServiceHelper.getDisplayName(objectName)));
                            configService.createConfigData(session, objectName5, "sessionDRSPersistence", "DRSSettings", (AttributeList)serializable);
                        }
                        objectName3 = configService.createConfigData(session, objectName, "members", "ClusterMember", attributeList2);
                        attributeList.clear();
                        ConfigServiceHelper.setAttributeValue(attributeList, "name", string);
                        ConfigServiceHelper.setAttributeValue(attributeList, "clusterName", ConfigServiceHelper.getDisplayName(objectName));
                        configService.setAttributes(session, objectName4, attributeList);
                        objectName5 = new ObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(objectName4));
                        serializable = new ObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(objectName));
                        ClusterConfigHelper.getAppManagement(configService).clusterMemberAdded(objectName5, (ObjectName)serializable, null, session.toString());
                        if (string5 != null && string5.length() > 0) {
                            String string13 = (String)configService.getAttribute(session, objectName, "nodeGroupName");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "nodeGroupName", string13);
                            }
                            ObjectName objectName8 = ConfigServiceHelper.createObjectName(null, "ClusterMember");
                            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName8, null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "There are currently " + objectNameArray.length + " members in cluster " + ConfigServiceHelper.getDisplayName(objectName));
                            }
                            if (objectNameArray != null && objectNameArray.length == 1) {
                                AttributeList attributeList3 = new AttributeList();
                                ConfigServiceHelper.setAttributeValue(attributeList3, "nodeGroupName", string5);
                                configService.setAttributes(session, objectName, attributeList3);
                            }
                        }
                        bl3 = true;
                    }
                    catch (ClusterConfigException clusterConfigException) {
                        throw clusterConfigException;
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        String string14 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{string, string2, ConfigServiceHelper.getDisplayName(objectName), malformedObjectNameException.toString()});
                        throw new ClusterConfigException(malformedObjectNameException, string14);
                    }
                    catch (ConfigServiceException configServiceException) {
                        String string15 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{string, string2, ConfigServiceHelper.getDisplayName(objectName), configServiceException.toString()});
                        throw new ClusterConfigException(configServiceException, string15);
                    }
                    catch (ConnectorException connectorException) {
                        String string16 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{string, string2, ConfigServiceHelper.getDisplayName(objectName), connectorException.toString()});
                        throw new ClusterConfigException(connectorException, string16);
                    }
                    catch (AdminException adminException) {
                        String string17 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{string, string2, ConfigServiceHelper.getDisplayName(objectName), adminException.toString()});
                        throw new ClusterConfigException(adminException, string17);
                    }
                    catch (Exception exception) {
                        String string18 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9243E", new Object[]{string, string2, ConfigServiceHelper.getDisplayName(objectName), exception.toString()});
                        throw new ClusterConfigException(exception, string18);
                    }
                    Object var32_44 = null;
                    if (bl3) break block49;
                    if (objectName4 == null) break block50;
                }
                catch (Throwable throwable) {
                    Object var32_45 = null;
                    if (!bl3) {
                        if (objectName4 != null) {
                            configService.deleteConfigData(session, objectName4);
                        }
                        if (objectName3 != null) {
                            configService.deleteConfigData(session, objectName3);
                        }
                    }
                    try {
                        if (objectName2 != null && (string10 == null || string10.equals(""))) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "clusterName is being removed from template");
                            }
                            String[] stringArray = new String[]{"clusterName"};
                            configService.unsetAttributes(session, objectName2, stringArray);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "clusterName is removed from template");
                            }
                            string10 = (String)configService.getAttribute(session, objectName2, "clusterName");
                            if (!tc.isDebugEnabled()) throw throwable;
                            Tr.debug(tc, "check again for clusterName " + string10);
                            throw throwable;
                        }
                        if (string10 == null) throw throwable;
                        if (string10.equals(string9)) throw throwable;
                        attributeList.clear();
                        ConfigServiceHelper.setAttributeValue(attributeList, "clusterName", string10);
                        configService.setAttributes(session, objectName2, attributeList);
                        if (!tc.isDebugEnabled()) throw throwable;
                        Tr.debug(tc, "clusterName is reset in template");
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                configService.deleteConfigData(session, objectName4);
            }
            if (objectName3 != null) {
                configService.deleteConfigData(session, objectName3);
            }
        }
        try {}
        catch (Exception exception) {}
        if (objectName2 != null && (string10 == null || string10.equals(""))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterName is being removed from template");
            }
            String[] stringArray = new String[]{"clusterName"};
            configService.unsetAttributes(session, objectName2, stringArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterName is removed from template");
            }
            string10 = (String)configService.getAttribute(session, objectName2, "clusterName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "check again for clusterName " + string10);
            }
        } else if (string10 != null && !string10.equals(string9)) {
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, "clusterName", string10);
            configService.setAttributes(session, objectName2, attributeList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterName is reset in template");
            }
        }
        if (!tc.isEntryEnabled()) return objectName3;
        Tr.exit(tc, "createClusterMemberFromTemplate");
        return objectName3;
    }

    public static ObjectName createClusterMember(ConfigService configService, Session session, String string, String string2, ObjectName objectName, String string3, Boolean bl, String string4, String string5, String string6) throws ClusterConfigException {
        return ClusterConfigHelper.createClusterMember(configService, session, string, string2, objectName, string3, bl, string4, string5, string6, null);
    }

    public static ObjectName createClusterMember(ConfigService configService, Session session, String string, String string2, ObjectName objectName, String string3, Boolean bl, String string4, String string5, String string6, String string7) throws ClusterConfigException {
        return ClusterConfigHelper.createClusterMember(configService, session, string, string2, objectName, string3, bl, string4, string5, string6, string7, null);
    }

    private static ObjectName createClusterMember(ConfigService configService, Session session, String string, String string2, ObjectName objectName, String string3, Boolean bl, String string4, String string5, String string6, String string7, String string8) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClusterMember");
        }
        ObjectName objectName2 = null;
        try {
            Object object;
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            TaskCommand taskCommand = null;
            taskCommand = string5 != null ? (string5.equals("PROXY_SERVER") ? (TaskCommand)commandMgr.createCommand("createProxyServer") : (string5.equals("ONDEMAND_ROUTER") ? (TaskCommand)commandMgr.createCommand("createOnDemandRouter") : (TaskCommand)commandMgr.createCommand("createApplicationServer"))) : (TaskCommand)commandMgr.createCommand("createApplicationServer");
            taskCommand.setConfigSession(session);
            taskCommand.setTargetObject(string);
            taskCommand.setParameter("name", string2);
            if (bl == null) {
                taskCommand.setParameter("genUniquePorts", new Boolean(true));
            } else {
                taskCommand.setParameter("genUniquePorts", bl);
            }
            if (string4 != null) {
                taskCommand.setParameter("templateName", string4);
                if (objectName != null) {
                    taskCommand.setParameter("templateLocation", objectName);
                }
            } else if (objectName != null) {
                taskCommand.setParameter("templateName", "clusterMember");
                taskCommand.setParameter("templateLocation", objectName);
            }
            if (string6 != null) {
                taskCommand.setParameter("specificShortName", string6);
            }
            if (string7 != null) {
                taskCommand.setParameter("genericShortName", string7);
            }
            if (string8 != null) {
                taskCommand.setParameter("clusterName", string8);
            }
            if (string3 != null) {
                object = taskCommand.getCommandStep("ConfigCoreGroup");
                object.setParameter("coregroupName", string3);
            }
            taskCommand.execute();
            object = taskCommand.getCommandResult();
            if (!object.isSuccessful()) {
                Object object2 = object.getResult();
                if (object2 != null && object2 instanceof String) {
                    throw new ClusterConfigException(object.getException(), (String)object2);
                }
                throw new ClusterConfigException(object.getException());
            }
            objectName2 = (ObjectName)object.getResult();
        }
        catch (Exception exception) {
            throw new ClusterConfigException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClusterMember");
        }
        return objectName2;
    }

    public static void deleteClusterMember(ConfigService configService, Session session, String string, String string2, String string3) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteClusterMember");
        }
        Object var5_5 = null;
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            TaskCommand taskCommand = (TaskCommand)commandMgr.createCommand("deleteServer");
            taskCommand.setConfigSession(session);
            taskCommand.setParameter("nodeName", string);
            taskCommand.setParameter("serverName", string2);
            taskCommand.execute();
            CommandResult commandResult = taskCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Object object = commandResult.getResult();
                if (object != null && object instanceof String) {
                    throw new ClusterConfigException(commandResult.getException(), (String)object);
                }
                throw new ClusterConfigException(commandResult.getException());
            }
        }
        catch (Exception exception) {
            throw new ClusterConfigException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteClusterMember");
        }
    }

    public static void addDefaultResources(ConfigService configService, Session session, String string) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDefaultResources", string);
        }
        try {
            RepositoryContextType repositoryContextType;
            Collection collection;
            String string2;
            RepositoryContext repositoryContext;
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContextType repositoryContextType2 = repositoryMetaData.getContextType("servertypes");
            RepositoryContextType repositoryContextType3 = repositoryMetaData.getContextType("servers");
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
            RepositoryContext repositoryContext2 = templateManager.getRootTemplateContext();
            if (repositoryContext2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find template context");
                }
                throw new ClusterConfigException("Cannot find template context");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context ", repositoryContext2);
            }
            if ((repositoryContext = repositoryContext2.getChild(repositoryContextType2, string2 = "APPLICATION_SERVER")) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find server type context");
                }
                throw new ClusterConfigException("Cannot find server type context");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context for servertypes", repositoryContext);
            }
            List list = repositoryContext.getChildren();
            RepositoryContext repositoryContext3 = null;
            Object object = list.iterator();
            while (object.hasNext() && !(repositoryContext3 = (RepositoryContext)object.next()).getName().equals("default")) {
            }
            if (repositoryContext3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find template for default server");
                }
                throw new ClusterConfigException("Cannot find default server template context");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context for server", repositoryContext3.getName());
            }
            if ((collection = (object = workSpace.getRootContext()).findContext(repositoryContextType = repositoryMetaData.getContextType("cells"))) == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find cell context");
                }
                throw new ClusterConfigException("Cannot find cell context");
            }
            RepositoryContext repositoryContext4 = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for cell", repositoryContext4.getName());
            }
            if ((collection = repositoryContext4.findContext("clusters", string)) == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find cluster context for cluster " + string);
                }
                throw new ClusterConfigException("Cannot find cluster context for " + string);
            }
            RepositoryContext repositoryContext5 = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for cluster", repositoryContext5.getName());
            }
            ClusterConfigHelper.copyFile(repositoryContext5, repositoryContext3, string, "resources.xml");
            ObjectName objectName = ClusterConfigHelper.getClusterObj(configService, session, string);
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "DataSource");
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            if (objectNameArray != null) {
                if (objectNameArray.length != 1 && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Warning: Number of cluster data sources = " + objectNameArray.length + "!");
                }
                for (int i = 0; i < objectNameArray.length; ++i) {
                    String string3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dataSources[" + i + "] = " + objectNameArray[i]);
                    }
                    if ((string3 = ConfigServiceHelper.getDisplayName(objectNameArray[i])).equals("DefaultEJBTimerDataSource")) {
                        configService.deleteConfigData(session, objectNameArray[i]);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Removed data source " + string3);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Warning: data source " + string3 + " did not match!");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: dataSources is null!");
            }
            try {
                ClusterConfigHelper.copyFile(repositoryContext5, repositoryContext3, string, "resources-pme.xml");
                ClusterConfigHelper.copyFile(repositoryContext5, repositoryContext3, string, "resources-pme502.xml");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to copy PME resources to cluster ", repositoryContext5.getName());
                }
            }
        }
        catch (ClusterConfigException clusterConfigException) {
            throw clusterConfigException;
        }
        catch (Exception exception) {
            throw new ClusterConfigException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDefaultResources");
        }
    }

    private static void copyFile(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, String string, String string2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile", new Object[]{repositoryContext, repositoryContext2, string, string2});
        }
        if (!repositoryContext2.isAvailable(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning - template context not available");
            }
            return;
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(repositoryContext.getWorkSpace());
        Template template = templateManager.getTemplate(repositoryContext2);
        templateManager.createFile(repositoryContext, string2, template, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static Boolean isMemberCompatibleWithNode(ConfigService configService, Session session, String string, ObjectName objectName, String string2, String string3, ObjectName objectName2) throws ClusterConfigException, MemberNodeVersionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMemberCompatibleWithNode");
        }
        Boolean bl = new Boolean(true);
        Properties properties = new Properties();
        Object var9_9 = null;
        Object var10_10 = null;
        String string4 = null;
        ObjectName objectName3 = null;
        Object var13_13 = null;
        ObjectName[] objectNameArray = null;
        AttributeList attributeList = new AttributeList();
        try {
            objectNameArray = configService.resolve(session, "Cell");
            if (objectNameArray.length < 1) {
                string4 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9211E", null);
                throw new ClusterConfigException(string4);
            }
            objectName3 = objectNameArray[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper.");
            }
            properties.setProperty("local.cell", ConfigServiceHelper.getDisplayName(objectName3));
            String string5 = System.getProperty("was.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "was.install.root=" + (string5 == null ? "null" : string5));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper");
            }
            ManagedObjectMetadataHelper managedObjectMetadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            String string6 = managedObjectMetadataHelper.getNodeBaseProductVersion(string2);
            String string7 = managedObjectMetadataHelper.getNodeBaseProductVersion(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberNode=" + string2 + "  memberVersion=" + string6);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName=" + string + "  nodeVersion=" + string7);
            }
            bl = ClusterConfigHelper.checkNodeVersions(string6, string7);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Excption caught during checkoing node version for compatibility ", string + " " + string2);
            }
            throw new ClusterConfigException(exception, string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMemberCompatibleWithNode");
        }
        return bl;
    }

    public static String getEffectiveNodeVersion(String string) {
        int n = string.indexOf(".");
        String string2 = string;
        if (n < 0) {
            return string2;
        }
        string2 = string.startsWith("6.1") ? "6.1" : string.substring(0, n);
        return string2;
    }

    public static Boolean checkNodeVersions(String string, String string2) {
        String string3;
        Boolean bl = Boolean.FALSE;
        if (string == null || string2 == null) {
            return bl;
        }
        String string4 = ClusterConfigHelper.getEffectiveNodeVersion(string);
        bl = !string4.equals(string3 = ClusterConfigHelper.getEffectiveNodeVersion(string2)) ? Boolean.FALSE : Boolean.TRUE;
        return bl;
    }

    public static String getMemberNodeVersion(ConfigService configService, Session session, String string) throws ClusterConfigException, MemberNodeVersionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMemberNodeVersion");
        }
        ObjectName[] objectNameArray = null;
        Properties properties = new Properties();
        Object var5_5 = null;
        String string2 = null;
        String string3 = null;
        ObjectName objectName = null;
        try {
            objectNameArray = configService.resolve(session, "Cell");
            if (objectNameArray.length < 1) {
                string3 = ClusterConfigHelper.getFormattedMessage(resBundle, "ADMG9211E", null);
                throw new ClusterConfigException(string3);
            }
            objectName = objectNameArray[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper.");
            }
            properties.setProperty("local.cell", ConfigServiceHelper.getDisplayName(objectName));
            String string4 = System.getProperty("was.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "was.install.root=" + (string4 == null ? "null" : string4));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting managed object metadata helper");
            }
            ManagedObjectMetadataHelper managedObjectMetadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            string2 = managedObjectMetadataHelper.getNodeBaseProductVersion(string);
            string2 = ClusterConfigHelper.getEffectiveNodeVersion(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName=" + string + "  nodeVersion=" + string2);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Excption caught during get node major version for node ", string);
            }
            throw new ClusterConfigException(exception, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberNodeVersion");
        }
        return string2;
    }

    public static String getClusterType(ConfigService configService, Session session, ObjectName objectName) {
        String string = null;
        try {
            string = (String)configService.getAttribute(session, objectName, "serverType");
        }
        catch (ConfigServiceException configServiceException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static ObjectName getBestMemberTemplate(ConfigService configService, Session session, ObjectName objectName, String string, String string2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBestMemberTemplate", objectName + " " + string + " " + string2);
        }
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        boolean bl = false;
        String string3 = "APPLICATION_SERVER";
        string3 = ClusterConfigHelper.getClusterType(configService, session, objectName);
        if (string3 == null || string3.equals("")) {
            string3 = "APPLICATION_SERVER";
        }
        int n = 0;
        Integer n2 = null;
        try {
            n2 = TemplateConfigHelper.getDefaultTemplateMatchCount(configService, session, string3, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 != null) {
            n = n2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "required matchcount = ", new Integer(n));
        }
        List list = new ArrayList();
        try {
            list = ClusterConfigHelper.getMemberTemplates(configService, session, objectName, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            objectName2 = (ObjectName)iterator.next();
            int n3 = 0;
            try {
                n3 = TemplateConfigHelper.getMatchCount(configService, session, objectName2, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n3 < n) continue;
            ArrayList arrayList = new ArrayList();
            try {
                Class<?> clazz = Class.forName("com.ibm.websphere.management.application.AppDeploymentUtil");
                Method method2 = clazz.getMethod("isNodeValidForCluster", class$java$lang$String == null ? ClusterConfigHelper.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? ClusterConfigHelper.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? ClusterConfigHelper.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? ClusterConfigHelper.class$("java.lang.String") : class$java$lang$String, class$java$util$Locale == null ? ClusterConfigHelper.class$("java.util.Locale") : class$java$util$Locale, class$java$util$List == null ? ClusterConfigHelper.class$("java.util.List") : class$java$util$List);
                method2.invoke(null, TemplateConfigHelper.getCellName(configService, session, objectName), string2, ConfigServiceHelper.getDisplayName(objectName), session.toString(), Locale.getDefault(), arrayList);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.templates.TemplateConfigHelper.getTemplateMetadata", "291");
            }
            if (arrayList.size() > 0) continue;
            n = n3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new match = ", n + " for " + objectName2);
            }
            objectName3 = objectName2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBestMemberTemplate", objectName3);
        }
        return objectName3;
    }

    public static ObjectName getMemberTemplate(ConfigService configService, Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        Object object;
        Collection collection;
        block19: {
            RepositoryContext repositoryContext;
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getMemberTemplate", objectName + " " + string);
                }
                String string2 = ConfigServiceHelper.getDisplayName(objectName);
                Object var5_5 = null;
                repositoryContext = null;
                try {
                    repositoryContext = ClusterConfigHelper.getClusterTemplateContext(string2, session);
                }
                catch (ClusterConfigException clusterConfigException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMemberTemplate", "Cannot get cluster template context");
                    }
                    try {
                        throw new ClusterConfigException(clusterConfigException, clusterConfigException.getMessage());
                    }
                    catch (ClusterConfigException clusterConfigException2) {
                        if (!tc.isEntryEnabled()) break block18;
                        Tr.exit(tc, "getMemberTemplate", "Failed throwing ClusterConfigException " + clusterConfigException2);
                    }
                }
            }
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            collection = null;
            try {
                collection = repositoryContext.findContext(repositoryMetaData.getContextType("servers"));
            }
            catch (WorkSpaceException workSpaceException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMemberTemplate", "Cannot get cluster template server list");
                }
                try {
                    throw new ClusterConfigException(workSpaceException, workSpaceException.getMessage());
                }
                catch (ClusterConfigException clusterConfigException) {
                    if (!tc.isEntryEnabled()) break block19;
                    Tr.exit(tc, "getMemberTemplate", "Failed throwing ClusterConfigException " + clusterConfigException);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of server contexts = " + collection.size());
        }
        Iterator iterator = collection.iterator();
        Object object2 = null;
        while (iterator.hasNext()) {
            object = (RepositoryContext)iterator.next();
            String string3 = object.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template for server " + string3);
            }
            if (!string3.equals("V" + string + "MemberTemplate")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching server context name " + string3);
            }
            object2 = object;
        }
        if (object2 != null) {
            object = MOFUtil.createObjectName(object2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMemberTemplate", object);
            }
            return object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberTemplate", null);
        }
        return null;
    }

    public static ObjectName createMemberTemplate(ConfigService configService, Session session, ObjectName objectName, ObjectName objectName2, String string) throws ClusterConfigException {
        ObjectName objectName3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMemberTemplate", objectName2 + " " + string);
        }
        try {
            List list = ClusterConfigHelper.getMemberTemplates(configService, session, objectName2, string);
            String string2 = ClusterConfigHelper.getNewMemberTemplate(configService, session, list, string);
            Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
            String string3 = properties.getProperty("node");
            String string4 = properties.getProperty("server");
            String string5 = ConfigServiceHelper.getDisplayName(objectName2);
            String string6 = string2;
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            TaskCommand taskCommand = (TaskCommand)commandMgr.createCommand("createApplicationServerTemplate");
            taskCommand.setConfigSession(session);
            taskCommand.setParameter("nodeName", string3);
            taskCommand.setParameter("serverName", string4);
            taskCommand.setParameter("templateName", string6);
            RepositoryContext repositoryContext = null;
            try {
                repositoryContext = ClusterConfigHelper.getClusterTemplateContext(string5, session);
            }
            catch (ClusterConfigException clusterConfigException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createMemberTemplate", "Cannot get cluster template context");
                }
                throw new ClusterConfigException(clusterConfigException, clusterConfigException.getMessage());
            }
            ObjectName objectName4 = MOFUtil.createObjectName(repositoryContext);
            taskCommand.setParameter("templateLocation", objectName4);
            taskCommand.execute();
            CommandResult commandResult = taskCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Object object = commandResult.getResult();
                if (object != null && object instanceof String) {
                    throw new ClusterConfigException(commandResult.getException(), (String)object);
                }
                throw new ClusterConfigException(commandResult.getException());
            }
            objectName3 = (ObjectName)commandResult.getResult();
        }
        catch (Exception exception) {
            throw new ClusterConfigException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMemberTemplate", objectName3);
        }
        return objectName3;
    }

    public static ObjectName getTemplateLocation(ConfigService configService, Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        ObjectName objectName2 = null;
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = properties.getProperty("servertype");
        String string2 = properties.getProperty("server");
        String string3 = properties.getProperty("node");
        if (string3 != null) {
            objectName2 = ClusterConfigHelper.getNodeObj(configService, session, string3);
        }
        return objectName2;
    }

    public static String getCoreGroupForServer(ConfigService configService, Session session, String string, String string2) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoreGroupForServer", string + " " + string2);
        }
        String string3 = null;
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("getCoreGroupNameForServer");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("nodeName", string);
            adminCommand.setParameter("serverName", string2);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Object object = commandResult.getResult();
                if (object != null && object instanceof String) {
                    throw new ClusterConfigException(commandResult.getException(), (String)object);
                }
                throw new ClusterConfigException(commandResult.getException());
            }
            string3 = (String)commandResult.getResult();
        }
        catch (Exception exception) {
            throw new ClusterConfigException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoreGroupForServer", string3);
        }
        return string3;
    }

    public static void changeClusterShortName(ConfigService configService, Session session, String string, String string2) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterShortName", string + " " + string2);
        }
        Object var4_4 = null;
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("changeClusterShortName");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("clusterName", string);
            adminCommand.setParameter("shortName", string2);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Object object = commandResult.getResult();
                if (object != null && object instanceof String) {
                    throw new ClusterConfigException(commandResult.getException(), (String)object);
                }
                throw new ClusterConfigException(commandResult.getException());
            }
        }
        catch (Exception exception) {
            throw new ClusterConfigException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterShortName", string);
        }
    }

    private static boolean noMoreMembers(ConfigService configService, Session session, ObjectName[] objectNameArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "noMoreMembers ", string);
        }
        boolean bl = true;
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = null;
            String string3 = null;
            try {
                string2 = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
                string3 = ClusterConfigHelper.getMemberNodeVersion(configService, session, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node  ", string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "version ", string3);
            }
            if (string3 == null || !string3.equals(string)) continue;
            bl = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "noMoreMembers", new Boolean(bl));
        }
        return bl;
    }

    public static void deleteMemberTemplate(ConfigService configService, Session session, String string, ObjectName objectName, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTemplate ", string2);
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "ClusterMember");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        String string3 = ClusterConfigHelper.getMemberNodeVersion(configService, session, string2);
        boolean bl = false;
        boolean bl2 = false;
        List list = ClusterConfigHelper.getMemberTemplates(configService, session, objectName, string3);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            ObjectName objectName3 = (ObjectName)iterator.next();
            if (ClusterConfigHelper.templateBeingUsed(configService, session, objectName3, objectNameArray)) continue;
            String string4 = ConfigServiceHelper.getDisplayName(objectName3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting member template ", string4);
            }
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting member template  metadata ", configDataId);
            }
            RepositoryContext repositoryContext = null;
            try {
                repositoryContext = ClusterConfigHelper.getClusterTemplateContext(string, session);
            }
            catch (ClusterConfigException clusterConfigException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteMemberTemplate", "Cannot get cluster template context");
                }
                throw new ClusterConfigException(clusterConfigException, clusterConfigException.getMessage());
            }
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "template-metadata.xml");
            if (docAccessor != null) {
                object = docAccessor.getRootObjects(session);
                for (int i = 0; object != null && i < ((Object)object).length; ++i) {
                    PropertySet propertySet = (PropertySet)MOFUtil.convertToEObject(session, (ObjectName)object[i]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got PropertySet: " + propertySet);
                    }
                    boolean bl3 = false;
                    EList eList = propertySet.getProperties();
                    Iterator iterator2 = eList.iterator();
                    while (iterator2.hasNext()) {
                        Property property = (Property)iterator2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Props ", property);
                        }
                        if (!property.getName().equals("name") || !property.getValue().equals(string4)) continue;
                        ObjectName objectName4 = MOFUtil.createObjectName((EObject)propertySet);
                        configService.deleteConfigData(session, objectName4);
                        bl3 = true;
                        break;
                    }
                    if (bl3) break;
                }
            }
            object = new BaseServerDelegator(ConfigServiceImpl.getInstance());
            ((BaseServerDelegator)object).deleteConfigData(session, objectName3);
        }
    }

    public static boolean isShortNameValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isShortNameValid " + string);
        }
        boolean bl = true;
        if (string != null && string.length() > 8) {
            bl = false;
        }
        for (int i = 0; string != null && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 && Character.isDigit(c)) {
                bl = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "First letter is digit " + string);
                break;
            }
            if (!Character.isLetterOrDigit(c)) {
                bl = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "shortname is not letter or digit " + string);
                break;
            }
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shortname is not uppercase letter " + string);
            }
            bl = false;
            break;
        }
        if (string != null && !AdminHelper.getPlatformHelper().isZOS()) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isShortNameValid " + new Boolean(bl));
        }
        return bl;
    }

    public static void promoteServerResources(ConfigService configService, Session session, String string, String string2, String string3, String string4, ObjectName objectName) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "promoteServerResources", string + " " + " " + string2 + " " + string3);
        }
        try {
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            RepositoryContext repositoryContext = workSpace.getRootContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
            Collection collection = repositoryContext.findContext(repositoryContextType);
            if (collection == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find cell context");
                }
                throw new ClusterConfigException("Cannot find cell context");
            }
            RepositoryContext repositoryContext2 = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for cell", repositoryContext2.getName());
            }
            if ((collection = repositoryContext2.findContext("nodes", string2)) == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find node context for node " + string2);
                }
                throw new ClusterConfigException("Cannot find node context for " + string2);
            }
            RepositoryContext repositoryContext3 = (RepositoryContext)collection.iterator().next();
            if ((collection = repositoryContext3.findContext("servers", string3)) == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find server context for " + string3);
                }
                throw new ClusterConfigException("Cannot find server context for " + string3);
            }
            RepositoryContext repositoryContext4 = (RepositoryContext)collection.iterator().next();
            if (repositoryContext4 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Server context for " + string3 + " is null");
                }
                throw new ClusterConfigException("Server context for " + string3 + " is null");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for server", repositoryContext4.getName());
            }
            if ((collection = repositoryContext2.findContext("clusters", string)) == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find cluster context for cluster " + string);
                }
                throw new ClusterConfigException("Cannot find cluster context for " + string);
            }
            RepositoryContext repositoryContext5 = (RepositoryContext)collection.iterator().next();
            if (repositoryContext5 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "promoteServerResources", "Cannot find cluster context for server");
                }
                throw new ClusterConfigException("Cannot find cluster context for server");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found context for cluster", repositoryContext5.getName());
            }
            if (null == string4 || string4.trim().equals("") || string4.equalsIgnoreCase(RESOURCES_SCOPE_BOTH) || string4.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER)) {
                block49: {
                    ObjectName[] objectNameArray;
                    block46: {
                        if ("true".equals(System.getProperty("com.ibm.websphere.management.disableResourcePromotion")) && repositoryContext5.isAvailable("resources.xml")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cluster has resources, don't merge");
                            }
                            return;
                        }
                        try {
                            repositoryContext5.delete("resources.xml");
                        }
                        catch (WorkSpaceException workSpaceException) {
                            if (!tc.isDebugEnabled()) break block46;
                            Tr.debug(tc, "Ignoring " + workSpaceException + " while deleting resources.xml");
                        }
                    }
                    ClusterConfigHelper.copyFile(repositoryContext5, repositoryContext4, string, "resources.xml");
                    String string5 = ConfigServiceHelper.getDisplayName(objectName);
                    String string6 = "Cell=" + string5 + ":ServerCluster=" + string + ":JDBCProvider:DataSource:";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "clusterSpec = " + string6);
                    }
                    if ((objectNameArray = configService.resolve(session, string6)) != null) {
                        if (objectNameArray.length != 1 && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Warning: Number of cluster data sources = " + objectNameArray.length + "!");
                        }
                        for (int i = 0; i < objectNameArray.length; ++i) {
                            String string7;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "dataSources[" + i + "] = " + objectNameArray[i]);
                            }
                            if ((string7 = ConfigServiceHelper.getDisplayName(objectNameArray[i])).equals("DefaultEJBTimerDataSource")) {
                                configService.deleteConfigData(session, objectNameArray[i]);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Removed data source " + string7);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Warning: data source " + string7 + " did not match!");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Warning: dataSources is null!");
                    }
                    String string8 = ClusterConfigHelper.getMemberNodeVersion(configService, session, string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeVersion = " + string8);
                    }
                    if (string8 != null && string8.charAt(0) >= '6') {
                        try {
                            block48: {
                                block47: {
                                    try {
                                        repositoryContext5.delete("resources-pme.xml");
                                    }
                                    catch (WorkSpaceException workSpaceException) {
                                        if (!tc.isDebugEnabled()) break block47;
                                        Tr.debug(tc, "Ignoring " + workSpaceException + " while deleting resources-pme.xml");
                                    }
                                }
                                ClusterConfigHelper.copyFile(repositoryContext5, repositoryContext4, string, "resources-pme.xml");
                                try {
                                    repositoryContext5.delete("resources-pme502.xml");
                                }
                                catch (WorkSpaceException workSpaceException) {
                                    if (!tc.isDebugEnabled()) break block48;
                                    Tr.debug(tc, "Ignoring " + workSpaceException + " while deleting resources-pme502.xml");
                                }
                            }
                            ClusterConfigHelper.copyFile(repositoryContext5, repositoryContext4, string, "resources-pme502.xml");
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block49;
                            Tr.debug(tc, "Failed to copy PME resources to cluster ", repositoryContext5.getName());
                        }
                    }
                }
                if (string4.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER)) {
                    ClusterConfigHelper.removeServerResources(session, string2, string, string3);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeVersion is null!");
                }
            } else if (!string4.equalsIgnoreCase(RESOURCES_SCOPE_SERVER)) {
                throw new ClusterConfigException("resourcesScope parameter value: " + string4 + " is not valid");
            }
            ClusterConfigHelper.saveResourcesScopeProperty(configService, session, string, string4);
        }
        catch (ClusterConfigException clusterConfigException) {
            throw clusterConfigException;
        }
        catch (Exception exception) {
            throw new ClusterConfigException(exception, exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promoteServerResources");
        }
    }

    private static void saveResourcesScopeProperty(ConfigService configService, Session session, String string, String string2) throws ConfigServiceException, WorkSpaceException, IOException, ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveResourceScopeProperty");
        }
        if (!(string2 == null || string2.trim().equals("") || string2.equalsIgnoreCase(RESOURCES_SCOPE_BOTH) || string2.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER) || string2.equalsIgnoreCase(RESOURCES_SCOPE_SERVER))) {
            throw new ClusterConfigException("resourcesScope parameter value: " + string2 + " is not valid");
        }
        OutputStream outputStream = null;
        RepositoryContext repositoryContext = ClusterConfigHelper.getClusterContext(session, string);
        outputStream = repositoryContext.getOutputStream("resourcesScope.properties");
        Properties properties = new Properties();
        properties.setProperty(RESOURCES_SCOPE, string2);
        properties.store(outputStream, "Possible resourcesScope values are null, both, cluster, and server");
        outputStream.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveResourceScopeProperty");
        }
    }

    public static InputStream getResourcesScopePropertyInputFile(Session session, String string) throws ConfigServiceException, WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcesScopePropertyFile");
        }
        RepositoryContext repositoryContext = ClusterConfigHelper.getClusterContext(session, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesScopePropertyFile");
        }
        return repositoryContext.getInputStream("resourcesScope.properties");
    }

    private static RepositoryContext getClusterContext(Session session, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterContext");
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryContext repositoryContext = workSpace.getRootContext();
        RepositoryContext repositoryContext2 = null;
        List list = repositoryContext.getChildren();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            RepositoryContext repositoryContext3 = (RepositoryContext)iterator.next();
            String string2 = repositoryContext3.getType().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "contextName=" + string2);
            }
            if (!string2.equalsIgnoreCase("cells")) continue;
            List list2 = repositoryContext3.getChildren();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                RepositoryContext repositoryContext4 = (RepositoryContext)iterator2.next();
                String string3 = repositoryContext4.getName();
                if (!repositoryContext4.getType().getName().equalsIgnoreCase("clusters") || !string.equalsIgnoreCase(string3)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clusterName=" + string);
                    Tr.debug(tc, "cellClusterName=" + string3);
                }
                repositoryContext2 = repositoryContext4;
                break block0;
            }
            break block0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterContext");
        }
        return repositoryContext2;
    }

    public static void removeServerResources(Session session, String string, String string2, String string3) throws Exception {
        block17: {
            RepositoryContext repositoryContext;
            block16: {
                RepositoryContextType repositoryContextType;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "removeServerResources");
                }
                RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                RepositoryContext repositoryContext2 = workSpace.getRootContext();
                Collection collection = repositoryContext2.findContext(repositoryContextType = repositoryMetaData.getContextType("cells"));
                if (collection == null || collection.size() < 1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteServerResources", "Cannot find cell context");
                    }
                    throw new ClusterConfigException("Cannot find cell context");
                }
                RepositoryContext repositoryContext3 = (RepositoryContext)collection.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found context for cell", repositoryContext3.getName());
                }
                if ((collection = repositoryContext3.findContext("nodes", string)) == null || collection.size() < 1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteServerResources", "Cannot find node context for node " + string);
                    }
                    throw new ClusterConfigException("Cannot find node context for " + string);
                }
                RepositoryContext repositoryContext4 = (RepositoryContext)collection.iterator().next();
                if ((collection = repositoryContext4.findContext("servers", string3)) == null || collection.size() < 1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteServerResources", "Cannot find server context for " + string3);
                    }
                    throw new ClusterConfigException("Cannot find server context for " + string3);
                }
                repositoryContext = (RepositoryContext)collection.iterator().next();
                if (repositoryContext == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteServerResources", "Server context for " + string3 + " is null");
                    }
                    throw new ClusterConfigException("Server context for " + string3 + " is null");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found context for server", repositoryContext.getName());
                }
                ClusterConfigHelper.preserveEJBTimerServerResources(repositoryContext);
                try {
                    repositoryContext.delete("resources-pme502.xml");
                }
                catch (WorkSpaceException workSpaceException) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "Ignoring " + workSpaceException + " while deleting resources-pme502.xml");
                }
            }
            try {
                repositoryContext.delete("resources-pme.xml");
            }
            catch (WorkSpaceException workSpaceException) {
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "Ignoring " + workSpaceException + " while deleting resources-pme502.xml");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServerResources");
        }
    }

    private static void preserveEJBTimerServerResources(RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preserveEJBTimer");
        }
        boolean bl = false;
        Resource resource = ConfigArchiveUtils.getResource(repositoryContext, "resources.xml");
        EList eList = resource.getContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            JDBCProvider jDBCProvider;
            Object e2 = iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found resource ", e2);
            }
            boolean bl2 = false;
            if (e2 instanceof JDBCProvider) {
                jDBCProvider = (JDBCProvider)e2;
                EList eList2 = jDBCProvider.getFactories();
                Iterator iterator2 = eList2.iterator();
                while (iterator2.hasNext()) {
                    Object e3 = iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found Datasource ", e3);
                    }
                    if (!(e3 instanceof DataSource)) continue;
                    DataSource dataSource = (DataSource)e3;
                    if (dataSource.getName().equals("DefaultEJBTimerDataSource")) {
                        bl = true;
                        bl2 = true;
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleting DataSource ", dataSource);
                    }
                    iterator2.remove();
                }
            } else if (e2 instanceof J2CResourceAdapter && (jDBCProvider = (J2CResourceAdapter)e2).getName().equals("WebSphere Relational Resource Adapter")) {
                bl2 = true;
            }
            if (bl2) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleting Resource ", e2);
            }
            iterator.remove();
        }
        if (bl) {
            resource.save(new HashMap());
        } else {
            repositoryContext.delete("resources.xml");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preserveEJBTimer");
        }
    }

    protected static RepositoryContext createContextIfNeeded(RepositoryContext repositoryContext, String string, String string2) throws Throwable {
        RepositoryMetaData repositoryMetaData;
        RepositoryContextType repositoryContextType;
        RepositoryContext repositoryContext2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createContextIfNeeded", new Object[]{repositoryContext, string, string2});
        }
        if ((repositoryContext2 = repositoryContext.getChild(repositoryContextType = (repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData()).getContextType(string), string2)) == null) {
            repositoryContext2 = repositoryContext.create(repositoryContextType, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createContextIfNeeded", repositoryContext2);
        }
        return repositoryContext2;
    }

    protected static RepositoryContext getClusterTemplateContext(String string, Session session) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterContext", string);
        }
        WorkSpace workSpace = null;
        try {
            workSpace = WorkspaceHelper.getWorkspace(session);
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot get workspace");
            }
            throw new ClusterConfigException(configServiceException, configServiceException.getMessage());
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
        RepositoryContext repositoryContext = null;
        try {
            repositoryContext = templateManager.getRootTemplateContext();
        }
        catch (WorkSpaceException workSpaceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot find template context");
            }
            throw new ClusterConfigException(workSpaceException, workSpaceException.getMessage());
        }
        if (repositoryContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "template context is null");
            }
            throw new ClusterConfigException("template context is null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found template context ", repositoryContext);
        }
        RepositoryContext repositoryContext2 = null;
        try {
            repositoryContext2 = ClusterConfigHelper.createContextIfNeeded(repositoryContext, "clusters", string);
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot find cluster template context");
            }
            throw new ClusterConfigException(throwable, throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterContext", string);
        }
        return repositoryContext2;
    }

    private static boolean templateBeingUsed(ConfigService configService, Session session, ObjectName objectName, ObjectName[] objectNameArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "templateBeingUsed", new Object[]{objectName, objectNameArray});
        }
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = null;
            String string2 = null;
            try {
                string = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
                string2 = ClusterConfigHelper.getMemberNodeVersion(configService, session, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node  ", string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "version ", string2);
                }
                if (!TemplateConfigHelper.isTemplateMatchWithNode(configService, session, objectName, string)) continue;
                bl = true;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "templateBeingUsed", new Boolean(bl));
        }
        return bl;
    }

    private static List getMemberTemplates(ConfigService configService, Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        return ClusterConfigHelper.getMemberTemplates(configService, session, objectName, null);
    }

    private static List getMemberTemplates(ConfigService configService, Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        Collection collection;
        ArrayList<ObjectName> arrayList;
        block18: {
            RepositoryContext repositoryContext;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getMemberTemplates", new Object[]{objectName, string});
                }
                String string2 = ConfigServiceHelper.getDisplayName(objectName);
                Object var5_5 = null;
                arrayList = new ArrayList<ObjectName>();
                repositoryContext = null;
                try {
                    repositoryContext = ClusterConfigHelper.getClusterTemplateContext(string2, session);
                }
                catch (ClusterConfigException clusterConfigException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMemberTemplates", "Cannot get cluster template context");
                    }
                    try {
                        throw new ClusterConfigException(clusterConfigException, clusterConfigException.getMessage());
                    }
                    catch (ClusterConfigException clusterConfigException2) {
                        if (!tc.isEntryEnabled()) break block17;
                        Tr.exit(tc, "getMemberTemplates", "Failed throwing ClusterConfigException " + clusterConfigException2);
                    }
                }
            }
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            collection = null;
            try {
                collection = repositoryContext.findContext(repositoryMetaData.getContextType("servers"));
            }
            catch (WorkSpaceException workSpaceException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMemberTemplates", "Cannot get cluster template server list");
                }
                try {
                    throw new ClusterConfigException(workSpaceException, workSpaceException.getMessage());
                }
                catch (ClusterConfigException clusterConfigException) {
                    if (!tc.isEntryEnabled()) break block18;
                    Tr.exit(tc, "getMemberTemplates", "Failed throwing ClusterConfigException " + clusterConfigException);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of server contexts = " + collection.size());
        }
        Iterator iterator = collection.iterator();
        Object var11_15 = null;
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            String string3 = repositoryContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template for server " + string3);
            }
            ObjectName objectName2 = MOFUtil.createObjectName(repositoryContext);
            if (string == null) {
                arrayList.add(objectName2);
                continue;
            }
            if (!string3.startsWith("V" + string + "MemberTemplate")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching server context name " + string3);
            }
            arrayList.add(objectName2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMemberTemplates", arrayList);
        }
        return arrayList;
    }

    private static String getNewMemberTemplate(ConfigService configService, Session session, List list, String string) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNewMemberTemplate", new Object[]{configService, session, list});
        }
        Object var4_4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (ObjectName)object2.next();
            String string2 = ConfigServiceHelper.getDisplayName((ObjectName)object);
            arrayList.add(string2);
        }
        object = object2 = "V" + string + "MemberTemplate";
        int n = 0;
        while (arrayList.contains(object)) {
            object = (String)object2 + new Integer(n);
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNewMemberTemplate", object);
        }
        return object;
    }
}

