/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.commands.cluster.ClusterConfigException;
import com.ibm.ws.management.commands.cluster.ClusterConfigHelper;
import com.ibm.ws.management.commands.nodegroup.NodeGroupConfigException;
import com.ibm.ws.management.commands.nodegroup.NodeGroupHelper;
import com.ibm.ws.management.util.ConfigLimits;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateClusterCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateClusterCommand.class, "ClusterConfig", BUNDLE_NAME);
    private static String CLUSTER_CONFIG_STEP = "clusterConfig";
    private static String CLUSTER_NAME_PARAM = "clusterName";
    private static String CLUSTER_TYPE_PARAM = "clusterType";
    private static String PREFER_LOCAL_PARAM = "preferLocal";
    private static String REP_DOMAIN_STEP = "replicationDomain";
    private static String CREATE_DOMAIN_PARM = "createDomain";
    private static String CONVERT_SERVER_STEP = "convertServer";
    private static String SERVER_NODE_PARAM = "serverNode";
    private static String SERVER_NAME_PARAM = "serverName";
    private static String MEMBER_WEIGHT_PARAM = "memberWeight";
    private static String NODE_GROUP_PARAM = "nodeGroup";
    private static String REP_ENTRY_PARAM = "replicatorEntry";
    private static String RESOURCES_SCOPE_PARAM = "resourcesScope";
    private static String RESOURCES_SCOPE_BOTH = "both";
    private static String RESOURCES_SCOPE_CLUSTER = "cluster";
    private static String RESOURCES_SCOPE_SERVER = "server";
    private static String RESOURCES_SCOPE = "resourcesScope";
    private String taskName = null;
    private String clusterConfigStep = null;
    private String clusterName = null;
    private String clusterType = null;
    private String shortName = null;
    private Boolean preferLocal = null;
    private Boolean replicationDomainStep = null;
    private Boolean createDomain = null;
    private Boolean convertServerStep = null;
    private String convertServerNode = null;
    private String convertServerName = null;
    private Integer memberWeight = null;
    private String nodeGroup = null;
    private Boolean replicatorEntry = null;
    private ObjectName newClusterObj = null;
    private ObjectName newMemberObj = null;
    private ObjectName convertServerObj = null;
    private ObjectName newRepDomainObj = null;
    private ObjectName newRepEntryObj = null;
    private String resourcesScope = null;

    public CreateClusterCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.taskName = taskCommandMetadata.getName();
    }

    public CreateClusterCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.taskName = commandData.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void beforeStepsExecuted() {
        block69: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "afterStepsExecuted");
            }
            String string = null;
            TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = null;
            ObjectName[] objectNameArray = null;
            AttributeList attributeList = new AttributeList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting to create new cluster.");
            }
            try {
                Object object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting the cell object.");
                }
                objectNameArray = null;
                objectName = ConfigServiceHelper.createObjectName(null, "Cell", null);
                ObjectName objectName2 = null;
                objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
                if (objectNameArray.length < 1) {
                    String string2 = this.getMsg(resBundle, "ADMG9211E", null);
                    throw new ClusterConfigException(string2);
                }
                objectName2 = objectNameArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting cluster attributes.");
                }
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, "name", this.clusterName);
                if (this.clusterType != null && this.clusterType.length() > 0) {
                    ConfigServiceHelper.setAttributeValue(attributeList, "serverType", this.clusterType);
                }
                ConfigServiceHelper.setAttributeValue(attributeList, "preferLocal", this.preferLocal);
                if (this.convertServerStep != null && this.convertServerStep.equals(Boolean.TRUE) && this.nodeGroup != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating NodeGroup", this.nodeGroup);
                    }
                    ConfigServiceHelper.setAttributeValue(attributeList, "nodeGroupName", this.nodeGroup);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating cluster config object.");
                }
                this.newClusterObj = configService.createConfigData(session, objectName2, "ServerCluster", "ServerCluster", attributeList);
                if (this.convertServerObj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding server " + this.convertServerNode + " on node " + this.convertServerNode + " to the cluster.");
                    }
                    this.newMemberObj = ClusterConfigHelper.convertServerToClusterMember(configService, session, this.convertServerObj, this.newClusterObj, this.memberWeight);
                }
                if (this.replicationDomainStep != null && this.replicationDomainStep.equals(Boolean.TRUE)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating replication domain.");
                    }
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, "name", this.clusterName);
                    this.newRepDomainObj = configService.createConfigData(session, objectName2, "DataReplicationDomain", "DataReplicationDomain", attributeList);
                    attributeList.clear();
                    object = configService.createConfigData(session, this.newRepDomainObj, "defaultDataReplicationSettings", "DataReplication", attributeList);
                }
                if (this.replicatorEntry != null && !this.replicatorEntry.equals(Boolean.FALSE) && this.convertServerObj != null) {
                    object = configService.queryConfigObjects(session, this.convertServerObj, ConfigServiceHelper.createObjectName(null, "SessionManager"), null)[0];
                    attributeList.clear();
                    attributeList.add(new Attribute("sessionPersistenceMode", "DATA_REPLICATION"));
                    configService.setAttributes(session, (ObjectName)object, attributeList);
                    attributeList.clear();
                    attributeList.add(new Attribute("messageBrokerDomainName", ConfigServiceHelper.getDisplayName(this.newClusterObj)));
                    configService.createConfigData(session, (ObjectName)object, "sessionDRSPersistence", "DRSSettings", attributeList);
                }
                if (this.convertServerObj != null) {
                    object = ClusterConfigHelper.getMemberNodeVersion(configService, session, this.convertServerNode);
                    ClusterConfigHelper.createMemberTemplate(configService, session, this.convertServerObj, this.newClusterObj, (String)object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resourcesScope=" + this.resourcesScope);
                    }
                    if (null == this.resourcesScope || this.resourcesScope.trim().equals("") || this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_BOTH) || this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER) || this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_SERVER)) {
                        if (tc.isDebugEnabled()) {
                            if (null == this.resourcesScope || this.resourcesScope.trim().equals("") || this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_BOTH)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Promoting " + this.convertServerNode + "/" + this.convertServerName + " copying resources");
                                }
                            } else if (this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Promoting " + this.convertServerNode + "/" + this.convertServerName + " removing server resources");
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Promoting " + this.convertServerNode + "/" + this.convertServerName + " removing all cluster resources");
                            }
                        }
                        ClusterConfigHelper.promoteServerResources(configService, session, this.clusterName, this.convertServerNode, this.convertServerName, this.resourcesScope, objectName2);
                    } else {
                        throw new ClusterConfigException("resourcesScope parameter value: " + this.resourcesScope + " is not valid");
                    }
                }
                if (this.shortName != null) {
                    ClusterConfigHelper.changeClusterShortName(configService, session, this.clusterName, this.shortName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting result of " + this.getName() + " command to " + this.newClusterObj.toString());
                }
                taskCommandResultImpl.setResult(this.newClusterObj);
                Object var12_16 = null;
            }
            catch (Throwable throwable) {
                Object var12_21 = null;
                if (!taskCommandResultImpl.isSuccessful()) {
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                        Tr.warning(tc, string);
                    }
                    try {
                        if (this.newClusterObj != null) {
                            configService.deleteConfigData(session, this.newClusterObj);
                        }
                        if (this.newRepDomainObj != null) {
                            configService.deleteConfigData(session, this.newRepDomainObj);
                        }
                    }
                    catch (ConfigServiceException configServiceException) {
                    }
                    catch (ConnectorException connectorException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (!taskCommandResultImpl.isSuccessful()) {
                if (string != null) {
                    taskCommandResultImpl.addWarnings(string);
                    Tr.warning(tc, string);
                }
                try {
                    if (this.newClusterObj != null) {
                        configService.deleteConfigData(session, this.newClusterObj);
                    }
                    if (this.newRepDomainObj != null) {
                        configService.deleteConfigData(session, this.newRepDomainObj);
                    }
                    break block69;
                }
                catch (ConfigServiceException configServiceException) {
                }
                catch (ConnectorException connectorException) {}
            }
            break block69;
            {
                catch (ClusterConfigException clusterConfigException) {
                    clusterConfigException.getMessage();
                    taskCommandResultImpl.setException(clusterConfigException);
                    taskCommandResultImpl.setResult(string);
                    Object var12_17 = null;
                    if (taskCommandResultImpl.isSuccessful()) break block69;
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                        Tr.warning(tc, string);
                    }
                    try {
                        if (this.newClusterObj != null) {
                            configService.deleteConfigData(session, this.newClusterObj);
                        }
                        if (this.newRepDomainObj != null) {
                            configService.deleteConfigData(session, this.newRepDomainObj);
                        }
                        break block69;
                    }
                    catch (ConfigServiceException configServiceException) {
                    }
                    catch (ConnectorException connectorException) {}
                    break block69;
                }
                catch (ConfigServiceException configServiceException) {
                    string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), configServiceException.toString()});
                    taskCommandResultImpl.setException(new ClusterConfigException(configServiceException, string));
                    taskCommandResultImpl.setResult(string);
                    Object var12_18 = null;
                    if (taskCommandResultImpl.isSuccessful()) break block69;
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                        Tr.warning(tc, string);
                    }
                    try {
                        if (this.newClusterObj != null) {
                            configService.deleteConfigData(session, this.newClusterObj);
                        }
                        if (this.newRepDomainObj != null) {
                            configService.deleteConfigData(session, this.newRepDomainObj);
                        }
                        break block69;
                    }
                    catch (ConfigServiceException configServiceException2) {
                    }
                    catch (ConnectorException connectorException) {}
                    break block69;
                }
                catch (ConnectorException connectorException) {
                    string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), connectorException.toString()});
                    taskCommandResultImpl.setException(new ClusterConfigException(connectorException, string));
                    taskCommandResultImpl.setResult(string);
                    Object var12_19 = null;
                    if (taskCommandResultImpl.isSuccessful()) break block69;
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                        Tr.warning(tc, string);
                    }
                    try {
                        if (this.newClusterObj != null) {
                            configService.deleteConfigData(session, this.newClusterObj);
                        }
                        if (this.newRepDomainObj != null) {
                            configService.deleteConfigData(session, this.newRepDomainObj);
                        }
                        break block69;
                    }
                    catch (ConfigServiceException configServiceException) {
                    }
                    catch (ConnectorException connectorException2) {}
                    break block69;
                }
                catch (Exception exception) {
                    string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), exception.toString()});
                    taskCommandResultImpl.setException(new ClusterConfigException(exception, string));
                    taskCommandResultImpl.setResult(string);
                    Object var12_20 = null;
                    if (taskCommandResultImpl.isSuccessful()) break block69;
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                        Tr.warning(tc, string);
                    }
                    try {
                        if (this.newClusterObj != null) {
                            configService.deleteConfigData(session, this.newClusterObj);
                        }
                        if (this.newRepDomainObj != null) {
                            configService.deleteConfigData(session, this.newRepDomainObj);
                        }
                    }
                    catch (ConfigServiceException configServiceException) {
                    }
                    catch (ConnectorException connectorException) {}
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void validate() throws CommandValidationException {
        Session session;
        Object object;
        CommandProviderHelper commandProviderHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate task " + this.taskName);
        }
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
        String string = null;
        try {
            this.reset();
            commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            object = commandProviderHelper.getConfigService();
            session = this.getConfigSession();
            Tr.debug(tc, "Calling superclass validator");
            super.validate();
        }
        catch (CommandValidationException commandValidationException) {
            taskCommandResultImpl.setException(commandValidationException);
            string = this.getMsg(resBundle, "ADMG9210E", new Object[]{this.getName(), commandValidationException.toString()});
            taskCommandResultImpl.addWarnings(string);
            taskCommandResultImpl.setResult(string);
            return;
        }
        try {
            short s;
            ConfigLimits configLimits;
            ObjectName objectName;
            ObjectName[] objectNameArray;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the cell object.");
            }
            if ((objectNameArray = (object = (commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper()).getConfigService()).queryConfigObjects(session = this.getConfigSession(), null, objectName = ConfigServiceHelper.createObjectName(null, "Cell", null), null)).length < 1) {
                String string2 = this.getMsg(resBundle, "ADMG9211E", null);
                throw new CommandValidationException(string2);
            }
            ObjectName objectName2 = objectNameArray[0];
            objectName = ConfigServiceHelper.createObjectName(null, "ServerCluster");
            ObjectName[] objectNameArray2 = object.queryConfigObjects(session, objectName2, objectName, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There are currently " + objectNameArray2.length + " clusters in the cell.");
            }
            if (!(configLimits = ConfigLimits.createConfigLimits()).isNumberOfClustersWithinLimit(s = (short)(objectNameArray2.length + 1))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exceeding number of clusters permitted by license.", new String[]{"newClusterCount=" + s});
                }
                String string3 = this.getMsg(resBundle, "ADMG0550E", null);
                throw new CommandValidationException(string3);
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred while checking licensing restrictions.", exception);
            }
            object = this.getMsg(resBundle, "ADMG0551E", null);
            throw new CommandValidationException((String)object);
        }
        Tr.exit(tc, "validate task " + this.taskName);
    }

    private void reset() {
        this.clusterConfigStep = null;
        this.clusterName = null;
        this.clusterType = null;
        this.shortName = null;
        this.preferLocal = null;
        this.replicationDomainStep = null;
        this.createDomain = null;
        this.convertServerStep = null;
        this.convertServerNode = null;
        this.convertServerName = null;
        this.memberWeight = null;
        this.nodeGroup = null;
        this.replicatorEntry = null;
        this.newClusterObj = null;
        this.newMemberObj = null;
        this.convertServerObj = null;
        this.newRepDomainObj = null;
        this.newRepEntryObj = null;
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return ClusterConfigHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    public class ConvertServerStep
    extends AbstractCommandStep {
        private String stepName;

        public ConvertServerStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.stepName = commandStepMetadata.getName();
        }

        public ConvertServerStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.stepName = commandStepData.getName();
        }

        protected void executeStep() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeStep" + this.stepName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeStep " + this.stepName);
            }
        }

        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate step " + this.stepName);
            }
            CommandResultImpl commandResultImpl = (CommandResultImpl)this.taskCmd.getCommandResult();
            super.validate();
            CreateClusterCommand.this.convertServerStep = null;
            CreateClusterCommand.this.convertServerName = null;
            CreateClusterCommand.this.convertServerNode = null;
            CreateClusterCommand.this.memberWeight = null;
            CreateClusterCommand.this.nodeGroup = null;
            CreateClusterCommand.this.replicatorEntry = null;
            CreateClusterCommand.this.newMemberObj = null;
            CreateClusterCommand.this.convertServerObj = null;
            CreateClusterCommand.this.newRepEntryObj = null;
            CreateClusterCommand.this.resourcesScope = null;
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.taskCmd.getConfigSession();
            Object var5_5 = null;
            Object var6_6 = null;
            AttributeList attributeList = new AttributeList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting command step parameters");
            }
            CreateClusterCommand.this.convertServerName = (String)this.getParameter(SERVER_NAME_PARAM);
            CreateClusterCommand.this.convertServerNode = (String)this.getParameter(SERVER_NODE_PARAM);
            CreateClusterCommand.this.memberWeight = (Integer)this.getParameter(MEMBER_WEIGHT_PARAM);
            CreateClusterCommand.this.nodeGroup = (String)this.getParameter(NODE_GROUP_PARAM);
            CreateClusterCommand.this.replicatorEntry = (Boolean)this.getParameter(REP_ENTRY_PARAM);
            CreateClusterCommand.this.resourcesScope = (String)this.getParameter(RESOURCES_SCOPE_PARAM);
            Tr.debug(tc, "Command parameters for the " + this.stepName + " step are: " + SERVER_NAME_PARAM + "=" + (CreateClusterCommand.this.convertServerNode == null ? "null" : CreateClusterCommand.this.convertServerNode) + " " + SERVER_NODE_PARAM + "=" + (CreateClusterCommand.this.convertServerName == null ? "null" : CreateClusterCommand.this.convertServerName) + " " + MEMBER_WEIGHT_PARAM + "=" + (CreateClusterCommand.this.memberWeight == null ? "null" : CreateClusterCommand.this.memberWeight.toString()) + " " + NODE_GROUP_PARAM + "=" + (CreateClusterCommand.this.nodeGroup == null ? "null" : CreateClusterCommand.this.nodeGroup.toString()) + " " + REP_ENTRY_PARAM + "=" + (CreateClusterCommand.this.replicatorEntry == null ? "null" : CreateClusterCommand.this.replicatorEntry.toString()) + " " + RESOURCES_SCOPE_PARAM + "=" + (CreateClusterCommand.this.resourcesScope == null ? "null" : CreateClusterCommand.this.resourcesScope.toString()));
            try {
                Object object;
                Object object2;
                ArrayList arrayList;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating command step parameters.");
                }
                if ((arrayList = new ArrayList(this.listSetParams())).size() <= 0) {
                    CreateClusterCommand.this.convertServerStep = new Boolean(false);
                    return;
                }
                CreateClusterCommand.this.convertServerStep = new Boolean(true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating server to convert to cluster.");
                }
                if (CreateClusterCommand.this.convertServerNode != null && CreateClusterCommand.this.convertServerName != null) {
                    CreateClusterCommand.this.convertServerObj = ClusterConfigHelper.getServerObj(configService, session, CreateClusterCommand.this.convertServerNode, CreateClusterCommand.this.convertServerName);
                    if (CreateClusterCommand.this.convertServerObj == null) {
                        String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9202E", new Object[]{CreateClusterCommand.this.convertServerName, CreateClusterCommand.this.convertServerNode});
                        throw new CommandValidationException(string);
                    }
                    object2 = null;
                    object2 = (String)configService.getAttribute(session, CreateClusterCommand.this.convertServerObj, "clusterName");
                    if (object2 != null) {
                        String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9203E", new Object[]{CreateClusterCommand.this.convertServerName, CreateClusterCommand.this.convertServerNode, object2});
                        throw new CommandValidationException(string);
                    }
                } else if (CreateClusterCommand.this.convertServerNode == null || CreateClusterCommand.this.convertServerName == null) {
                    String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9204E", null);
                    throw new CommandValidationException(string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating member weight of converted server.");
                }
                if (CreateClusterCommand.this.memberWeight != null && (CreateClusterCommand.this.memberWeight.compareTo(new Integer(0)) < 0 || CreateClusterCommand.this.memberWeight.compareTo(new Integer(100)) > 0)) {
                    object2 = CreateClusterCommand.this.getMsg(resBundle, "ADMG9205E", new Object[]{"0", "100"});
                    throw new CommandValidationException((String)object2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating node existence and product version. ");
                }
                if ((object2 = ClusterConfigHelper.getNodeObj(configService, session, CreateClusterCommand.this.convertServerNode)) == null) {
                    String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9218E", new Object[]{CreateClusterCommand.this.convertServerNode});
                    throw new CommandValidationException(string);
                }
                if (CreateClusterCommand.this.nodeGroup != null) {
                    if (!NodeGroupHelper.isNodeInNodeGroup(session, configService, CreateClusterCommand.this.convertServerNode, CreateClusterCommand.this.nodeGroup)) {
                        String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG0446E", new Object[]{CreateClusterCommand.this.convertServerNode, CreateClusterCommand.this.nodeGroup});
                        throw new CommandValidationException(string);
                    }
                } else {
                    object = NodeGroupHelper.listNodeGroups(session, configService, CreateClusterCommand.this.convertServerNode);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node groups are ", object);
                    }
                    if (((String[])object).length > 0) {
                        CreateClusterCommand.this.nodeGroup = object[0];
                    }
                }
                if (CreateClusterCommand.this.replicatorEntry != null && !CreateClusterCommand.this.replicatorEntry.equals(Boolean.FALSE) && (CreateClusterCommand.this.replicationDomainStep == null || CreateClusterCommand.this.replicationDomainStep.equals(Boolean.FALSE))) {
                    object = CreateClusterCommand.this.getMsg(resBundle, "ADMG9208E", null);
                    throw new CommandValidationException((String)object);
                }
            }
            catch (ConfigServiceException configServiceException) {
                String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{"convertServer", "createCluster", configServiceException.toString()});
                throw new CommandValidationException(string);
            }
            catch (ConnectorException connectorException) {
                String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{"convertServer", "createCluster", connectorException.toString()});
                throw new CommandValidationException(string);
            }
            catch (NodeGroupConfigException nodeGroupConfigException) {
                String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{"convertServer", "createCluster", nodeGroupConfigException.toString()});
                throw new CommandValidationException(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate step " + this.stepName);
            }
        }
    }

    public class ReplicationDomainStep
    extends AbstractCommandStep {
        private String stepName;

        public ReplicationDomainStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.stepName = commandStepMetadata.getName();
        }

        public ReplicationDomainStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.stepName = commandStepData.getName();
        }

        protected void executeStep() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeStep" + this.stepName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeStep" + this.stepName);
            }
        }

        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate step " + this.stepName);
            }
            CommandResultImpl commandResultImpl = (CommandResultImpl)this.taskCmd.getCommandResult();
            try {
                super.validate();
                CreateClusterCommand.this.replicationDomainStep = null;
                CreateClusterCommand.this.createDomain = null;
                CreateClusterCommand.this.newRepDomainObj = null;
                CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
                ConfigService configService = commandProviderHelper.getConfigService();
                Session session = this.taskCmd.getConfigSession();
                Object var5_7 = null;
                ObjectName[] objectNameArray = null;
                AttributeList attributeList = new AttributeList();
                CreateClusterCommand.this.createDomain = (Boolean)this.getParameter(CREATE_DOMAIN_PARM);
                Tr.debug(tc, "Command parameters for the " + this.stepName + " step are: " + CREATE_DOMAIN_PARM + "=" + (CreateClusterCommand.this.createDomain == null ? "null" : CreateClusterCommand.this.createDomain.toString()));
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Validating createDomain parameter.");
                    }
                    CreateClusterCommand.this.replicationDomainStep = CreateClusterCommand.this.createDomain;
                    if (CreateClusterCommand.this.replicationDomainStep != null && CreateClusterCommand.this.replicationDomainStep.equals(Boolean.TRUE)) {
                        objectNameArray = null;
                        objectNameArray = configService.resolve(session, "DataReplicationDomain=" + CreateClusterCommand.this.clusterName);
                        if (objectNameArray.length != 0) {
                            String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9201E", new Object[]{CreateClusterCommand.this.clusterName});
                            throw new CommandValidationException(string);
                        }
                    }
                }
                catch (ConfigServiceException configServiceException) {
                    String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateClusterCommand.this.taskName, configServiceException.toString()});
                    throw new CommandValidationException(string);
                }
                catch (ConnectorException connectorException) {
                    String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateClusterCommand.this.taskName, connectorException.toString()});
                    throw new CommandValidationException(string);
                }
            }
            catch (CommandValidationException commandValidationException) {
                String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9250E", new Object[]{this.stepName, CreateClusterCommand.this.taskName, commandValidationException.toString()});
                commandResultImpl.setException(commandValidationException);
                commandResultImpl.addWarnings(string);
                commandResultImpl.setResult(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate step " + this.stepName);
            }
        }
    }

    public class ClusterConfigStep
    extends AbstractCommandStep {
        private String stepName;

        public ClusterConfigStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.stepName = commandStepMetadata.getName();
        }

        public ClusterConfigStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.stepName = commandStepData.getName();
        }

        protected void executeStep() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeStep " + this.stepName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeStep " + this.stepName);
            }
        }

        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate step " + this.stepName);
            }
            CommandResultImpl commandResultImpl = (CommandResultImpl)this.taskCmd.getCommandResult();
            super.validate();
            CreateClusterCommand.this.clusterName = null;
            CreateClusterCommand.this.clusterType = null;
            CreateClusterCommand.this.shortName = null;
            CreateClusterCommand.this.preferLocal = null;
            CreateClusterCommand.this.newClusterObj = null;
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.taskCmd.getConfigSession();
            Object var5_5 = null;
            ObjectName[] objectNameArray = null;
            AttributeList attributeList = new AttributeList();
            CreateClusterCommand.this.clusterName = (String)this.getParameter(CLUSTER_NAME_PARAM);
            CreateClusterCommand.this.clusterType = (String)this.getParameter(CLUSTER_TYPE_PARAM);
            CreateClusterCommand.this.preferLocal = (Boolean)this.getParameter(PREFER_LOCAL_PARAM);
            CreateClusterCommand.this.shortName = (String)this.getParameter("shortName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parameters for " + this.stepName + " command step are: " + CLUSTER_NAME_PARAM + "=" + CreateClusterCommand.this.clusterName + " " + CLUSTER_TYPE_PARAM + "=" + CreateClusterCommand.this.clusterType + " " + "shortName" + "=" + CreateClusterCommand.this.shortName + " " + PREFER_LOCAL_PARAM + "=" + (CreateClusterCommand.this.preferLocal == null ? "null" : CreateClusterCommand.this.preferLocal.toString()));
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating cluster does not already exist.");
                }
                objectNameArray = null;
                objectNameArray = configService.resolve(session, "ServerCluster=" + CreateClusterCommand.this.clusterName);
                if (objectNameArray.length != 0) {
                    String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9200E", new Object[]{CreateClusterCommand.this.clusterName});
                    throw new CommandValidationException(string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating cluster type.");
                }
                if (CreateClusterCommand.this.clusterType != null && (CreateClusterCommand.this.clusterType.equals("APPLICATION_SERVER") || CreateClusterCommand.this.clusterType.equals("PROXY_SERVER") || CreateClusterCommand.this.clusterType.equals("ONDEMAND_ROUTER"))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster type is valid", CreateClusterCommand.this.clusterType);
                    }
                } else if (CreateClusterCommand.this.clusterType != null) {
                    String string = "Invalid Cluster Type";
                    throw new CommandValidationException(string);
                }
                if (!ClusterConfigHelper.isShortNameValid(CreateClusterCommand.this.shortName)) {
                    String string = "Invalid shortName";
                    throw new CommandValidationException(string);
                }
            }
            catch (ConfigServiceException configServiceException) {
                String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateClusterCommand.this.taskName, configServiceException.toString()});
                throw new CommandValidationException(string);
            }
            catch (ConnectorException connectorException) {
                String string = CreateClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateClusterCommand.this.taskName, connectorException.toString()});
                throw new CommandValidationException(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate step " + this.stepName);
            }
        }
    }
}

