/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.cluster.ClusterConfigException;
import com.ibm.ws.management.commands.cluster.ClusterConfigHelper;
import com.ibm.ws.management.commands.nodegroup.NodeGroupConfigException;
import com.ibm.ws.management.commands.nodegroup.NodeGroupHelper;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.util.ConfigLimits;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateMemberCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateMemberCommand.class, "ClusterConfig", BUNDLE_NAME);
    private static String CLUSTER_NAME_PARAM = "clusterName";
    private static String MEMBER_CONFIG_STEP = "memberConfig";
    private static String MEMBER_NODE_PARAM = "memberNode";
    private static String MEMBER_NAME_PARAM = "memberName";
    private static String MEMBER_UUID_PARAM = "memberUUID";
    private static String MEMBER_WEIGHT_PARAM = "memberWeight";
    private static String GEN_UNIQUE_PORTS_PARAM = "genUniquePorts";
    private static String REPLICATOR_ENTRY_PARAM = "replicatorEntry";
    private static String FIRST_MEMBER_STEP = "firstMember";
    private static String TEMPLATE_NAME_PARAM = "templateName";
    private static String TEMPLATE_SERVER_NODE_PARAM = "templateServerNode";
    private static String TEMPLATE_SERVER_NAME_PARAM = "templateServerName";
    private static String NODE_GROUP_PARAM = "nodeGroup";
    private static String CORE_GROUP_PARAM = "coreGroup";
    private static String RESOURCES_SCOPE_PARAM = "resourcesScope";
    private static String RESOURCES_SCOPE_BOTH = "both";
    private static String RESOURCES_SCOPE_CLUSTER = "cluster";
    private static String RESOURCES_SCOPE_SERVER = "server";
    private static String RESOURCES_SCOPE = "resourcesScope";
    public static String CELL_TYPE = "Cell";
    private String taskName = null;
    private ObjectName targetObj = null;
    private String clusterName = null;
    private String memberConfigStep = null;
    private String memberNode = null;
    private String memberName = null;
    private String memberUUID = null;
    private Integer memberWeight = null;
    private Boolean genUniquePorts = null;
    private Boolean replicatorEntry = null;
    private String shortName = null;
    private Boolean firstMemberStep = null;
    private String templateName = null;
    private String templateServerNode = null;
    private String templateServerName = null;
    private String nodeGroup = null;
    private String coreGroup = null;
    private String firstMemberCoreGroup = null;
    private String resourcesScope = null;
    private ObjectName clusterObj = null;
    private ObjectName nodeObj = null;
    private ObjectName newServerObj = null;
    private ObjectName newMemberObj = null;
    private ObjectName[] currentMemberObjs = null;
    private ObjectName firstServerObj = null;
    private ObjectName firstMemberObj = null;
    private ObjectName newMemberTemplate = null;
    private ObjectName templateObj = null;
    private ObjectName repDomainObj = null;
    private ObjectName newRepEntryObj = null;

    public CreateMemberCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.taskName = taskCommandMetadata.getName();
    }

    public CreateMemberCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.taskName = commandData.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeStepsExecuted() {
        block77: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            Tr.debug(tc, "Resetting the command result.");
            TaskCommandResultImpl taskCommandResultImpl = new TaskCommandResultImpl();
            this.setCommandResult(taskCommandResultImpl);
            taskCommandResultImpl.reset();
            String string = null;
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = null;
            ObjectName[] objectNameArray = null;
            AttributeList attributeList = new AttributeList();
            Tr.debug(tc, "Starting to create new cluster member.");
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating new member server object.");
                }
                String string2 = null;
                String string3 = ClusterConfigHelper.getMemberNodeVersion(configService, session, this.memberNode);
                if (this.newMemberTemplate != null) {
                    this.templateObj = this.newMemberTemplate;
                } else if (this.firstServerObj != null) {
                    if (this.templateObj != null) {
                        string2 = ConfigServiceHelper.getDisplayName(this.templateObj);
                    } else {
                        this.templateObj = this.firstServerObj;
                    }
                }
                if (this.firstMemberCoreGroup != null) {
                    this.coreGroup = this.firstMemberCoreGroup;
                }
                String string4 = ClusterConfigHelper.getClusterType(configService, session, this.clusterObj);
                this.newMemberObj = ClusterConfigHelper.createClusterMemberFromTemplate(configService, session, this.memberName, this.memberNode, this.clusterObj, this.templateObj, this.memberUUID, this.coreGroup, this.nodeGroup, this.genUniquePorts, string4, string2, this.replicatorEntry, this.shortName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting server object created for the member.");
                }
                this.newServerObj = ClusterConfigHelper.getServerObj(configService, session, this.memberNode, this.memberName);
                if (this.newMemberTemplate != null) {
                    ClusterConfigHelper.createMemberTemplate(configService, session, this.newServerObj, this.clusterObj, string3);
                } else if (this.firstServerObj == null) {
                    ClusterConfigHelper.createMemberTemplate(configService, session, this.newServerObj, this.clusterObj, string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting the cell object.");
                    }
                    objectNameArray = null;
                    objectName = ConfigServiceHelper.createObjectName(null, CELL_TYPE, null);
                    ObjectName objectName2 = null;
                    objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
                    if (objectNameArray.length < 1) {
                        String string5 = this.getMsg(resBundle, "ADMG9211E", null);
                        throw new ClusterConfigException(string5);
                    }
                    objectName2 = objectNameArray[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resourcesScope=" + this.resourcesScope);
                    }
                    if (null != this.resourcesScope && !this.resourcesScope.trim().equals("") && !this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_BOTH) && !this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER) && !this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_SERVER)) throw new ClusterConfigException("resourcesScope parameter value: " + this.resourcesScope + " is not valid");
                    if (tc.isDebugEnabled()) {
                        if (null == this.resourcesScope || this.resourcesScope.trim().equals("") || this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_BOTH)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Copying server resources to cluster scope");
                            }
                        } else if (this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Removing server resources");
                            }
                        } else if (this.resourcesScope.equalsIgnoreCase(RESOURCES_SCOPE_SERVER) && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing cluster resources");
                        }
                    }
                    ClusterConfigHelper.promoteServerResources(configService, session, this.clusterName, this.memberNode, ConfigServiceHelper.getDisplayName(this.newServerObj), this.resourcesScope, objectName2);
                } else {
                    InputStream inputStream = ClusterConfigHelper.getResourcesScopePropertyInputFile(session, this.clusterName);
                    String string6 = ConfigServiceHelper.getDisplayName(this.newServerObj);
                    if (null != inputStream) {
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        String string7 = properties.getProperty(RESOURCES_SCOPE);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "resourcesScope=" + string7);
                        }
                        if (null == string7 || string7.trim().equals("") && !string7.equalsIgnoreCase(RESOURCES_SCOPE_BOTH) && !string7.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER) && !string7.equalsIgnoreCase(RESOURCES_SCOPE_SERVER)) {
                            throw new ClusterConfigException("resourcesScope property is not properly set, its value is: " + string7 + ", \n leaving member server resources with serverName: " + string6 + " in server scope. " + "Valid properties value are: both, cluster, or server");
                        }
                        if (string7.equalsIgnoreCase(RESOURCES_SCOPE_CLUSTER)) {
                            ClusterConfigHelper.removeServerResources(session, this.memberNode, this.clusterName, string6);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No resourcesScope.properties file found, and a firstMember server already exists.  Leaving server resources with serverName: " + string6 + " in server scope without any change to cluster resources");
                    }
                }
                if (this.memberWeight != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting member weight.");
                    }
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, "weight", this.memberWeight);
                    configService.setAttributes(session, this.newMemberObj, attributeList);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting result of " + this.getName() + " command.");
                }
                taskCommandResultImpl.setResult(this.newMemberObj);
                Object var17_22 = null;
            }
            catch (Throwable throwable) {
                Object var17_27 = null;
                if (taskCommandResultImpl.isSuccessful()) throw throwable;
                if (string != null) {
                    taskCommandResultImpl.addWarnings(string);
                }
                try {
                    if (this.newMemberObj != null) {
                        configService.deleteConfigData(session, this.newMemberObj);
                    }
                    if (this.newServerObj != null) {
                        configService.deleteConfigData(session, this.newServerObj);
                    }
                    if (this.newRepEntryObj == null) throw throwable;
                    configService.deleteConfigData(session, this.newRepEntryObj);
                    throw throwable;
                }
                catch (ConfigServiceException configServiceException) {
                    FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "384", this);
                    throw throwable;
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "386", this);
                }
                throw throwable;
            }
            if (!taskCommandResultImpl.isSuccessful()) {
                if (string != null) {
                    taskCommandResultImpl.addWarnings(string);
                }
                try {
                    if (this.newMemberObj != null) {
                        configService.deleteConfigData(session, this.newMemberObj);
                    }
                    if (this.newServerObj != null) {
                        configService.deleteConfigData(session, this.newServerObj);
                    }
                    if (this.newRepEntryObj != null) {
                        configService.deleteConfigData(session, this.newRepEntryObj);
                    }
                    break block77;
                }
                catch (ConfigServiceException configServiceException) {
                    FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "384", this);
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "386", this);
                }
            }
            break block77;
            {
                catch (ClusterConfigException clusterConfigException) {
                    FFDCFilter.processException((Throwable)clusterConfigException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "340", this);
                    clusterConfigException.getMessage();
                    taskCommandResultImpl.setException(clusterConfigException);
                    taskCommandResultImpl.setResult(string);
                    Object var17_23 = null;
                    if (taskCommandResultImpl.isSuccessful()) break block77;
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                    }
                    try {
                        if (this.newMemberObj != null) {
                            configService.deleteConfigData(session, this.newMemberObj);
                        }
                        if (this.newServerObj != null) {
                            configService.deleteConfigData(session, this.newServerObj);
                        }
                        if (this.newRepEntryObj != null) {
                            configService.deleteConfigData(session, this.newRepEntryObj);
                        }
                        break block77;
                    }
                    catch (ConfigServiceException configServiceException) {
                        FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "384", this);
                    }
                    catch (ConnectorException connectorException) {
                        FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "386", this);
                    }
                    break block77;
                }
                catch (ConfigServiceException configServiceException) {
                    FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "346", this);
                    string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), configServiceException.toString()});
                    taskCommandResultImpl.setException(new ClusterConfigException(configServiceException, string));
                    taskCommandResultImpl.setResult(string);
                    Object var17_24 = null;
                    if (taskCommandResultImpl.isSuccessful()) break block77;
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                    }
                    try {
                        if (this.newMemberObj != null) {
                            configService.deleteConfigData(session, this.newMemberObj);
                        }
                        if (this.newServerObj != null) {
                            configService.deleteConfigData(session, this.newServerObj);
                        }
                        if (this.newRepEntryObj != null) {
                            configService.deleteConfigData(session, this.newRepEntryObj);
                        }
                        break block77;
                    }
                    catch (ConfigServiceException configServiceException2) {
                        FFDCFilter.processException((Throwable)configServiceException2, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "384", this);
                    }
                    catch (ConnectorException connectorException) {
                        FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "386", this);
                    }
                    break block77;
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "352", this);
                    string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), connectorException.toString()});
                    taskCommandResultImpl.setException(new ClusterConfigException(connectorException, string));
                    taskCommandResultImpl.setResult(string);
                    Object var17_25 = null;
                    if (taskCommandResultImpl.isSuccessful()) break block77;
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                    }
                    try {
                        if (this.newMemberObj != null) {
                            configService.deleteConfigData(session, this.newMemberObj);
                        }
                        if (this.newServerObj != null) {
                            configService.deleteConfigData(session, this.newServerObj);
                        }
                        if (this.newRepEntryObj != null) {
                            configService.deleteConfigData(session, this.newRepEntryObj);
                        }
                        break block77;
                    }
                    catch (ConfigServiceException configServiceException) {
                        FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "384", this);
                    }
                    catch (ConnectorException connectorException2) {
                        FFDCFilter.processException((Throwable)connectorException2, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "386", this);
                    }
                    break block77;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "358", this);
                    string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), exception.toString()});
                    taskCommandResultImpl.setException(new ClusterConfigException(exception, string));
                    taskCommandResultImpl.setResult(string);
                    Object var17_26 = null;
                    if (taskCommandResultImpl.isSuccessful()) break block77;
                    if (string != null) {
                        taskCommandResultImpl.addWarnings(string);
                    }
                    try {
                        if (this.newMemberObj != null) {
                            configService.deleteConfigData(session, this.newMemberObj);
                        }
                        if (this.newServerObj != null) {
                            configService.deleteConfigData(session, this.newServerObj);
                        }
                        if (this.newRepEntryObj != null) {
                            configService.deleteConfigData(session, this.newRepEntryObj);
                        }
                    }
                    catch (ConfigServiceException configServiceException) {
                        FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "384", this);
                    }
                    catch (ConnectorException connectorException) {
                        FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.beforeStepsExecuted", "386", this);
                    }
                }
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "beforeStepsExecuted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void validate() throws CommandValidationException {
        if (CreateMemberCommand.tc.isEntryEnabled()) {
            Tr.entry(CreateMemberCommand.tc, "validate");
        }
        this.reset();
        var1_1 = CommandMgr.getCommandMgr().getCommandProviderHelper();
        var2_2 = var1_1.getConfigService();
        var3_3 = this.getConfigSession();
        var4_4 = null;
        var5_5 = null;
        var6_6 = new AttributeList();
        this.targetObj = (ObjectName)this.getTargetObject();
        this.clusterName = (String)this.getParameter(CreateMemberCommand.CLUSTER_NAME_PARAM);
        Tr.debug(CreateMemberCommand.tc, "Command parameters are targetObject=" + (this.targetObj == null ? "null" : this.targetObj.toString()) + CreateMemberCommand.CLUSTER_NAME_PARAM + "=" + (this.clusterName == null ? "null" : this.clusterName));
        try {
            if (this.targetObj != null) {
                if (CreateMemberCommand.tc.isDebugEnabled()) {
                    Tr.debug(CreateMemberCommand.tc, "Validating cluster object ID.");
                }
                if (this.clusterName != null) {
                    var7_7 = this.getMsg(CreateMemberCommand.resBundle, "ADMG9213E", null);
                    throw new CommandValidationException(var7_7);
                }
                this.clusterObj = ObjectName.getInstance(this.targetObj);
                this.clusterName = ConfigServiceHelper.getDisplayName(this.clusterObj);
                var7_8 = null;
                var8_13 = null;
                var5_5 = null;
                try {
                    var7_8 = (String)var2_2.getAttribute(var3_3, this.clusterObj, "name");
                    var5_5 = var2_2.resolve(var3_3, "ServerCluster=" + this.clusterName);
                }
                catch (Exception var9_17) {
                    FFDCFilter.processException((Throwable)var9_17, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "456", this);
                    var8_13 = var9_17;
                }
                finally {
                    if (var8_13 == null && this.clusterName != null && var7_8 != null && var5_5.length >= 1 && this.clusterName.equals(var7_8)) ** GOTO lbl45
                    var9_18 = this.getMsg(CreateMemberCommand.resBundle, "ADMG9214E", null);
                    throw new CommandValidationException(var9_18);
                }
            } else {
                if (this.clusterName == null) {
                    var7_9 = this.getMsg(CreateMemberCommand.resBundle, "ADMG9215E", null);
                    throw new CommandValidationException(var7_9);
                }
                var5_5 = null;
                var5_5 = var2_2.resolve(var3_3, "ServerCluster=" + this.clusterName);
                if (var5_5.length == 0) {
                    var7_10 = this.getMsg(CreateMemberCommand.resBundle, "ADMG9216E", new Object[]{this.clusterName});
                    throw new CommandValidationException(var7_10);
                }
                this.clusterObj = var5_5[0];
            }
lbl45:
            // 3 sources

            Tr.debug(CreateMemberCommand.tc, "Calling superclass validator.");
            super.validate();
        }
        catch (ConfigServiceException var7_11) {
            FFDCFilter.processException((Throwable)var7_11, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "496", this);
            var8_14 = this.getMsg(CreateMemberCommand.resBundle, "ADMG9209E", new Object[]{this.getName(), var7_11.toString()});
            throw new CommandValidationException(var8_14);
        }
        catch (ConnectorException var7_12) {
            FFDCFilter.processException((Throwable)var7_12, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "501", this);
            var8_15 = this.getMsg(CreateMemberCommand.resBundle, "ADMG9209E", new Object[]{this.getName(), var7_12.toString()});
            throw new CommandValidationException(var8_15);
        }
        if (CreateMemberCommand.tc.isEntryEnabled()) {
            Tr.exit(CreateMemberCommand.tc, "validate");
        }
    }

    private void reset() {
        this.targetObj = null;
        this.clusterName = null;
        this.memberConfigStep = null;
        this.memberNode = null;
        this.memberName = null;
        this.memberUUID = null;
        this.memberWeight = null;
        this.genUniquePorts = null;
        this.replicatorEntry = null;
        this.shortName = null;
        this.firstMemberStep = null;
        this.templateName = null;
        this.templateServerNode = null;
        this.templateServerName = null;
        this.nodeGroup = null;
        this.coreGroup = null;
        this.firstMemberCoreGroup = null;
        this.clusterObj = null;
        this.nodeObj = null;
        this.newServerObj = null;
        this.newMemberObj = null;
        this.currentMemberObjs = null;
        this.firstMemberObj = null;
        this.newMemberTemplate = null;
        this.firstServerObj = null;
        this.templateObj = null;
        this.repDomainObj = null;
        this.newRepEntryObj = null;
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return ClusterConfigHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    static /* synthetic */ ObjectName[] access$1202(CreateMemberCommand createMemberCommand, ObjectName[] objectNameArray) {
        createMemberCommand.currentMemberObjs = objectNameArray;
        return objectNameArray;
    }

    public class FirstMemberStep
    extends AbstractCommandStep {
        private String stepName;
        private CommandProviderHelper ch;
        private ConfigService cs;
        private Session session;
        private AbstractTaskCommand taskCmd;

        public FirstMemberStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.ch = null;
            this.cs = null;
            this.session = null;
            this.taskCmd = null;
            this.stepName = commandStepMetadata.getName();
            this.taskCmd = abstractTaskCommand;
        }

        public FirstMemberStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.ch = null;
            this.cs = null;
            this.session = null;
            this.taskCmd = null;
            this.stepName = commandStepData.getName();
            this.taskCmd = abstractTaskCommand;
        }

        protected void executeStep() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeStep " + this.stepName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeStep " + this.stepName);
            }
        }

        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate step " + this.stepName);
            }
            super.validate();
            CreateMemberCommand.this.firstMemberStep = null;
            CreateMemberCommand.this.templateName = null;
            CreateMemberCommand.this.templateServerNode = null;
            CreateMemberCommand.this.templateServerName = null;
            CreateMemberCommand.this.nodeGroup = null;
            CreateMemberCommand.this.coreGroup = null;
            CreateMemberCommand.this.resourcesScope = null;
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.taskCmd.getConfigSession();
            Object var4_4 = null;
            ObjectName[] objectNameArray = null;
            AttributeList attributeList = new AttributeList();
            CreateMemberCommand.this.templateName = (String)this.getParameter(TEMPLATE_NAME_PARAM);
            CreateMemberCommand.this.templateServerNode = (String)this.getParameter(TEMPLATE_SERVER_NODE_PARAM);
            CreateMemberCommand.this.templateServerName = (String)this.getParameter(TEMPLATE_SERVER_NAME_PARAM);
            CreateMemberCommand.this.nodeGroup = (String)this.getParameter(NODE_GROUP_PARAM);
            CreateMemberCommand.this.coreGroup = (String)this.getParameter(CORE_GROUP_PARAM);
            CreateMemberCommand.this.resourcesScope = (String)this.getParameter(RESOURCES_SCOPE_PARAM);
            Tr.debug(tc, "Parameters for " + this.stepName + " command step are: " + TEMPLATE_NAME_PARAM + "=" + (CreateMemberCommand.this.templateName == null ? "null" : CreateMemberCommand.this.templateName) + " " + TEMPLATE_SERVER_NODE_PARAM + "=" + (CreateMemberCommand.this.templateServerNode == null ? "null" : CreateMemberCommand.this.templateServerNode) + " " + TEMPLATE_SERVER_NAME_PARAM + "=" + (CreateMemberCommand.this.templateServerName == null ? "null" : CreateMemberCommand.this.templateServerName) + " " + NODE_GROUP_PARAM + "=" + (CreateMemberCommand.this.nodeGroup == null ? "null" : CreateMemberCommand.this.nodeGroup) + " " + CORE_GROUP_PARAM + "=" + (CreateMemberCommand.this.coreGroup == null ? "null" : CreateMemberCommand.this.coreGroup) + " " + RESOURCES_SCOPE_PARAM + "=" + (CreateMemberCommand.this.resourcesScope == null ? "null" : CreateMemberCommand.this.resourcesScope));
            try {
                ArrayList arrayList;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating command step parameters.");
                }
                if ((arrayList = new ArrayList(this.listSetParams())).size() > 0) {
                    CreateMemberCommand.this.firstMemberStep = new Boolean(true);
                } else {
                    CreateMemberCommand.this.firstMemberStep = new Boolean(false);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Determining if firstMember step is valid.");
                }
                if (CreateMemberCommand.this.currentMemberObjs.length > 0) {
                    if (CreateMemberCommand.this.firstMemberStep.equals(Boolean.FALSE)) {
                        return;
                    }
                    String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9222E", null);
                    throw new CommandValidationException(string);
                }
                if (CreateMemberCommand.this.firstMemberStep.equals(Boolean.FALSE)) {
                    Tr.debug(tc, "Using default template for the first member of the cluster" + CreateMemberCommand.this.clusterName);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating first cluster member");
                    }
                    if (CreateMemberCommand.this.templateName == null && CreateMemberCommand.this.templateServerNode == null && CreateMemberCommand.this.templateServerName == null) {
                        String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9219E", null);
                        throw new CommandValidationException(string);
                    }
                    if (CreateMemberCommand.this.templateName != null && (CreateMemberCommand.this.templateServerNode != null || CreateMemberCommand.this.templateServerName != null)) {
                        String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9220E", null);
                        throw new CommandValidationException(string);
                    }
                    if (CreateMemberCommand.this.templateName == null && (CreateMemberCommand.this.templateServerNode == null || CreateMemberCommand.this.templateServerName == null)) {
                        String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9221E", null);
                        throw new CommandValidationException(string);
                    }
                }
                if (CreateMemberCommand.this.templateName != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Finding true server template object " + CreateMemberCommand.this.templateName);
                    }
                    objectNameArray = null;
                    objectNameArray = configService.queryTemplates(session, "Server");
                    if (objectNameArray.length > 0) {
                        for (int i = 0; i < objectNameArray.length; ++i) {
                            if (!CreateMemberCommand.this.templateName.equals(ConfigServiceHelper.getDisplayName(objectNameArray[i]))) continue;
                            CreateMemberCommand.this.templateObj = objectNameArray[i];
                            break;
                        }
                    }
                    if (CreateMemberCommand.this.templateObj == null) {
                        String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9223E", new Object[]{CreateMemberCommand.this.templateName});
                        throw new CommandValidationException(string);
                    }
                } else if (CreateMemberCommand.this.templateServerNode != null && CreateMemberCommand.this.templateServerName != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Finding server " + CreateMemberCommand.this.templateServerName + " on node " + "templateNodeName" + " to use as template");
                    }
                    CreateMemberCommand.this.templateObj = ClusterConfigHelper.getServerObj(configService, session, CreateMemberCommand.this.templateServerNode, CreateMemberCommand.this.templateServerName);
                    if (CreateMemberCommand.this.templateObj == null) {
                        String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9202E", new Object[]{CreateMemberCommand.this.templateServerName, CreateMemberCommand.this.templateServerNode});
                        throw new CommandValidationException(string);
                    }
                }
                if (CreateMemberCommand.this.nodeGroup != null && CreateMemberCommand.this.nodeGroup.length() > 0) {
                    if (!NodeGroupHelper.isNodeInNodeGroup(session, configService, CreateMemberCommand.this.memberNode, CreateMemberCommand.this.nodeGroup)) {
                        String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG0446E", new Object[]{CreateMemberCommand.this.memberNode, CreateMemberCommand.this.nodeGroup});
                        throw new CommandValidationException(string);
                    }
                } else {
                    String[] stringArray = NodeGroupHelper.listNodeGroups(session, configService, CreateMemberCommand.this.memberNode);
                    if (stringArray.length > 0) {
                        CreateMemberCommand.this.nodeGroup = stringArray[0];
                    }
                }
            }
            catch (NodeGroupConfigException nodeGroupConfigException) {
                FFDCFilter.processException((Throwable)nodeGroupConfigException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "1080", this);
                String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateMemberCommand.this.taskName, nodeGroupConfigException.toString()});
                throw new CommandValidationException(string);
            }
            catch (ConfigServiceException configServiceException) {
                FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "1084", this);
                String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateMemberCommand.this.taskName, configServiceException.toString()});
                throw new CommandValidationException(string);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "1088", this);
                String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateMemberCommand.this.taskName, connectorException.toString()});
                throw new CommandValidationException(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate step " + this.stepName);
            }
        }
    }

    public class MemberConfigStep
    extends AbstractCommandStep {
        private String stepName;
        private AbstractTaskCommand taskCmd;

        public MemberConfigStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.taskCmd = null;
            this.stepName = commandStepMetadata.getName();
            this.taskCmd = abstractTaskCommand;
        }

        public MemberConfigStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.taskCmd = null;
            this.stepName = commandStepData.getName();
            this.taskCmd = abstractTaskCommand;
        }

        protected void executeStep() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeStep " + this.stepName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeStep " + this.stepName);
            }
        }

        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate step " + this.stepName);
            }
            super.validate();
            CreateMemberCommand.this.memberConfigStep = null;
            CreateMemberCommand.this.memberName = null;
            CreateMemberCommand.this.memberUUID = null;
            CreateMemberCommand.this.memberNode = null;
            CreateMemberCommand.this.memberWeight = null;
            CreateMemberCommand.this.genUniquePorts = null;
            CreateMemberCommand.this.replicatorEntry = null;
            CreateMemberCommand.this.shortName = null;
            CreateMemberCommand.this.nodeObj = null;
            CreateMemberCommand.this.newServerObj = null;
            CreateMemberCommand.this.newMemberObj = null;
            CreateMemberCommand.access$1202(CreateMemberCommand.this, null);
            CreateMemberCommand.this.firstServerObj = null;
            CreateMemberCommand.this.firstMemberObj = null;
            CreateMemberCommand.this.repDomainObj = null;
            CreateMemberCommand.this.newRepEntryObj = null;
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.taskCmd.getConfigSession();
            ObjectName objectName = null;
            Object var5_5 = null;
            AttributeList attributeList = new AttributeList();
            CreateMemberCommand.this.memberNode = (String)this.getParameter(MEMBER_NODE_PARAM);
            CreateMemberCommand.this.memberName = (String)this.getParameter(MEMBER_NAME_PARAM);
            CreateMemberCommand.this.memberUUID = (String)this.getParameter(MEMBER_UUID_PARAM);
            CreateMemberCommand.this.memberWeight = (Integer)this.getParameter(MEMBER_WEIGHT_PARAM);
            CreateMemberCommand.this.genUniquePorts = (Boolean)this.getParameter(GEN_UNIQUE_PORTS_PARAM);
            CreateMemberCommand.this.replicatorEntry = (Boolean)this.getParameter(REPLICATOR_ENTRY_PARAM);
            CreateMemberCommand.this.shortName = (String)this.getParameter("specificShortName");
            Tr.debug(tc, "Parameters for " + this.stepName + " command step are: " + MEMBER_NODE_PARAM + "=" + (CreateMemberCommand.this.memberNode == null ? "null" : CreateMemberCommand.this.memberNode) + " " + MEMBER_NAME_PARAM + "=" + (CreateMemberCommand.this.memberName == null ? "null" : CreateMemberCommand.this.memberName) + " " + MEMBER_WEIGHT_PARAM + "=" + (CreateMemberCommand.this.memberWeight == null ? "null" : CreateMemberCommand.this.memberWeight.toString()) + " " + GEN_UNIQUE_PORTS_PARAM + "=" + (CreateMemberCommand.this.genUniquePorts == null ? "null" : CreateMemberCommand.this.genUniquePorts.toString()) + " " + REPLICATOR_ENTRY_PARAM + "=" + (CreateMemberCommand.this.replicatorEntry == null ? "null" : CreateMemberCommand.this.replicatorEntry.toString()) + " " + "shortName" + "=" + CreateMemberCommand.this.shortName);
            try {
                String string;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string2;
                int n;
                Object object5;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating member does not exist yet.");
                }
                CreateMemberCommand.this.newServerObj = ClusterConfigHelper.getServerObj(configService, session, CreateMemberCommand.this.memberNode, CreateMemberCommand.this.memberName);
                if (CreateMemberCommand.this.newServerObj != null) {
                    String string3 = CreateMemberCommand.this.getMsg(resBundle, "ADMG9217E", new Object[]{CreateMemberCommand.this.memberName, CreateMemberCommand.this.memberNode});
                    throw new CommandValidationException(string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating node existence and product version.");
                }
                CreateMemberCommand.this.nodeObj = ClusterConfigHelper.getNodeObj(configService, session, CreateMemberCommand.this.memberNode);
                if (CreateMemberCommand.this.nodeObj == null) {
                    String string4 = CreateMemberCommand.this.getMsg(resBundle, "ADMG9218E", new Object[]{CreateMemberCommand.this.memberNode});
                    throw new CommandValidationException(string4);
                }
                Tr.debug(tc, "Validating member weight.");
                if (CreateMemberCommand.this.memberWeight != null && (CreateMemberCommand.this.memberWeight.compareTo(new Integer(0)) < 0 || CreateMemberCommand.this.memberWeight.compareTo(new Integer(100)) > 0)) {
                    String string5 = CreateMemberCommand.this.getMsg(resBundle, "ADMG9205E", null);
                    throw new CommandValidationException(string5);
                }
                boolean bl = false;
                if (CreateMemberCommand.this.memberNode != null && (object5 = ClusterConfigHelper.getMemberNodeVersion(configService, session, CreateMemberCommand.this.memberNode)) != null && ((String)object5).startsWith("5")) {
                    bl = true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking if this is the first cluster member.");
                }
                objectName = ConfigServiceHelper.createObjectName(null, "ClusterMember");
                CreateMemberCommand.access$1202(CreateMemberCommand.this, configService.queryConfigObjects(session, CreateMemberCommand.this.clusterObj, objectName, null));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There are currently " + CreateMemberCommand.this.currentMemberObjs.length + " members in cluster " + CreateMemberCommand.this.clusterName);
                }
                try {
                    object5 = ConfigLimits.createConfigLimits();
                    n = CreateMemberCommand.this.currentMemberObjs.length + 1;
                    if (!((ConfigLimits)object5).isNumberOfClusterMembersWithinLimit((short)n)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exceeding number of cluster members permitted by license.", new String[]{"clusterName=" + CreateMemberCommand.this.clusterName, "newMemberCount=" + n});
                        }
                        String string6 = CreateMemberCommand.this.getMsg(resBundle, "ADMG0550E", null);
                        throw new CommandValidationException(string6);
                    }
                }
                catch (CommandValidationException commandValidationException) {
                    FFDCFilter.processException((Throwable)commandValidationException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "728", this);
                    throw commandValidationException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "731", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error occurred while checking licensing restrictions.", exception);
                    }
                    String string7 = CreateMemberCommand.this.getMsg(resBundle, "ADMG0551E", null);
                    throw new CommandValidationException(string7);
                }
                object5 = Boolean.FALSE;
                for (n = 0; n < CreateMemberCommand.this.currentMemberObjs.length; ++n) {
                    block49: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Use first cluster member's server as template.");
                        }
                        CreateMemberCommand.this.firstMemberObj = CreateMemberCommand.this.currentMemberObjs[n];
                        string2 = (String)configService.getAttribute(session, CreateMemberCommand.this.firstMemberObj, "memberName");
                        object4 = (String)configService.getAttribute(session, CreateMemberCommand.this.firstMemberObj, "nodeName");
                        CreateMemberCommand.this.firstServerObj = ClusterConfigHelper.getServerObj(configService, session, (String)object4, string2);
                        object3 = ClusterConfigHelper.getMemberNodeVersion(configService, session, (String)object4);
                        object2 = ClusterConfigHelper.getBestMemberTemplate(configService, session, CreateMemberCommand.this.clusterObj, (String)object3, (String)object4);
                        if (object2 == null) {
                            object2 = ClusterConfigHelper.createMemberTemplate(configService, session, CreateMemberCommand.this.firstServerObj, CreateMemberCommand.this.clusterObj, (String)object3);
                        }
                        object = ClusterConfigHelper.getMemberNodeVersion(configService, session, CreateMemberCommand.this.memberNode);
                        try {
                            object5 = ClusterConfigHelper.isMemberCompatibleWithNode(configService, session, CreateMemberCommand.this.memberNode, CreateMemberCommand.this.nodeObj, (String)object4, string2, CreateMemberCommand.this.firstMemberObj);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "node = " + (String)object4 + " match " + object5);
                            }
                            if (!((Boolean)object5).booleanValue()) break block49;
                            object2 = ClusterConfigHelper.getBestMemberTemplate(configService, session, CreateMemberCommand.this.clusterObj, (String)object, CreateMemberCommand.this.memberNode);
                            if (object2 == null) {
                                object5 = Boolean.FALSE;
                            } else {
                                CreateMemberCommand.this.templateObj = (ObjectName)object2;
                            }
                            if (!tc.isDebugEnabled()) break block49;
                            Tr.debug(tc, "Best matching template = " + object2 + " match " + object5);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "773", this);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "first member is not compatible " + (String)object4);
                            continue;
                        }
                    }
                    if (((Boolean)object5).booleanValue() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "found first member that is compatible " + (String)object4);
                    }
                    try {
                        CreateMemberCommand.this.firstMemberCoreGroup = ClusterConfigHelper.getCoreGroupForServer(configService, session, (String)object4, string2);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "786", this);
                        CreateMemberCommand.this.firstMemberCoreGroup = null;
                    }
                    if (!bl && n == 0 && (string = (String)configService.getAttribute(session, CreateMemberCommand.this.clusterObj, "nodeGroupName")) != null && !NodeGroupHelper.isNodeInNodeGroup(session, configService, CreateMemberCommand.this.memberNode, string)) {
                        String string8 = CreateMemberCommand.this.getMsg(resBundle, "ADMG0446E", new Object[]{CreateMemberCommand.this.memberNode, string});
                        throw new CommandValidationException(string8);
                    }
                    if (((Boolean)object5).booleanValue()) break;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "match = " + object5 + " members " + new Integer(CreateMemberCommand.this.currentMemberObjs.length));
                }
                if (!((Boolean)object5).booleanValue() && CreateMemberCommand.this.currentMemberObjs.length != 0) {
                    String string9 = (String)configService.getAttribute(session, CreateMemberCommand.this.firstMemberObj, "nodeName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "firstServerNode =" + string9);
                    }
                    if ((string2 = ClusterConfigHelper.getClusterType(configService, session, CreateMemberCommand.this.clusterObj)) == null) {
                        string2 = "APPLICATION_SERVER";
                    }
                    if ((object4 = TemplateConfigHelper.findDefaultTemplate(configService, session, CreateMemberCommand.this.memberNode, CreateMemberCommand.this.clusterObj, string2)) != null && object4 instanceof ObjectName) {
                        CreateMemberCommand.this.newMemberTemplate = (ObjectName)object4;
                    } else if (object4 != null) {
                        object3 = (List)object4;
                        object2 = new StringBuffer();
                        object = object3.iterator();
                        while (object.hasNext()) {
                            string = (String)object.next();
                            ((StringBuffer)object2).append(string);
                            ((StringBuffer)object2).append(";");
                        }
                        throw new CommandValidationException(((StringBuffer)object2).toString());
                    }
                    if (CreateMemberCommand.this.newMemberTemplate == null) {
                        object3 = ClusterConfigHelper.getMemberNodeVersion(configService, session, CreateMemberCommand.this.memberNode);
                        object2 = CreateMemberCommand.this.getMsg(resBundle, "ADMG0503E", new Object[]{object3});
                        throw new CommandValidationException((String)object2);
                    }
                }
                if (CreateMemberCommand.this.firstServerObj == null) {
                    CreateMemberCommand.this.firstMemberObj = null;
                    if (CreateMemberCommand.this.firstMemberStep == null || CreateMemberCommand.this.firstMemberStep.equals(Boolean.FALSE)) {
                        String[] stringArray = NodeGroupHelper.listNodeGroups(session, configService, CreateMemberCommand.this.memberNode);
                        if (stringArray != null && stringArray.length > 0) {
                            CreateMemberCommand.this.nodeGroup = stringArray[0];
                        } else if (!bl) {
                            string2 = CreateMemberCommand.this.getMsg(resBundle, "ADMG0446E", new Object[]{CreateMemberCommand.this.memberNode, CreateMemberCommand.this.nodeGroup});
                            throw new CommandValidationException(string2);
                        }
                    }
                }
                if (CreateMemberCommand.this.shortName != null && !ClusterConfigHelper.isShortNameValid(CreateMemberCommand.this.shortName)) {
                    throw new CommandValidationException("ShortName parameter not valid");
                }
            }
            catch (ClusterConfigException clusterConfigException) {
                FFDCFilter.processException((Throwable)clusterConfigException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "857", this);
                String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateMemberCommand.this.taskName, clusterConfigException.toString()});
                throw new CommandValidationException(string);
            }
            catch (NodeGroupConfigException nodeGroupConfigException) {
                FFDCFilter.processException((Throwable)nodeGroupConfigException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "861", this);
                String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateMemberCommand.this.taskName, nodeGroupConfigException.toString()});
                throw new CommandValidationException(string);
            }
            catch (ConfigServiceException configServiceException) {
                FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "865", this);
                String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateMemberCommand.this.taskName, configServiceException.toString()});
                throw new CommandValidationException(string);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "869", this);
                String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateMemberCommand.this.taskName, connectorException.toString()});
                throw new CommandValidationException(string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.commands.cluster.CreateMemberCommand.validate", "873", this);
                String string = CreateMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, CreateMemberCommand.this.taskName, exception.toString()});
                throw new CommandValidationException(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate step " + this.stepName);
            }
        }
    }
}

