/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.commands.cluster.ClusterConfigException;
import com.ibm.ws.management.commands.cluster.ClusterConfigHelper;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteClusterCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(DeleteClusterCommand.class, "ClusterConfig", BUNDLE_NAME);
    private static String CLUSTER_NAME_PARAM = "clusterName";
    private static String DELETE_REP_DOMAIN_PARAM = "deleteRepDomain";
    private String taskName = null;
    private ObjectName targetObj = null;
    private String clusterName = null;
    private Boolean deleteRepDomain = null;
    private ObjectName clusterObj = null;
    private ObjectName[] memberObjs = null;
    private ObjectName repDomainObj = null;
    private ArrayList memberServerObjs = null;
    private CommandProviderHelper ch = null;
    private ConfigService cs = null;
    private Session session = null;

    public DeleteClusterCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.reset();
        this.taskName = taskCommandMetadata.getName();
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
    }

    public DeleteClusterCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.reset();
        this.taskName = commandData.getName();
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resetting the command result.");
        }
        CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
        commandResultImpl.reset();
        String string = null;
        Object var3_3 = null;
        Object var4_4 = null;
        AttributeList attributeList = new AttributeList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting to delete cluster.");
        }
        try {
            Object object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting cluster: " + this.clusterObj.toString());
            }
            this.cs.deleteConfigData(this.session, this.clusterObj);
            if (this.deleteRepDomain != null && this.deleteRepDomain.equals(Boolean.TRUE)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleting cluster's replication domain");
                }
                this.cs.deleteConfigData(this.session, this.repDomainObj);
            }
            try {
                object = ClusterConfigHelper.getClusterTemplateContext(this.clusterName, this.session);
                object.delete(true);
            }
            catch (ClusterConfigException clusterConfigException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted", "Cannot get cluster template context");
                }
                string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), clusterConfigException.toString()});
                commandResultImpl.setException(new ClusterConfigException(clusterConfigException, string));
                commandResultImpl.setResult(string);
            }
            catch (WorkSpaceException workSpaceException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted", "failed deleting cluster context");
                }
                string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), workSpaceException.toString()});
                commandResultImpl.setException(new ClusterConfigException(workSpaceException, string));
                commandResultImpl.setResult(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting result of " + this.getName() + " command.");
            }
            object = this.getMsg(resBundle, "ADMG9228I", new Object[]{this.clusterName});
            commandResultImpl.setResult(object);
            if (!commandResultImpl.isSuccessful() && string != null) {
                commandResultImpl.addWarnings(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), configServiceException.toString()});
            commandResultImpl.setException(new ClusterConfigException(configServiceException, string));
            commandResultImpl.setResult(string);
            if (!commandResultImpl.isSuccessful() && string != null) {
                commandResultImpl.addWarnings(string);
            }
        }
        catch (ConnectorException connectorException) {
            string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), connectorException.toString()});
            commandResultImpl.setException(new ClusterConfigException(connectorException, string));
            commandResultImpl.setResult(string);
            if (!commandResultImpl.isSuccessful() && string != null) {
                commandResultImpl.addWarnings(string);
            }
            {
                catch (Throwable throwable) {
                    if (!commandResultImpl.isSuccessful() && string != null) {
                        commandResultImpl.addWarnings(string);
                    }
                    throw throwable;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void validate() throws CommandValidationException {
        if (DeleteClusterCommand.tc.isEntryEnabled()) {
            Tr.entry(DeleteClusterCommand.tc, "validate command");
        }
        this.reset();
        if (DeleteClusterCommand.tc.isDebugEnabled()) {
            Tr.debug(DeleteClusterCommand.tc, "Getting target object and parameters.");
        }
        this.targetObj = (ObjectName)this.getTargetObject();
        this.clusterName = (String)this.getParameter(DeleteClusterCommand.CLUSTER_NAME_PARAM);
        if (DeleteClusterCommand.tc.isDebugEnabled()) {
            Tr.debug(DeleteClusterCommand.tc, "Command parameters are: targetObject=" + (this.targetObj == null ? "null" : this.targetObj.toString()) + " " + DeleteClusterCommand.CLUSTER_NAME_PARAM + "=" + (this.clusterName == null ? "null" : this.clusterName.toString()));
        }
        try {
            this.ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            this.cs = this.ch.getConfigService();
            this.session = this.getConfigSession();
            var1_1 = null;
            var2_4 = null;
            var3_7 = new AttributeList();
            if (DeleteClusterCommand.tc.isDebugEnabled()) {
                Tr.debug(DeleteClusterCommand.tc, "Validating cluster to delete.");
            }
            if (this.targetObj != null) {
                if (this.clusterName != null) {
                    var4_8 = this.getMsg(DeleteClusterCommand.resBundle, "ADMG9213E", null);
                    throw new CommandValidationException(var4_8);
                }
                this.clusterObj = ObjectName.getInstance(this.targetObj);
                this.clusterName = ConfigServiceHelper.getDisplayName(this.clusterObj);
                var4_9 = null;
                var5_12 = null;
                var2_4 = null;
                try {
                    var4_9 = (String)this.cs.getAttribute(this.session, this.clusterObj, "name");
                    var2_4 = this.cs.resolve(this.session, "ServerCluster=" + this.clusterName);
                }
                catch (Exception var6_14) {
                    var5_12 = var6_14;
                }
                finally {
                    if (var5_12 == null && this.clusterName != null && var4_9 != null && var2_4.length >= 1 && this.clusterName.equals(var4_9)) ** GOTO lbl47
                    var6_15 = this.getMsg(DeleteClusterCommand.resBundle, "ADMG9214E", null);
                    throw new CommandValidationException(null);
                }
            } else {
                if (this.clusterName == null) {
                    var4_10 = this.getMsg(DeleteClusterCommand.resBundle, "ADMG9215E", null);
                    throw new CommandValidationException(var4_10);
                }
                var2_4 = null;
                var2_4 = this.cs.resolve(this.session, "ServerCluster=" + this.clusterName);
                if (var2_4.length == 0) {
                    var4_11 = this.getMsg(DeleteClusterCommand.resBundle, "ADMG9216E", new Object[]{this.clusterName});
                    throw new CommandValidationException(var4_11);
                }
                this.clusterObj = var2_4[0];
            }
lbl47:
            // 3 sources

            Tr.debug(DeleteClusterCommand.tc, "Calling superclass validator.");
            super.validate();
        }
        catch (ConnectorException var1_2) {
            var2_5 = this.getMsg(DeleteClusterCommand.resBundle, "ADMG9209E", new Object[]{this.getName(), var1_2.toString()});
            throw new CommandValidationException(var2_5);
        }
        catch (ConfigServiceException var1_3) {
            var2_6 = this.getMsg(DeleteClusterCommand.resBundle, "ADMG9209E", new Object[]{this.getName(), var1_3.toString()});
            throw new CommandValidationException(var2_6);
        }
        if (DeleteClusterCommand.tc.isEntryEnabled()) {
            Tr.exit(DeleteClusterCommand.tc, "validate command");
        }
    }

    private void reset() {
        this.clusterName = null;
        this.deleteRepDomain = null;
        this.clusterObj = null;
        this.memberObjs = null;
        this.repDomainObj = null;
        this.memberServerObjs = null;
        this.ch = null;
        this.cs = null;
        this.session = null;
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return ClusterConfigHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    private void getCommandParams(AbstractTaskCommand abstractTaskCommand) {
        this.targetObj = (ObjectName)abstractTaskCommand.getTargetObject();
        this.clusterName = null;
        try {
            this.clusterName = (String)abstractTaskCommand.getParameter(CLUSTER_NAME_PARAM);
        }
        catch (InvalidParameterNameException invalidParameterNameException) {
            // empty catch block
        }
        if (this.clusterName == null) {
            this.clusterObj = ObjectName.getInstance(this.targetObj);
            this.clusterName = ConfigServiceHelper.getDisplayName(this.clusterObj);
        }
    }

    public class DeleteReplicationDomainStep
    extends AbstractCommandStep {
        private String stepName;
        private CommandProviderHelper ch;
        private ConfigService cs;
        private Session session;
        private AbstractTaskCommand taskCmd;

        public DeleteReplicationDomainStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.ch = null;
            this.cs = null;
            this.session = null;
            this.taskCmd = null;
            this.stepName = commandStepMetadata.getName();
            this.taskCmd = abstractTaskCommand;
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
        }

        public DeleteReplicationDomainStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.ch = null;
            this.cs = null;
            this.session = null;
            this.taskCmd = null;
            this.stepName = commandStepData.getName();
            this.taskCmd = abstractTaskCommand;
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
        }

        protected void executeStep() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeStep " + this.stepName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeStep " + this.stepName);
            }
        }

        public void validate() throws CommandValidationException {
            block9: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "validate step " + this.stepName);
                }
                super.validate();
                CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
                ConfigService configService = commandProviderHelper.getConfigService();
                Session session = this.taskCmd.getConfigSession();
                Object var4_4 = null;
                ObjectName[] objectNameArray = null;
                AttributeList attributeList = new AttributeList();
                DeleteClusterCommand.this.getCommandParams(this.taskCmd);
                DeleteClusterCommand.this.deleteRepDomain = (Boolean)this.getParameter(DELETE_REP_DOMAIN_PARAM);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command parameters are: targetObject=" + (DeleteClusterCommand.this.targetObj == null ? "null" : DeleteClusterCommand.this.targetObj.toString()) + " " + CLUSTER_NAME_PARAM + "=" + (DeleteClusterCommand.this.clusterName == null ? "null" : DeleteClusterCommand.this.clusterName.toString()) + DELETE_REP_DOMAIN_PARAM + "=" + (DeleteClusterCommand.this.deleteRepDomain == null ? "null" : DeleteClusterCommand.this.deleteRepDomain.toString()));
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Validating command step parameters.");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Validating replication domain.");
                    }
                    if (DeleteClusterCommand.this.deleteRepDomain == null || !DeleteClusterCommand.this.deleteRepDomain.equals(Boolean.TRUE)) break block9;
                    objectNameArray = null;
                    objectNameArray = configService.resolve(session, "DataReplicationDomain=" + DeleteClusterCommand.this.clusterName);
                    if (objectNameArray.length != 0) {
                        DeleteClusterCommand.this.repDomainObj = objectNameArray[0];
                        break block9;
                    }
                    String string = DeleteClusterCommand.this.getMsg(resBundle, "ADMG9227E", new Object[]{DeleteClusterCommand.this.clusterName});
                    throw new CommandValidationException(string);
                }
                catch (ConfigServiceException configServiceException) {
                    String string = DeleteClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, DeleteClusterCommand.this.taskName, configServiceException.toString()});
                    throw new CommandValidationException(string);
                }
                catch (ConnectorException connectorException) {
                    String string = DeleteClusterCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, DeleteClusterCommand.this.taskName, connectorException.toString()});
                    throw new CommandValidationException(string);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate step " + this.stepName);
            }
        }

        public void stepModified(String string) {
            CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
            commandResultImpl.reset();
            try {
                this.validate();
            }
            catch (CommandValidationException commandValidationException) {
                String string2 = DeleteClusterCommand.this.getMsg(resBundle, "ADMG9250E", new Object[]{string, DeleteClusterCommand.this.taskName, commandValidationException.toString()});
                commandResultImpl.setException(commandValidationException);
                commandResultImpl.setResult(string2);
            }
        }
    }
}

