/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.cluster;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.commands.cluster.ClusterConfigException;
import com.ibm.ws.management.commands.cluster.ClusterConfigHelper;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteMemberCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(DeleteMemberCommand.class, "ClusterConfig", BUNDLE_NAME);
    private static String CLUSTER_NAME_PARAM = "clusterName";
    private static String MEMBER_NODE_PARAM = "memberNode";
    private static String MEMBER_NAME_PARAM = "memberName";
    private static String DELETE_REP_ENTRY_PARAM = "deleteEntry";
    private String taskName = null;
    private ObjectName targetObj = null;
    private String clusterName = null;
    private String memberNode = null;
    private String memberName = null;
    private Boolean deleteRepEntry = null;
    private ObjectName clusterObj = null;
    private ObjectName memberObj = null;
    private ObjectName serverObj = null;
    private ObjectName repDomainObj = null;
    private ObjectName repEntryObj = null;
    private CommandProviderHelper ch = null;
    private ConfigService cs = null;
    private Session session = null;

    public DeleteMemberCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.reset();
        this.taskName = taskCommandMetadata.getName();
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
    }

    public DeleteMemberCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.reset();
        this.taskName = commandData.getName();
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resetting the command result.");
        }
        CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
        commandResultImpl.reset();
        String string = null;
        Object var3_3 = null;
        Object var4_4 = null;
        AttributeList attributeList = new AttributeList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting to delete cluster member.");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting member server " + this.serverObj.toString());
            }
            ClusterConfigHelper.deleteClusterMember(this.cs, this.session, this.memberNode, this.memberName, null);
            ClusterConfigHelper.deleteMemberTemplate(this.cs, this.session, this.clusterName, this.clusterObj, this.memberNode);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting result of " + this.getName() + " command.");
            }
            String string2 = this.getMsg(resBundle, "ADMG9239I", new Object[]{this.memberName, this.memberNode, this.clusterName});
            commandResultImpl.setResult(string2);
            if (!commandResultImpl.isSuccessful() && string != null) {
                commandResultImpl.addWarnings(string);
            }
        }
        catch (Exception exception) {
            try {
                string = this.getMsg(resBundle, "ADMG9212E", new Object[]{this.getName(), exception.toString()});
                commandResultImpl.setException(new ClusterConfigException(exception, string));
                commandResultImpl.setResult(string);
                if (!commandResultImpl.isSuccessful() && string != null) {
                    commandResultImpl.addWarnings(string);
                }
            }
            catch (Throwable throwable) {
                if (!commandResultImpl.isSuccessful() && string != null) {
                    commandResultImpl.addWarnings(string);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        this.reset();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting target object and parameters.");
        }
        this.targetObj = (ObjectName)this.getTargetObject();
        this.clusterName = (String)this.getParameter(CLUSTER_NAME_PARAM);
        this.memberNode = (String)this.getParameter(MEMBER_NODE_PARAM);
        this.memberName = (String)this.getParameter(MEMBER_NAME_PARAM);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command parameters are: targetObject=" + (this.targetObj == null ? "null" : this.targetObj.toString()) + " " + CLUSTER_NAME_PARAM + "=" + (this.clusterName == null ? "null" : this.clusterName.toString()) + MEMBER_NODE_PARAM + "=" + (this.memberNode == null ? "null" : this.memberNode.toString()) + MEMBER_NAME_PARAM + "=" + (this.memberName == null ? "null" : this.memberName.toString()));
        }
        try {
            String string;
            this.ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
            this.cs = this.ch.getConfigService();
            this.session = this.getConfigSession();
            ObjectName objectName = null;
            ObjectName[] objectNameArray = null;
            AttributeList attributeList = new AttributeList();
            if (this.targetObj != null) {
                if (this.clusterName != null || this.memberNode != null || this.memberName != null) {
                    String string2 = this.getMsg(resBundle, "ADMG9233E", null);
                    throw new CommandValidationException(string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating target object.");
                }
                this.memberObj = ObjectName.getInstance(this.targetObj);
                this.memberName = (String)this.cs.getAttribute(this.session, this.memberObj, "memberName");
                this.memberNode = (String)this.cs.getAttribute(this.session, this.memberObj, "nodeName");
                if (this.memberName == null && this.memberNode == null) {
                    String string3 = this.getMsg(resBundle, "ADMG9230E", null);
                    throw new CommandValidationException(string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Finding parent cluster of cluster member.");
                }
                this.clusterObj = (ObjectName)this.cs.getAttribute(this.session, this.memberObj, "cluster");
                if (this.clusterObj == null) {
                    String string4 = this.getMsg(resBundle, "ADMG9231E", new Object[]{this.memberName, this.memberNode});
                    throw new CommandValidationException(string4);
                }
                this.clusterName = (String)this.cs.getAttribute(this.session, this.clusterObj, "name");
                if (this.clusterName == null) {
                    String string5 = this.getMsg(resBundle, "ADMG9232E", null);
                    throw new CommandValidationException(string5);
                }
            } else {
                if (this.clusterName == null && this.memberName == null && this.memberName == null) {
                    String string6 = this.getMsg(resBundle, "ADMG9229E", null);
                    throw new CommandValidationException(string6);
                }
                if (this.clusterName == null || this.memberName == null || this.memberName == null) {
                    String string7 = this.getMsg(resBundle, "ADMG9234E", null);
                    throw new CommandValidationException(string7);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating cluster name.");
                }
                objectNameArray = null;
                objectNameArray = this.cs.resolve(this.session, "ServerCluster=" + this.clusterName);
                if (objectNameArray.length == 0) {
                    String string8 = this.getMsg(resBundle, "ADMG9216E", new Object[]{this.clusterName});
                    throw new CommandValidationException(string8);
                }
                this.clusterObj = objectNameArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Findng member object in cluster.");
                }
                objectName = ConfigServiceHelper.createObjectName(null, "ClusterMember");
                objectNameArray = null;
                objectNameArray = this.cs.queryConfigObjects(this.session, this.clusterObj, objectName, null);
                if (objectNameArray.length > 0) {
                    string = null;
                    String string9 = null;
                    for (int i = 0; i < objectNameArray.length; ++i) {
                        string = null;
                        string9 = null;
                        string = (String)this.cs.getAttribute(this.session, objectNameArray[i], "memberName");
                        if (!string.equals(this.memberName) || !(string9 = (String)this.cs.getAttribute(this.session, objectNameArray[i], "nodeName")).equals(this.memberNode)) continue;
                        this.memberObj = objectNameArray[i];
                    }
                }
                if (this.memberObj == null) {
                    string = this.getMsg(resBundle, "ADMG9235E", new Object[]{this.memberName, this.memberNode, this.clusterName});
                    throw new CommandValidationException(string);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Obtaining member's server object.");
            }
            this.serverObj = ClusterConfigHelper.getServerObj(this.cs, this.session, this.memberNode, this.memberName);
            if (this.serverObj == null) {
                string = this.getMsg(resBundle, "ADMG9236E", new Object[]{this.memberName, this.memberNode});
                throw new CommandValidationException(string);
            }
            Tr.debug(tc, "Calling superclass validator.");
            super.validate();
        }
        catch (ConnectorException connectorException) {
            String string = this.getMsg(resBundle, "ADMG9209E", new Object[]{this.getName(), connectorException.toString()});
            throw new CommandValidationException(string);
        }
        catch (ConfigServiceException configServiceException) {
            String string = this.getMsg(resBundle, "ADMG9209E", new Object[]{this.getName(), configServiceException.toString()});
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    private void reset() {
        this.targetObj = null;
        this.clusterName = null;
        this.memberNode = null;
        this.memberName = null;
        this.deleteRepEntry = null;
        this.clusterObj = null;
        this.memberObj = null;
        this.serverObj = null;
        this.repDomainObj = null;
        this.repEntryObj = null;
        this.ch = null;
        this.cs = null;
        this.session = null;
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return ClusterConfigHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    private void getCommandParams(ConfigService configService, Session session, AbstractTaskCommand abstractTaskCommand) {
        try {
            this.targetObj = (ObjectName)abstractTaskCommand.getTargetObject();
            this.clusterName = (String)abstractTaskCommand.getParameter(CLUSTER_NAME_PARAM);
            if (this.targetObj != null) {
                this.memberObj = ObjectName.getInstance(this.targetObj);
            }
            this.memberNode = (String)abstractTaskCommand.getParameter(MEMBER_NODE_PARAM);
            this.memberName = (String)abstractTaskCommand.getParameter(MEMBER_NAME_PARAM);
            if (this.memberObj != null) {
                this.clusterObj = (ObjectName)configService.getAttribute(session, this.memberObj, "cluster");
            }
            if (this.memberName == null) {
                this.memberName = (String)configService.getAttribute(session, this.memberObj, "memberName");
            }
            if (this.memberNode == null) {
                this.memberNode = (String)configService.getAttribute(session, this.memberObj, "nodeName");
            }
            if (this.clusterName == null) {
                this.clusterName = (String)configService.getAttribute(session, this.clusterObj, "name");
            }
        }
        catch (ConfigServiceException configServiceException) {
            configServiceException.printStackTrace();
        }
        catch (ConnectorException connectorException) {
            connectorException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class DeleteReplicationEntryStep
    extends AbstractCommandStep {
        private String stepName;
        private CommandProviderHelper ch;
        private ConfigService cs;
        private Session session;
        private AbstractTaskCommand taskCmd;

        public DeleteReplicationEntryStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.ch = null;
            this.cs = null;
            this.session = null;
            this.taskCmd = null;
            this.stepName = commandStepMetadata.getName();
            this.taskCmd = abstractTaskCommand;
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
        }

        public DeleteReplicationEntryStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.ch = null;
            this.cs = null;
            this.session = null;
            this.taskCmd = null;
            this.stepName = commandStepData.getName();
            this.taskCmd = abstractTaskCommand;
            CommandResultImpl commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
        }

        protected void executeStep() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeStep " + this.stepName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeStep " + this.stepName);
            }
        }

        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate step " + this.stepName);
            }
            super.validate();
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.taskCmd.getConfigSession();
            Object var4_4 = null;
            Object var5_5 = null;
            AttributeList attributeList = new AttributeList();
            DeleteMemberCommand.this.getCommandParams(configService, session, this.taskCmd);
            try {
                DeleteMemberCommand.this.deleteRepEntry = (Boolean)this.getParameter(DELETE_REP_ENTRY_PARAM);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command parameters are: targetObject=" + (DeleteMemberCommand.this.targetObj == null ? "null" : DeleteMemberCommand.this.targetObj.toString()) + " " + CLUSTER_NAME_PARAM + "=" + (DeleteMemberCommand.this.clusterName == null ? "null" : DeleteMemberCommand.this.clusterName.toString()) + MEMBER_NODE_PARAM + "=" + (DeleteMemberCommand.this.memberNode == null ? "null" : DeleteMemberCommand.this.memberNode.toString()) + MEMBER_NAME_PARAM + "=" + (DeleteMemberCommand.this.memberName == null ? "null" : DeleteMemberCommand.this.memberName.toString()) + DELETE_REP_ENTRY_PARAM + "=" + (DeleteMemberCommand.this.deleteRepEntry == null ? "null" : DeleteMemberCommand.this.deleteRepEntry.toString()));
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating command step parameters.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = DeleteMemberCommand.this.getMsg(resBundle, "ADMG9249E", new Object[]{this.stepName, DeleteMemberCommand.this.taskName, exception.toString()});
                throw new CommandValidationException(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate step " + this.stepName);
            }
        }

        public void stepModified(String string) {
            CommandResultImpl commandResultImpl = (CommandResultImpl)this.getCommandResult();
            commandResultImpl.reset();
            try {
                this.validate();
            }
            catch (CommandValidationException commandValidationException) {
                String string2 = DeleteMemberCommand.this.getMsg(resBundle, "ADMG9250E", new Object[]{string, DeleteMemberCommand.this.taskName, commandValidationException.toString()});
                commandResultImpl.setException(commandValidationException);
                commandResultImpl.setResult(string2);
            }
        }
    }
}

