/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.helper;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.AdminCommandHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AdminHelperCommandProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(AdminHelperCommandProvider.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final String[] processDefPropList = new String[]{"executableName", "workingDirectory", "executableTarget", "executableArguments", "executableTargetKind"};
    private static final String[] processDefPropListZOS = new String[]{"processType", "startCommand", "stopCommand", "terminateCommand", "startCommandArgs", "stopCommandArgs", "terminateCommandArgs"};
    private static final String[] jvmPropertiesList = new String[]{"classpath", "bootClasspath", "verboseModeClass", "verboseModeGarbageCollection", "verboseModeJNI", "initialHeapSize", "maximumHeapSize", "runHProf", "hprofArguments", "debugMode", "debugArgs", "genericJvmArguments", "executableJarFileName", "disableJIT", "osName", "internalClassAccessMode"};
    private static final String[] serverInstancePropList = new String[]{"enableMultipleServerInstances", "minimumNumOfInstances", "maximumNumberOfInstances"};
    private static String JVM_Mode_64 = "64bit";
    private static String JVM_Mode_31 = "31bit";
    private static String JAVA_HOME = "${WAS_HOME}/java64";

    public Boolean isFederated(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFederated", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + objectName + "\n");
        }
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + objectName2 + "\n");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell Name is " + ConfigServiceHelper.getDisplayName(objectName2));
        }
        String string = (String)configService.getAttribute(session, objectName2, "cellType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell type is " + string);
        }
        Boolean bl = new Boolean(string.equals("DISTRIBUTED"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFederated", bl);
        }
        return bl;
    }

    public List getDmgrProperties(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDmgrName", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        AttributeList attributeList = new AttributeList();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName2 = objectNameArray[i];
            String string = (String)configService.getAttribute(session, objectName2, "serverType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server type is " + string);
            }
            if (!string.equals("DEPLOYMENT_MANAGER")) continue;
            String string2 = (String)configService.getAttribute(session, objectName2, "serverName");
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "specialEndpoints", false);
            for (int j = 0; j < arrayList.size(); ++j) {
                ObjectName objectName3 = (ObjectName)arrayList.get(j);
                if (!((String)configService.getAttribute(session, objectName3, "endPointName")).equals("SOAP_CONNECTOR_ADDRESS")) continue;
                ObjectName objectName4 = (ObjectName)configService.getAttribute(session, objectName3, "endPoint", false);
                String string3 = (String)configService.getAttribute(session, objectName4, "host");
                Integer n = (Integer)configService.getAttribute(session, objectName4, "port");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dmgr host is " + string3 + " port is " + n);
                }
                ConfigServiceHelper.setAttributeValue(attributeList, "host", string3);
                ConfigServiceHelper.setAttributeValue(attributeList, "port", n);
                ConfigServiceHelper.setAttributeValue(attributeList, "name", string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDmgrName", attributeList);
        }
        return attributeList;
    }

    public boolean setVariable(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVariable", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("scope");
        if (string == null || string.equals("")) {
            string = "Cell";
        }
        try {
            int n;
            ObjectName[] objectNameArray = AdminCommandHelper.getResources(session, configService, string);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scope", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = configService.getRelationship(session, objectName, "VariableMap")[0];
            AttributeList attributeList = new AttributeList();
            String string2 = (String)abstractAdminCommand.getParameter("variableName");
            ConfigServiceHelper.setAttributeValue(attributeList, "value", abstractAdminCommand.getParameter("variableValue"));
            ConfigServiceHelper.setAttributeValue(attributeList, "description", abstractAdminCommand.getParameter("variableDescription"));
            boolean bl = false;
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "entries", false);
            for (n = 0; n < arrayList.size(); ++n) {
                ObjectName objectName3 = (ObjectName)arrayList.get(n);
                String string3 = (String)configService.getAttribute(session, objectName3, "symbolicName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing variable name is " + string3);
                }
                if (!string3.equals(string2)) continue;
                configService.setAttributes(session, objectName3, attributeList);
                bl = true;
            }
            if (!bl) {
                ConfigServiceHelper.setAttributeValue(attributeList, "symbolicName", string2);
                configService.createConfigData(session, objectName2, "entries", "VariableSubstitutionEntry", attributeList);
            }
            n = 1;
            return n != 0;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setVariable", "187");
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setVariable");
            }
        }
    }

    public boolean removeVariable(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeVariable", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("scope");
        String string2 = (String)abstractAdminCommand.getParameter("variableName");
        if (string == null || string.equals("")) {
            string = "Cell";
        }
        try {
            int n;
            ObjectName[] objectNameArray = AdminCommandHelper.getResources(session, configService, string);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scope", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = configService.getRelationship(session, objectName, "VariableMap")[0];
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "entries", false);
            for (n = 0; n < arrayList.size(); ++n) {
                ObjectName objectName3 = (ObjectName)arrayList.get(n);
                String string3 = (String)configService.getAttribute(session, objectName3, "symbolicName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing variable name is " + string3);
                }
                if (!string3.equals(string2)) continue;
                configService.deleteConfigData(session, objectName3);
            }
            n = 1;
            return n != 0;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.removeVariable", "187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeVariable");
            }
        }
    }

    public Object showVariables(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showVariables", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("scope");
        String string2 = (String)abstractAdminCommand.getParameter("variableName");
        if (string == null || string.equals("")) {
            string = "Cell";
        }
        Object object = null;
        if (string2 == null || string2.equals("")) {
            object = new AttributeList();
        }
        try {
            ObjectName[] objectNameArray = AdminCommandHelper.getResources(session, configService, string);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scope", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName[] objectNameArray2 = configService.getRelationship(session, objectName, "VariableMap");
            if (objectNameArray2.length <= 0) {
                Object var11_12 = null;
                return var11_12;
            }
            ObjectName objectName2 = objectNameArray2[0];
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "entries", false);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3;
                ObjectName objectName3 = (ObjectName)arrayList.get(i);
                String string4 = (String)configService.getAttribute(session, objectName3, "symbolicName");
                if (string2 == null || string2.equals("")) {
                    string3 = (String)configService.getAttribute(session, objectName3, "value");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Existing variable name is " + string4 + ".  Value is " + string3);
                    }
                    ConfigServiceHelper.setAttributeValue((AttributeList)object, string4, string3);
                    continue;
                }
                if (!string4.equals(string2)) continue;
                string3 = (String)configService.getAttribute(session, objectName3, "value");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing variable name is " + string4 + ".  Value is " + string3);
                }
                object = string3;
                break;
            }
            AttributeList attributeList = object;
            return attributeList;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.showVariables", "257");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "showVariables");
            }
        }
    }

    public boolean setProcessDefinition(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProcessDefinition", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        AttributeList attributeList = new AttributeList();
        try {
            int n;
            Object object;
            ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
            String string = (String)abstractAdminCommand.getParameter("serverName");
            String string2 = (String)abstractAdminCommand.getParameter("nodeName");
            String string3 = (String)abstractAdminCommand.getParameter("processType");
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scopeName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string3);
            if (arrayList.contains("executableName")) {
                object = (String[])abstractAdminCommand.getParameter("executableName");
                ConfigServiceHelper.setAttributeValue(attributeList, "executableName", object);
            }
            if (arrayList.contains("workingDirectory") && (object = (String)abstractAdminCommand.getParameter("workingDirectory")) != null && !((String)object).equals("")) {
                ConfigServiceHelper.setAttributeValue(attributeList, "workingDirectory", object);
            }
            if (arrayList.contains("executableTarget")) {
                object = (String)abstractAdminCommand.getParameter("executableTarget");
                ConfigServiceHelper.setAttributeValue(attributeList, "executableTarget", object);
            }
            if (arrayList.contains("executableArguments")) {
                object = (String[])abstractAdminCommand.getParameter("executableArguments");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "executableArg got is ", object);
                }
                for (n = 0; n < ((String[])object).length; ++n) {
                    configService.addElement(session, objectName2, "executableArguments", object[n], -1);
                }
            }
            if (arrayList.contains("startCommand")) {
                object = (String)abstractAdminCommand.getParameter("startCommand");
                ConfigServiceHelper.setAttributeValue(attributeList, "startCommand", object);
            }
            if (arrayList.contains("startCommandArgs")) {
                object = (String[])abstractAdminCommand.getParameter("startCommandArgs");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "startCommandArgs got is ", object);
                }
                for (n = 0; n < ((String[])object).length; ++n) {
                    configService.addElement(session, objectName2, "startCommandArgs", object[n], -1);
                }
            }
            if (arrayList.contains("stopCommand")) {
                object = (String)abstractAdminCommand.getParameter("stopCommand");
                ConfigServiceHelper.setAttributeValue(attributeList, "stopCommand", object);
            }
            if (arrayList.contains("stopCommandArgs")) {
                object = (String[])abstractAdminCommand.getParameter("stopCommandArgs");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stopCommandArgs got is ", object);
                }
                for (n = 0; n < ((String[])object).length; ++n) {
                    configService.addElement(session, objectName2, "stopCommandArgs", object[n], -1);
                }
            }
            if (arrayList.contains("terminateCommand")) {
                object = (String)abstractAdminCommand.getParameter("terminateCommand");
                ConfigServiceHelper.setAttributeValue(attributeList, "terminateCommand", object);
            }
            if (arrayList.contains("terminateCommandArgs")) {
                object = (String[])abstractAdminCommand.getParameter("terminateCommandArgs");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "terminateCommandArgs got is ", object);
                }
                for (n = 0; n < ((String[])object).length; ++n) {
                    configService.addElement(session, objectName2, "terminateCommandArgs", object[n], -1);
                }
            }
            if (arrayList.contains("stopImmediateCommand")) {
                object = (String)abstractAdminCommand.getParameter("stopImmediateCommand");
                ConfigServiceHelper.setAttributeValue(attributeList, "stopImmediateCommand", object);
            }
            if (arrayList.contains("processType")) {
                if (string3.equalsIgnoreCase("Control") || string3.equalsIgnoreCase("Servant") || string3.equalsIgnoreCase("Adjunct")) {
                    ConfigServiceHelper.setAttributeValue(attributeList, "processType", string3);
                } else {
                    throw new InvalidParameterValueException(abstractAdminCommand.getName(), "processType", string3);
                }
            }
            if (arrayList.contains("executableTargetKind")) {
                object = (String)abstractAdminCommand.getParameter("executableTargetKind");
                if (!((String)object).equalsIgnoreCase("JAVA_CLASS") && !((String)object).equalsIgnoreCase("EXECUTABLE_JAR")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "executableTargetType is incorrect" + (String)object);
                    }
                    throw new InvalidParameterValueException(abstractAdminCommand.getName(), "executableTargetKind", object);
                }
                ConfigServiceHelper.setAttributeValue(attributeList, "executableTargetKind", object);
            }
            configService.setAttributes(session, objectName2, attributeList);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setProcessDefinition", "297");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setProcessDefinition");
            }
        }
    }

    public Object showProcessDefinition(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProcessDefinition", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("serverName");
        String string2 = (String)abstractAdminCommand.getParameter("nodeName");
        String string3 = (String)abstractAdminCommand.getParameter("propertyName");
        String string4 = (String)abstractAdminCommand.getParameter("processType");
        try {
            Object object;
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string4);
            if (string3 != null && !string3.equals("")) {
                object = configService.getAttribute(session, objectName2, string3, false);
            } else {
                Object object2;
                int n;
                object = new AttributeList();
                for (n = 0; n < processDefPropList.length; ++n) {
                    string3 = processDefPropList[n];
                    object2 = configService.getAttribute(session, objectName2, string3, false);
                    ConfigServiceHelper.setAttributeValue((AttributeList)object, string3, object2);
                }
                for (n = 0; n < processDefPropListZOS.length; ++n) {
                    string3 = processDefPropListZOS[n];
                    object2 = configService.getAttribute(session, objectName2, string3, false);
                    ConfigServiceHelper.setAttributeValue((AttributeList)object, string3, object2);
                }
            }
            Object object3 = object;
            return object3;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.showProcessDefinition", "339");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "showProcessDefinition");
            }
        }
    }

    public boolean setJVMProperties(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMProperties", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        AttributeList attributeList = new AttributeList();
        try {
            int n;
            Object object;
            Serializable serializable;
            Object object2;
            ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
            String string = (String)abstractAdminCommand.getParameter("serverName");
            String string2 = (String)abstractAdminCommand.getParameter("nodeName");
            String string3 = (String)abstractAdminCommand.getParameter("processType");
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            if (arrayList.contains("internalClassAccessMode")) {
                object2 = (String)abstractAdminCommand.getParameter("internalClassAccessMode");
                if (((String)object2).equals("ALLOW") || ((String)object2).equals("RESTRICT")) {
                    serializable = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(serializable, "internalClassAccessMode", object2);
                    object = configService.queryConfigObjects(session, objectName, objectName2, null);
                    for (n = 0; n < ((Object[])object).length; ++n) {
                        Object object3 = object[n];
                        configService.setAttributes(session, (ObjectName)object3, (AttributeList)serializable);
                    }
                } else {
                    throw new InvalidParameterValueException(abstractAdminCommand.getName(), "internalClassAccessMode", object2);
                }
            }
            object2 = this.getProcessDefWithProcessType(session, configService, objectName, string3);
            serializable = configService.queryConfigObjects(session, (ObjectName)object2, objectName2, null)[0];
            if (arrayList.contains("classpath")) {
                object = (String[])abstractAdminCommand.getParameter("classpath");
                for (n = 0; n < ((Object[])object).length; ++n) {
                    configService.addElement(session, (ObjectName)serializable, "classpath", object[n], -1);
                }
            }
            if (arrayList.contains("bootClasspath")) {
                object = (String[])abstractAdminCommand.getParameter("bootClasspath");
                for (n = 0; n < ((Object[])object).length; ++n) {
                    configService.addElement(session, (ObjectName)serializable, "bootClasspath", object[n], -1);
                }
            }
            if (arrayList.contains("verboseModeClass")) {
                object = (Boolean)abstractAdminCommand.getParameter("verboseModeClass");
                ConfigServiceHelper.setAttributeValue(attributeList, "verboseModeClass", object);
            }
            if (arrayList.contains("verboseModeGarbageCollection")) {
                object = (Boolean)abstractAdminCommand.getParameter("verboseModeGarbageCollection");
                ConfigServiceHelper.setAttributeValue(attributeList, "verboseModeGarbageCollection", object);
            }
            if (arrayList.contains("verboseModeJNI")) {
                object = (Boolean)abstractAdminCommand.getParameter("verboseModeJNI");
                ConfigServiceHelper.setAttributeValue(attributeList, "verboseModeJNI", object);
            }
            if (arrayList.contains("initialHeapSize")) {
                object = (Integer)abstractAdminCommand.getParameter("initialHeapSize");
                ConfigServiceHelper.setAttributeValue(attributeList, "initialHeapSize", object);
            }
            if (arrayList.contains("maximumHeapSize")) {
                object = (Integer)abstractAdminCommand.getParameter("maximumHeapSize");
                ConfigServiceHelper.setAttributeValue(attributeList, "maximumHeapSize", object);
            }
            if (arrayList.contains("runHProf")) {
                object = (Boolean)abstractAdminCommand.getParameter("runHProf");
                ConfigServiceHelper.setAttributeValue(attributeList, "runHProf", object);
            }
            if (arrayList.contains("hprofArguments")) {
                object = (String)abstractAdminCommand.getParameter("hprofArguments");
                ConfigServiceHelper.setAttributeValue(attributeList, "hprofArguments", object);
            }
            if (arrayList.contains("debugMode")) {
                object = (Boolean)abstractAdminCommand.getParameter("debugMode");
                ConfigServiceHelper.setAttributeValue(attributeList, "debugMode", object);
            }
            if (arrayList.contains("debugArgs")) {
                object = (String)abstractAdminCommand.getParameter("debugArgs");
                ConfigServiceHelper.setAttributeValue(attributeList, "debugArgs", object);
            }
            if (arrayList.contains("genericJvmArguments")) {
                object = (String)abstractAdminCommand.getParameter("genericJvmArguments");
                ConfigServiceHelper.setAttributeValue(attributeList, "genericJvmArguments", object);
            }
            if (arrayList.contains("executableJarFileName")) {
                object = (String)abstractAdminCommand.getParameter("executableJarFileName");
                ConfigServiceHelper.setAttributeValue(attributeList, "executableJarFileName", object);
            }
            if (arrayList.contains("disableJIT")) {
                object = (Boolean)abstractAdminCommand.getParameter("disableJIT");
                ConfigServiceHelper.setAttributeValue(attributeList, "disableJIT", object);
            }
            if (arrayList.contains("osName")) {
                object = (String)abstractAdminCommand.getParameter("osName");
                ConfigServiceHelper.setAttributeValue(attributeList, "osName", object);
            }
            configService.setAttributes(session, (ObjectName)serializable, attributeList);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setJVMProperties", "498");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setJVMProperties");
            }
        }
    }

    public boolean setJVMInitialHeapSize(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMInitialHeapSize", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        AttributeList attributeList = new AttributeList();
        try {
            ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
            String string = (String)abstractAdminCommand.getParameter("serverName");
            String string2 = (String)abstractAdminCommand.getParameter("nodeName");
            String string3 = (String)abstractAdminCommand.getParameter("processType");
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string3);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName objectName4 = configService.queryConfigObjects(session, objectName2, objectName3, null)[0];
            if (arrayList.contains("initialHeapSize")) {
                Integer n = (Integer)abstractAdminCommand.getParameter("initialHeapSize");
                ConfigServiceHelper.setAttributeValue(attributeList, "initialHeapSize", n);
            }
            configService.setAttributes(session, objectName4, attributeList);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setJVMInitialHeapSize", "535");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setJVMInitialHeapSize");
            }
        }
    }

    public boolean setJVMDebugMode(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMDebugMode", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        AttributeList attributeList = new AttributeList();
        try {
            ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
            String string = (String)abstractAdminCommand.getParameter("serverName");
            String string2 = (String)abstractAdminCommand.getParameter("nodeName");
            String string3 = (String)abstractAdminCommand.getParameter("processType");
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string3);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName objectName4 = configService.queryConfigObjects(session, objectName2, objectName3, null)[0];
            if (arrayList.contains("debugMode")) {
                Boolean bl = (Boolean)abstractAdminCommand.getParameter("debugMode");
                ConfigServiceHelper.setAttributeValue(attributeList, "debugMode", bl);
            }
            configService.setAttributes(session, objectName4, attributeList);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setJVMDebugMode", "572");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setJVMDebugMode");
            }
        }
    }

    public boolean setGenericJVMArguments(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGenericJVMArguments", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        AttributeList attributeList = new AttributeList();
        try {
            ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
            String string = (String)abstractAdminCommand.getParameter("serverName");
            String string2 = (String)abstractAdminCommand.getParameter("nodeName");
            String string3 = (String)abstractAdminCommand.getParameter("processType");
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string3);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName objectName4 = configService.queryConfigObjects(session, objectName2, objectName3, null)[0];
            if (arrayList.contains("genericJvmArguments")) {
                String string4 = (String)abstractAdminCommand.getParameter("genericJvmArguments");
                ConfigServiceHelper.setAttributeValue(attributeList, "genericJvmArguments", string4);
            }
            configService.setAttributes(session, objectName4, attributeList);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setGenericJVMArguments", "612");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setGenericJVMArguments");
            }
        }
    }

    public boolean setJVMMaxHeapSize(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMMaxHeapSize", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        AttributeList attributeList = new AttributeList();
        try {
            ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
            String string = (String)abstractAdminCommand.getParameter("serverName");
            String string2 = (String)abstractAdminCommand.getParameter("nodeName");
            String string3 = (String)abstractAdminCommand.getParameter("processType");
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string3);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName objectName4 = configService.queryConfigObjects(session, objectName2, objectName3, null)[0];
            if (arrayList.contains("maximumHeapSize")) {
                Integer n = (Integer)abstractAdminCommand.getParameter("maximumHeapSize");
                ConfigServiceHelper.setAttributeValue(attributeList, "maximumHeapSize", n);
            }
            configService.setAttributes(session, objectName4, attributeList);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setJVMMaxHeapSize", "609");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setJVMMaxHeapSize");
            }
        }
    }

    public Object showJVMProperties(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showJVMProperties", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("serverName");
        String string2 = (String)abstractAdminCommand.getParameter("nodeName");
        String string3 = (String)abstractAdminCommand.getParameter("processType");
        String string4 = (String)abstractAdminCommand.getParameter("propertyName");
        try {
            Object object;
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string3);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName objectName4 = configService.queryConfigObjects(session, objectName2, objectName3, null)[0];
            if (string4 != null && !string4.equals("")) {
                object = configService.getAttribute(session, objectName4, string4, false);
            } else {
                object = new AttributeList();
                for (int i = 0; i < jvmPropertiesList.length; ++i) {
                    string4 = jvmPropertiesList[i];
                    Object object2 = configService.getAttribute(session, objectName4, string4, false);
                    ConfigServiceHelper.setAttributeValue((AttributeList)object, string4, object2);
                }
            }
            Object object3 = object;
            return object3;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.showJVMProperties", "475");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "showJVMProperties");
            }
        }
    }

    public boolean setJVMSystemProperties(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMSystemProperties", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        AttributeList attributeList = new AttributeList();
        try {
            String string;
            ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
            String string2 = (String)abstractAdminCommand.getParameter("serverName");
            String string3 = (String)abstractAdminCommand.getParameter("nodeName");
            String string4 = (String)abstractAdminCommand.getParameter("processType");
            ObjectName[] objectNameArray = this.getScope(session, "Server", string2, string3);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string2);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string4);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName objectName4 = configService.queryConfigObjects(session, objectName2, objectName3, null)[0];
            if (arrayList.contains("propertyName")) {
                string = (String)abstractAdminCommand.getParameter("propertyName");
                ConfigServiceHelper.setAttributeValue(attributeList, "name", string);
            }
            if (arrayList.contains("propertyValue")) {
                string = (String)abstractAdminCommand.getParameter("propertyValue");
                ConfigServiceHelper.setAttributeValue(attributeList, "value", string);
            }
            configService.addElement(session, objectName4, "systemProperties", attributeList, -1);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setJVMSystemProperties", "517");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setJVMSystemProperties");
            }
        }
    }

    public Object showJVMSystemProperties(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showJVMProperties", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("serverName");
        String string2 = (String)abstractAdminCommand.getParameter("nodeName");
        String string3 = (String)abstractAdminCommand.getParameter("processType");
        String string4 = (String)abstractAdminCommand.getParameter("propertyName");
        Object object = null;
        if (string4 == null || string4.equals("")) {
            object = new AttributeList();
        }
        try {
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = this.getProcessDefWithProcessType(session, configService, objectName, string3);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
            ObjectName objectName4 = configService.queryConfigObjects(session, objectName2, objectName3, null)[0];
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName4, "systemProperties");
            for (int i = 0; i < arrayList.size(); ++i) {
                String string5;
                AttributeList attributeList = (AttributeList)arrayList.get(i);
                String string6 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
                if (string4 == null || string4.equals("")) {
                    string5 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "value");
                    ConfigServiceHelper.setAttributeValue((AttributeList)object, string6, string5);
                    continue;
                }
                if (!string6.equalsIgnoreCase(string4)) continue;
                string5 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "value");
                object = string5;
                break;
            }
            AttributeList attributeList = object;
            return attributeList;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.showJVMProperties", "475");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "showJVMProperties");
            }
        }
    }

    public boolean setServerInstance(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerInstance", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
        String string = (String)abstractAdminCommand.getParameter("serverName");
        String string2 = (String)abstractAdminCommand.getParameter("nodeName");
        try {
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "ServerInstance");
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, objectName2, null);
            if (objectNameArray2.length > 0) {
                ObjectName objectName3 = objectNameArray2[0];
                if (objectName3 != null) {
                    Comparable<Boolean> comparable;
                    AttributeList attributeList = new AttributeList();
                    if (arrayList.contains("enableMultipleServerInstances")) {
                        comparable = (Boolean)abstractAdminCommand.getParameter("enableMultipleServerInstances");
                        ConfigServiceHelper.setAttributeValue(attributeList, "enableMultipleServerInstances", comparable);
                    }
                    if (arrayList.contains("minimumNumOfInstances")) {
                        comparable = (Integer)abstractAdminCommand.getParameter("minimumNumOfInstances");
                        ConfigServiceHelper.setAttributeValue(attributeList, "minimumNumOfInstances", comparable);
                    }
                    if (arrayList.contains("maximumNumberOfInstances")) {
                        comparable = (Integer)abstractAdminCommand.getParameter("maximumNumberOfInstances");
                        ConfigServiceHelper.setAttributeValue(attributeList, "maximumNumberOfInstances", comparable);
                    }
                    configService.setAttributes(session, objectName3, attributeList);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find serverInstance");
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setServerInstance", "825");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setServerInstance");
            }
        }
    }

    public Object showServerInstance(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showServerInstance", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
        String string = (String)abstractAdminCommand.getParameter("serverName");
        String string2 = (String)abstractAdminCommand.getParameter("nodeName");
        String string3 = (String)abstractAdminCommand.getParameter("propertyName");
        Object object = null;
        try {
            ObjectName objectName;
            ObjectName[] objectNameArray = this.getScope(session, "Server", string, string2);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            ObjectName objectName2 = objectNameArray[0];
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "ServerInstance");
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName2, objectName3, null);
            if (objectNameArray2.length > 0) {
                objectName = objectNameArray2[0];
                if (objectName != null) {
                    if (string3 != null && !string3.equals("")) {
                        object = configService.getAttribute(session, objectName, string3, false);
                    } else {
                        object = new AttributeList();
                        for (int i = 0; i < serverInstancePropList.length; ++i) {
                            string3 = serverInstancePropList[i];
                            Object object2 = configService.getAttribute(session, objectName, string3, false);
                            ConfigServiceHelper.setAttributeValue((AttributeList)object, string3, object2);
                        }
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot find serverInstance");
                }
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
            }
            objectName = object;
            return objectName;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.showServerInstance", "905");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "showServerInstance");
            }
        }
    }

    public boolean setTraceSpecification(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTraceSpecification", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ArrayList arrayList = (ArrayList)abstractAdminCommand.listSetParams();
        String string = (String)abstractAdminCommand.getParameter("serverName");
        String string2 = (String)abstractAdminCommand.getParameter("nodeName");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("persist");
        try {
            if (arrayList.contains("traceSpecification")) {
                Serializable serializable;
                Object object;
                Comparable<StringBuffer> comparable;
                Object object2;
                String string3 = (String)abstractAdminCommand.getParameter("traceSpecification");
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    object2 = null;
                    if (string == null || string.equalsIgnoreCase("")) {
                        string = adminService.getProcessName();
                    }
                    comparable = new StringBuffer("WebSphere:type=TraceService");
                    if (string2 != null && !string2.equalsIgnoreCase("")) {
                        ((StringBuffer)comparable).append(",node=" + string2);
                    }
                    ((StringBuffer)comparable).append(",process=" + string + ",*");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TraceServiceMean query string is " + ((StringBuffer)comparable).toString());
                    }
                    if ((object = adminService.queryNames(new ObjectName(((StringBuffer)comparable).toString()), null)).size() == 1) {
                        object2 = (ObjectName)object.iterator().next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TraceServiceMean is " + object2);
                        }
                        serializable = new Attribute("traceSpecification", string3);
                        adminService.setAttribute((ObjectName)object2, (Attribute)serializable);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TraceServiceMean spec is is " + adminService.getAttribute((ObjectName)object2, "traceSpecification"));
                        }
                    }
                }
                if (bl.booleanValue()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Persist is true.  Save the trace specification " + string3 + " into the configuration");
                    }
                    if (((ObjectName[])(object2 = this.getScope(session, "Server", string, string2))).length != 1) {
                        throw new InvalidParameterValueException(abstractAdminCommand.getName(), "serverName", string);
                    }
                    comparable = object2[0];
                    object = ConfigServiceHelper.createObjectName(null, "TraceService");
                    serializable = configService.queryConfigObjects(session, (ObjectName)comparable, (ObjectName)object, null)[0];
                    String string4 = (String)configService.getAttribute(session, (ObjectName)serializable, "startupTraceSpecification");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "current trace string is " + string4);
                    }
                    AttributeList attributeList = new AttributeList();
                    attributeList.add(new Attribute("startupTraceSpecification", string3));
                    configService.setAttributes(session, (ObjectName)serializable, attributeList);
                }
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.configureTraceService", "889");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", exception);
            }
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setTraceSpecification");
            }
        }
    }

    private ObjectName[] getScope(Session session, String string, String string2, String string3) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScope", new Object[]{string, string2, string3});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.equals("Cell")) {
            stringBuffer.append(string);
            if (string2 != null && !string2.equals("")) {
                stringBuffer.append("=");
                stringBuffer.append(string2);
            }
        }
        if (string3 != null && !string3.equals("")) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append("Node");
            stringBuffer.append("=");
            stringBuffer.append(string3);
        }
        if (string != null && !string.equals("Cell")) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(string);
            if (string2 != null && !string2.equals("")) {
                stringBuffer.append("=");
                stringBuffer.append(string2);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeQueryString is " + stringBuffer.toString());
        }
        ObjectName[] objectNameArray = configService.resolve(session, stringBuffer.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScope", objectNameArray);
        }
        return objectNameArray;
    }

    public boolean setJVMMode(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMMode", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = null;
        String string = "JAVA_HOME";
        String string2 = "private_Enable_zWAS_for_64bit";
        String string3 = (String)abstractAdminCommand.getParameter("serverName");
        String string4 = (String)abstractAdminCommand.getParameter("nodeName");
        ManagedObjectMetadataHelper managedObjectMetadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
        if (!managedObjectMetadataHelper.isNodeZOS(string4)) {
            throw new CommandException("This command is only applicable to z/OS servers");
        }
        String string5 = (String)abstractAdminCommand.getParameter("mode");
        boolean bl = true;
        if (string5 != null && !string5.equals(JVM_Mode_31) && !string5.equals(JVM_Mode_64)) {
            throw new InvalidParameterValueException(abstractAdminCommand.getName(), "jvmMode: jvm modes are either \"31bit\" or \"64bit\" ", string5);
        }
        if (string5.equals(JVM_Mode_64)) {
            bl = false;
        }
        try {
            ObjectName[] objectNameArray = this.getScope(session, "Server", string3, string4);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scopeName", string3);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            ObjectName objectName2 = objectNameArray[0];
            AttributeList attributeList = new AttributeList();
            ObjectName[] objectNameArray2 = configService.getRelationship(session, objectName2, "VariableMap");
            if (objectNameArray2 == null || objectNameArray2.length == 0) {
                objectName = configService.createConfigData(session, objectName2, "VariableMap", null, new AttributeList());
            } else {
                objectName = objectNameArray2[0];
                ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "entries", false);
                for (int i = 0; i < arrayList.size(); ++i) {
                    ObjectName objectName3 = (ObjectName)arrayList.get(i);
                    String string6 = (String)configService.getAttribute(session, objectName3, "symbolicName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Existing variable name is " + string6);
                    }
                    if (string6.equals(string)) {
                        if (bl) {
                            configService.deleteConfigData(session, objectName3);
                            continue;
                        }
                        ConfigServiceHelper.setAttributeValue(attributeList, "value", JAVA_HOME);
                        configService.setAttributes(session, objectName3, attributeList);
                        bl2 = true;
                        attributeList.clear();
                        continue;
                    }
                    if (!string6.equals(string2)) continue;
                    if (bl) {
                        ConfigServiceHelper.setAttributeValue(attributeList, "value", "false");
                        configService.setAttributes(session, objectName3, attributeList);
                        attributeList.clear();
                    } else {
                        ConfigServiceHelper.setAttributeValue(attributeList, "value", "true");
                        configService.setAttributes(session, objectName3, attributeList);
                        attributeList.clear();
                    }
                    bl3 = true;
                }
            }
            if (!bl2 && !bl) {
                ConfigServiceHelper.setAttributeValue(attributeList, "symbolicName", string);
                ConfigServiceHelper.setAttributeValue(attributeList, "value", JAVA_HOME);
                configService.createConfigData(session, objectName, "entries", "VariableSubstitutionEntry", attributeList);
                attributeList.clear();
            }
            if (!bl3 && !bl) {
                ConfigServiceHelper.setAttributeValue(attributeList, "symbolicName", string2);
                ConfigServiceHelper.setAttributeValue(attributeList, "value", "true");
                configService.createConfigData(session, objectName, "entries", "VariableSubstitutionEntry", attributeList);
                attributeList.clear();
            }
            this.setJVMModeProperty(abstractAdminCommand, string4, string3, string5);
            if (string5.equals(JVM_Mode_31)) {
                AdminHelperCommandProvider.resetHeapSize(session, configService, objectName2);
            }
            boolean bl4 = true;
            return bl4;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.setJVMMode", "969");
            throw exception;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setJVMMode");
            }
        }
    }

    public void setJVMModeProperty(AbstractAdminCommand abstractAdminCommand, String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJVMModeProperty", new Object[]{string, string, string2, string3});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName[] objectNameArray = this.getScope(session, "Server", string2, string);
        if (objectNameArray.length != 1) {
            throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scopeName", string2);
        }
        String string4 = "was.com.ibm.websphere.zos.jvmmode";
        ObjectName objectName = objectNameArray[0];
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "value", string3);
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray2.length; ++i) {
            String string5 = (String)configService.getAttribute(session, objectNameArray2[i], "processType");
            if (!string5.equalsIgnoreCase("Control")) continue;
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectNameArray2[i], "environment", false);
            for (int j = 0; j < arrayList.size(); ++j) {
                ObjectName objectName3 = (ObjectName)arrayList.get(j);
                String string6 = (String)configService.getAttribute(session, objectName3, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing prop name is " + string6);
                }
                if (string6 == null || !string6.equals(string4)) continue;
                configService.setAttributes(session, objectName3, attributeList);
                bl = true;
            }
            if (bl) continue;
            ConfigServiceHelper.setAttributeValue(attributeList, "name", string4);
            configService.createConfigData(session, objectNameArray2[i], "environment", null, attributeList);
        }
        this.updateServersStartCommandArgs(session, configService, objectNameArray2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJVMModeProperty");
        }
    }

    public String getJVMMode(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJVMMode", abstractAdminCommand);
        }
        String string = JVM_Mode_31;
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("serverName");
        String string3 = (String)abstractAdminCommand.getParameter("nodeName");
        ManagedObjectMetadataHelper managedObjectMetadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
        if (!managedObjectMetadataHelper.isNodeZOS(string3)) {
            throw new CommandException("This command is only applicable to z/OS servers");
        }
        ObjectName[] objectNameArray = this.getScope(session, "Server", string2, string3);
        if (objectNameArray.length != 1) {
            throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scopeName", string2);
        }
        String string4 = "was.com.ibm.websphere.zos.jvmmode";
        ObjectName objectName = objectNameArray[0];
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, objectName2, null);
        block0: for (int i = 0; i < objectNameArray2.length; ++i) {
            String string5 = (String)configService.getAttribute(session, objectNameArray2[i], "processType");
            if (string5 == null || !string5.equalsIgnoreCase("Control")) continue;
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectNameArray2[i], "environment", false);
            for (int j = 0; j < arrayList.size(); ++j) {
                ObjectName objectName3 = (ObjectName)arrayList.get(j);
                String string6 = (String)configService.getAttribute(session, objectName3, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing prop name is " + string6);
                }
                if (string6 == null || !string6.equals(string4)) continue;
                string = (String)configService.getAttribute(session, objectName3, "value");
                continue block0;
            }
        }
        return string;
    }

    private ObjectName getProcessDefWithProcessType(Session session, ConfigService configService, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessDef", new Object[]{objectName, string});
        }
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName4 = objectNameArray[i];
            String string2 = (String)configService.getAttribute(session, objectName4, "processType", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process Definition ProcessType is " + string2);
            }
            if (string != null && !string.equals("") && !string.equals(string2)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process Definition ProcessType found");
            }
            objectName2 = objectName4;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessDef", objectName2);
        }
        if (objectName2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no process type with the type " + string + " found.");
            }
            throw new InvalidParameterValueException("", "processType", string);
        }
        return objectName2;
    }

    public static void resetHeapSize(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        AttributeList attributeList = new AttributeList();
        Integer n = new Integer(256);
        Integer n2 = new Integer(512);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "JavaVirtualMachine");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            ConfigServiceHelper.setAttributeValue(attributeList, "initialHeapSize", n);
            ConfigServiceHelper.setAttributeValue(attributeList, "maximumHeapSize", n2);
            configService.setAttributes(session, objectNameArray[i], attributeList);
        }
    }

    public String getJavaHome(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJavaHome", abstractAdminCommand);
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        String string = "";
        String string2 = "JAVA_HOME";
        String string3 = "WAS_INSTALL_ROOT";
        String string4 = (String)abstractAdminCommand.getParameter("serverName");
        String string5 = (String)abstractAdminCommand.getParameter("nodeName");
        ObjectName[] objectNameArray = null;
        String string6 = (String)abstractAdminCommand.getParameter("mode");
        boolean bl = false;
        if (string6 != null && !string6.equals(JVM_Mode_31) && !string6.equals(JVM_Mode_64)) {
            throw new InvalidParameterValueException(abstractAdminCommand.getName(), "jvmMode: jvm modes are either \"31bit\" or \"64bit\" ", string6);
        }
        if (string6 != null && string6.length() > 0 && string6.equals(JVM_Mode_64)) {
            bl = true;
        }
        try {
            Object object;
            Object object2;
            String string7 = "";
            String string8 = "";
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService != null && (object2 = adminService.getProcessType()) != null && !((String)object2).equalsIgnoreCase("DeploymentManager")) {
                object = (VariableMap)WsServiceRegistry.getService((Object)this, (Class)VariableMap.class);
                string8 = object.expand("${WAS_INSTALL_ROOT}");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "${WAS_INSTALL_ROOT} " + string8);
                }
                if (string8 != null) {
                    string = !bl ? string8 + "/java" : string8 + "/java64";
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getJavaHome", string);
                    }
                    return string;
                }
            }
            if ((objectNameArray = this.getScope(session, "Node", string5, null)).length != 1) {
                throw new InvalidParameterValueException(abstractAdminCommand.getName(), "scopeName", string4);
            }
            object2 = objectNameArray[0];
            object = configService.getRelationship(session, (ObjectName)object2, "VariableMap")[0];
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, (ObjectName)object, "entries", false);
            for (int i = 0; i < arrayList.size(); ++i) {
                ObjectName objectName = (ObjectName)arrayList.get(i);
                String string9 = (String)configService.getAttribute(session, objectName, "symbolicName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "variable name is " + string9);
                }
                if (string9 != null && string9.equals(string2)) {
                    string7 = (String)configService.getAttribute(session, objectName, "value");
                    continue;
                }
                if (string9 == null || !string9.equals(string3)) continue;
                string8 = (String)configService.getAttribute(session, objectName, "value");
            }
            string = !bl ? string8 + "/java" : string8 + "/java64";
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.admintasks.getJavaHome", "969");
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJavaHome", string);
        }
        return string;
    }

    private void updateServersStartCommandArgs(Session session, ConfigService configService, ObjectName[] objectNameArray, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServersStartCommandArgs", new Object[]{objectNameArray});
        }
        String string2 = "";
        StringBuilder stringBuilder = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            int n;
            string2 = (String)((List)configService.getAttribute(session, objectNameArray[i], "startCommandArgs")).get(0);
            if (string.equals(JVM_Mode_31)) {
                stringBuilder = new StringBuilder(string2);
                n = stringBuilder.lastIndexOf(",AMODE=64");
                if (n != -1) {
                    stringBuilder.delete(n, stringBuilder.length());
                }
            } else {
                stringBuilder = new StringBuilder(string2);
                n = stringBuilder.lastIndexOf(",AMODE=64");
                if (n == -1) {
                    stringBuilder.append(",AMODE=64");
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(stringBuilder.toString());
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute("startCommandArgs", arrayList));
            configService.setAttributes(session, objectNameArray[i], attributeList);
        }
    }
}

