/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.node;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ChangeHost
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ChangeHost.class, "Admin", "com.ibm.ws.management.resources.configarchive");
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());
    private Session session = null;
    private ConfigService configService = null;
    private String nodeName = null;
    private String hostName = null;
    private String systemName = null;
    private static String WAS_DAEMON_ONLY_SERVER_CONFIGURED_SYSTEM_NAME = "WAS_DAEMON_ONLY_server_configured_system_name";
    private static String WAS_DAEMON_ONLY_CONTROL_REGION_CONFIGURED_SYSTEM = "WAS_DAEMON_ONLY_control_region_configured_system";
    private static String WAS_DAEMON_DAEMONINSTANCENAME = "WAS_DAEMON_daemonInstanceName";
    private static final String NODE_IPV6_MULTICAST_DISCOVERY_ADDRESS_NEP = "NODE_IPV6_MULTICAST_DISCOVERY_ADDRESS";
    private static final String NODE_MULTICAST_DISCOVERY_ADDRESS_NEP = "NODE_MULTICAST_DISCOVERY_ADDRESS";

    public ChangeHost(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ChangeHost(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ObjectName[] objectNameArray;
            this.session = this.getConfigSession();
            this.configService = ConfigServiceFactory.getConfigService();
            this.nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", this.nodeName);
            }
            this.hostName = (String)this.getParameter("hostName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hostName", this.hostName);
            }
            this.systemName = (String)this.getParameter("systemName");
            if (this.nodeName != null && this.nodeName.length() > 0 && ((objectNameArray = this.configService.resolve(this.session, "Node=" + this.nodeName)) == null || objectNameArray.length == 0)) {
                String string = this.getFormattedMessage("ADMG9218E", new Object[]{this.nodeName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string);
                }
                throw new CommandValidationException(string);
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.node.ChangeHost.validate", "92");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to validate the command", throwable);
            }
            CommandValidationException commandValidationException = new CommandValidationException(throwable, "unexpected exception during validation");
            throw commandValidationException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        ObjectName[] objectNameArray = null;
        try {
            if (this.nodeName != null && this.nodeName.length() > 0) {
                objectNameArray = this.configService.resolve(this.session, "Node=" + this.nodeName);
            } else {
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node");
                objectNameArray = this.configService.queryConfigObjects(this.session, null, objectName, null);
            }
            this.changeHost(objectNameArray);
            if (this.nodeName != null && this.nodeName.length() > 0 && this.systemName != null && this.systemName.length() > 0) {
                this.changeSystemName(objectNameArray, this.systemName);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.node.ChangeHost.beforeStepsExecuted", "134");
            taskCommandResultImpl.setException(new CommandException(throwable, "change host command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = RESOURCE_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    private void changeHost(ObjectName[] objectNameArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeHost", new Object[]{objectNameArray, this.hostName});
        }
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName = this.configService.getRelationship(this.session, objectNameArray[i], "ServerIndex")[0];
            if (objectName != null) {
                attributeList.clear();
                attributeList.add(new Attribute("hostName", this.hostName));
                this.configService.setAttributes(this.session, objectName, attributeList);
            }
            attributeList.clear();
            attributeList.add(new Attribute("host", this.hostName));
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
            ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(this.session, objectName, objectName2, null);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "NamedEndPoint");
            ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, "EndPoint");
            for (int j = 0; j < objectNameArray2.length; ++j) {
                ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(this.session, objectNameArray2[j], objectName3, null);
                for (int k = 0; k < objectNameArray3.length; ++k) {
                    ObjectName[] objectNameArray4;
                    String string;
                    String string2 = (String)this.configService.getAttribute(this.session, objectNameArray3[k], "endPointName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing NamedEndPoint with endPointName " + string2);
                    }
                    if (string2.equals(NODE_IPV6_MULTICAST_DISCOVERY_ADDRESS_NEP) || string2.equals(NODE_MULTICAST_DISCOVERY_ADDRESS_NEP) || (string = (String)this.configService.getAttribute(this.session, (objectNameArray4 = this.configService.queryConfigObjects(this.session, objectNameArray3[k], objectName4, null))[0], "host")).equals("*")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Changing host value from " + string + " to " + this.hostName);
                    }
                    this.configService.setAttributes(this.session, objectNameArray4[0], attributeList);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeHost", new Object[]{objectNameArray});
        }
    }

    private void changeSystemName(ObjectName[] objectNameArray, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeSystemName");
        }
        if (string.length() > 8) {
            String string2 = "The specified systemName " + string + " has more than 8 characters";
            throw new CommandValidationException(string2);
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName2 = this.configService.getRelationship(this.session, objectNameArray[i], "VariableMap")[0];
            ObjectName[] objectNameArray2 = this.configService.getRelationship(this.session, objectNameArray[i], "Server");
            if (objectNameArray2 != null && objectNameArray2.length > 0) {
                this.changeConfiguredSystemName(objectNameArray2, string);
            }
            ObjectName[] objectNameArray3 = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
            for (int j = 0; j < objectNameArray3.length; ++j) {
                String string3 = (String)this.configService.getAttribute(this.session, objectNameArray3[j], "symbolicName");
                if (string3 == null || string3.length() <= 0) continue;
                if (WAS_DAEMON_ONLY_SERVER_CONFIGURED_SYSTEM_NAME.equals(string3)) {
                    attributeList.clear();
                    attributeList.add(new Attribute("value", string));
                    this.configService.setAttributes(this.session, objectNameArray3[j], attributeList);
                    continue;
                }
                if (WAS_DAEMON_ONLY_CONTROL_REGION_CONFIGURED_SYSTEM.equals(string3)) {
                    attributeList.clear();
                    attributeList.add(new Attribute("value", string));
                    this.configService.setAttributes(this.session, objectNameArray3[j], attributeList);
                    continue;
                }
                if (!WAS_DAEMON_DAEMONINSTANCENAME.equals(string3)) continue;
                attributeList.clear();
                attributeList.add(new Attribute("value", string));
                this.configService.setAttributes(this.session, objectNameArray3[j], attributeList);
            }
            if (!tc.isEntryEnabled()) continue;
            Tr.exit(tc, "changeSystemName");
        }
    }

    private void changeConfiguredSystemName(ObjectName[] objectNameArray, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeConfiguredSystemName", new Object[]{objectNameArray, string});
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "ApplicationServer");
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "AdminService");
        ObjectName[] objectNameArray2 = null;
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("value", string));
        block0: for (int i = 0; i < objectNameArray.length; ++i) {
            objectNameArray2 = !ConfigServiceHelper.getDisplayName(objectNameArray[i]).equals("nodeagent") ? this.configService.queryConfigObjects(this.session, objectNameArray[i], objectName, null) : this.configService.queryConfigObjects(this.session, objectNameArray[i], objectName2, null);
            if (objectNameArray2 == null || objectNameArray2.length <= 0) continue;
            ObjectName objectName3 = objectNameArray2[0];
            AttributeList attributeList2 = this.configService.getAttributes(this.session, objectName3, new String[]{"properties"}, false);
            List list = (List)((Attribute)attributeList2.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName4 = (ObjectName)iterator.next();
                String string2 = (String)this.configService.getAttribute(this.session, objectName4, "name");
                if (!string2.equals("was.ConfiguredSystemName")) continue;
                this.configService.setAttributes(this.session, objectName4, attributeList);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeConfiguredSystemName");
        }
    }
}

