/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.node;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.authzgroup.AuthzGroupUtil;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.ContextUtil;
import com.ibm.ws.sm.workspace.ContextUtilFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.TreeIterator;

public class RenameNode
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RenameNode.class, "admin", "com.ibm.ws.management.resources.configservice");
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());
    private Session session = null;
    private ConfigService configService = null;
    private ObjectName newNodeObject = null;
    private String nodeName = null;
    private String newNodeName = null;
    private String shortName = null;
    private ObjectName cell = null;

    public RenameNode(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public RenameNode(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            this.session = this.getConfigSession();
            this.configService = ConfigServiceFactory.getConfigService();
            this.nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", this.nodeName);
            }
            this.newNodeName = (String)this.getParameter("newNodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newNodeName", this.newNodeName);
            }
            this.shortName = (String)this.getParameter("shortName");
            if (this.shortName != null && this.shortName.length() > 0) {
                this.shortName = this.shortName.toUpperCase();
            }
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
            this.cell = this.configService.queryConfigObjects(this.session, null, objectName, null)[0];
            ObjectName[] objectNameArray = this.configService.resolve(this.session, "Node=" + this.nodeName);
            if (objectNameArray == null || objectNameArray.length == 0) {
                String string = this.getFormattedMessage("ADMG9218E", new Object[]{this.nodeName}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string);
                }
                throw new CommandValidationException(string);
            }
            objectNameArray = this.configService.resolve(this.session, "Node=" + this.newNodeName);
            if (objectNameArray != null && objectNameArray.length > 0) {
                String string = "The specified node " + this.newNodeName + " exists in the cell already";
                throw new CommandValidationException(string);
            }
            if (this.shortName != null && this.shortName.length() > 8) {
                String string = "The specified shortName " + this.shortName + " has more than 8 characters";
                throw new CommandValidationException(string);
            }
            if (this.shortName != null && this.shortName.length() > 0) {
                this.validateNodeShortName();
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.node.RenameNode.validate", "114");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to validate the command", throwable);
            }
            CommandValidationException commandValidationException = new CommandValidationException(throwable, "unexpected exception during validation");
            throw commandValidationException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.changeNodeDir();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.node.RenameNode.beforeStepsExecuted", "134");
            taskCommandResultImpl.setException(new CommandException(throwable, "renameNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.newNodeObject = this.configService.resolve(this.session, "Node=" + this.newNodeName)[0];
            this.changeNodeName();
            this.changeNodeDeployment();
            this.changeSecuritySSLConfig();
            this.changeServerSSLConfig();
            this.changeNodeGroupConfig();
            this.changeCoreGroupConfig();
            this.changeClusterConfig();
            this.changeNodeVariables();
            this.changeAuthorizationGroups();
            if (this.shortName != null && this.shortName.length() > 0) {
                this.changeServersStartCommandArgs();
                this.changeNodeShortNameVariables();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.node.RenameNode.afterStepsExecuted", "126");
            taskCommandResultImpl.setException(new CommandException(throwable, "renameNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = RESOURCE_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    private void changeNodeVariables() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeVariables");
        }
        ObjectName objectName = this.configService.getRelationship(this.session, this.newNodeObject, "VariableMap")[0];
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        AttributeList attributeList = new AttributeList();
        String string = "";
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(this.session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2;
            String string3 = (String)this.configService.getAttribute(this.session, objectNameArray[i], "symbolicName");
            if (string3 == null || string3.length() <= 0) continue;
            if (string3.equalsIgnoreCase("WAS_NODE") || string3.equalsIgnoreCase("WAS_SERVER_ONLY_node_name")) {
                attributeList.clear();
                attributeList.add(new Attribute("value", this.newNodeName));
                this.configService.setAttributes(this.session, objectNameArray[i], attributeList);
                continue;
            }
            if (!"WAS_SERVER_ONLY_default_jvm_options".equals(string3) || (string2 = (String)this.configService.getAttribute(this.session, objectNameArray[i], "value")) == null || string2.length() <= 0) continue;
            String[] stringArray = string2.split(this.nodeName);
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray != null && stringArray.length == 2) {
                stringBuffer.append(stringArray[0]);
                stringBuffer.append(this.newNodeName);
                stringBuffer.append(stringArray[1]);
                string = stringBuffer.toString();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newNode ", string);
            }
            attributeList.clear();
            attributeList.add(new Attribute("value", string));
            this.configService.setAttributes(this.session, objectNameArray[i], attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeVariables");
        }
    }

    private void changeNodeShortNameVariables() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeShortVariables");
        }
        ObjectName objectName = this.configService.getRelationship(this.session, this.newNodeObject, "VariableMap")[0];
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        AttributeList attributeList = new AttributeList();
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(this.session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)this.configService.getAttribute(this.session, objectNameArray[i], "symbolicName");
            if (string == null || string.length() <= 0 || !string.equalsIgnoreCase("WAS_SERVER_ONLY_node_short_name")) continue;
            attributeList.clear();
            attributeList.add(new Attribute("value", this.shortName));
            this.configService.setAttributes(this.session, objectNameArray[i], attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeShortVariables");
        }
    }

    private void validateNodeShortName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNodeShortName()", this.shortName);
        }
        ObjectName[] objectNameArray = this.configService.getRelationship(this.session, this.cell, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)this.configService.getAttribute(this.session, objectNameArray[i], "shortName");
            if (string == null || !string.equalsIgnoreCase(this.shortName)) continue;
            String string2 = this.getFormattedMessage("ADMU0182E", new Object[]{this.shortName}, null);
            throw new CommandValidationException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateNodeShortName()");
        }
    }

    private String normalizeSSLConfig(String string, String string2) {
        String string3 = string2 + string.substring(string.indexOf("/"));
        return string3;
    }

    private void changeSecuritySSLConfig() throws Exception {
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeSecuritySSLConfig");
        }
        AttributeList attributeList = new AttributeList();
        String string = "";
        String string2 = "";
        ObjectName objectName = null;
        ObjectName objectName2 = this.configService.getRelationship(this.session, this.cell, "Security")[0];
        objectName = ConfigServiceHelper.createObjectName(null, "SSLConfig");
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
        for (n2 = 0; n2 < objectNameArray.length; ++n2) {
            string2 = (String)this.configService.getAttribute(this.session, objectNameArray[n2], "alias");
            if (string2 == null || string2.length() <= 0 || (n = string2.indexOf("/")) <= 0 || (string = string2.substring(0, n)) == null || !string.equalsIgnoreCase(this.nodeName)) continue;
            attributeList.add(new Attribute("alias", this.normalizeSSLConfig(string2, this.newNodeName)));
            this.configService.setAttributes(this.session, objectNameArray[n2], attributeList);
        }
        attributeList.clear();
        objectName = ConfigServiceHelper.createObjectName(null, "IIOPTransport");
        objectNameArray = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
        for (n2 = 0; n2 < objectNameArray.length; ++n2) {
            string2 = (String)this.configService.getAttribute(this.session, objectNameArray[n2], "sslConfig");
            if (string2 == null || string2.length() <= 0 || (string = string2.substring(0, string2.indexOf("/"))) == null || !string.equalsIgnoreCase(this.nodeName)) continue;
            attributeList.add(new Attribute("sslConfig", this.normalizeSSLConfig(string2, this.newNodeName)));
            this.configService.setAttributes(this.session, objectNameArray[n2], attributeList);
        }
        attributeList.clear();
        String string3 = "";
        objectName = ConfigServiceHelper.createObjectName(null, "ManagementScope");
        objectNameArray = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
        for (n = 0; n < objectNameArray.length; ++n) {
            string3 = (String)this.configService.getAttribute(this.session, objectNameArray[n], "scopeName");
            if (string3 == null || string3.length() <= 0) continue;
            String string4 = string3.replaceAll(this.nodeName, this.newNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scope name", string4);
            }
            attributeList.add(new Attribute("scopeName", string4));
            this.configService.setAttributes(this.session, objectNameArray[n], attributeList);
        }
        attributeList.clear();
        String string5 = "";
        objectName = ConfigServiceHelper.createObjectName(null, "KeyStore");
        objectNameArray = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            string5 = (String)this.configService.getAttribute(this.session, objectNameArray[i], "location");
            if (string3 == null || string5.length() <= 0) continue;
            String string6 = string5.replaceAll(this.nodeName, this.newNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "location", string6);
            }
            attributeList.add(new Attribute("location", string6));
            this.configService.setAttributes(this.session, objectNameArray[i], attributeList);
        }
        attributeList.clear();
        String string7 = "";
        objectName = ConfigServiceHelper.createObjectName(null, "SSLConfigGroup");
        objectNameArray = this.configService.queryConfigObjects(this.session, objectName2, objectName, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            string7 = (String)this.configService.getAttribute(this.session, objectNameArray[i], "name");
            if (string7 == null || string7.length() <= 0) continue;
            String string8 = string7.replaceAll(this.nodeName, this.newNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name", string8);
            }
            attributeList.add(new Attribute("name", string8));
            this.configService.setAttributes(this.session, objectNameArray[i], attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeSecuritySSLConfig");
        }
    }

    private void changeServerSSLConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerSSLConfig");
        }
        ObjectName objectName = null;
        ObjectName[] objectNameArray = this.configService.getRelationship(this.session, this.newNodeObject, "Server");
        ObjectName objectName2 = null;
        ObjectName[] objectNameArray2 = null;
        AttributeList attributeList = new AttributeList();
        String string = null;
        String string2 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            int n;
            objectName = objectNameArray[i];
            objectName2 = ConfigServiceHelper.createObjectName(null, "SOAPConnector");
            objectNameArray2 = this.configService.queryConfigObjects(this.session, objectName, objectName2, null);
            if (objectNameArray2.length > 0) {
                ObjectName objectName3 = objectNameArray2[0];
                List list = (List)this.configService.getAttribute(this.session, objectName3, "properties", false);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName4 = (ObjectName)iterator.next();
                    if (objectName4 == null || !"sslConfig".equals(this.configService.getAttribute(this.session, objectName4, "name")) || (string = (String)this.configService.getAttribute(this.session, objectName4, "value")) == null || string.length() <= 0 || (string2 = string.substring(0, string.indexOf("/"))) == null || !string2.equalsIgnoreCase(this.nodeName)) continue;
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, "value", this.normalizeSSLConfig(string, this.newNodeName));
                    this.configService.setAttributes(this.session, objectName4, attributeList);
                }
            }
            objectName2 = ConfigServiceHelper.createObjectName(null, "SSLInboundChannel");
            objectNameArray2 = this.configService.queryConfigObjects(this.session, objectName, objectName2, null);
            for (n = 0; n < objectNameArray2.length; ++n) {
                string = (String)this.configService.getAttribute(this.session, objectNameArray2[n], "sslConfigAlias");
                if (string == null || string.length() <= 0 || (string2 = string.substring(0, string.indexOf("/"))) == null || !string2.equalsIgnoreCase(this.nodeName)) continue;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, "sslConfigAlias", this.normalizeSSLConfig(string, this.newNodeName));
                this.configService.setAttributes(this.session, objectNameArray2[n], attributeList);
            }
            objectName2 = ConfigServiceHelper.createObjectName(null, "SSLOutboundChannel");
            objectNameArray2 = this.configService.queryConfigObjects(this.session, objectName, objectName2, null);
            for (n = 0; n < objectNameArray2.length; ++n) {
                string = (String)this.configService.getAttribute(this.session, objectNameArray2[n], "sslConfigAlias");
                if (string == null || string.length() <= 0 || (string2 = string.substring(0, string.indexOf("/"))) == null || !string2.equalsIgnoreCase(this.nodeName)) continue;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, "sslConfigAlias", this.normalizeSSLConfig(string, this.newNodeName));
                this.configService.setAttributes(this.session, objectNameArray2[n], attributeList);
            }
            objectName2 = ConfigServiceHelper.createObjectName(null, "HTTPTransport");
            objectNameArray2 = this.configService.queryConfigObjects(this.session, objectName, objectName2, null);
            for (n = 0; n < objectNameArray2.length; ++n) {
                string = (String)this.configService.getAttribute(this.session, objectNameArray2[n], "sslConfig");
                if (string == null || string.length() <= 0 || (string2 = string.substring(0, string.indexOf("/"))) == null || !string2.equalsIgnoreCase(this.nodeName)) continue;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, "sslConfig", this.normalizeSSLConfig(string, this.newNodeName));
                this.configService.setAttributes(this.session, objectNameArray2[n], attributeList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerSSLConfig");
        }
    }

    private void changeNodeDeployment() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeDeployment");
        }
        Session session = this.getConfigSession();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Deployment");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            Deployment deployment = (Deployment)MOFUtil.convertToEObject(session, objectNameArray[i]);
            this.updateDeploymentTarget(deployment);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeDeployment");
        }
    }

    private void updateDeploymentTarget(Deployment deployment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentTarget");
        }
        TreeIterator treeIterator = deployment.eAllContents();
        while (treeIterator.hasNext()) {
            ServerTarget serverTarget;
            Object e2 = treeIterator.next();
            if (!(e2 instanceof ServerTarget) || !(serverTarget = (ServerTarget)e2).getNodeName().equals(this.nodeName)) continue;
            serverTarget.setNodeName(this.newNodeName);
        }
        deployment.eResource().save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateDeploymentTarget");
        }
    }

    private void changeNodeName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeName");
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("name", this.newNodeName));
        if (this.shortName != null && this.shortName.length() > 0) {
            attributeList.add(new Attribute("shortName", this.shortName));
        }
        this.configService.setAttributes(this.session, this.newNodeObject, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeName");
        }
    }

    private void changeNodeDir() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeDir");
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(this.session);
        RepositoryContext repositoryContext = workSpace.findContext("cells/" + ConfigServiceHelper.getDisplayName(this.cell) + "/nodes/" + this.nodeName);
        ContextUtil contextUtil = ContextUtilFactory.getUtil();
        RepositoryContext repositoryContext2 = contextUtil.rename(repositoryContext, this.newNodeName);
        repositoryContext.delete(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeDir");
        }
    }

    private void changeCoreGroupConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeCoreGroupConfig");
        }
        ObjectName objectName = null;
        AttributeList attributeList = new AttributeList();
        ObjectName[] objectNameArray = this.configService.getRelationship(this.session, this.cell, "CoreGroup");
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName = ConfigServiceHelper.createObjectName(null, "CoreGroupServer");
            ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(this.session, objectNameArray[i], objectName, null);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                String string = (String)this.configService.getAttribute(this.session, objectNameArray2[j], "nodeName");
                if (string == null || !string.equals(this.nodeName)) continue;
                attributeList.clear();
                attributeList.add(new Attribute("nodeName", this.newNodeName));
                this.configService.setAttributes(this.session, objectNameArray2[j], attributeList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeCoreGroupConfig");
        }
    }

    private void changeNodeGroupConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeGroupConfig");
        }
        AttributeList attributeList = new AttributeList();
        Object var2_2 = null;
        ObjectName[] objectNameArray = this.configService.getRelationship(this.session, this.cell, "NodeGroup");
        for (int i = 0; i < objectNameArray.length; ++i) {
            AttributeList attributeList2 = this.configService.getAttributes(this.session, objectNameArray[i], new String[]{"members"}, false);
            List list = (List)((Attribute)attributeList2.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                String string = (String)this.configService.getAttribute(this.session, objectName, "nodeName");
                if (string == null || !string.equals(this.nodeName)) continue;
                attributeList.clear();
                attributeList.add(new Attribute("nodeName", this.newNodeName));
                this.configService.setAttributes(this.session, objectName, attributeList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeGroupConfig");
        }
    }

    private void changeClusterConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeClusterConfig");
        }
        AttributeList attributeList = new AttributeList();
        Object var2_2 = null;
        ObjectName[] objectNameArray = this.configService.getRelationship(this.session, this.cell, "ServerCluster");
        for (int i = 0; i < objectNameArray.length; ++i) {
            AttributeList attributeList2 = this.configService.getAttributes(this.session, objectNameArray[i], new String[]{"members"}, false);
            List list = (List)((Attribute)attributeList2.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                String string = (String)this.configService.getAttribute(this.session, objectName, "nodeName");
                if (string == null || !string.equals(this.nodeName)) continue;
                attributeList.clear();
                attributeList.add(new Attribute("nodeName", this.newNodeName));
                this.configService.setAttributes(this.session, objectName, attributeList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeClusterConfig");
        }
    }

    private void changeServersStartCommandArgs() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServersStartCommandArgs");
        }
        ObjectName[] objectNameArray = this.configService.getRelationship(this.session, this.newNodeObject, "Server");
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        String string = this.getCellShortName();
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)this.configService.getAttribute(this.session, objectNameArray[i], "name");
            String string3 = (String)this.configService.getAttribute(this.session, objectNameArray[i], "shortName");
            ObjectName[] objectNameArray2 = this.configService.queryConfigObjects(this.session, objectNameArray[i], objectName, null);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                Object object;
                ArrayList<Object> arrayList;
                Object object2;
                String string4 = (String)this.configService.getAttribute(this.session, objectNameArray2[j], "processType");
                if (string4 == null || string4.length() <= 0) continue;
                if (string4.equalsIgnoreCase("Control")) {
                    object2 = (List)this.configService.getAttribute(this.session, objectNameArray2[j], "startCommandArgs");
                    if (object2 == null || object2.size() <= 0) continue;
                    arrayList = (String)object2.get(0);
                    object = ((String)((Object)arrayList)).substring("JOBNAME=".length(), ((String)((Object)arrayList)).indexOf(","));
                    String string5 = "JOBNAME=" + (String)object + ",ENV=" + string + "." + this.shortName + "." + string3;
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(string5);
                    AttributeList attributeList = new AttributeList();
                    attributeList.add(new Attribute("startCommandArgs", arrayList2));
                    this.configService.setAttributes(this.session, objectNameArray2[j], attributeList);
                    continue;
                }
                if (string4.equalsIgnoreCase("Servant")) {
                    object2 = "JOBNAME=&IWMSSNM.S,ENV='" + string + "." + this.shortName + "." + "&IWMSSNM." + "'";
                    arrayList = new ArrayList();
                    arrayList.add(object2);
                    object = new AttributeList();
                    ((AttributeList)object).add(new Attribute("startCommandArgs", arrayList));
                    this.configService.setAttributes(this.session, objectNameArray2[j], (AttributeList)object);
                    continue;
                }
                if (!string4.equalsIgnoreCase("Adjunct")) continue;
                object2 = "JOBNAME=&IWMSSNM.A,ENV='" + string + "." + this.shortName + "." + "&IWMSSNM." + "'";
                arrayList = new ArrayList<Object>();
                arrayList.add(object2);
                object = new AttributeList();
                ((AttributeList)object).add(new Attribute("startCommandArgs", arrayList));
                this.configService.setAttributes(this.session, objectNameArray2[j], (AttributeList)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServersStartCommandArgs");
        }
    }

    private String getCellShortName() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellShortName()");
        }
        String string = (String)this.configService.getAttribute(this.session, this.cell, "shortName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellShortNames()", string);
        }
        return string;
    }

    private void changeAuthorizationGroups() throws Exception {
        final ConfigService configService = this.configService;
        final Session session = this.session;
        final String string = this.nodeName;
        final String string2 = this.newNodeName;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthzGroupUtil.changeNodeName(configService, session, string, string2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new Exception(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw exception;
        }
    }
}

