/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.nodegroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.ws.management.commands.nodegroup.NodeGroupConfigException;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class NodeGroupHelper {
    private static TraceComponent tc = Tr.register(NodeGroupHelper.class, "management", "com.ibm.ws.management.resources.configservice");
    private static ResourceBundle RESOURCE_BUNDLE = null;
    private static Locale _locale = null;
    private static int NODEGROUP_NOT_JOIN = 0;
    private static int NODEGROUP_JOIN = 1;
    private static int NODEGROUP_CONVERT_JOIN = 2;

    private NodeGroupHelper() throws AdminException {
    }

    public static void setLocale(Locale locale) {
        _locale = locale;
    }

    public static Locale getLocale() {
        if (_locale == null) {
            return Locale.getDefault();
        }
        return _locale;
    }

    public static String[] getNodeGroupMembers(Session session, ConfigService configService, String string) throws ConfigServiceException {
        Object[] objectArray;
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            objectArray = configService.resolve(session, "NodeGroup=" + string);
            if (objectArray == null || objectArray.length == 0) {
                String string2 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2);
                }
                throw new NodeGroupConfigException(string2);
            }
            ObjectName objectName = objectArray[0];
            AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"members"}, false);
            List list = (List)((Attribute)attributeList.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                String string3 = (String)configService.getAttribute(session, objectName2, "nodeName");
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.configservice", "ADMG0011E", new Object[]{exception}, null));
        }
        objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private static String[] getGroupMemberShip(Session session, ConfigService configService, String string, ObjectName objectName) throws ConfigServiceException {
        String[] stringArray;
        if (objectName == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = ConfigServiceHelper.getDisplayName(objectName);
        try {
            if (objectName != null && (stringArray = configService.getRelationship(session, objectName, "parent")[0]) != null) {
                ObjectName[] objectNameArray = configService.getRelationship(session, (ObjectName)stringArray, "NodeGroup");
                for (int i = 0; i < objectNameArray.length; ++i) {
                    AttributeList attributeList = configService.getAttributes(session, objectNameArray[i], new String[]{"members"}, false);
                    List list = (List)((Attribute)attributeList.get(0)).getValue();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string3;
                        ObjectName objectName2 = (ObjectName)iterator.next();
                        String string4 = (String)configService.getAttribute(session, objectName2, "nodeName");
                        if (!string4.equals(string2) || (string3 = (String)configService.getAttribute(session, objectNameArray[i], "name")).equals(string)) continue;
                        arrayList.add(string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.configservice", "ADMG0011E", new Object[]{exception}, null));
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] getServerClusterMemberShip(Session session, ConfigService configService, String string, ObjectName objectName) throws ConfigServiceException {
        String[] stringArray;
        if (objectName == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            stringArray = ConfigServiceHelper.getDisplayName(objectName);
            ObjectName objectName2 = configService.getRelationship(session, objectName, "parent")[0];
            if (objectName2 != null) {
                ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "ServerCluster");
                for (int i = 0; i < objectNameArray.length; ++i) {
                    AttributeList attributeList = configService.getAttributes(session, objectNameArray[i], new String[]{"nodeGroupName"}, false);
                    String string2 = (String)((Attribute)attributeList.get(0)).getValue();
                    AttributeList attributeList2 = configService.getAttributes(session, objectNameArray[i], new String[]{"members"}, false);
                    List list = (List)((Attribute)attributeList2.get(0)).getValue();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ObjectName objectName3 = (ObjectName)iterator.next();
                        String string3 = (String)configService.getAttribute(session, objectName3, "nodeName");
                        if (!string3.equals(stringArray) || !string2.equals(string)) continue;
                        String string4 = (String)configService.getAttribute(session, objectNameArray[i], "name");
                        arrayList.add(string4);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.configservice", "ADMG0011E", new Object[]{exception}, null));
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static ObjectName removeNodeGroupMember(Session session, ConfigService configService, String string, String string2) throws ConfigServiceException, ConnectorException, NodeGroupConfigException, AdminException {
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodeGroupMember", new Object[]{session, string, string2});
        }
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string2);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string3 = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{string2}, null);
            throw new NodeGroupConfigException(string3);
        }
        objectName = objectNameArray[0];
        ObjectName[] objectNameArray2 = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray2 == null || objectNameArray2.length == 0) {
            String string4 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string4);
            }
            throw new NodeGroupConfigException(string4);
        }
        objectName2 = objectNameArray2[0];
        String[] stringArray2 = NodeGroupHelper.getServerClusterMemberShip(session, configService, string, objectName);
        if (stringArray2.length > 0) {
            boolean bl = true;
            for (int i = 0; i < stringArray2.length && (bl &= NodeGroupHelper.isXDDynamicCluster(session, stringArray2[i])); ++i) {
            }
            if (!bl) {
                String string5 = NodeGroupHelper.getFormattedMessage("ADMG0451E", new Object[]{string2, string}, null);
                throw new NodeGroupConfigException(string5);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All the clusters are dynamic clusters");
            }
        }
        if ((stringArray = NodeGroupHelper.getGroupMemberShip(session, configService, string, objectName)).length > 0) {
            AttributeList attributeList = configService.getAttributes(session, objectName2, new String[]{"members"}, false);
            List list = (List)((Attribute)attributeList.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string6;
                objectName3 = (ObjectName)iterator.next();
                if (objectName3 == null || !(string6 = (String)configService.getAttribute(session, objectName3, "nodeName")).equals(string2)) continue;
                if (NodeGroupHelper.isSysplexNodeGroup(session, configService, string)) {
                    String string7 = NodeGroupHelper.getFormattedMessage("ADMG0459E", new Object[]{string2, string}, null);
                    throw new NodeGroupConfigException(string7);
                }
                configService.deleteConfigData(session, objectName3);
                break;
            }
        } else {
            String string8 = NodeGroupHelper.getFormattedMessage("ADMG0452E", new Object[]{string2, string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string8);
            }
            throw new NodeGroupConfigException(string8);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodeGroupMember", objectName3);
        }
        return objectName3;
    }

    public static ObjectName addNodeGroupMember(Session session, ConfigService configService, String string, String string2) throws ConfigServiceException, ConnectorException, AdminException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNodeGroupMember", new Object[]{session, string, string2});
        }
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        ManagedObjectMetadataHelper managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session);
        boolean bl = NodeGroupHelper.isSysplexNodeGroup(session, configService, string);
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("nodeName", string2));
        ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string2);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string3 = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{string2}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3);
            }
            throw new NodeGroupConfigException(string3);
        }
        objectName3 = objectNameArray[0];
        if (!NodeGroupHelper.isManagedNode(session, configService, objectName3)) {
            String string4 = NodeGroupHelper.getFormattedMessage("ADMG0492E", new Object[]{string2}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string4);
            }
            throw new NodeGroupConfigException(string4);
        }
        ObjectName[] objectNameArray2 = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray2 == null || objectNameArray2.length == 0) {
            String string5 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string5);
            }
            throw new NodeGroupConfigException(string5);
        }
        objectName = objectNameArray2[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, "NodeGroupMember");
        ObjectName[] objectNameArray3 = configService.queryConfigObjects(session, objectName, objectName4, null);
        if (objectNameArray3.length == 0) {
            if (!managedObjectMetadataHelper.isNodeZOS(string2) && bl) {
                String string6 = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{string2, string}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string6);
                }
                throw new NodeGroupConfigException(string6);
            }
            objectName2 = configService.createConfigData(session, objectName, "members", "NodeGroupMember", attributeList);
        } else {
            for (int i = 0; i < objectNameArray3.length; ++i) {
                String string7 = (String)configService.getAttribute(session, objectNameArray3[i], "nodeName");
                if (i == 0) {
                    NodeGroupHelper.validate(session, configService, string7, string2, string, managedObjectMetadataHelper);
                }
                if (string7 == null || !string7.equals(string2)) continue;
                String string8 = NodeGroupHelper.getFormattedMessage("ADMG0454E", new Object[]{string2, string}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string8);
                }
                throw new NodeGroupConfigException(string8);
            }
            objectName2 = configService.createConfigData(session, objectName, "members", "NodeGroupMember", attributeList);
        }
        if (!bl) {
            NodeGroupHelper.addToSysplexNodeGroupIfNeeded(session, configService, string, string2, managedObjectMetadataHelper);
        } else {
            NodeGroupHelper.modifyNodeProperty(session, configService, string2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNodeGroupMember", new Object[]{objectName2});
        }
        return objectName2;
    }

    private static void addToSysplexNodeGroupIfNeeded(Session session, ConfigService configService, String string, String string2, ManagedObjectMetadataHelper managedObjectMetadataHelper) throws ConfigServiceException, ConnectorException, NodeGroupConfigException, AdminException {
        Properties properties;
        String string3;
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSysplexNodeGroupIfNeeded", new Object[]{string2});
        }
        ObjectName objectName = null;
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("nodeName", string2));
        boolean bl = false;
        if (managedObjectMetadataHelper.isNodeZOS(string2) && (string4 = NodeGroupHelper.getNodeGroupFromSysplexName(session, configService, string3 = ((String)(properties = managedObjectMetadataHelper.getAccessor().getMetadataProperties(string2)).get("com.ibm.websphere.nodeSysplexName")).trim())) != null) {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "NodeGroupMember");
            ObjectName objectName3 = configService.resolve(session, "NodeGroup=" + string4)[0];
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName3, objectName2, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string5 = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
                if (string5 == null || !string5.equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                objectName = configService.createConfigData(session, objectName3, "members", "NodeGroupMember", attributeList);
                NodeGroupHelper.modifyNodeProperty(session, configService, string2, string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSysplexNodeGroupIfNeeded", objectName);
        }
    }

    public static ObjectName removeNodeGroup(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodeGroup", new Object[]{session, string});
        }
        if (string.equalsIgnoreCase("DefaultNodeGroup")) {
            String string2 = NodeGroupHelper.getFormattedMessage("ADMG0457E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2);
            }
            throw new NodeGroupConfigException(string2);
        }
        ObjectName objectName = null;
        ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string3 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            throw new NodeGroupConfigException(string3);
        }
        objectName = objectNameArray[0];
        List list = (List)configService.getAttribute(session, objectName, "members");
        if (list.size() != 0) {
            String string4 = NodeGroupHelper.getFormattedMessage("ADMG0456E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string4);
            }
            throw new NodeGroupConfigException(string4);
        }
        configService.deleteConfigData(session, objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodeGroup", objectName);
        }
        return objectName;
    }

    public static ObjectName createNodeGroup(Session session, ConfigService configService, String string, String string2, String string3) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeGroup", new Object[]{session, string, string2, string3});
        }
        ObjectName objectName = null;
        if (string != null && string.length() > 0) {
            String[] stringArray = NodeGroupHelper.listNodeGroups(session, configService);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                String string4 = NodeGroupHelper.getFormattedMessage("ADMG0493E", new Object[]{string}, null);
                throw new NodeGroupConfigException(string4);
            }
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName objectName3 = configService.queryConfigObjects(session, null, objectName2, null)[0];
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute("name", string));
            attributeList.add(new Attribute("shortName", string2));
            attributeList.add(new Attribute("description", string3));
            objectName = configService.createConfigData(session, objectName3, "NodeGroup", null, attributeList);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createNodeGroup", new Object[]{objectName});
            }
        }
        return objectName;
    }

    public static ObjectName modifyNodeGroup(Session session, ConfigService configService, String string, String string2, String string3) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyNodeGroup", new Object[]{session, string, string2, string3});
        }
        ObjectName objectName = null;
        if (string != null && string.length() > 0) {
            ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
            if (objectNameArray == null || objectNameArray.length == 0) {
                String string4 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4);
                }
                throw new NodeGroupConfigException(string4);
            }
            objectName = objectNameArray[0];
            AttributeList attributeList = new AttributeList();
            if (string2 != null) {
                attributeList.add(new Attribute("shortName", string2));
            }
            if (string3 != null) {
                attributeList.add(new Attribute("description", string3));
            }
            configService.setAttributes(session, objectName, attributeList);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "modifyNodeGroup", new Object[]{objectName});
            }
        }
        return objectName;
    }

    public static String[] listNodeGroups(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNodeGroups");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "NodeGroup");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "name");
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNodeGroups", stringArray);
        }
        return stringArray;
    }

    public static String[] listNodeGroups(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNodeGroups", string);
        }
        if (string == null || string.length() == 0) {
            return NodeGroupHelper.listNodeGroups(session, configService);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "NodeGroup");
        for (int i = 0; i < objectNameArray.length; ++i) {
            AttributeList attributeList = configService.getAttributes(session, objectNameArray[i], new String[]{"members"}, false);
            List list = (List)((Attribute)attributeList.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName3 = (ObjectName)iterator.next();
                String string2 = (String)configService.getAttribute(session, objectName3, "nodeName");
                if (!string2.equals(string)) continue;
                String string3 = (String)configService.getAttribute(session, objectNameArray[i], "name");
                arrayList.add(string3);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNodeGroups", stringArray);
        }
        return stringArray;
    }

    public static String[] listNodes(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNodes", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            return NodeGroupHelper.getNodeGroupMembers(session, configService, string);
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "name");
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNodes", stringArray);
        }
        return stringArray;
    }

    public static ObjectName createNodeGroupProperty(Session session, ConfigService configService, String string, String string2, String string3, String string4, Boolean bl, String string5) throws NodeGroupConfigException, ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeGroupProperty", new Object[]{string, string2, string3, string4, bl, string5});
        }
        ObjectName objectName = null;
        ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string6 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string6);
            }
            throw new NodeGroupConfigException(string6);
        }
        ObjectName objectName2 = objectNameArray[0];
        if (!NodeGroupHelper.validateNodeGroupProperty(session, configService, objectName2, string2)) {
            String string7 = NodeGroupHelper.getFormattedMessage("ADMG0458E", new Object[]{string2, string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string7);
            }
            throw new NodeGroupConfigException(string7);
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("name", string2));
        attributeList.add(new Attribute("value", string3));
        attributeList.add(new Attribute("description", string4));
        attributeList.add(new Attribute("required", bl));
        attributeList.add(new Attribute("validationExpression", string5));
        objectName = configService.createConfigData(session, objectName2, "properties", null, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeGroupProperty", objectName);
        }
        return objectName;
    }

    public static ObjectName modifyNodeGroupProperty(Session session, ConfigService configService, String string, String string2, String string3, String string4, Boolean bl, String string5) throws ConfigServiceException, NodeGroupConfigException, ConnectorException, AdminException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyNodeGroupProperty", new Object[]{string, string2, string3, string4, bl, string5});
        }
        if ((objectNameArray = configService.resolve(session, "NodeGroup=" + string)) == null || objectNameArray.length == 0) {
            String string6 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string6);
            }
            throw new NodeGroupConfigException(string6);
        }
        ObjectName objectName = objectNameArray[0];
        ObjectName objectName2 = null;
        AttributeList attributeList = new AttributeList();
        AttributeList attributeList2 = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList2.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            objectName2 = (ObjectName)iterator.next();
            String string7 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string7.equals(string2)) continue;
            attributeList.add(new Attribute("name", string2));
            if (string3 != null) {
                attributeList.add(new Attribute("value", string3));
            }
            if (string4 != null) {
                attributeList.add(new Attribute("description", string4));
            }
            if (bl != null && bl.booleanValue()) {
                attributeList.add(new Attribute("required", bl));
            } else {
                attributeList.add(new Attribute("required", new Boolean(false)));
            }
            if (string5 != null) {
                attributeList.add(new Attribute("validationExpression", string5));
            }
            configService.setAttributes(session, objectName2, attributeList);
            if (NodeGroupHelper.isSysplexNodeGroup(session, configService, string)) {
                NodeGroupHelper.modifyMatchingCellLevelVar(session, configService, objectName, string2, string3);
                NodeGroupHelper.modifyMatchingNode5LevelVar(session, configService, objectName, string2, string3);
            }
            return objectName2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyNodeGroupProperty");
        }
        return null;
    }

    public static ObjectName removeNodeGroupProperty(Session session, ConfigService configService, String string, String string2) throws ConfigServiceException, NodeGroupConfigException, ConnectorException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodeGroupProperty", new Object[]{string, string2});
        }
        if ((objectNameArray = configService.resolve(session, "NodeGroup=" + string)) == null || objectNameArray.length == 0) {
            String string3 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3);
            }
            throw new NodeGroupConfigException(string3);
        }
        ObjectName objectName = objectNameArray[0];
        ObjectName objectName2 = null;
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            objectName2 = (ObjectName)iterator.next();
            String string4 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string4.equals(string2)) continue;
            configService.deleteConfigData(session, objectName2);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodeGroupProperty", objectName2);
        }
        return objectName2;
    }

    public static boolean isNodeInNodeGroup(Session session, ConfigService configService, String string, String string2) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
            ObjectName objectName = null;
            ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string2);
            if (objectNameArray == null || objectNameArray.length <= 0) {
                String string3 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string2}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
                throw new NodeGroupConfigException(string3);
            }
            objectName = objectNameArray[0];
            AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"members"}, false);
            List list = (List)((Attribute)attributeList.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                String string4 = (String)configService.getAttribute(session, objectName2, "nodeName");
                if (!string.equals(string4)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", NodeGroupHelper.getLocale());
            String string3 = RESOURCE_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    private static boolean validateNodeGroupProperty(Session session, ConfigService configService, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNodeGroupProperty", new Object[]{objectName, string});
        }
        AttributeList attributeList = new AttributeList();
        AttributeList attributeList2 = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList2.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string2 = (String)configService.getAttribute(session, objectName2, "name");
            if (string == null || !string2.equals(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSysplexNodeGroup(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSysplexNodeGroup", new Object[]{string});
        }
        boolean bl = false;
        ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string2 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2);
            }
            throw new NodeGroupConfigException(string2);
        }
        ObjectName objectName = objectNameArray[0];
        AttributeList attributeList = new AttributeList();
        AttributeList attributeList2 = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList2.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string3 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string3.equals("was.sysplexName")) continue;
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isSysplexNodeGroup", new Boolean(bl));
        }
        return bl;
    }

    public static String getNodeGroupFromSysplexName(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroupFromSysplexName", string);
        }
        String string2 = null;
        boolean bl = false;
        if (string != null && string.length() > 0) {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
            ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "NodeGroup");
            for (int i = 0; i < objectNameArray.length; ++i) {
                AttributeList attributeList = configService.getAttributes(session, objectNameArray[i], new String[]{"properties"}, false);
                List list = (List)((Attribute)attributeList.get(0)).getValue();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName3 = (ObjectName)iterator.next();
                    String string3 = (String)configService.getAttribute(session, objectName3, "name");
                    if (!string3.equals("was.sysplexName")) continue;
                    String string4 = (String)configService.getAttribute(session, objectName3, "value");
                    string4 = string4.trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "plex", string4);
                    }
                    if (!string4.equals(string.trim())) continue;
                    string2 = (String)configService.getAttribute(session, objectNameArray[i], "name");
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroupFromSysplexName", string2);
        }
        return string2;
    }

    public static String getSysplexName(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSysplexName", new Object[]{string});
        }
        String string2 = null;
        ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string3 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3);
            }
            throw new NodeGroupConfigException(string3);
        }
        ObjectName objectName = objectNameArray[0];
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string4 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string4.equals("was.sysplexName")) continue;
            string2 = (String)configService.getAttribute(session, objectName2, "value");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSysplexName", string2);
        }
        return string2;
    }

    public static Properties getSysplexNodeGroupProperties(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSysplexNodeGroupProperties", new Object[]{string});
        }
        Properties properties = new Properties();
        ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string2 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2);
            }
            throw new NodeGroupConfigException(string2);
        }
        ObjectName objectName = objectNameArray[0];
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string3 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string3.startsWith("was.")) continue;
            String string4 = (String)configService.getAttribute(session, objectName2, "value");
            properties.put(string3, string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSysplexNodeGroupProperties", properties);
        }
        return properties;
    }

    public static String[] listNodeGroupProperties(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listNodeGroupProperties", new Object[]{string});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string2 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2);
            }
            throw new NodeGroupConfigException(string2);
        }
        ObjectName objectName = objectNameArray[0];
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        String[] stringArray = list.iterator();
        while (stringArray.hasNext()) {
            ObjectName objectName2 = (ObjectName)stringArray.next();
            String string3 = (String)configService.getAttribute(session, objectName2, "name");
            String string4 = (String)configService.getAttribute(session, objectName2, "value");
            arrayList.add(string3 + "=" + string4);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listNodeGroupProperties", stringArray);
        }
        return stringArray;
    }

    public static String getSysplexNodeGroup(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSysplexNodeGroup", new Object[]{string});
        }
        String string2 = null;
        ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string3 = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3);
            }
            throw new NodeGroupConfigException(string3);
        }
        ObjectName objectName = objectNameArray[0];
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string4 = (String)configService.getAttribute(session, objectName2, "name");
            if (!(string4 != null & string4.length() > 0) || !string4.equals("was.sysplexNodeGroup")) continue;
            string2 = (String)configService.getAttribute(session, objectName2, "value");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSysplexNodeGroup", string2);
        }
        return string2;
    }

    private static ObjectName createNodeProperty(Session session, ConfigService configService, ObjectName objectName, String string, String string2) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeProperty", new Object[]{objectName});
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("name", string));
        attributeList.add(new Attribute("value", string2));
        ObjectName objectName2 = configService.createConfigData(session, objectName, "properties", null, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeProperty", new Object[]{objectName2});
        }
        return objectName2;
    }

    private static void modifyNodeProperty(Session session, ConfigService configService, String string, String string2) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyNodeProperty", new Object[]{string});
        }
        if ((objectNameArray = configService.resolve(session, "Node=" + string)) == null || objectNameArray.length == 0) {
            String string3 = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3);
            }
            throw new NodeGroupConfigException(string3);
        }
        ObjectName objectName = objectNameArray[0];
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string4 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string4.equals("was.sysplexNodeGroup")) continue;
            AttributeList attributeList2 = new AttributeList();
            attributeList2.add(new Attribute("value", string2));
            configService.setAttributes(session, objectName2, attributeList2);
        }
    }

    public static ObjectName createSysplexNodeGroup(Session session, ConfigService configService, String string, String string2, String string3, Map map) throws ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSysplexNodeGroup", new Object[]{session, string, string2, string3, map});
        }
        ObjectName objectName = null;
        if (string != null && string.length() > 0) {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName objectName3 = configService.queryConfigObjects(session, null, objectName2, null)[0];
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute("name", string));
            attributeList.add(new Attribute("shortName", string2));
            attributeList.add(new Attribute("description", string3));
            NodeGroupHelper.validateNodeGroupShortName(session, configService, string2);
            objectName = configService.createConfigData(session, objectName3, "NodeGroup", null, attributeList);
            if (objectName != null) {
                AttributeList attributeList2 = new AttributeList();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string4 = (String)entry.getKey();
                    String string5 = (String)entry.getValue();
                    attributeList2.add(new Attribute("name", string4));
                    attributeList2.add(new Attribute("value", string5));
                    ObjectName objectName4 = configService.createConfigData(session, objectName, "properties", null, attributeList2);
                    attributeList2.clear();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSysplexNodeGroup", new Object[]{objectName});
            }
        }
        return objectName;
    }

    public static String getCellName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        String string = null;
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        string = ConfigServiceHelper.getDisplayName(objectName2);
        return string;
    }

    private static String getFirstNodeGroupMember(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException {
        String string2 = null;
        ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string3 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3);
            }
            throw new NodeGroupConfigException(string3);
        }
        ObjectName objectName = objectNameArray[0];
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"members"}, false);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            string2 = (String)configService.getAttribute(session, objectName2, "nodeName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFirstNodeGroupMember", string2);
        }
        return string2;
    }

    public static boolean hasZosNode(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, AdminException {
        ManagedObjectMetadataHelper managedObjectMetadataHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasZosNode", string);
        }
        boolean bl = false;
        String string2 = NodeGroupHelper.getFirstNodeGroupMember(session, configService, string);
        if (string2 != null && string2.length() > 0 && (managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session)).isNodeZOS(string2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasZosNode", new Boolean(bl));
        }
        return bl;
    }

    public static boolean hasDistributedNode(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, AdminException {
        ManagedObjectMetadataHelper managedObjectMetadataHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasDistributedNode", string);
        }
        boolean bl = false;
        String string2 = NodeGroupHelper.getFirstNodeGroupMember(session, configService, string);
        if (string2 != null && string2.length() > 0 && !(managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session)).isNodeZOS(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isNodeZOS: true");
            }
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasDistributedNode", new Boolean(bl));
        }
        return bl;
    }

    public static List listCandidateNodes(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCandidateNodes");
        }
        ManagedObjectMetadataHelper managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session);
        if (NodeGroupHelper.hasDistributedNode(session, configService, string)) {
            return NodeGroupHelper.listDistributedNodes(session, configService, managedObjectMetadataHelper);
        }
        if (NodeGroupHelper.hasZosNode(session, configService, string)) {
            return NodeGroupHelper.listZosNodes(session, configService, string, managedObjectMetadataHelper);
        }
        return NodeGroupHelper.getAllManagedNodes(session, configService);
    }

    public static List getAllNodes(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException, AdminException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            Node node = (Node)MOFUtil.convertToEObject(session, objectNameArray[i]);
            arrayList.add(node);
        }
        return arrayList;
    }

    private static List listDistributedNodes(Session session, ConfigService configService, ManagedObjectMetadataHelper managedObjectMetadataHelper) throws ConfigServiceException, ConnectorException, AdminException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "name");
            if (managedObjectMetadataHelper.isNodeZOS(string)) continue;
            Node node = (Node)MOFUtil.convertToEObject(session, objectNameArray[i]);
            arrayList.add(node);
        }
        return arrayList;
    }

    private static List listZosNodes(Session session, ConfigService configService, String string, ManagedObjectMetadataHelper managedObjectMetadataHelper) throws ConfigServiceException, ConnectorException, AdminException {
        Properties properties;
        String string2;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        String string3 = NodeGroupHelper.getFirstNodeGroupMember(session, configService, string);
        if (string3 != null && string3.length() > 0 && (string2 = (String)(properties = managedObjectMetadataHelper.getAccessor().getMetadataProperties(string3)).get("com.ibm.websphere.nodeSysplexName")) != null && string2.length() > 0) {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
            ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "Node");
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string4;
                String string5 = (String)configService.getAttribute(session, objectNameArray[i], "name");
                if (!managedObjectMetadataHelper.isNodeZOS(string5) || (string4 = (String)(properties = managedObjectMetadataHelper.getAccessor().getMetadataProperties(string5)).get("com.ibm.websphere.nodeSysplexName")) == null || string4.length() <= 0 || !string4.equals(string2) || string3.equals(string5)) continue;
                Node node = (Node)MOFUtil.convertToEObject(session, objectNameArray[i]);
                arrayList.add(node);
            }
        }
        return arrayList;
    }

    private static void validate(Session session, ConfigService configService, String string, String string2, String string3, ManagedObjectMetadataHelper managedObjectMetadataHelper) throws AdminException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{string, string2, string3});
        }
        if (!managedObjectMetadataHelper.isNodeZOS(string) && !managedObjectMetadataHelper.isNodeZOS(string2)) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Not z/OS nodes ", new Object[]{string, string2});
            }
            if (NodeGroupHelper.isSysplexNodeGroup(session, configService, string3)) {
                String string4 = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{string2, string3}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4);
                }
                throw new NodeGroupConfigException(string4);
            }
        } else if (managedObjectMetadataHelper.isNodeZOS(string) && managedObjectMetadataHelper.isNodeZOS(string2)) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "z/OS nodes ", new Object[]{string, string2});
            }
            if (NodeGroupHelper.isSysplexNodeGroup(session, configService, string3) && managedObjectMetadataHelper.compareNodeVersion(string2, "5") == 0) {
                String string5 = NodeGroupHelper.getFormattedMessage("ADMG0490E", new Object[]{string2, string3}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string5);
                }
                throw new NodeGroupConfigException(string5);
            }
            Properties properties = managedObjectMetadataHelper.getAccessor().getMetadataProperties(string);
            String string6 = ((String)properties.get("com.ibm.websphere.nodeSysplexName")).trim();
            Properties properties2 = managedObjectMetadataHelper.getAccessor().getMetadataProperties(string2);
            String string7 = ((String)properties2.get("com.ibm.websphere.nodeSysplexName")).trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "plex1,plex2", new Object[]{string6, string7});
            }
            if (string6 == null || string7 == null || !string6.equals(string7)) {
                String string8 = NodeGroupHelper.getFormattedMessage("ADMG0421E", new Object[]{string2, string3}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string8);
                }
                throw new NodeGroupConfigException(string8);
            }
        } else {
            if (managedObjectMetadataHelper.isNodeZOS(string) && !managedObjectMetadataHelper.isNodeZOS(string2)) {
                String string9 = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{string2, string3}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string9);
                }
                throw new NodeGroupConfigException(string9);
            }
            if (!managedObjectMetadataHelper.isNodeZOS(string) && managedObjectMetadataHelper.isNodeZOS(string2)) {
                String string10 = NodeGroupHelper.getFormattedMessage("ADMG0420E", new Object[]{string2, string3}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string10);
                }
                throw new NodeGroupConfigException(string10);
            }
        }
    }

    public static int canNodeJoinNodeGroup(Session session, ConfigService configService, String string, String string2, String string3, String string4, String string5) throws AdminException, ConnectorException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canNodeJoinNodeGroup", new Object[]{string, string2, string4, string5});
        }
        ManagedObjectMetadataHelper managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session);
        String string6 = NodeGroupHelper.getFirstNodeGroupMember(session, configService, string5);
        if (string6 != null && string6.length() > 0) {
            String string7 = managedObjectMetadataHelper.getNodePlatformOS(string6);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "canNodeJoinNodeGroup: firstNode,platform", new Object[]{string6, string7});
            }
            if (!string2.equalsIgnoreCase("os390") && !managedObjectMetadataHelper.isNodeZOS(string6)) {
                if (string5.equals("DefaultNodeGroup") || !NodeGroupHelper.isSysplexNodeGroup(session, configService, string5)) {
                    return NODEGROUP_JOIN;
                }
                String string8 = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{string, string5}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string8);
                }
                throw new NodeGroupConfigException(string8);
            }
            if (string2.equalsIgnoreCase("os390") && managedObjectMetadataHelper.isNodeZOS(string6)) {
                Properties properties = managedObjectMetadataHelper.getAccessor().getMetadataProperties(string6);
                String string9 = ((String)properties.get("com.ibm.websphere.nodeSysplexName")).trim();
                if (string9 == null || string4 == null || !string9.equals(string4.trim())) {
                    String string10 = NodeGroupHelper.getFormattedMessage("ADMG0421E", new Object[]{string, string5}, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string10);
                    }
                    throw new NodeGroupConfigException(string10);
                }
                return NODEGROUP_JOIN;
            }
            if (!managedObjectMetadataHelper.isNodeZOS(string6) && string2.equalsIgnoreCase("os390")) {
                String string11 = NodeGroupHelper.getFormattedMessage("ADMG0420E", new Object[]{string, string5}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string11);
                }
                throw new NodeGroupConfigException(string11);
            }
            if (managedObjectMetadataHelper.isNodeZOS(string6) && !string2.equalsIgnoreCase("os390")) {
                String string12 = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{string, string5}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string12);
                }
                throw new NodeGroupConfigException(string12);
            }
        } else {
            if (string2.equalsIgnoreCase("os390")) {
                if (NodeGroupHelper.isSysplexNodeGroup(session, configService, string5)) {
                    return NODEGROUP_JOIN;
                }
                String string13 = NodeGroupHelper.getNodeGroupFromSysplexName(session, configService, string4);
                if (string13 == null) {
                    return NODEGROUP_CONVERT_JOIN;
                }
                return NODEGROUP_JOIN;
            }
            if (!string2.equalsIgnoreCase("os390")) {
                if (!NodeGroupHelper.isSysplexNodeGroup(session, configService, string5)) {
                    return NODEGROUP_JOIN;
                }
                String string14 = NodeGroupHelper.getFormattedMessage("ADMG0455E", new Object[]{string, string5}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string14);
                }
                throw new NodeGroupConfigException(string14);
            }
        }
        return NODEGROUP_NOT_JOIN;
    }

    public static List getNodeGroups(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroups", string);
        }
        ArrayList<NodeGroup> arrayList = new ArrayList<NodeGroup>();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "NodeGroup");
        for (int i = 0; i < objectNameArray.length; ++i) {
            AttributeList attributeList = configService.getAttributes(session, objectNameArray[i], new String[]{"members"}, false);
            List list = (List)((Attribute)attributeList.get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName3 = (ObjectName)iterator.next();
                String string2 = (String)configService.getAttribute(session, objectName3, "nodeName");
                if (!string2.equals(string)) continue;
                NodeGroup nodeGroup = (NodeGroup)MOFUtil.convertToEObject(session, objectNameArray[i]);
                arrayList.add(nodeGroup);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroups", arrayList);
        }
        return arrayList;
    }

    public static void removeNodeFromNodeGroups(Session session, ConfigService configService, String string) throws ConfigServiceException, ConnectorException, NodeGroupConfigException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodeFromNodeGroups", new Object[]{session, string});
        }
        ObjectName objectName = null;
        Object var4_4 = null;
        ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string);
        if (objectNameArray == null || objectNameArray.length == 0) {
            String string2 = NodeGroupHelper.getFormattedMessage("ADMG9218E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2);
            }
            throw new NodeGroupConfigException(string2);
        }
        objectName = objectNameArray[0];
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName3 = configService.queryConfigObjects(session, null, objectName2, null)[0];
        ObjectName[] objectNameArray2 = configService.getRelationship(session, objectName3, "NodeGroup");
        for (int i = 0; i < objectNameArray2.length; ++i) {
            AttributeList attributeList = configService.getAttributes(session, objectNameArray2[i], new String[]{"members"}, false);
            List list = (List)((Attribute)attributeList.get(0)).getValue();
            int n = list.size();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName4 = (ObjectName)iterator.next();
                String string3 = (String)configService.getAttribute(session, objectName4, "nodeName");
                if (!string3.equals(string)) continue;
                if (n == 1) {
                    NodeGroupHelper.cleanupSysplexProperties(session, configService, objectNameArray2[i]);
                }
                configService.deleteConfigData(session, objectName4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodeFromNodeGroups");
        }
    }

    public static void cleanupSysplexProperties(Session session, ConfigService configService, ObjectName objectName) throws ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSysplexProperties", objectName);
        }
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
        List list = (List)((Attribute)attributeList.get(0)).getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            configService.deleteConfigData(session, objectName2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSysplexProperties");
        }
    }

    public static ObjectName convertToSysplexNodeGroup(Session session, ConfigService configService, String string, String string2, Properties properties) throws ConfigServiceException, ConnectorException, AdminException, NodeGroupConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToSysplexNodeGroup", new Object[]{session, string, properties});
        }
        ObjectName objectName = null;
        if (string != null && string.length() > 0) {
            ObjectName[] objectNameArray = configService.resolve(session, "NodeGroup=" + string);
            if (objectNameArray == null || objectNameArray.length == 0) {
                String string3 = NodeGroupHelper.getFormattedMessage("ADMG0453E", new Object[]{string}, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
                throw new NodeGroupConfigException(string3);
            }
            objectName = objectNameArray[0];
            if (string2 != null && string2.length() > 0) {
                NodeGroupHelper.validateNodeGroupShortName(session, configService, string2);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "shortName", string2);
            configService.setAttributes(session, objectName, attributeList);
            attributeList.clear();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = (String)properties.get(string4);
                attributeList.add(new Attribute("name", string4));
                attributeList.add(new Attribute("value", string5));
                ObjectName objectName2 = configService.createConfigData(session, objectName, "properties", null, attributeList);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertToSysplexNodeGroup", new Object[]{objectName});
            }
        }
        return objectName;
    }

    public static void validateNodeGroupShortName(Session session, ConfigService configService, String string) throws NodeGroupConfigException, ConfigServiceException, ConnectorException, AdminException {
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "NodeGroup");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2;
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "name");
            if (!NodeGroupHelper.isSysplexNodeGroup(session, configService, string3) || (string2 = (String)configService.getAttribute(session, objectNameArray[i], "shortName")) == null || string2.length() <= 0 || !string2.equalsIgnoreCase(string)) continue;
            String string4 = NodeGroupHelper.getFormattedMessage("ADMG0489E", new Object[]{string}, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string4);
            }
            throw new NodeGroupConfigException(string4);
        }
    }

    public static void modifyMatchingCellLevelVar(Session session, ConfigService configService, ObjectName objectName, String string, String string2) throws NodeGroupConfigException, ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyMatchingCellLevelVar ", new Object[]{objectName, string, string2});
        }
        Object var5_5 = null;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName3 = configService.queryConfigObjects(session, null, objectName2, null)[0];
        ManagedObjectMetadataHelper managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session);
        ObjectName objectName4 = configService.getRelationship(session, objectName3, "VariableMap")[0];
        objectName2 = ConfigServiceHelper.createObjectName(null, "NodeGroupMember");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        objectName2 = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        block0: for (int i = 0; i < objectNameArray.length; ++i) {
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
            if (!managedObjectMetadataHelper.isNodeZOS(string3) || managedObjectMetadataHelper.compareNodeVersion(string3, "5") != 0 || !string.startsWith("was.")) continue;
            String string4 = string.substring(4);
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName4, objectName2, null);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                String string5 = (String)configService.getAttribute(session, objectNameArray2[j], "symbolicName");
                if (string5 == null || string5.length() <= 0 || !string5.equals(string4)) continue;
                AttributeList attributeList = new AttributeList();
                attributeList.add(new Attribute("value", string2));
                configService.setAttributes(session, objectNameArray2[j], attributeList);
                continue block0;
            }
        }
    }

    public static void modifyMatchingNode5LevelVar(Session session, ConfigService configService, ObjectName objectName, String string, String string2) throws NodeGroupConfigException, ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyMatchingNode5LevelVar", new Object[]{objectName, string, string2});
        }
        Object var5_5 = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        ObjectName objectName4 = null;
        ManagedObjectMetadataHelper managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session);
        objectName4 = ConfigServiceHelper.createObjectName(null, "NodeGroupMember");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName4, null);
        objectName4 = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        block0: for (int i = 0; i < objectNameArray.length; ++i) {
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
            if (!managedObjectMetadataHelper.isNodeZOS(string3) || managedObjectMetadataHelper.compareNodeVersion(string3, "5") != 0 || !string.equalsIgnoreCase("was.WAS_DAEMON_ONLY_protocol_iiop_listenIPAddress") && !string.equalsIgnoreCase("was.WAS_DAEMON_daemon_start_command")) continue;
            objectName2 = configService.resolve(session, "Node=" + string3)[0];
            objectName3 = configService.getRelationship(session, objectName2, "VariableMap")[0];
            String string4 = string.substring(4);
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName3, objectName4, null);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                String string5 = (String)configService.getAttribute(session, objectNameArray2[j], "symbolicName");
                if (string5 == null || string5.length() <= 0 || !string5.equals(string4)) continue;
                AttributeList attributeList = new AttributeList();
                attributeList.add(new Attribute("value", string2));
                configService.setAttributes(session, objectNameArray2[j], attributeList);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyMatchingNode5LevelVar");
        }
    }

    private static ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigServiceException, AdminException, ConnectorException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        return workSpace.getMetadataHelper();
    }

    public static String getCellType(Session session, ConfigService configService) throws ConfigServiceException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellType()");
        }
        String string = null;
        ManagedObjectMetadataHelper managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session);
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray = NodeGroupHelper.listNodes(session, configService, null);
        for (int i = 0; i < stringArray.length; ++i) {
            if (managedObjectMetadataHelper.isNodeZOS(stringArray[i])) {
                bl = true;
                continue;
            }
            if (managedObjectMetadataHelper.isNodeZOS(stringArray[i])) continue;
            bl2 = true;
        }
        if (NodeGroupHelper.isDistributedCell(session, configService)) {
            if (bl && bl2) {
                string = "mixedcell";
            } else if (bl && !bl2) {
                string = "zoscell";
            } else if (bl2 && !bl) {
                string = "distributedcell";
            }
        } else {
            string = bl ? "zosbase" : "distributedbase";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellType", string);
        }
        return string;
    }

    private static boolean isDistributedCell(Session session, ConfigService configService) throws ConfigServiceException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDistributedCell()");
        }
        boolean bl = false;
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ManagedObjectMetadataHelper managedObjectMetadataHelper = NodeGroupHelper.getMetadataHelper(session);
        String string = (String)configService.getAttribute(session, objectName2, "cellType");
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "cellType", string);
        }
        if (string != null && string.length() > 0 && string.equals("DISTRIBUTED")) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDistributedCell()", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isManagedNode(Session session, ConfigService configService, ObjectName objectName) throws ConfigServiceException, NodeGroupConfigException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedNode", objectName);
        }
        boolean bl = false;
        ObjectName objectName2 = configService.getRelationship(session, objectName, "ServerIndex")[0];
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "serverType");
            if (string == null || string.length() <= 0) continue;
            if (string.equals("NODE_AGENT")) {
                bl = true;
                break;
            }
            if (!string.equals("DEPLOYMENT_MANAGER")) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedNode", new Boolean(bl));
        }
        return bl;
    }

    public static List getAllManagedNodes(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getAllManagedNodes");
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (!NodeGroupHelper.isManagedNode(session, configService, objectNameArray[i])) continue;
            Node node = (Node)MOFUtil.convertToEObject(session, objectNameArray[i]);
            arrayList.add(node);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllManagedNodes", arrayList);
        }
        return arrayList;
    }

    private static boolean isXDDynamicCluster(Session session, String string) throws ConfigServiceException {
        boolean bl;
        block8: {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isDynamicCluster");
            }
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("dynamicclusters");
            try {
                Collection collection;
                if (repositoryContextType == null || (collection = workSpace.findContext(repositoryContextType)) == null) break block8;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dynamicclusters found=" + collection.size());
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string2 = ((RepositoryContext)iterator.next()).getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dynamiccluster found=" + string2);
                    }
                    if (!string2.equals(string)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dynamic cluster matches cluster name");
                    }
                    bl = true;
                    break;
                }
            }
            catch (WorkSpaceException workSpaceException) {
                throw new ConfigServiceException(workSpaceException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDynamicCluster");
        }
        return bl;
    }
}

